/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.client;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementHeadersResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentDependency;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentImpactedElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.governanceaction.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataAttributeTypeDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataAttributeTypeDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefGallery;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.TranslationDetail;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValue;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValueDetail;
import org.odpi.openmetadata.frameworks.governanceaction.search.ClassificationCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ToDoStatus;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ArchiveProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworkservices.gaf.client.rest.GAFRESTClient;
import org.odpi.openmetadata.frameworkservices.gaf.ffdc.OpenMetadataStoreErrorCode;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ArchiveRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.AttributeTypeDefListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.AttributeTypeDefResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.FindRelationshipRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.FindRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IncidentReportRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.MetadataCorrelationHeadersResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewClassificationRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewOpenMetadataElementRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewRelatedElementsRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RelatedMetadataElementListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RelatedMetadataElementsListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RelatedMetadataElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TemplateRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TranslationDetailResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TranslationListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TypeDefGalleryResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TypeDefListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TypeDefResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateEffectivityDatesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdatePropertiesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueDetailListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueResponse;

public abstract class OpenMetadataClientBase
extends OpenMetadataClient {
    private final GAFRESTClient restClient;
    protected final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final PropertyHelper propertyHelper = new PropertyHelper();

    public OpenMetadataClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.restClient = new GAFRESTClient(serverName, serverPlatformURLRoot);
    }

    public OpenMetadataClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, String serverUserId, String serverPassword, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.restClient = new GAFRESTClient(serverName, serverPlatformURLRoot, serverUserId, serverPassword);
    }

    public OpenMetadataClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, GAFRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        String methodName = "Client Constructor (with REST client)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor (with REST client)");
        this.restClient = restClient;
    }

    public void setMaxPageSize(int maxPageSize) {
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
    }

    public int getMaxPagingSize() {
        return this.invalidParameterHandler.getMaxPagingSize();
    }

    private long getEffectiveTimeAsLong(Date effectiveTime) {
        long effectiveTimeLong = 0L;
        if (effectiveTime != null) {
            effectiveTimeLong = effectiveTime.getTime();
        }
        return effectiveTimeLong;
    }

    public OpenMetadataTypeDefGallery getAllTypes(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAllTypes";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types";
        this.invalidParameterHandler.validateUserId(userId, "getAllTypes");
        TypeDefGalleryResponse restResult = this.restClient.callTypeDefGalleryGetRESTCall("getAllTypes", urlTemplate, this.serverName, this.serviceURLMarker, userId);
        if (restResult != null) {
            OpenMetadataTypeDefGallery gallery = new OpenMetadataTypeDefGallery();
            gallery.setTypeDefs(restResult.getTypeDefs());
            gallery.setAttributeTypeDefs(restResult.getAttributeTypeDefs());
            return gallery;
        }
        return null;
    }

    public List<OpenMetadataTypeDef> findTypeDefsByCategory(String userId, OpenMetadataTypeDefCategory category) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByCategory";
        String categoryParameterName = "category";
        String entityURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types/entity-defs";
        String relationshipURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types/relationship-defs";
        String classificationURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types/classification-defs";
        this.invalidParameterHandler.validateUserId(userId, "findTypeDefsByCategory");
        this.invalidParameterHandler.validateEnum((Object)category, "category", "findTypeDefsByCategory");
        String urlTemplate = entityURLTemplate;
        if (category == OpenMetadataTypeDefCategory.CLASSIFICATION_DEF) {
            urlTemplate = classificationURLTemplate;
        } else if (category == OpenMetadataTypeDefCategory.RELATIONSHIP_DEF) {
            urlTemplate = relationshipURLTemplate;
        }
        TypeDefListResponse restResult = this.restClient.callTypeDefListGetRESTCall("findTypeDefsByCategory", urlTemplate, this.serverName, this.serviceURLMarker, userId);
        return restResult.getTypeDefs();
    }

    public List<OpenMetadataAttributeTypeDef> findAttributeTypeDefsByCategory(String userId, OpenMetadataAttributeTypeDefCategory category) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findAttributeTypeDefsByCategory";
        String categoryParameterName = "category";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-attribute-types/category/{3}";
        this.invalidParameterHandler.validateUserId(userId, "findAttributeTypeDefsByCategory");
        this.invalidParameterHandler.validateEnum((Object)category, "category", "findAttributeTypeDefsByCategory");
        AttributeTypeDefListResponse restResult = this.restClient.callAttributeTypeDefListGetRESTCall("findAttributeTypeDefsByCategory", urlTemplate, this.serverName, this.serviceURLMarker, userId, category);
        return restResult.getAttributeTypeDefs();
    }

    public List<OpenMetadataTypeDef> findTypesByExternalId(String userId, String standard, String organization, String identifier) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findTypesByExternalId";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types/external-id?standard={3}&organization={4}&identifier={5}";
        this.invalidParameterHandler.validateUserId(userId, "findTypesByExternalId");
        TypeDefListResponse restResult = this.restClient.callTypeDefListGetRESTCall("findTypesByExternalId", urlTemplate, this.serverName, this.serviceURLMarker, userId, standard, organization, identifier);
        return restResult.getTypeDefs();
    }

    public List<OpenMetadataTypeDef> getSubTypes(String userId, String typeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getSubTypes";
        String parameterName = "typeName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types/sub-types?typeName={3}";
        this.invalidParameterHandler.validateUserId(userId, "getSubTypes");
        this.invalidParameterHandler.validateName(typeName, "typeName", "getSubTypes");
        TypeDefListResponse restResult = this.restClient.callTypeDefListGetRESTCall("getSubTypes", urlTemplate, this.serverName, this.serviceURLMarker, userId, typeName);
        return restResult.getTypeDefs();
    }

    public OpenMetadataTypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTypeDefByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types/guid/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getTypeDefByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getTypeDefByGUID");
        TypeDefResponse restResult = this.restClient.callTypeDefGetRESTCall("getTypeDefByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, guid);
        return restResult.getTypeDef();
    }

    public OpenMetadataAttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-attribute-types/guid/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getAttributeTypeDefByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getAttributeTypeDefByGUID");
        AttributeTypeDefResponse restResult = this.restClient.callAttributeTypeDefGetRESTCall("getAttributeTypeDefByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, guid);
        return restResult.getAttributeTypeDef();
    }

    public OpenMetadataTypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTypeDefByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types/name/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getTypeDefByName");
        this.invalidParameterHandler.validateName(name, "name", "getTypeDefByName");
        TypeDefResponse restResult = this.restClient.callTypeDefGetRESTCall("getTypeDefByName", urlTemplate, this.serverName, this.serviceURLMarker, userId, name);
        return restResult.getTypeDef();
    }

    public OpenMetadataAttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-attribute-types/name/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getAttributeTypeDefByName");
        this.invalidParameterHandler.validateName(name, "name", "getAttributeTypeDefByName");
        AttributeTypeDefResponse restResult = this.restClient.callAttributeTypeDefGetRESTCall("getAttributeTypeDefByName", urlTemplate, this.serverName, this.serviceURLMarker, userId, name);
        return restResult.getAttributeTypeDef();
    }

    public OpenMetadataElement getMetadataElementByGUID(String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementByGUID";
        String guidParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}?forLineage={4}&forDuplicateProcessing={5}&effectiveTime={6}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementByGUID");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getMetadataElementByGUID");
        OpenMetadataElementResponse restResult = this.restClient.callOpenMetadataElementGetRESTCall("getMetadataElementByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, elementGUID, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime));
        return restResult.getElement();
    }

    public OpenMetadataElement getMetadataElementByUniqueName(String userId, String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementByUniqueName";
        String defaultPropertyName = OpenMetadataProperty.QUALIFIED_NAME.name;
        String nameParameterName = "uniqueName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-unique-name?forLineage={3}&forDuplicateProcessing={4}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getMetadataElementByUniqueName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(uniqueName);
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setNameParameterName("uniqueName");
        if (uniquePropertyName != null) {
            requestBody.setNamePropertyName(uniquePropertyName);
        } else {
            requestBody.setNamePropertyName(defaultPropertyName);
        }
        OpenMetadataElementResponse restResult = this.restClient.callOpenMetadataElementPostRESTCall("getMetadataElementByUniqueName", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    public OpenMetadataElement getDeletedElementByUniqueName(String userId, String uniqueName, String uniquePropertyName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDeletedElementByUniqueName";
        String defaultPropertyName = OpenMetadataProperty.QUALIFIED_NAME.name;
        String nameParameterName = "uniqueName";
        this.invalidParameterHandler.validateUserId(userId, "getDeletedElementByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getDeletedElementByUniqueName");
        ArrayList<String> propertyNames = new ArrayList<String>();
        if (uniquePropertyName != null) {
            propertyNames.add(uniquePropertyName);
        } else {
            propertyNames.add(defaultPropertyName);
        }
        ArrayList<ElementStatus> requiredStatuses = new ArrayList<ElementStatus>();
        requiredStatuses.add(ElementStatus.DELETED);
        List<OpenMetadataElement> matchingElements = this.findMetadataElements(userId, OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, this.propertyHelper.getSearchPropertiesByName(propertyNames, uniqueName, PropertyComparisonOperator.EQ), requiredStatuses, null, null, null, SequencingOrder.LAST_UPDATE_RECENT, true, true, null, 0, 10);
        if (matchingElements != null) {
            for (OpenMetadataElement matchingElement : matchingElements) {
                if (matchingElement == null) continue;
                return matchingElement;
            }
        }
        return null;
    }

    public String getMetadataElementGUIDByUniqueName(String userId, String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementGUIDByUniqueName";
        String defaultPropertyName = "qualifiedName";
        String nameParameterName = "uniqueName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/guid-by-unique-name?forLineage={3}&forDuplicateProcessing={4}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementGUIDByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getMetadataElementGUIDByUniqueName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(uniqueName);
        requestBody.setNameParameterName("uniqueName");
        requestBody.setEffectiveTime(effectiveTime);
        if (uniquePropertyName != null) {
            requestBody.setNamePropertyName(uniquePropertyName);
        } else {
            requestBody.setNamePropertyName("qualifiedName");
        }
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("getMetadataElementGUIDByUniqueName", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing});
        return restResult.getGUID();
    }

    public List<OpenMetadataElement> findMetadataElementsWithString(String userId, String searchString, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findMetadataElementsWithString(userId, searchString, null, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElementsWithString(String userId, String searchString, String typeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findMetadataElementsWithString";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-search-string?forLineage={3}&forDuplicateProcessing={4}&startFrom={5}&pageSize={6}";
        this.invalidParameterHandler.validateUserId(userId, "findMetadataElementsWithString");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findMetadataElementsWithString");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setTypeName(typeName);
        OpenMetadataElementsResponse restResult = this.restClient.callOpenMetadataElementsPostRESTCall("findMetadataElementsWithString", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<RelatedMetadataElement> getRelatedMetadataElements(String userId, String elementGUID, int startingAtEnd, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedMetadataElements";
        String guidParameterName = "elementGUID";
        String allURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/any-type?startingAtEnd={4}&forLineage={5}&forDuplicateProcessing={6}&effectiveTime={7}&startFrom={8}&pageSize={9}";
        String specificURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/type/{4}?startingAtEnd={5}&forLineage={6}&forDuplicateProcessing={7}&effectiveTime={8}&startFrom={9}&pageSize={10}";
        this.invalidParameterHandler.validateUserId(userId, "getRelatedMetadataElements");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getRelatedMetadataElements");
        RelatedMetadataElementListResponse restResult = relationshipTypeName == null ? this.restClient.callRelatedMetadataElementListGetRESTCall("getRelatedMetadataElements", allURLTemplate, this.serverName, this.serviceURLMarker, userId, elementGUID, startingAtEnd, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), startFrom, pageSize) : this.restClient.callRelatedMetadataElementListGetRESTCall("getRelatedMetadataElements", specificURLTemplate, this.serverName, this.serviceURLMarker, userId, elementGUID, relationshipTypeName, startingAtEnd, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), startFrom, pageSize);
        return restResult.getElementList();
    }

    public RelatedMetadataElement getRelatedMetadataElement(String userId, String elementGUID, int startingAtEnd, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedMetadataElement";
        List<RelatedMetadataElement> relationships = this.getRelatedMetadataElements(userId, elementGUID, startingAtEnd, relationshipTypeName, forLineage, forDuplicateProcessing, effectiveTime, 0, 0);
        if (relationships != null && !relationships.isEmpty()) {
            if (relationships.size() == 1) {
                return relationships.get(0);
            }
            RelatedMetadataElement result = null;
            for (RelatedMetadataElement relatedMetadataElement : relationships) {
                if (relatedMetadataElement == null) continue;
                if (result == null) {
                    result = relatedMetadataElement;
                    continue;
                }
                throw new PropertyServerException(OpenMetadataStoreErrorCode.MULTIPLE_RELATIONSHIPS_FOUND.getMessageDefinition(new String[]{relationshipTypeName, elementGUID}), ((Object)((Object)this)).getClass().getName(), "getRelatedMetadataElement");
            }
            return result;
        }
        return null;
    }

    public List<OpenMetadataRelationship> getMetadataElementRelationships(String userId, String metadataElementAtEnd1GUID, String metadataElementAtEnd2GUID, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedMetadataElements";
        String guid1ParameterName = "metadataElementAtEnd1GUID";
        String allURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/linked-by-any-type/to-elements/{4}?&forLineage={5}&forDuplicateProcessing={6}&effectiveTime={7}&startFrom={8}&pageSize={9}";
        String specificURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/linked-by-type/{4}/to-elements/{5}?forLineage={6}&forDuplicateProcessing={7}&effectiveTime={8}&startFrom={9}&pageSize={10}";
        this.invalidParameterHandler.validateUserId(userId, "getRelatedMetadataElements");
        this.invalidParameterHandler.validateGUID(metadataElementAtEnd1GUID, "metadataElementAtEnd1GUID", "getRelatedMetadataElements");
        RelatedMetadataElementsListResponse restResult = relationshipTypeName == null ? this.restClient.callRelatedMetadataElementsListGetRESTCall("getRelatedMetadataElements", allURLTemplate, this.serverName, this.serviceURLMarker, userId, metadataElementAtEnd1GUID, metadataElementAtEnd2GUID, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), startFrom, pageSize) : this.restClient.callRelatedMetadataElementsListGetRESTCall("getRelatedMetadataElements", specificURLTemplate, this.serverName, this.serviceURLMarker, userId, metadataElementAtEnd1GUID, relationshipTypeName, metadataElementAtEnd2GUID, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<OpenMetadataElement> getMetadataElementsByClassificationPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String classificationName, String classificationPropertyName, String classificationPropertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PrimitiveTypePropertyValue requestedPropertyValue = new PrimitiveTypePropertyValue();
        requestedPropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        requestedPropertyValue.setPrimitiveValue((Object)classificationPropertyValue);
        requestedPropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        PropertyCondition nameCondition = new PropertyCondition();
        nameCondition.setProperty(classificationPropertyName);
        nameCondition.setOperator(PropertyComparisonOperator.EQ);
        nameCondition.setValue((PropertyValue)requestedPropertyValue);
        conditions.add(nameCondition);
        SearchProperties searchClassificationProperties = new SearchProperties();
        searchClassificationProperties.setConditions(conditions);
        searchClassificationProperties.setMatchCriteria(MatchCriteria.ANY);
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition classificationCondition = new ClassificationCondition();
        classificationCondition.setName(classificationName);
        classificationCondition.setSearchProperties(searchClassificationProperties);
        classificationConditions.add(classificationCondition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, null, limitResultsByStatus, asOfTime, searchClassifications, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> getMetadataElementsByClassificationPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String classificationName, String classificationPropertyName, int classificationPropertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PrimitiveTypePropertyValue requestedPropertyValue = new PrimitiveTypePropertyValue();
        requestedPropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT);
        requestedPropertyValue.setPrimitiveValue((Object)classificationPropertyValue);
        requestedPropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT.getName());
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        PropertyCondition nameCondition = new PropertyCondition();
        nameCondition.setProperty(classificationPropertyName);
        nameCondition.setOperator(PropertyComparisonOperator.EQ);
        nameCondition.setValue((PropertyValue)requestedPropertyValue);
        conditions.add(nameCondition);
        SearchProperties searchClassificationProperties = new SearchProperties();
        searchClassificationProperties.setConditions(conditions);
        searchClassificationProperties.setMatchCriteria(MatchCriteria.ANY);
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition classificationCondition = new ClassificationCondition();
        classificationCondition.setName(classificationName);
        classificationCondition.setSearchProperties(searchClassificationProperties);
        classificationConditions.add(classificationCondition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, null, limitResultsByStatus, asOfTime, searchClassifications, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElementsByClassificationPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String classificationName, String classificationPropertyName, String classificationPropertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PrimitiveTypePropertyValue requestedPropertyValue = new PrimitiveTypePropertyValue();
        requestedPropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        requestedPropertyValue.setPrimitiveValue((Object)(".*" + Pattern.quote(classificationPropertyValue) + ".*"));
        requestedPropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        PropertyCondition nameCondition = new PropertyCondition();
        nameCondition.setProperty(classificationPropertyName);
        nameCondition.setOperator(PropertyComparisonOperator.LIKE);
        nameCondition.setValue((PropertyValue)requestedPropertyValue);
        conditions.add(nameCondition);
        SearchProperties searchClassificationProperties = new SearchProperties();
        searchClassificationProperties.setConditions(conditions);
        searchClassificationProperties.setMatchCriteria(MatchCriteria.ANY);
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition classificationCondition = new ClassificationCondition();
        classificationCondition.setName(classificationName);
        classificationCondition.setSearchProperties(searchClassificationProperties);
        classificationConditions.add(classificationCondition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, null, limitResultsByStatus, asOfTime, searchClassifications, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> getMetadataElementsByClassificationPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String classificationName, List<String> classificationPropertyNames, String classificationPropertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PrimitiveTypePropertyValue requestedPropertyValue = new PrimitiveTypePropertyValue();
        requestedPropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        requestedPropertyValue.setPrimitiveValue((Object)classificationPropertyValue);
        requestedPropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        if (classificationPropertyNames != null) {
            for (String propertyName : classificationPropertyNames) {
                PropertyCondition nameCondition = new PropertyCondition();
                nameCondition.setProperty(propertyName);
                nameCondition.setOperator(PropertyComparisonOperator.EQ);
                nameCondition.setValue((PropertyValue)requestedPropertyValue);
                conditions.add(nameCondition);
            }
        }
        SearchProperties searchClassificationProperties = new SearchProperties();
        searchClassificationProperties.setConditions(conditions);
        searchClassificationProperties.setMatchCriteria(MatchCriteria.ANY);
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition classificationCondition = new ClassificationCondition();
        classificationCondition.setName(classificationName);
        classificationCondition.setSearchProperties(searchClassificationProperties);
        classificationConditions.add(classificationCondition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, null, limitResultsByStatus, asOfTime, searchClassifications, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElementsByClassificationPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String classificationName, List<String> classificationPropertyNames, String classificationPropertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PrimitiveTypePropertyValue requestedPropertyValue = new PrimitiveTypePropertyValue();
        requestedPropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        requestedPropertyValue.setPrimitiveValue((Object)(".*" + Pattern.quote(classificationPropertyValue) + ".*"));
        requestedPropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        if (classificationPropertyNames != null) {
            for (String propertyName : classificationPropertyNames) {
                PropertyCondition nameCondition = new PropertyCondition();
                nameCondition.setProperty(propertyName);
                nameCondition.setOperator(PropertyComparisonOperator.LIKE);
                nameCondition.setValue((PropertyValue)requestedPropertyValue);
                conditions.add(nameCondition);
            }
        }
        SearchProperties searchClassificationProperties = new SearchProperties();
        searchClassificationProperties.setConditions(conditions);
        searchClassificationProperties.setMatchCriteria(MatchCriteria.ANY);
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition classificationCondition = new ClassificationCondition();
        classificationCondition.setName(classificationName);
        classificationCondition.setSearchProperties(searchClassificationProperties);
        classificationConditions.add(classificationCondition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, null, limitResultsByStatus, asOfTime, searchClassifications, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> getMetadataElementsByClassification(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String classificationName, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition classificationCondition = new ClassificationCondition();
        classificationCondition.setName(classificationName);
        classificationConditions.add(classificationCondition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, null, limitResultsByStatus, asOfTime, searchClassifications, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> getMetadataElementsByPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String propertyName, String propertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<String> propertyNames = List.of(propertyName);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, this.propertyHelper.getSearchPropertiesByName(propertyNames, propertyValue, PropertyComparisonOperator.EQ), limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElementsByPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String propertyName, String propertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<String> propertyNames = List.of(propertyName);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, this.propertyHelper.getSearchPropertiesByName(propertyNames, propertyValue, PropertyComparisonOperator.LIKE), limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> getMetadataElementsByPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, List<String> propertyNames, String propertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, this.propertyHelper.getSearchPropertiesByName(propertyNames, propertyValue, PropertyComparisonOperator.EQ), limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElementsByPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, List<String> propertyNames, String propertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, this.propertyHelper.getSearchPropertiesByName(propertyNames, propertyValue, PropertyComparisonOperator.LIKE), limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElements(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, Date asOfTime, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findMetadataElements";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-search-specification?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}&startFrom={6}&pageSize={7}";
        this.invalidParameterHandler.validateUserId(userId, "findMetadataElements");
        FindRequestBody requestBody = new FindRequestBody();
        requestBody.setMetadataElementTypeName(metadataElementTypeName);
        requestBody.setMetadataElementSubtypeNames(metadataElementSubtypeNames);
        requestBody.setSearchProperties(searchProperties);
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setMatchClassifications(matchClassifications);
        requestBody.setSequencingProperty(sequencingProperty);
        if (sequencingOrder == null) {
            requestBody.setSequencingOrder(SequencingOrder.LAST_UPDATE_RECENT);
        } else {
            requestBody.setSequencingOrder(sequencingOrder);
        }
        requestBody.setAsOfTime(asOfTime);
        OpenMetadataElementsResponse restResult = this.restClient.callOpenMetadataElementsPostRESTCall("findMetadataElements", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<OpenMetadataRelationship> findRelationshipsBetweenMetadataElements(String userId, String relationshipTypeName, SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findRelationshipsBetweenMetadataElements";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/relationships/by-search-specification?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}&startFrom={6}&pageSize={7}";
        this.invalidParameterHandler.validateUserId(userId, "findRelationshipsBetweenMetadataElements");
        FindRelationshipRequestBody requestBody = new FindRelationshipRequestBody();
        requestBody.setRelationshipTypeName(relationshipTypeName);
        requestBody.setSearchProperties(searchProperties);
        requestBody.setSequencingProperty(sequencingProperty);
        requestBody.setSequencingOrder(sequencingOrder);
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setAsOfTime(asOfTime);
        RelatedMetadataElementsListResponse restResult = this.restClient.callRelatedMetadataElementsListPostRESTCall("findRelationshipsBetweenMetadataElements", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), startFrom, pageSize);
        return restResult.getElementList();
    }

    public OpenMetadataRelationship getRelationshipByGUID(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelationshipByGUID";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/relationships/by-guid/{3}?forLineage={4}&forDuplicateProcessing={5}&effectiveTime={6}";
        this.invalidParameterHandler.validateUserId(userId, "getRelationshipByGUID");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "getRelationshipByGUID");
        RelatedMetadataElementsResponse restResult = this.restClient.callRelatedMetadataElementGetRESTCall("getRelationshipByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, relationshipGUID, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime));
        return restResult.getElement();
    }

    public String createMetadataElementInStore(String userId, String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createMetadataElementInStore(userId, null, null, metadataElementTypeName, initialStatus, null, null, false, effectiveFrom, effectiveTo, properties, null, null, null, true);
    }

    public String createMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createMetadataElementInStore(userId, externalSourceGUID, externalSourceName, metadataElementTypeName, initialStatus, null, null, false, effectiveFrom, effectiveTo, properties, null, null, null, true);
    }

    public String createMetadataElementInStore(String userId, String metadataElementTypeName, ElementStatus initialStatus, Map<String, ElementProperties> initialClassifications, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createMetadataElementInStore(userId, null, null, metadataElementTypeName, initialStatus, initialClassifications, anchorGUID, isOwnAnchor, effectiveFrom, effectiveTo, properties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
    }

    public String createMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementTypeName, ElementStatus initialStatus, Map<String, ElementProperties> initialClassifications, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createMetadataElementInStore";
        String elementTypeParameterName = "metadataElementTypeName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements";
        this.invalidParameterHandler.validateUserId(userId, "createMetadataElementInStore");
        this.invalidParameterHandler.validateName(metadataElementTypeName, "metadataElementTypeName", "createMetadataElementInStore");
        if (parentGUID != null) {
            String parentRelationshipTypeNameParameterName = "parentRelationshipTypeName";
            this.invalidParameterHandler.validateName(parentRelationshipTypeName, "parentRelationshipTypeName", "createMetadataElementInStore");
        }
        NewOpenMetadataElementRequestBody requestBody = new NewOpenMetadataElementRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setTypeName(metadataElementTypeName);
        requestBody.setInitialStatus(initialStatus);
        requestBody.setInitialClassifications(initialClassifications);
        requestBody.setAnchorGUID(anchorGUID);
        requestBody.setIsOwnAnchor(isOwnAnchor);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setParentGUID(parentGUID);
        requestBody.setParentRelationshipTypeName(parentRelationshipTypeName);
        requestBody.setParentRelationshipProperties(parentRelationshipProperties);
        requestBody.setParentAtEnd1(parentAtEnd1);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
        return restResult.getGUID();
    }

    public String createMetadataElementFromTemplate(String userId, String metadataElementTypeName, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createMetadataElementFromTemplate(userId, null, null, metadataElementTypeName, anchorGUID, isOwnAnchor, effectiveFrom, effectiveTo, templateGUID, replacementProperties, placeholderProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
    }

    public String createMetadataElementFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String metadataElementTypeName, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createMetadataElementFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/from-template";
        this.invalidParameterHandler.validateUserId(userId, "createMetadataElementFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createMetadataElementFromTemplate");
        if (parentGUID != null) {
            String parentRelationshipTypeNameParameterName = "parentRelationshipTypeName";
            this.invalidParameterHandler.validateName(parentRelationshipTypeName, "parentRelationshipTypeName", "createMetadataElementFromTemplate");
        }
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setTypeName(metadataElementTypeName);
        requestBody.setAnchorGUID(anchorGUID);
        requestBody.setIsOwnAnchor(isOwnAnchor);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setTemplateGUID(templateGUID);
        requestBody.setReplacementProperties(replacementProperties);
        requestBody.setPlaceholderPropertyValues(placeholderProperties);
        requestBody.setParentGUID(parentGUID);
        requestBody.setParentRelationshipTypeName(parentRelationshipTypeName);
        requestBody.setParentRelationshipProperties(parentRelationshipProperties);
        requestBody.setParentAtEnd1(parentAtEnd1);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createMetadataElementFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
        return restResult.getGUID();
    }

    public String getMetadataElementFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String metadataElementTypeName, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/from-template?allowRetrieve={3}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "getMetadataElementFromTemplate");
        if (parentGUID != null) {
            String parentRelationshipTypeNameParameterName = "parentRelationshipTypeName";
            this.invalidParameterHandler.validateName(parentRelationshipTypeName, "parentRelationshipTypeName", "getMetadataElementFromTemplate");
        }
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setTypeName(metadataElementTypeName);
        requestBody.setAnchorGUID(anchorGUID);
        requestBody.setIsOwnAnchor(isOwnAnchor);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setTemplateGUID(templateGUID);
        requestBody.setReplacementProperties(replacementProperties);
        requestBody.setPlaceholderPropertyValues(placeholderProperties);
        requestBody.setParentGUID(parentGUID);
        requestBody.setParentRelationshipTypeName(parentRelationshipTypeName);
        requestBody.setParentRelationshipProperties(parentRelationshipProperties);
        requestBody.setParentAtEnd1(parentAtEnd1);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("getMetadataElementFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, true});
        return restResult.getGUID();
    }

    public void updateMetadataElementInStore(String userId, String metadataElementGUID, boolean replaceAllProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateMetadataElementInStore(userId, null, null, metadataElementGUID, replaceAllProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    public void updateMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID});
    }

    public void updateMetadataElementStatusInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, ElementStatus newElementStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateMetadataElementStatusInStore(userId, null, null, metadataElementGUID, forLineage, forDuplicateProcessing, newElementStatus, effectiveTime);
    }

    public void updateMetadataElementStatusInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, ElementStatus newElementStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementStatusInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-status";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementStatusInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementStatusInStore");
        UpdateStatusRequestBody requestBody = new UpdateStatusRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setNewStatus(newElementStatus);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementStatusInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID});
    }

    public void updateMetadataElementEffectivityInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateMetadataElementEffectivityInStore(userId, null, null, metadataElementGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    public void updateMetadataElementEffectivityInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementEffectivityInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementEffectivityInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementEffectivityInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID});
    }

    public void deleteMetadataElementInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteMetadataElementInStore(userId, null, null, metadataElementGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void deleteMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "deleteMetadataElementInStore");
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("deleteMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID});
    }

    public void archiveMetadataElementInStore(String userId, String metadataElementGUID, ArchiveProperties archiveProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.archiveMetadataElementInStore(userId, null, null, metadataElementGUID, archiveProperties, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void archiveMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, ArchiveProperties archiveProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "archiveMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/archive";
        this.invalidParameterHandler.validateUserId(userId, "archiveMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "archiveMetadataElementInStore");
        ArchiveRequestBody requestBody = new ArchiveRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setArchiveProperties(archiveProperties);
        this.restClient.callVoidPostRESTCall("archiveMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID});
    }

    public void classifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.classifyMetadataElementInStore(userId, null, null, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
    }

    public void classifyMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "classifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}";
        this.invalidParameterHandler.validateUserId(userId, "classifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "classifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "classifyMetadataElementInStore");
        NewClassificationRequestBody requestBody = new NewClassificationRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("classifyMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName});
    }

    public void reclassifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.reclassifyMetadataElementInStore(userId, null, null, metadataElementGUID, classificationName, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    public void reclassifyMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "reclassifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "reclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "reclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "reclassifyMetadataElementInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("reclassifyMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName});
    }

    public void updateClassificationEffectivityInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateClassificationEffectivityInStore(userId, null, null, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    public void updateClassificationEffectivityInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateClassificationEffectivityInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateClassificationEffectivityInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateClassificationEffectivityInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "updateClassificationEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateClassificationEffectivityInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName});
    }

    public void declassifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.declassifyMetadataElementInStore(userId, null, null, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void declassifyMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "declassifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/delete";
        this.invalidParameterHandler.validateUserId(userId, "declassifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "declassifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "declassifyMetadataElementInStore");
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("declassifyMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName});
    }

    public String createRelatedElementsInStore(String userId, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createRelatedElementsInStore(userId, null, null, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
    }

    public String createRelatedElementsInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createRelatedElementsInStore";
        String elementTypeParameterName = "relationshipTypeName";
        String end1ParameterName = "metadataElement1GUID";
        String end2ParameterName = "metadataElement2GUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements";
        this.invalidParameterHandler.validateUserId(userId, "createRelatedElementsInStore");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "createRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", "createRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", "createRelatedElementsInStore");
        NewRelatedElementsRequestBody requestBody = new NewRelatedElementsRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setTypeName(relationshipTypeName);
        requestBody.setMetadataElement1GUID(metadataElement1GUID);
        requestBody.setMetadataElement2GUID(metadataElement2GUID);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createRelatedElementsInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
        return restResult.getGUID();
    }

    public void updateRelatedElementsInStore(String userId, String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateRelatedElementsInStore(userId, null, null, relationshipGUID, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    public void updateRelatedElementsInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateRelatedElementsInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "updateRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "updateRelatedElementsInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setProperties(properties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateRelatedElementsInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, relationshipGUID});
    }

    public void updateRelatedElementsEffectivityInStore(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateRelatedElementsEffectivityInStore(userId, null, null, relationshipGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    public void updateRelatedElementsEffectivityInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateRelatedElementsEffectivityInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateRelatedElementsEffectivityInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "updateRelatedElementsEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateRelatedElementsEffectivityInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, relationshipGUID});
    }

    public void deleteRelatedElementsInStore(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteRelatedElementsInStore(userId, null, null, relationshipGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void deleteRelatedElementsInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteRelatedElementsInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "deleteRelatedElementsInStore");
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("deleteRelatedElementsInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, relationshipGUID});
    }

    public String initiateGovernanceActionProcess(String userId, String processQualifiedName, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, Map<String, String> requestParameters, String originatorServiceName, String originatorEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "initiateGovernanceActionProcess";
        String qualifiedNameParameterName = "processQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes/initiate";
        this.invalidParameterHandler.validateUserId(userId, "initiateGovernanceActionProcess");
        this.invalidParameterHandler.validateName(processQualifiedName, "processQualifiedName", "initiateGovernanceActionProcess");
        InitiateGovernanceActionProcessRequestBody requestBody = new InitiateGovernanceActionProcessRequestBody();
        requestBody.setProcessQualifiedName(processQualifiedName);
        requestBody.setRequestSourceGUIDs(requestSourceGUIDs);
        requestBody.setActionTargets(actionTargets);
        requestBody.setStartDate(startTime);
        requestBody.setRequestParameters(requestParameters);
        requestBody.setOriginatorServiceName(originatorServiceName);
        requestBody.setOriginatorEngineName(originatorEngineName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("initiateGovernanceActionProcess", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
        return restResult.getGUID();
    }

    public String createIncidentReport(String userId, String qualifiedName, int domainIdentifier, String background, List<IncidentImpactedElement> impactedResources, List<IncidentDependency> previousIncidents, Map<String, Integer> incidentClassifiers, Map<String, String> additionalProperties, String originatorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIncidentReport";
        String qualifiedNameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/incident-reports";
        this.invalidParameterHandler.validateUserId(userId, "createIncidentReport");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createIncidentReport");
        IncidentReportRequestBody requestBody = new IncidentReportRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDomainIdentifier(domainIdentifier);
        requestBody.setBackground(background);
        requestBody.setImpactedResources(impactedResources);
        requestBody.setPreviousIncidents(previousIncidents);
        requestBody.setIncidentClassifiers(incidentClassifiers);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setOriginatorGUID(originatorGUID);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createIncidentReport", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
        return restResult.getGUID();
    }

    public String openToDo(String userId, String qualifiedName, String title, String instructions, String category, int priority, Date dueDate, Map<String, String> additionalProperties, String assignToGUID, String sponsorGUID, String originatorGUID, List<NewActionTarget> actionTargets) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "openToDo";
        String toDoQualifiedNameParameterName = "qualifiedName";
        String assignToParameterName = "assignToGUID";
        this.propertyHelper.validateMandatoryName(qualifiedName, "qualifiedName", "openToDo");
        this.propertyHelper.validateMandatoryName(assignToGUID, "assignToGUID", "openToDo");
        ElementProperties properties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName);
        properties = this.propertyHelper.addStringProperty(properties, OpenMetadataProperty.NAME.name, title);
        properties = this.propertyHelper.addStringProperty(properties, OpenMetadataProperty.DESCRIPTION.name, instructions);
        properties = this.propertyHelper.addStringProperty(properties, OpenMetadataProperty.TO_DO_TYPE.name, category);
        properties = this.propertyHelper.addDateProperty(properties, OpenMetadataProperty.DUE_TIME.name, dueDate);
        properties = this.propertyHelper.addIntProperty(properties, OpenMetadataProperty.PRIORITY.name, priority);
        properties = this.propertyHelper.addEnumProperty(properties, OpenMetadataProperty.TO_DO_STATUS.name, ToDoStatus.getOpenTypeName(), ToDoStatus.OPEN.getName());
        String toDoGUID = this.createMetadataElementInStore(userId, OpenMetadataType.TO_DO.typeName, ElementStatus.ACTIVE, null, null, false, null, null, properties, assignToGUID, OpenMetadataType.ACTION_ASSIGNMENT_RELATIONSHIP.typeName, null, true);
        if (toDoGUID != null) {
            if (actionTargets != null) {
                for (NewActionTarget actionTarget : actionTargets) {
                    if (actionTarget == null || actionTarget.getActionTargetGUID() == null) continue;
                    ElementProperties relationshipProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.ACTION_TARGET_NAME.name, actionTarget.getActionTargetName());
                    this.createRelatedElementsInStore(userId, OpenMetadataType.ACTION_TARGET_RELATIONSHIP.typeName, toDoGUID, actionTarget.getActionTargetGUID(), false, false, null, null, relationshipProperties, null);
                }
            }
            if (sponsorGUID != null) {
                this.createRelatedElementsInStore(userId, OpenMetadataType.ACTION_SPONSOR_RELATIONSHIP.typeName, sponsorGUID, toDoGUID, false, false, null, null, null, new Date());
            }
            if (originatorGUID != null) {
                this.createRelatedElementsInStore(userId, OpenMetadataType.TO_DO_SOURCE_RELATIONSHIP.typeName, originatorGUID, toDoGUID, false, false, null, null, null, new Date());
            }
        }
        return toDoGUID;
    }

    public void setTranslation(String userId, String elementGUID, TranslationDetail translationDetail) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTranslation";
        String elementGUIDParameterName = "elementGUID";
        String translationDetailParameterName = "translationDetail";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/multi-language/set-translation/{3}";
        this.invalidParameterHandler.validateUserId(userId, "setTranslation");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "setTranslation");
        this.invalidParameterHandler.validateObject((Object)translationDetail, "translationDetail", "setTranslation");
        this.restClient.callVoidPostRESTCall("setTranslation", urlTemplate, translationDetail, new Object[]{this.serverName, this.serviceURLMarker, userId, elementGUID});
    }

    public void clearTranslation(String userId, String elementGUID, String language, String locale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTranslation";
        String elementGUIDParameterName = "elementGUID";
        String languageParameterName = "language";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/multi-language/clear-translation/{3}?language={4}&locale={5}";
        this.invalidParameterHandler.validateUserId(userId, "clearTranslation");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "clearTranslation");
        this.invalidParameterHandler.validateName(language, "language", "clearTranslation");
        this.restClient.callVoidPostRESTCall("clearTranslation", urlTemplate, new NullRequestBody(), new Object[]{this.serverName, this.serviceURLMarker, userId, elementGUID, language, locale});
    }

    public TranslationDetail getTranslation(String userId, String elementGUID, String language, String locale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTranslation";
        String elementGUIDParameterName = "elementGUID";
        String languageParameterName = "language";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/multi-language/get-translation/{3}?language={4}&locale={5}";
        this.invalidParameterHandler.validateUserId(userId, "getTranslation");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getTranslation");
        this.invalidParameterHandler.validateName(language, "language", "getTranslation");
        TranslationDetailResponse response = this.restClient.callTranslationDetailGetRESTCall("getTranslation", urlTemplate, this.serverName, this.serviceURLMarker, userId, elementGUID, language, locale);
        return response.getElement();
    }

    public List<TranslationDetail> getTranslations(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTranslations";
        String elementGUIDParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/multi-language/get-translations/{3}?startFrom={4}&pageSize={5}";
        this.invalidParameterHandler.validateUserId(userId, "getTranslations");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getTranslations");
        TranslationListResponse response = this.restClient.callTranslationListGetRESTCall("getTranslations", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, elementGUID, startFrom, pageSize);
        return response.getElementList();
    }

    public void setUpValidMetadataValue(String userId, String typeName, String propertyName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setUpValidMetadataValue";
        String propertyNameParameterName = "propertyName";
        String propertiesParameterName = "validMetadataValue";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/setup-value/{3}?typeName={4}";
        this.invalidParameterHandler.validateUserId(userId, "setUpValidMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataValue");
        this.invalidParameterHandler.validateObject((Object)validMetadataValue, "validMetadataValue", "setUpValidMetadataValue");
        this.restClient.callVoidPostRESTCall("setUpValidMetadataValue", urlTemplate, validMetadataValue, new Object[]{this.serverName, this.serviceURLMarker, userId, propertyName, typeName});
    }

    public void setUpValidMetadataMapName(String userId, String typeName, String propertyName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setUpValidMetadataMapName";
        String propertyNameParameterName = "propertyName";
        String propertiesParameterName = "validMetadataValue";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/setup-map-name/{3}?typeName={4}";
        this.invalidParameterHandler.validateUserId(userId, "setUpValidMetadataMapName");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataMapName");
        this.invalidParameterHandler.validateObject((Object)validMetadataValue, "validMetadataValue", "setUpValidMetadataMapName");
        this.restClient.callVoidPostRESTCall("setUpValidMetadataMapName", urlTemplate, validMetadataValue, new Object[]{this.serverName, this.serviceURLMarker, userId, propertyName, typeName});
    }

    public void setUpValidMetadataMapValue(String userId, String typeName, String propertyName, String mapName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setUpValidMetadataMapValue";
        String propertyNameParameterName = "propertyName";
        String mapNameParameterName = "mapName";
        String propertiesParameterName = "validMetadataValue";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/setup-map-value/{3}/{4}?typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "setUpValidMetadataMapValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataMapValue");
        this.invalidParameterHandler.validateName(mapName, "mapName", "setUpValidMetadataMapValue");
        this.invalidParameterHandler.validateObject((Object)validMetadataValue, "validMetadataValue", "setUpValidMetadataMapValue");
        this.restClient.callVoidPostRESTCall("setUpValidMetadataMapValue", urlTemplate, validMetadataValue, new Object[]{this.serverName, this.serviceURLMarker, userId, propertyName, mapName, typeName});
    }

    public void clearValidMetadataValue(String userId, String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearValidMetadataValue";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/clear-value/{3}?preferredValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "clearValidMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataValue");
        this.restClient.callVoidPostRESTCall("clearValidMetadataValue", urlTemplate, new NullRequestBody(), new Object[]{this.serverName, this.serviceURLMarker, userId, propertyName, preferredValue, typeName});
    }

    public void clearValidMetadataMapName(String userId, String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearValidMetadataMapName";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/clear-map-name/{3}?preferredValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "clearValidMetadataMapName");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataMapName");
        this.restClient.callVoidPostRESTCall("clearValidMetadataMapName", urlTemplate, new NullRequestBody(), new Object[]{this.serverName, this.serviceURLMarker, userId, propertyName, preferredValue, typeName});
    }

    public void clearValidMetadataMapValue(String userId, String typeName, String propertyName, String mapName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearValidMetadataMapValue";
        String propertyNameParameterName = "propertyName";
        String mapNameParameterName = "mapName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/clear-map-value/{3}/{4}?preferredValue={5}&typeName={6}";
        this.invalidParameterHandler.validateUserId(userId, "clearValidMetadataMapValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataMapValue");
        this.invalidParameterHandler.validateName(mapName, "mapName", "clearValidMetadataMapValue");
        this.restClient.callVoidPostRESTCall("clearValidMetadataMapValue", urlTemplate, new NullRequestBody(), new Object[]{this.serverName, this.serviceURLMarker, userId, propertyName, mapName, preferredValue, typeName});
    }

    public boolean validateMetadataValue(String userId, String typeName, String propertyName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateMetadataValue";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/validate-value/{3}?actualValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "validateMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataValue");
        BooleanResponse response = this.restClient.callBooleanGetRESTCall("validateMetadataValue", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, actualValue, typeName);
        return response.getFlag();
    }

    public boolean validateMetadataMapName(String userId, String typeName, String propertyName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateMetadataMapName";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/validate-map-name/{3}?actualValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "validateMetadataMapName");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataMapName");
        BooleanResponse response = this.restClient.callBooleanGetRESTCall("validateMetadataMapName", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, actualValue, typeName);
        return response.getFlag();
    }

    public boolean validateMetadataMapValue(String userId, String typeName, String propertyName, String mapName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateMetadataMapValue";
        String propertyNameParameterName = "propertyName";
        String mapNameParameterName = "mapName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/validate-map-value/{3}/{4}?actualValue={5}&typeName={6}";
        this.invalidParameterHandler.validateUserId(userId, "validateMetadataMapValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataMapValue");
        this.invalidParameterHandler.validateName(mapName, "mapName", "validateMetadataMapValue");
        BooleanResponse response = this.restClient.callBooleanGetRESTCall("validateMetadataMapValue", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, mapName, actualValue, typeName);
        return response.getFlag();
    }

    public ValidMetadataValue getValidMetadataValue(String userId, String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidMetadataValue";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/get-value/{3}?preferredValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "getValidMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataValue");
        ValidMetadataValueResponse response = this.restClient.callValidMetadataValueGetRESTCall("getValidMetadataValue", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, preferredValue, typeName);
        return response.getElement();
    }

    public ValidMetadataValue getValidMetadataMapName(String userId, String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidMetadataMapName";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/get-map-name/{3}?preferredValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "getValidMetadataMapName");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataMapName");
        ValidMetadataValueResponse response = this.restClient.callValidMetadataValueGetRESTCall("getValidMetadataMapName", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, preferredValue, typeName);
        return response.getElement();
    }

    public ValidMetadataValue getValidMetadataMapValue(String userId, String typeName, String propertyName, String mapName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidMetadataMapValue";
        String propertyNameParameterName = "propertyName";
        String mapNameParameterName = "mapName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/get-map-value/{3}/{4}?preferredValue={5}&typeName={6}";
        this.invalidParameterHandler.validateUserId(userId, "getValidMetadataMapValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataMapValue");
        this.invalidParameterHandler.validateName(mapName, "mapName", "getValidMetadataMapValue");
        ValidMetadataValueResponse response = this.restClient.callValidMetadataValueGetRESTCall("getValidMetadataMapValue", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, mapName, preferredValue, typeName);
        return response.getElement();
    }

    public List<ValidMetadataValueDetail> getValidMetadataValues(String userId, String typeName, String propertyName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidMetadataValues";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/get-valid-metadata-values/{3}?typeName={4}&startFrom={5}&pageSize={6}";
        this.invalidParameterHandler.validateUserId(userId, "getValidMetadataValues");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataValues");
        ValidMetadataValueDetailListResponse response = this.restClient.callValidMetadataValueDetailListGetRESTCall("getValidMetadataValues", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, typeName, startFrom, pageSize);
        return response.getElementList();
    }

    public List<ValidMetadataValue> getConsistentMetadataValues(String userId, String typeName, String propertyName, String mapName, String preferredValue, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConsistentMetadataValues";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/{3}/consistent-metadata-values?typeName={4}&mapName={5}&preferredValue={6}&startFrom={7}&pageSize={8}";
        this.invalidParameterHandler.validateUserId(userId, "getConsistentMetadataValues");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getConsistentMetadataValues");
        ValidMetadataValueListResponse response = this.restClient.callValidMetadataValueListGetRESTCall("getConsistentMetadataValues", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, typeName, mapName, preferredValue, startFrom, pageSize);
        return response.getElementList();
    }

    public void setConsistentMetadataValues(String userId, String typeName1, String propertyName1, String mapName1, String preferredValue1, String typeName2, String propertyName2, String mapName2, String preferredValue2) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setConsistentMetadataValues";
        String propertyName1ParameterName = "propertyName1";
        String preferredValue1ParameterName = "preferredValue1";
        String propertyName2ParameterName = "propertyName2";
        String preferredValue2ParameterName = "preferredValue2";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/{3}/consistent-metadata-values/{4}?typeName1={5}&typeName2={6}&preferredValue1={7}&preferredValue2={8}&mapName1={9}&mapName2={10}";
        this.invalidParameterHandler.validateUserId(userId, "setConsistentMetadataValues");
        this.invalidParameterHandler.validateName(propertyName1, "propertyName1", "setConsistentMetadataValues");
        this.invalidParameterHandler.validateObject((Object)preferredValue1, "preferredValue1", "setConsistentMetadataValues");
        this.invalidParameterHandler.validateName(propertyName2, "propertyName2", "setConsistentMetadataValues");
        this.invalidParameterHandler.validateObject((Object)preferredValue2, "preferredValue2", "setConsistentMetadataValues");
        this.restClient.callVoidPostRESTCall("setConsistentMetadataValues", urlTemplate, new NullRequestBody(), new Object[]{this.serverName, this.serviceURLMarker, userId, propertyName1, propertyName2, typeName1, typeName2, preferredValue1, preferredValue2, mapName1, mapName2});
    }

    public Map<String, List<Map<String, String>>> getSpecification(String userId, String elementGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getSpecification";
        HashMap<String, List<Map<String, String>>> specification = new HashMap<String, List<Map<String, String>>>();
        List<RelatedMetadataElement> refDataElements = this.getRelatedMetadataElements(userId, elementGUID, 1, OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName, false, false, new Date(), 0, 0);
        if (refDataElements != null) {
            for (RelatedMetadataElement refDataElement : refDataElements) {
                String propertyType;
                if (refDataElement == null || (propertyType = this.propertyHelper.getStringProperty(this.serviceURLMarker, OpenMetadataProperty.PROPERTY_TYPE.name, refDataElement.getRelationshipProperties(), "getSpecification")) == null) continue;
                HashMap<CallSite, String> additionalProperties = this.propertyHelper.getStringMapFromProperty(this.serviceURLMarker, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, refDataElement.getElement().getElementProperties(), "getSpecification");
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<CallSite, String>();
                }
                additionalProperties.put((CallSite)((Object)(propertyType + "Name")), this.propertyHelper.getStringProperty(this.serviceURLMarker, "preferredValue", refDataElement.getElement().getElementProperties(), "getSpecification"));
                ArrayList<HashMap<CallSite, String>> properties = (ArrayList<HashMap<CallSite, String>>)specification.get(propertyType);
                if (properties == null) {
                    properties = new ArrayList<HashMap<CallSite, String>>();
                }
                properties.add(additionalProperties);
                specification.put(propertyType, properties);
            }
        }
        if (!specification.isEmpty()) {
            return specification;
        }
        return null;
    }

    public void addExternalIdentifier(String userId, String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName, ExternalIdentifierProperties externalIdentifierProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addExternalIdentifier";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        String externalScopeNameParameterName = "externalScopeName";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String openMetadataTypeParameterName = "openMetadataElementTypeName";
        String externalIdentifierPropertiesParameterName = "externalIdentifierProperties";
        String externalIdentifierParameterName = "externalIdentifierProperties.externalIdentifier";
        this.invalidParameterHandler.validateUserId(userId, "addExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalScopeGUID, "externalScopeGUID", "addExternalIdentifier");
        this.invalidParameterHandler.validateName(externalScopeName, "externalScopeName", "addExternalIdentifier");
        this.invalidParameterHandler.validateGUID(openMetadataElementGUID, "openMetadataElementGUID", "addExternalIdentifier");
        this.invalidParameterHandler.validateName(openMetadataElementTypeName, "openMetadataElementTypeName", "addExternalIdentifier");
        this.invalidParameterHandler.validateObject((Object)externalIdentifierProperties, "externalIdentifierProperties", "addExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalIdentifierProperties.getExternalIdentifier(), "externalIdentifierProperties.externalIdentifier", "addExternalIdentifier");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/{4}/external-identifiers/add";
        MetadataCorrelationProperties requestBody = new MetadataCorrelationProperties(externalIdentifierProperties);
        requestBody.setExternalScopeGUID(externalScopeGUID);
        requestBody.setExternalScopeName(externalScopeName);
        this.restClient.callVoidPostRESTCall("addExternalIdentifier", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, openMetadataElementTypeName, openMetadataElementGUID});
    }

    public void updateExternalIdentifier(String userId, String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName, ExternalIdentifierProperties externalIdentifierProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateExternalIdentifier";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        String externalScopeNameParameterName = "externalScopeName";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String openMetadataTypeParameterName = "openMetadataElementTypeName";
        String externalIdentifierPropertiesParameterName = "externalIdentifierProperties";
        String externalIdentifierParameterName = "externalIdentifierProperties.externalIdentifier";
        this.invalidParameterHandler.validateUserId(userId, "updateExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalScopeGUID, "externalScopeGUID", "updateExternalIdentifier");
        this.invalidParameterHandler.validateName(externalScopeName, "externalScopeName", "updateExternalIdentifier");
        this.invalidParameterHandler.validateGUID(openMetadataElementGUID, "openMetadataElementGUID", "updateExternalIdentifier");
        this.invalidParameterHandler.validateName(openMetadataElementTypeName, "openMetadataElementTypeName", "updateExternalIdentifier");
        this.invalidParameterHandler.validateObject((Object)externalIdentifierProperties, "externalIdentifierProperties", "updateExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalIdentifierProperties.getExternalIdentifier(), "externalIdentifierProperties.externalIdentifier", "updateExternalIdentifier");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/{4}/external-identifiers/update";
        MetadataCorrelationProperties requestBody = new MetadataCorrelationProperties(externalIdentifierProperties);
        requestBody.setExternalScopeGUID(externalScopeGUID);
        requestBody.setExternalScopeName(externalScopeName);
        this.restClient.callVoidPostRESTCall("updateExternalIdentifier", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, openMetadataElementTypeName, openMetadataElementGUID});
    }

    public void removeExternalIdentifier(String userId, String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName, String externalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeExternalIdentifier";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        String externalScopeNameParameterName = "externalScopeName";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String openMetadataTypeParameterName = "openMetadataElementTypeName";
        String externalIdentifierParameterName = "externalIdentifier";
        this.invalidParameterHandler.validateUserId(userId, "removeExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalScopeGUID, "externalScopeGUID", "removeExternalIdentifier");
        this.invalidParameterHandler.validateName(externalScopeName, "externalScopeName", "removeExternalIdentifier");
        this.invalidParameterHandler.validateGUID(openMetadataElementGUID, "openMetadataElementGUID", "removeExternalIdentifier");
        this.invalidParameterHandler.validateName(openMetadataElementTypeName, "openMetadataElementTypeName", "removeExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalIdentifier, "externalIdentifier", "removeExternalIdentifier");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/{4}/external-identifiers/remove";
        MetadataCorrelationProperties requestBody = new MetadataCorrelationProperties();
        requestBody.setExternalScopeGUID(externalScopeGUID);
        requestBody.setExternalScopeName(externalScopeName);
        requestBody.setExternalIdentifier(externalIdentifier);
        this.restClient.callVoidPostRESTCall("removeExternalIdentifier", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, openMetadataElementTypeName, openMetadataElementGUID});
    }

    public void confirmSynchronization(String userId, String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName, String externalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "confirmSynchronization";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        String externalScopeNameParameterName = "externalScopeName";
        String externalIdentifierParameterName = "externalIdentifier";
        this.invalidParameterHandler.validateUserId(userId, "confirmSynchronization");
        this.invalidParameterHandler.validateGUID(externalScopeGUID, "externalScopeGUID", "confirmSynchronization");
        this.invalidParameterHandler.validateName(externalScopeName, "externalScopeName", "confirmSynchronization");
        this.invalidParameterHandler.validateGUID(openMetadataElementGUID, "openMetadataElementGUID", "confirmSynchronization");
        this.invalidParameterHandler.validateGUID(externalIdentifier, "externalIdentifier", "confirmSynchronization");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/{4}/synchronized";
        MetadataCorrelationProperties requestBody = new MetadataCorrelationProperties();
        requestBody.setExternalScopeGUID(externalScopeGUID);
        requestBody.setExternalScopeName(externalScopeName);
        requestBody.setExternalIdentifier(externalIdentifier);
        this.restClient.callVoidPostRESTCall("confirmSynchronization", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, openMetadataElementTypeName, openMetadataElementGUID});
    }

    public List<ElementHeader> getElementsForExternalIdentifier(String userId, String externalScopeGUID, String externalScopeName, String externalIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsForExternalIdentifier";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        String externalScopeNameParameterName = "externalScopeName";
        String externalIdentifierParameterName = "externalIdentifier";
        this.invalidParameterHandler.validateUserId(userId, "getElementsForExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalScopeGUID, "externalScopeGUID", "getElementsForExternalIdentifier");
        this.invalidParameterHandler.validateName(externalScopeName, "externalScopeName", "getElementsForExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalIdentifier, "externalIdentifier", "getElementsForExternalIdentifier");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getElementsForExternalIdentifier");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/external-identifiers/open-metadata-elements?startFrom={3}&pageSize={4}";
        MetadataCorrelationProperties requestBody = new MetadataCorrelationProperties();
        requestBody.setExternalScopeGUID(externalScopeGUID);
        requestBody.setExternalScopeName(externalScopeName);
        requestBody.setExternalIdentifier(externalIdentifier);
        ElementHeadersResponse restResult = this.restClient.callElementHeadersPostRESTCall("getElementsForExternalIdentifier", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, startFrom, validatedPageSize});
        return restResult.getElementHeaders();
    }

    public void validateExternalIdentifier(String userId, String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName, String elementExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (elementExternalIdentifier != null && externalScopeGUID != null && externalScopeName != null) {
            this.confirmSynchronization(userId, openMetadataElementGUID, openMetadataElementTypeName, elementExternalIdentifier, externalScopeGUID, externalScopeName);
        }
    }

    public List<MetadataCorrelationHeader> getMetadataCorrelationHeaders(String userId, String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataCorrelationHeaders";
        String guidParameterName = "openMetadataElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataCorrelationHeaders");
        this.invalidParameterHandler.validateGUID(openMetadataElementGUID, "openMetadataElementGUID", "getMetadataCorrelationHeaders");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/{4}/external-identifiers";
        MetadataCorrelationHeadersResponse restResult = this.restClient.callCorrelationHeadersPostRESTCall("getMetadataCorrelationHeaders", urlTemplate, this.getEffectiveTimeQueryRequestBody(externalScopeGUID, externalScopeName, null), this.serverName, this.serviceURLMarker, userId, openMetadataElementTypeName, openMetadataElementGUID);
        return restResult.getElementList();
    }

    public Map<String, Map<String, String>> getVendorProperties(String userId, String openMetadataElementGUID, String openMetadataElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getVendorProperties";
        List<RelatedMetadataElement> propertyFacets = this.getRelatedMetadataElements(userId, openMetadataElementGUID, 1, OpenMetadataType.REFERENCEABLE_FACET.typeName, false, false, new Date(), 0, 0);
        if (propertyFacets != null) {
            HashMap<String, Map<String, String>> vendorProperties = new HashMap<String, Map<String, String>>();
            for (RelatedMetadataElement relatedMetadataElement : propertyFacets) {
                String propertyFacetDescription;
                String vendorIdentifier;
                if (relatedMetadataElement == null || (vendorIdentifier = this.propertyHelper.getStringProperty(this.serverName, OpenMetadataProperty.SOURCE.name, relatedMetadataElement.getRelationshipProperties(), "getVendorProperties")) == null || !"vendorProperties".equals(propertyFacetDescription = this.propertyHelper.getStringProperty(this.serverName, OpenMetadataProperty.DESCRIPTION.name, relatedMetadataElement.getElement().getElementProperties(), "getVendorProperties"))) continue;
                Map facetProperties = this.propertyHelper.getStringMapFromProperty(this.serverName, OpenMetadataProperty.PROPERTIES.name, relatedMetadataElement.getElement().getElementProperties(), "getVendorProperties");
                vendorProperties.put(vendorIdentifier, facetProperties);
            }
            return vendorProperties;
        }
        return null;
    }

    protected EffectiveTimeQueryRequestBody getEffectiveTimeQueryRequestBody(String externalScopeGUID, String externalScopeName, Date effectiveTime) {
        EffectiveTimeQueryRequestBody requestBody = new EffectiveTimeQueryRequestBody();
        if (externalScopeGUID != null) {
            requestBody.setExternalScopeGUID(externalScopeGUID);
            requestBody.setExternalScopeName(externalScopeName);
        }
        requestBody.setEffectiveTime(effectiveTime);
        return requestBody;
    }
}

