/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.gaf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.gaf.metadatamanagement.builders.GovernanceZoneBuilder;
import org.odpi.openmetadata.commonservices.gaf.metadatamanagement.converters.GovernanceZoneConverter;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceZone;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceZoneHandler {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;

    public GovernanceZoneHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
    }

    public void createGovernanceZone(String userId, String qualifiedName, String displayName, String description, String criteria, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        GovernanceZoneBuilder governanceZoneBuilder = new GovernanceZoneBuilder(qualifiedName, displayName, description, criteria, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.repositoryHandler.createEntity(userId, "290a192b-42a7-449a-935a-269ca62cfdac", "GovernanceZone", governanceZoneBuilder.getInstanceProperties(methodName), methodName);
    }

    public GovernanceZone getGovernanceZone(String userId, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        GovernanceZoneBuilder zoneBuilder = new GovernanceZoneBuilder(qualifiedName, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail zoneEntity = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", zoneBuilder.getQualifiedNameInstanceProperties(methodName), "290a192b-42a7-449a-935a-269ca62cfdac", "GovernanceZone", methodName);
        GovernanceZoneConverter zoneConverter = new GovernanceZoneConverter(zoneEntity, this.repositoryHelper, this.serviceName);
        return zoneConverter.getZoneBean();
    }

    public List<GovernanceZone> getGovernanceZones(String userId, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        List entities = this.repositoryHandler.getEntitiesForType(userId, "290a192b-42a7-449a-935a-269ca62cfdac", "GovernanceZone", startingFrom, maximumResults, methodName);
        ArrayList<GovernanceZone> results = new ArrayList<GovernanceZone>();
        if (entities != null) {
            for (EntityDetail entity : entities) {
                if (entity == null || entity.getGUID() == null) continue;
                GovernanceZoneConverter zoneConverter = new GovernanceZoneConverter(entity, this.repositoryHelper, this.serviceName);
                results.add(zoneConverter.getZoneBean());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

