/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.gaf.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.gaf.converters.RelatedElementConverter;
import org.odpi.openmetadata.commonservices.gaf.converters.RelatedElementsConverter;
import org.odpi.openmetadata.commonservices.gaf.handlers.MetadataElementBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.search.ArrayTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.ClassificationCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.EnumTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.MapTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.SequencingOrder;
import org.odpi.openmetadata.frameworks.governanceaction.search.StructTypePropertyValue;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataElementHandler<B>
extends ReferenceableHandler<B> {
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private final RelatedElementsConverter<RelatedMetadataElements> relatedElementsConverter;
    private final RelatedElementConverter<RelatedMetadataElement> relatedElementConverter;
    private static final Logger log = LoggerFactory.getLogger(MetadataElementHandler.class);

    public MetadataElementHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.relatedElementsConverter = new RelatedElementsConverter(repositoryHelper, serviceName, serverName);
        this.relatedElementConverter = new RelatedElementConverter(repositoryHelper, serviceName, serverName);
    }

    public B getMetadataElementByGUID(String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", methodName);
        return (B)this.getBeanFromRepository(userId, elementGUID, "elementGUID", "OpenMetadataRoot", forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public B getMetadataElementByUniqueName(String userId, String uniqueName, String uniqueNameParameterName, String uniqueNamePropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "uniqueName";
        String namePropertyName = "uniqueNamePropertyName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", methodName);
        this.invalidParameterHandler.validateName(uniqueNamePropertyName, "uniqueNamePropertyName", methodName);
        this.invalidParameterHandler.validateUserId(userId, methodName);
        if (uniqueNameParameterName != null) {
            this.invalidParameterHandler.validateName(uniqueName, uniqueNameParameterName, methodName);
        } else {
            this.invalidParameterHandler.validateName(uniqueName, "uniqueName", methodName);
        }
        return (B)this.getBeanByUniqueName(userId, uniqueName, uniqueNameParameterName, uniqueNamePropertyName, "4e7761e8-3969-4627-8f40-bfe3cde85a1d", "OpenMetadataRoot", forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public String getMetadataElementGUIDByUniqueName(String userId, String uniqueName, String uniqueNameParameterName, String uniqueNamePropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "uniqueName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        if (uniqueNameParameterName != null) {
            this.invalidParameterHandler.validateName(uniqueName, uniqueNameParameterName, methodName);
        } else {
            this.invalidParameterHandler.validateName(uniqueName, "uniqueName", methodName);
        }
        return this.getBeanGUIDByUniqueName(userId, uniqueName, uniqueNameParameterName, uniqueNamePropertyName, "4e7761e8-3969-4627-8f40-bfe3cde85a1d", "OpenMetadataRoot", forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public List<B> findMetadataElementsWithString(String userId, String searchString, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        return this.findBeans(userId, searchString, "searchString", "4e7761e8-3969-4627-8f40-bfe3cde85a1d", "OpenMetadataRoot", forLineage, forDuplicateProcessing, serviceSupportedZones, null, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<RelatedMetadataElement> getRelatedMetadataElements(String userId, String elementGUID, int startingAtEnd, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "elementGUID";
        String typeNameParameterName = "relationshipTypeName";
        String otherEndGUIDParameterName = "otherEnd.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        String relationshipTypeGUID = null;
        if (relationshipTypeName != null) {
            relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        }
        int attachmentAtEnd = 0;
        if (startingAtEnd == 1) {
            attachmentAtEnd = 2;
        } else if (startingAtEnd == 2) {
            attachmentAtEnd = 1;
        }
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, elementGUID, "elementGUID", "OpenMetadataRoot", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List relationships = super.getAttachmentLinks(userId, startingEntity, "elementGUID", "OpenMetadataRoot", relationshipTypeGUID, relationshipTypeName, null, "OpenMetadataRoot", attachmentAtEnd, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (relationships != null) {
            ArrayList<RelatedMetadataElement> results = new ArrayList<RelatedMetadataElement>();
            HashSet<String> entityGUIDs = new HashSet<String>();
            for (Relationship relationship : relationships) {
                EntityProxy otherEnd;
                if (relationship == null || (otherEnd = this.repositoryHandler.getOtherEnd(startingEntity.getGUID(), relationship)) == null || entityGUIDs.contains(otherEnd.getGUID())) continue;
                entityGUIDs.add(otherEnd.getGUID());
                try {
                    EntityDetail otherEndEntity = this.getEntityFromRepository(userId, otherEnd.getGUID(), "otherEnd.getGUID()", "OpenMetadataRoot", null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                    if (otherEndEntity == null) continue;
                    results.add(this.relatedElementConverter.getNewBean(RelatedMetadataElement.class, otherEndEntity, relationship, methodName));
                }
                catch (Exception nonVisibleEntityException) {
                    log.debug("Ignoring entity " + otherEnd.getGUID());
                }
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<B> findMetadataElements(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeName, org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, SearchClassifications searchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return super.findBeans(userId, metadataElementTypeName, metadataElementSubtypeName, this.getSearchProperties(searchProperties), this.getInstanceStatuses(limitResultsByStatus), this.getSearchClassifications(searchClassifications), asOfTime, sequencingProperty, this.getSequencingOrder(sequencingOrder), forLineage, forDuplicateProcessing, startingFrom, pageSize, serviceSupportedZones, effectiveTime, methodName);
    }

    private SearchProperties getSearchProperties(org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties gafSearchProperties) throws InvalidParameterException {
        if (gafSearchProperties != null) {
            SearchProperties omrsSearchProperties = new SearchProperties();
            omrsSearchProperties.setConditions(this.getPropertyConditions(gafSearchProperties.getConditions()));
            omrsSearchProperties.setMatchCriteria(this.getMatchCriteria(gafSearchProperties.getMatchCriteria()));
            return omrsSearchProperties;
        }
        return null;
    }

    private org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications getSearchClassifications(SearchClassifications gafSearchClassifications) throws InvalidParameterException {
        if (gafSearchClassifications != null) {
            org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications omrsSearchClassifications = new org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications();
            if (gafSearchClassifications.getConditions() != null && !gafSearchClassifications.getConditions().isEmpty()) {
                ArrayList<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition> omrsClassificationConditions = new ArrayList<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition>();
                for (ClassificationCondition gafClassificationCondition : gafSearchClassifications.getConditions()) {
                    org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition omrsClassificationCondition = new org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition();
                    omrsClassificationCondition.setName(gafClassificationCondition.getName());
                    omrsClassificationCondition.setMatchProperties(this.getSearchProperties(gafClassificationCondition.getSearchProperties()));
                    omrsClassificationConditions.add(omrsClassificationCondition);
                }
                if (!omrsClassificationConditions.isEmpty()) {
                    omrsSearchClassifications.setConditions(omrsClassificationConditions);
                }
            }
            omrsSearchClassifications.setMatchCriteria(this.getMatchCriteria(gafSearchClassifications.getMatchCriteria()));
            return omrsSearchClassifications;
        }
        return null;
    }

    private List<PropertyCondition> getPropertyConditions(List<org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition> gafPropertyConditions) throws InvalidParameterException {
        if (gafPropertyConditions != null && !gafPropertyConditions.isEmpty()) {
            ArrayList<PropertyCondition> omrsPropertyConditions = new ArrayList<PropertyCondition>();
            for (org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition propertyCondition : gafPropertyConditions) {
                if (propertyCondition == null) continue;
                PropertyCondition omrsPropertyCondition = new PropertyCondition();
                omrsPropertyCondition.setProperty(propertyCondition.getProperty());
                omrsPropertyCondition.setOperator(this.getPropertyComparisonOperator(propertyCondition.getOperator()));
                omrsPropertyCondition.setValue(this.getInstancePropertyValue(propertyCondition.getValue()));
                omrsPropertyCondition.setNestedConditions(this.getSearchProperties(propertyCondition.getNestedConditions()));
                omrsPropertyConditions.add(omrsPropertyCondition);
            }
            return omrsPropertyConditions;
        }
        return null;
    }

    private InstancePropertyValue getInstancePropertyValue(PropertyValue propertyValue) throws InvalidParameterException {
        if (propertyValue != null) {
            String methodName = "getInstancePropertyValue";
            String typeParameterName = "propertyValue.getTypeName()";
            AttributeTypeDef typeDef = this.repositoryHelper.getAttributeTypeDefByName(this.serviceName, propertyValue.getTypeName());
            this.invalidParameterHandler.validateObject((Object)typeDef, "propertyValue.getTypeName()", "getInstancePropertyValue");
            if (propertyValue instanceof ArrayTypePropertyValue) {
                ArrayTypePropertyValue gafPropertyValue = (ArrayTypePropertyValue)propertyValue;
                return this.getArrayPropertyValue(typeDef, gafPropertyValue.getArrayCount(), this.propertyHelper.getElementPropertiesAsMap(gafPropertyValue.getArrayValues()));
            }
            if (propertyValue instanceof EnumTypePropertyValue) {
                EnumTypePropertyValue gafPropertyValue = (EnumTypePropertyValue)propertyValue;
                return this.getEnumPropertyValue(typeDef, gafPropertyValue.getSymbolicName());
            }
            if (propertyValue instanceof MapTypePropertyValue) {
                MapTypePropertyValue gafPropertyValue = (MapTypePropertyValue)propertyValue;
                return this.getMapPropertyValue(typeDef, this.propertyHelper.getElementPropertiesAsMap(gafPropertyValue.getMapValues()));
            }
            if (propertyValue instanceof PrimitiveTypePropertyValue) {
                PrimitiveTypePropertyValue gafPropertyValue = (PrimitiveTypePropertyValue)propertyValue;
                return this.getPrimitivePropertyValue(typeDef, gafPropertyValue.getPrimitiveTypeCategory(), gafPropertyValue.getPrimitiveValue());
            }
            if (propertyValue instanceof StructTypePropertyValue) {
                StructTypePropertyValue gafPropertyValue = (StructTypePropertyValue)propertyValue;
                return this.getStructPropertyValue(typeDef, this.propertyHelper.getElementPropertiesAsMap(gafPropertyValue.getAttributes()));
            }
        }
        return null;
    }

    private ArrayPropertyValue getArrayPropertyValue(AttributeTypeDef typeDef, int arrayCount, Map<String, Object> arrayValues) throws InvalidParameterException {
        String methodName = "getArrayPropertyValue";
        ArrayPropertyValue omrsPropertyValue = new ArrayPropertyValue();
        omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.ARRAY);
        omrsPropertyValue.setTypeGUID(typeDef.getGUID());
        omrsPropertyValue.setTypeName(typeDef.getName());
        omrsPropertyValue.setArrayCount(arrayCount);
        try {
            omrsPropertyValue.setArrayValues(this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, arrayValues, "getArrayPropertyValue"));
        }
        catch (OCFCheckedExceptionBase error) {
            String parameterName = "searchProperties";
            throw new InvalidParameterException(error, "searchProperties");
        }
        return omrsPropertyValue;
    }

    private EnumPropertyValue getEnumPropertyValue(AttributeTypeDef typeDef, String symbolicName) throws InvalidParameterException {
        EnumDef enumDef;
        List enumElementDefs;
        String methodName = "getEnumPropertyValue";
        String symbolicNameParameterName = "symbolicName";
        String propertyParameterName = "omrsPropertyValue";
        this.invalidParameterHandler.validateName(symbolicName, "symbolicName", "getEnumPropertyValue");
        EnumPropertyValue omrsPropertyValue = null;
        if (typeDef instanceof EnumDef && (enumElementDefs = (enumDef = (EnumDef)typeDef).getElementDefs()) != null && !enumElementDefs.isEmpty()) {
            for (EnumElementDef enumElementDef : enumElementDefs) {
                if (enumElementDef == null || !symbolicName.equals(enumElementDef.getValue())) continue;
                omrsPropertyValue = new EnumPropertyValue();
                omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.ENUM);
                omrsPropertyValue.setTypeGUID(typeDef.getGUID());
                omrsPropertyValue.setTypeName(typeDef.getName());
                omrsPropertyValue.setSymbolicName(symbolicName);
                omrsPropertyValue.setOrdinal(enumElementDef.getOrdinal());
                omrsPropertyValue.setDescription(enumElementDef.getDescription());
            }
        }
        this.invalidParameterHandler.validateObject(omrsPropertyValue, "omrsPropertyValue", "getEnumPropertyValue");
        return omrsPropertyValue;
    }

    private MapPropertyValue getMapPropertyValue(AttributeTypeDef typeDef, Map<String, Object> mapValues) throws InvalidParameterException {
        String methodName = "getMapPropertyValue";
        MapPropertyValue omrsPropertyValue = new MapPropertyValue();
        omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.MAP);
        omrsPropertyValue.setTypeGUID(typeDef.getGUID());
        omrsPropertyValue.setTypeName(typeDef.getName());
        try {
            omrsPropertyValue.setMapValues(this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, mapValues, "getMapPropertyValue"));
        }
        catch (OCFCheckedExceptionBase error) {
            String parameterName = "searchProperties";
            throw new InvalidParameterException(error, "searchProperties");
        }
        return omrsPropertyValue;
    }

    private PrimitivePropertyValue getPrimitivePropertyValue(AttributeTypeDef typeDef, PrimitiveTypeCategory primitiveTypeCategory, Object primitiveValue) throws InvalidParameterException {
        String methodName = "getPrimitivePropertyValue";
        String valueParameterName = "primitiveValue";
        String categoryParameterName = "primitiveTypeCategory";
        this.invalidParameterHandler.validateObject((Object)primitiveTypeCategory, "primitiveTypeCategory", "getPrimitivePropertyValue");
        this.invalidParameterHandler.validateObject(primitiveValue, "primitiveValue", "getPrimitivePropertyValue");
        PrimitivePropertyValue omrsPropertyValue = new PrimitivePropertyValue();
        omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.PRIMITIVE);
        omrsPropertyValue.setTypeGUID(typeDef.getGUID());
        omrsPropertyValue.setTypeName(typeDef.getName());
        omrsPropertyValue.setPrimitiveDefCategory(this.getPrimitiveDefCategory(primitiveTypeCategory));
        omrsPropertyValue.setPrimitiveValue(primitiveValue);
        return omrsPropertyValue;
    }

    private PrimitiveDefCategory getPrimitiveDefCategory(PrimitiveTypeCategory gafPrimitiveTypeCategory) {
        if (gafPrimitiveTypeCategory != null) {
            switch (gafPrimitiveTypeCategory) {
                case OM_PRIMITIVE_TYPE_UNKNOWN: {
                    return PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                }
                case OM_PRIMITIVE_TYPE_BOOLEAN: {
                    return PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN;
                }
                case OM_PRIMITIVE_TYPE_BYTE: {
                    return PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE;
                }
                case OM_PRIMITIVE_TYPE_CHAR: {
                    return PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR;
                }
                case OM_PRIMITIVE_TYPE_SHORT: {
                    return PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT;
                }
                case OM_PRIMITIVE_TYPE_INT: {
                    return PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT;
                }
                case OM_PRIMITIVE_TYPE_LONG: {
                    return PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG;
                }
                case OM_PRIMITIVE_TYPE_FLOAT: {
                    return PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT;
                }
                case OM_PRIMITIVE_TYPE_DOUBLE: {
                    return PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE;
                }
                case OM_PRIMITIVE_TYPE_BIGINTEGER: {
                    return PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER;
                }
                case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                    return PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL;
                }
                case OM_PRIMITIVE_TYPE_STRING: {
                    return PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING;
                }
                case OM_PRIMITIVE_TYPE_DATE: {
                    return PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE;
                }
            }
        }
        return null;
    }

    private StructPropertyValue getStructPropertyValue(AttributeTypeDef typeDef, Map<String, Object> attributes) throws InvalidParameterException {
        String methodName = "getStructPropertyValue";
        StructPropertyValue omrsPropertyValue = new StructPropertyValue();
        omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.STRUCT);
        omrsPropertyValue.setTypeGUID(typeDef.getGUID());
        omrsPropertyValue.setTypeName(typeDef.getName());
        try {
            omrsPropertyValue.setAttributes(this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, attributes, "getStructPropertyValue"));
        }
        catch (OCFCheckedExceptionBase error) {
            String parameterName = "searchProperties";
            throw new InvalidParameterException(error, "searchProperties");
        }
        return omrsPropertyValue;
    }

    private org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria getMatchCriteria(MatchCriteria gafMatchCriteria) {
        if (gafMatchCriteria != null) {
            switch (gafMatchCriteria) {
                case ALL: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria.ALL;
                }
                case ANY: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria.ANY;
                }
                case NONE: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria.NONE;
                }
            }
        }
        return null;
    }

    private PropertyComparisonOperator getPropertyComparisonOperator(org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator gafPropertyComparisonOperator) {
        if (gafPropertyComparisonOperator != null) {
            switch (gafPropertyComparisonOperator) {
                case EQ: {
                    return PropertyComparisonOperator.EQ;
                }
                case NEQ: {
                    return PropertyComparisonOperator.NEQ;
                }
                case LT: {
                    return PropertyComparisonOperator.LT;
                }
                case LTE: {
                    return PropertyComparisonOperator.LTE;
                }
                case GT: {
                    return PropertyComparisonOperator.GT;
                }
                case GTE: {
                    return PropertyComparisonOperator.GTE;
                }
                case IN: {
                    return PropertyComparisonOperator.IN;
                }
                case IS_NULL: {
                    return PropertyComparisonOperator.IS_NULL;
                }
                case NOT_NULL: {
                    return PropertyComparisonOperator.NOT_NULL;
                }
                case LIKE: {
                    return PropertyComparisonOperator.LIKE;
                }
            }
        }
        return null;
    }

    private org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder getSequencingOrder(SequencingOrder gafSequencingOrder) {
        if (gafSequencingOrder != null) {
            switch (gafSequencingOrder) {
                case ANY: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.ANY;
                }
                case GUID: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.GUID;
                }
                case CREATION_DATE_RECENT: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.CREATION_DATE_RECENT;
                }
                case CREATION_DATE_OLDEST: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.CREATION_DATE_OLDEST;
                }
                case LAST_UPDATE_RECENT: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.LAST_UPDATE_RECENT;
                }
                case LAST_UPDATE_OLDEST: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.LAST_UPDATE_OLDEST;
                }
                case PROPERTY_ASCENDING: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.PROPERTY_ASCENDING;
                }
                case PROPERTY_DESCENDING: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.PROPERTY_DESCENDING;
                }
            }
        }
        return null;
    }

    private List<InstanceStatus> getInstanceStatuses(List<ElementStatus> elementStatuses) {
        if (elementStatuses != null) {
            ArrayList<InstanceStatus> instanceStatuses = new ArrayList<InstanceStatus>();
            for (ElementStatus elementStatus : elementStatuses) {
                if (elementStatus == null) continue;
                instanceStatuses.add(this.getInstanceStatus(elementStatus));
            }
            if (!instanceStatuses.isEmpty()) {
                return instanceStatuses;
            }
        }
        return null;
    }

    private InstanceStatus getInstanceStatus(ElementStatus elementStatus) {
        if (elementStatus != null) {
            switch (elementStatus) {
                case UNKNOWN: {
                    return InstanceStatus.UNKNOWN;
                }
                case DRAFT: {
                    return InstanceStatus.DRAFT;
                }
                case PREPARED: {
                    return InstanceStatus.PREPARED;
                }
                case PROPOSED: {
                    return InstanceStatus.PROPOSED;
                }
                case APPROVED: {
                    return InstanceStatus.APPROVED;
                }
                case REJECTED: {
                    return InstanceStatus.REJECTED;
                }
                case APPROVED_CONCEPT: {
                    return InstanceStatus.APPROVED_CONCEPT;
                }
                case UNDER_DEVELOPMENT: {
                    return InstanceStatus.UNDER_DEVELOPMENT;
                }
                case DEVELOPMENT_COMPLETE: {
                    return InstanceStatus.DEVELOPMENT_COMPLETE;
                }
                case APPROVED_FOR_DEPLOYMENT: {
                    return InstanceStatus.APPROVED_FOR_DEPLOYMENT;
                }
                case STANDBY: {
                    return InstanceStatus.STANDBY;
                }
                case ACTIVE: {
                    return InstanceStatus.ACTIVE;
                }
                case FAILED: {
                    return InstanceStatus.FAILED;
                }
                case DISABLED: {
                    return InstanceStatus.DISABLED;
                }
                case COMPLETE: {
                    return InstanceStatus.COMPLETE;
                }
                case DEPRECATED: {
                    return InstanceStatus.DEPRECATED;
                }
                case OTHER: {
                    return InstanceStatus.OTHER;
                }
            }
        }
        return null;
    }

    public List<RelatedMetadataElements> findRelationshipsBetweenMetadataElements(String userId, String relationshipTypeName, org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        List relationships = this.findAttachmentLinks(userId, relationshipTypeName, this.getSearchProperties(searchProperties), this.getInstanceStatuses(limitResultsByStatus), asOfTime, sequencingProperty, this.getSequencingOrder(sequencingOrder), forLineage, forDuplicateProcessing, startFrom, pageSize, serviceSupportedZones, effectiveTime, methodName);
        if (relationships != null) {
            ArrayList<RelatedMetadataElements> results = new ArrayList<RelatedMetadataElements>();
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                results.add(this.relatedElementsConverter.getNewRelationshipBean(RelatedMetadataElements.class, relationship, methodName));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public String createMetadataElementInStore(String userId, String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String templateGUID, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementTypeParameterName = "metadataElementTypeName";
        String templateGUIDParameterName = "templateGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(metadataElementTypeName, "metadataElementTypeName", methodName);
        String metadataElementTypeGUID = this.invalidParameterHandler.validateTypeName(metadataElementTypeName, "OpenMetadataRoot", this.serviceName, methodName, this.repositoryHelper);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.getElementPropertiesAsOMRSMap(properties), this.getInstanceStatus(initialStatus), effectiveFrom, effectiveTo, this.repositoryHelper, this.serviceName, this.serverName);
        if (templateGUID == null) {
            return this.createBeanInRepository(userId, null, null, metadataElementTypeGUID, metadataElementTypeName, null, null, builder, effectiveTime, methodName);
        }
        return this.createBeanFromTemplate(userId, null, null, templateGUID, "templateGUID", metadataElementTypeGUID, metadataElementTypeName, null, null, builder, serviceSupportedZones, methodName);
    }

    public void updateMetadataElementInStore(String userId, String metadataElementGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.getElementPropertiesAsOMRSMap(properties), this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, null, null, metadataElementGUID, "metadataElementGUID", "4e7761e8-3969-4627-8f40-bfe3cde85a1d", "OpenMetadataRoot", forLineage, forDuplicateProcessing, serviceSupportedZones, builder.getInstanceProperties(methodName), !replaceProperties, effectiveTime, methodName);
    }

    public void updateMetadataElementStatusInStore(String userId, String metadataElementGUID, ElementStatus newElementStatus, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        String statusParameterName = "newElementStatus";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        super.updateBeanStatusInRepository(userId, null, null, metadataElementGUID, "metadataElementGUID", "4e7761e8-3969-4627-8f40-bfe3cde85a1d", "OpenMetadataRoot", forLineage, forDuplicateProcessing, serviceSupportedZones, this.getInstanceStatus(newElementStatus), "newElementStatus", effectiveTime, methodName);
    }

    public void updateMetadataElementEffectivityInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        super.updateBeanEffectivityDates(userId, null, null, metadataElementGUID, "metadataElementGUID", "4e7761e8-3969-4627-8f40-bfe3cde85a1d", "OpenMetadataRoot", forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, serviceSupportedZones, effectiveTime, methodName);
    }

    public void deleteMetadataElementInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        super.deleteBeanInRepository(userId, null, null, metadataElementGUID, "metadataElementGUID", "4e7761e8-3969-4627-8f40-bfe3cde85a1d", "OpenMetadataRoot", null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public void classifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        this.invalidParameterHandler.validateName(classificationName, "classificationName", methodName);
        String classificationTypeGUID = this.invalidParameterHandler.validateTypeName(classificationName, null, this.serviceName, methodName, this.repositoryHelper);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties classificationProperties = builder.getInstanceProperties(this.getElementPropertiesAsOMRSMap(properties), effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, null, null, metadataElementGUID, "metadataElementGUID", "OpenMetadataRoot", classificationTypeGUID, classificationName, classificationProperties, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public void reclassifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        this.invalidParameterHandler.validateName(classificationName, "classificationName", methodName);
        String classificationTypeGUID = this.invalidParameterHandler.validateTypeName(classificationName, null, this.serviceName, methodName, this.repositoryHelper);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties classificationProperties = builder.getInstanceProperties(this.getElementPropertiesAsOMRSMap(properties), null, null);
        this.setClassificationInRepository(userId, null, null, metadataElementGUID, "metadataElementGUID", "OpenMetadataRoot", classificationTypeGUID, classificationName, classificationProperties, !replaceProperties, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public void updateClassificationStatusInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        this.invalidParameterHandler.validateName(classificationName, "classificationName", methodName);
        String classificationTypeGUID = this.invalidParameterHandler.validateTypeName(classificationName, null, this.serviceName, methodName, this.repositoryHelper);
        super.updateClassificationEffectivityDates(userId, null, null, metadataElementGUID, "metadataElementGUID", "OpenMetadataRoot", classificationTypeGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, serviceSupportedZones, effectiveTime, methodName);
    }

    public void unclassifyMetadataElementInStore(String userId, String metadataElementGUID, String metadataElementGUIDParameterName, String metadataElementTypeName, String classificationName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String classificationParameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, metadataElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(classificationName, "classificationName", methodName);
        String classificationTypeGUID = this.invalidParameterHandler.validateTypeName(classificationName, null, this.serviceName, methodName, this.repositoryHelper);
        super.removeClassificationFromRepository(userId, null, null, metadataElementGUID, metadataElementGUIDParameterName, metadataElementTypeName, classificationTypeGUID, classificationName, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public String createRelatedElementsInStore(String userId, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementTypeParameterName = "relationshipTypeName";
        String end1ParameterName = "metadataElement1GUID";
        String end2ParameterName = "metadataElement2GUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", methodName);
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getInstanceProperties(this.getElementPropertiesAsOMRSMap(properties), effectiveFrom, effectiveTo);
        super.linkElementToElement(userId, null, null, metadataElement1GUID, "metadataElement1GUID", "OpenMetadataRoot", metadataElement2GUID, "metadataElement2GUID", "OpenMetadataRoot", forLineage, forDuplicateProcessing, serviceSupportedZones, relationshipTypeGUID, relationshipTypeName, relationshipProperties, effectiveFrom, effectiveTo, effectiveTime, methodName);
        return null;
    }

    public Map<String, InstancePropertyValue> getElementPropertiesAsOMRSMap(ElementProperties properties) throws InvalidParameterException {
        if (properties != null) {
            Map propertyValues = properties.getPropertyValueMap();
            HashMap<String, InstancePropertyValue> resultingMap = new HashMap<String, InstancePropertyValue>();
            if (propertyValues != null) {
                for (String mapPropertyName : propertyValues.keySet()) {
                    PropertyValue actualPropertyValue = properties.getPropertyValue(mapPropertyName);
                    InstancePropertyValue instancePropertyValue = this.getInstancePropertyValue(actualPropertyValue);
                    resultingMap.put(mapPropertyName, instancePropertyValue);
                }
            }
            return resultingMap;
        }
        return null;
    }

    public void updateRelatedElementsInStore(String userId, String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationshipGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", methodName);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getInstanceProperties(this.getElementPropertiesAsOMRSMap(properties), null, null);
        this.updateRelationshipProperties(userId, null, null, relationshipGUID, "relationshipGUID", null, !replaceProperties, relationshipProperties, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public void updateRelatedElementsStatusInStore(String userId, String relationshipGUID, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationshipGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", methodName);
        super.updateRelationshipEffectivityDates(userId, null, null, relationshipGUID, "relationshipGUID", null, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public void deleteRelatedElementsInStore(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationshipGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", methodName);
        this.repositoryHandler.removeRelationship(userId, null, null, null, relationshipGUID, methodName);
    }
}

