/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.gaf.server;

import java.util.Date;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.gaf.ffdc.OpenMetadataStoreAuditCode;
import org.odpi.openmetadata.commonservices.gaf.handlers.MetadataElementHandler;
import org.odpi.openmetadata.commonservices.gaf.rest.FindRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.IncidentReportRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.NewClassificationRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.NewMetadataElementRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.NewRelatedElementsRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.RelatedMetadataElementListResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.RelatedMetadataElementsListResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdateEffectivityDatesRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdatePropertiesRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdateRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdateStatusRequestBody;
import org.odpi.openmetadata.commonservices.gaf.server.OpenMetadataStoreInstanceHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.slf4j.LoggerFactory;

public class OpenMetadataStoreRESTServices {
    private static final OpenMetadataStoreInstanceHandler instanceHandler = new OpenMetadataStoreInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OpenMetadataStoreRESTServices.class), instanceHandler.getServiceName());

    public VoidResponse logAssetAuditMessage(String serverName, String serviceURLMarker, String userId, String assetGUID, String governanceService, String message) {
        String methodName = "logAssetAuditMessage";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "logAssetAuditMessage");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "logAssetAuditMessage");
            this.getMetadataElementByGUID(serverName, serviceURLMarker, userId, assetGUID, false, false, new Date().getTime());
            auditLog.logMessage("logAssetAuditMessage", OpenMetadataStoreAuditCode.ASSET_AUDIT_LOG.getMessageDefinition(new String[]{assetGUID, governanceService, message}));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "logAssetAuditMessage", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private Date getEffectiveTimeFromLong(long effectiveTime) {
        Date result = null;
        if (effectiveTime != 0L) {
            result = new Date(effectiveTime);
        }
        return result;
    }

    public OpenMetadataElementResponse getMetadataElementByGUID(String serverName, String serviceURLMarker, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime) {
        String methodName = "getMetadataElementByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataElementByGUID");
        AuditLog auditLog = null;
        OpenMetadataElementResponse response = new OpenMetadataElementResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementByGUID");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getMetadataElementByGUID");
            response.setElement(handler.getMetadataElementByGUID(userId, elementGUID, forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getMetadataElementByGUID"), this.getEffectiveTimeFromLong(effectiveTime), "getMetadataElementByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataElementByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementResponse getMetadataElementByUniqueName(String serverName, String serviceURLMarker, String userId, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime, NameRequestBody requestBody) {
        String methodName = "getMetadataElementByUniqueName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataElementByUniqueName");
        AuditLog auditLog = null;
        OpenMetadataElementResponse response = new OpenMetadataElementResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementByUniqueName");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getMetadataElementByUniqueName");
                response.setElement(handler.getMetadataElementByUniqueName(userId, requestBody.getName(), requestBody.getNameParameterName(), requestBody.getNamePropertyName(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getMetadataElementByUniqueName"), this.getEffectiveTimeFromLong(effectiveTime), "getMetadataElementByUniqueName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMetadataElementByUniqueName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataElementByUniqueName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getMetadataElementGUIDByUniqueName(String serverName, String serviceURLMarker, String userId, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime, NameRequestBody requestBody) {
        String methodName = "getMetadataElementGUIDByUniqueName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataElementGUIDByUniqueName");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementGUIDByUniqueName");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getMetadataElementGUIDByUniqueName");
                response.setGUID(handler.getMetadataElementGUIDByUniqueName(userId, requestBody.getName(), requestBody.getNameParameterName(), requestBody.getNamePropertyName(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getMetadataElementGUIDByUniqueName"), this.getEffectiveTimeFromLong(effectiveTime), "getMetadataElementGUIDByUniqueName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMetadataElementGUIDByUniqueName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataElementGUIDByUniqueName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementsResponse findMetadataElementsWithString(String serverName, String serviceURLMarker, String userId, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findMetadataElementsWithString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMetadataElementsWithString");
        AuditLog auditLog = null;
        OpenMetadataElementsResponse response = new OpenMetadataElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMetadataElementsWithString");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "findMetadataElementsWithString");
                response.setElementList(handler.findMetadataElementsWithString(userId, requestBody.getSearchString(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "findMetadataElementsWithString"), this.getEffectiveTimeFromLong(effectiveTime), startFrom, pageSize, "findMetadataElementsWithString"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findMetadataElementsWithString", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findMetadataElementsWithString", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementListResponse getRelatedMetadataElements(String serverName, String serviceURLMarker, String userId, String elementGUID, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime, int startingAtEnd, int startFrom, int pageSize) {
        String methodName = "getRelatedMetadataElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelatedMetadataElements");
        AuditLog auditLog = null;
        RelatedMetadataElementListResponse response = new RelatedMetadataElementListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedMetadataElements");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getRelatedMetadataElements");
            response.setElementList(handler.getRelatedMetadataElements(userId, elementGUID, startingAtEnd, relationshipTypeName, forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getRelatedMetadataElements"), this.getEffectiveTimeFromLong(effectiveTime), startFrom, pageSize, "getRelatedMetadataElements"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRelatedMetadataElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementsResponse findMetadataElements(String serverName, String serviceURLMarker, String userId, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime, int startFrom, int pageSize, FindRequestBody requestBody) {
        String methodName = "findMetadataElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMetadataElements");
        AuditLog auditLog = null;
        OpenMetadataElementsResponse response = new OpenMetadataElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMetadataElements");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "findMetadataElements");
                response.setElementList(handler.findMetadataElements(userId, requestBody.getMetadataElementTypeName(), requestBody.getMetadataElementSubtypeName(), requestBody.getSearchProperties(), requestBody.getLimitResultsByStatus(), requestBody.getMatchClassifications(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "findMetadataElements"), this.getEffectiveTimeFromLong(effectiveTime), startFrom, pageSize, "findMetadataElements"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findMetadataElements", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findMetadataElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementsListResponse findRelationshipsBetweenMetadataElements(String serverName, String serviceURLMarker, String userId, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime, int startFrom, int pageSize, FindRequestBody requestBody) {
        String methodName = "findRelationshipsBetweenMetadataElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findRelationshipsBetweenMetadataElements");
        AuditLog auditLog = null;
        RelatedMetadataElementsListResponse response = new RelatedMetadataElementsListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findRelationshipsBetweenMetadataElements");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "findRelationshipsBetweenMetadataElements");
                response.setElementList(handler.findRelationshipsBetweenMetadataElements(userId, requestBody.getMetadataElementTypeName(), requestBody.getSearchProperties(), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "findRelationshipsBetweenMetadataElements"), this.getEffectiveTimeFromLong(effectiveTime), startFrom, pageSize, "findRelationshipsBetweenMetadataElements"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findRelationshipsBetweenMetadataElements", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findRelationshipsBetweenMetadataElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createMetadataElementInStore(String serverName, String serviceURLMarker, String userId, NewMetadataElementRequestBody requestBody) {
        String methodName = "createMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createMetadataElementInStore");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "createMetadataElementInStore");
                response.setGUID(handler.createMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getTypeName(), requestBody.getInitialStatus(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), requestBody.getTemplateGUID(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createMetadataElementInStore"), requestBody.getEffectiveTime(), "createMetadataElementInStore"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, UpdatePropertiesRequestBody requestBody) {
        String methodName = "updateMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateMetadataElementInStore");
                handler.updateMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getReplaceProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateMetadataElementInStore"), requestBody.getEffectiveTime(), "updateMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateMetadataElementStatusInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, UpdateStatusRequestBody requestBody) {
        String methodName = "updateMetadataElementStatusInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateMetadataElementStatusInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateMetadataElementStatusInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateMetadataElementStatusInStore");
                handler.updateMetadataElementStatusInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getNewStatus(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateMetadataElementStatusInStore"), requestBody.getEffectiveTime(), "updateMetadataElementStatusInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateMetadataElementStatusInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateMetadataElementStatusInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateMetadataElementEffectivityInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, UpdateEffectivityDatesRequestBody requestBody) {
        String methodName = "updateMetadataElementEffectivityInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateMetadataElementEffectivityInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateMetadataElementEffectivityInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateMetadataElementEffectivityInStore");
                handler.updateMetadataElementEffectivityInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateMetadataElementEffectivityInStore"), requestBody.getEffectiveTime(), "updateMetadataElementEffectivityInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateMetadataElementEffectivityInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateMetadataElementEffectivityInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, UpdateRequestBody requestBody) {
        String methodName = "deleteMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "deleteMetadataElementInStore");
                handler.deleteMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "deleteMetadataElementInStore"), requestBody.getEffectiveTime(), "deleteMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse classifyMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, String classificationName, NewClassificationRequestBody requestBody) {
        String methodName = "classifyMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "classifyMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "classifyMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "classifyMetadataElementInStore");
                handler.classifyMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, classificationName, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "classifyMetadataElementInStore"), requestBody.getEffectiveTime(), "classifyMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "classifyMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "classifyMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse reclassifyMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, String classificationName, UpdatePropertiesRequestBody requestBody) {
        String methodName = "reclassifyMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "reclassifyMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "reclassifyMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "reclassifyMetadataElementInStore");
                handler.reclassifyMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, classificationName, requestBody.getReplaceProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "reclassifyMetadataElementInStore"), requestBody.getEffectiveTime(), "reclassifyMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "reclassifyMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "reclassifyMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateClassificationEffectivityInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, String classificationName, UpdateEffectivityDatesRequestBody requestBody) {
        String methodName = "updateClassificationStatusInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateClassificationStatusInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateClassificationStatusInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateClassificationStatusInStore");
                handler.updateClassificationStatusInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, classificationName, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateClassificationStatusInStore"), requestBody.getEffectiveTime(), "updateClassificationStatusInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateClassificationStatusInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateClassificationStatusInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unclassifyMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, String classificationName, UpdateRequestBody requestBody) {
        String methodName = "unclassifyMetadataElementInStore";
        String metadataElementGUIDParameterName = "metadataElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unclassifyMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unclassifyMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "unclassifyMetadataElementInStore");
                handler.unclassifyMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, "metadataElementGUID", "OpenMetadataRoot", classificationName, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "unclassifyMetadataElementInStore"), requestBody.getEffectiveTime(), "unclassifyMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "unclassifyMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unclassifyMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createRelatedElementsInStore(String serverName, String serviceURLMarker, String userId, NewRelatedElementsRequestBody requestBody) {
        String methodName = "createRelatedElementsInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createRelatedElementsInStore");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createRelatedElementsInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "createRelatedElementsInStore");
                response.setGUID(handler.createRelatedElementsInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getTypeName(), requestBody.getMetadataElement1GUID(), requestBody.getMetadataElement2GUID(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createRelatedElementsInStore"), requestBody.getEffectiveTime(), "createRelatedElementsInStore"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createRelatedElementsInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createRelatedElementsInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateRelatedElementsInStore(String serverName, String serviceURLMarker, String userId, String relationshipGUID, UpdatePropertiesRequestBody requestBody) {
        String methodName = "updateRelatedElementsInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateRelatedElementsInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateRelatedElementsInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateRelatedElementsInStore");
                handler.updateRelatedElementsInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), relationshipGUID, requestBody.getReplaceProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateRelatedElementsInStore"), requestBody.getEffectiveTime(), "updateRelatedElementsInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateRelatedElementsInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateRelatedElementsInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateRelatedElementsEffectivityInStore(String serverName, String serviceURLMarker, String userId, String relationshipGUID, UpdateEffectivityDatesRequestBody requestBody) {
        String methodName = "updateRelatedElementsStatusInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateRelatedElementsStatusInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateRelatedElementsStatusInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateRelatedElementsStatusInStore");
                handler.updateRelatedElementsStatusInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), relationshipGUID, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateRelatedElementsStatusInStore"), requestBody.getEffectiveTime(), "updateRelatedElementsStatusInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateRelatedElementsStatusInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateRelatedElementsStatusInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteRelatedElementsInStore(String serverName, String serviceURLMarker, String userId, String relationshipGUID, UpdateRequestBody requestBody) {
        String methodName = "deleteRelatedElementsInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteRelatedElementsInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteRelatedElementsInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "deleteRelatedElementsInStore");
                handler.deleteRelatedElementsInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), relationshipGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "deleteRelatedElementsInStore"), requestBody.getEffectiveTime(), "deleteRelatedElementsInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteRelatedElementsInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteRelatedElementsInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createIncidentReport(String serverName, String serviceURLMarker, String userId, IncidentReportRequestBody requestBody) {
        String methodName = "createIncidentReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createIncidentReport");
        Object auditLog = null;
        GUIDResponse response = new GUIDResponse();
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

