/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server;

import java.util.Date;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworkservices.gaf.handlers.MetadataElementHandler;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ActionTargetStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CompletionStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ConsolidatedDuplicatesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.PeerDuplicatesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.server.GAFMetadataManagementInstanceHandler;
import org.slf4j.LoggerFactory;

public class OpenGovernanceRESTServices {
    private static final GAFMetadataManagementInstanceHandler instanceHandler = new GAFMetadataManagementInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OpenGovernanceRESTServices.class), instanceHandler.getServiceName());

    public VoidResponse linkElementsAsDuplicates(String serverName, String userId, PeerDuplicatesRequestBody requestBody) {
        String methodName = "linkElementsAsDuplicates";
        String element1GUIDParameterName = "element1GUID";
        String element2GUIDParameterName = "element2GUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkElementsAsDuplicates");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkElementsAsDuplicates");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "linkElementsAsDuplicates");
            if (requestBody != null) {
                handler.linkElementsAsPeerDuplicates(userId, requestBody.getMetadataElement1GUID(), "element1GUID", requestBody.getMetadataElement2GUID(), "element2GUID", requestBody.getSetKnownDuplicate(), requestBody.getStatusIdentifier(), requestBody.getSteward(), requestBody.getStewardTypeName(), requestBody.getStewardPropertyName(), requestBody.getSource(), requestBody.getNotes(), instanceHandler.getSupportedZones(userId, serverName, "linkElementsAsDuplicates"), "linkElementsAsDuplicates");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkElementsAsDuplicates", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkElementsAsDuplicates", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkConsolidatedDuplicate(String serverName, String userId, ConsolidatedDuplicatesRequestBody requestBody) {
        String methodName = "linkConsolidatedDuplicate";
        String elementGUIDParameterName = "consolidatedElementGUID";
        String sourceElementGUIDsParameterName = "sourceElementGUIDs";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkConsolidatedDuplicate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkConsolidatedDuplicate");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "linkConsolidatedDuplicate");
            if (requestBody != null) {
                handler.linkConsolidatedDuplicate(userId, requestBody.getConsolidatedElementGUID(), "consolidatedElementGUID", requestBody.getStatusIdentifier(), requestBody.getSteward(), requestBody.getStewardTypeName(), requestBody.getStewardPropertyName(), requestBody.getSource(), requestBody.getNotes(), requestBody.getSourceElementGUIDs(), "sourceElementGUIDs", instanceHandler.getSupportedZones(userId, serverName, "linkConsolidatedDuplicate"), "linkConsolidatedDuplicate");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkConsolidatedDuplicate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkConsolidatedDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateActionTargetStatus(String serverName, String userId, ActionTargetStatusRequestBody requestBody) {
        String methodName = "updateActionTargetStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateActionTargetStatus");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateActionTargetStatus");
            if (requestBody != null) {
                GovernanceActionHandler<Object> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "updateActionTargetStatus");
                int statusOrdinal = GovernanceActionStatus.ACTIONED.getOpenTypeOrdinal();
                if (requestBody.getStatus() != null) {
                    statusOrdinal = requestBody.getStatus().getOpenTypeOrdinal();
                }
                handler.updateActionTargetStatus(userId, requestBody.getActionTargetGUID(), statusOrdinal, requestBody.getStartDate(), requestBody.getCompletionDate(), requestBody.getCompletionMessage(), new Date(), "updateActionTargetStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateActionTargetStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateActionTargetStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse recordCompletionStatus(String serverName, String userId, String governanceActionGUID, CompletionStatusRequestBody requestBody) {
        String methodName = "recordCompletionStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "recordCompletionStatus");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "recordCompletionStatus");
            if (requestBody != null) {
                GovernanceActionHandler<Object> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "recordCompletionStatus");
                int statusOrdinal = GovernanceActionStatus.ACTIONED.getOpenTypeOrdinal();
                if (requestBody.getStatus() != null) {
                    statusOrdinal = requestBody.getStatus().getOpenTypeOrdinal();
                }
                handler.recordCompletionStatus(userId, governanceActionGUID, statusOrdinal, requestBody.getRequestParameters(), requestBody.getOutputGuards(), requestBody.getNewActionTargets(), requestBody.getCompletionMessage(), new Date(), "recordCompletionStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "recordCompletionStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "recordCompletionStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse initiateGovernanceAction(String serverName, String userId, String governanceEngineName, GovernanceActionRequestBody requestBody) {
        String methodName = "initiateGovernanceAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "initiateGovernanceAction");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "initiateGovernanceAction");
            if (requestBody != null) {
                GovernanceActionHandler<Object> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "initiateGovernanceAction");
                String governanceActionGUID = handler.createGovernanceAction(userId, requestBody.getQualifiedName(), requestBody.getDomainIdentifier(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getRequestSourceGUIDs(), requestBody.getActionTargets(), null, requestBody.getReceivedGuards(), requestBody.getStartTime(), governanceEngineName, requestBody.getRequestType(), requestBody.getRequestParameters(), null, null, null, requestBody.getProcessName(), requestBody.getRequestSourceName(), requestBody.getOriginatorServiceName(), requestBody.getOriginatorEngineName(), "initiateGovernanceAction");
                if (governanceActionGUID != null) {
                    handler.approveGovernanceAction(userId, governanceActionGUID, requestBody.getQualifiedName(), null, requestBody.getReceivedGuards(), requestBody.getStartTime(), governanceEngineName, requestBody.getRequestType(), requestBody.getRequestParameters(), null, requestBody.getProcessName(), "initiateGovernanceAction");
                    response.setGUID(governanceActionGUID);
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "initiateGovernanceAction", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "initiateGovernanceAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse initiateGovernanceActionProcess(String serverName, String userId, GovernanceActionProcessRequestBody requestBody) {
        String methodName = "initiateGovernanceActionProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "initiateGovernanceActionProcess");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "initiateGovernanceActionProcess");
            if (requestBody != null) {
                GovernanceActionHandler<Object> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "initiateGovernanceActionProcess");
                response.setGUID(handler.initiateGovernanceActionProcess(userId, requestBody.getProcessQualifiedName(), requestBody.getRequestSourceGUIDs(), requestBody.getActionTargets(), requestBody.getRequestParameters(), requestBody.getStartTime(), requestBody.getOriginatorServiceName(), requestBody.getOriginatorEngineName(), "initiateGovernanceActionProcess"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "initiateGovernanceActionProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "initiateGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

