/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ValidValuesHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.properties.TranslationDetail;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValue;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValueDetail;
import org.odpi.openmetadata.frameworkservices.gaf.converters.RelatedElementsConverter;
import org.odpi.openmetadata.frameworkservices.gaf.ffdc.OpenMetadataStoreAuditCode;
import org.odpi.openmetadata.frameworkservices.gaf.handlers.MetadataElementHandler;
import org.odpi.openmetadata.frameworkservices.gaf.rest.FindRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IncidentReportRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewClassificationRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewMetadataElementRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewRelatedElementsRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RelatedMetadataElementListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RelatedMetadataElementsListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RelatedMetadataElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ToDoRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TranslationDetailResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TranslationListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateEffectivityDatesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdatePropertiesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueResponse;
import org.odpi.openmetadata.frameworkservices.gaf.server.GAFMetadataManagementInstanceHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.LoggerFactory;

public class OpenMetadataStoreRESTServices {
    private static final GAFMetadataManagementInstanceHandler instanceHandler = new GAFMetadataManagementInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OpenMetadataStoreRESTServices.class), instanceHandler.getServiceName());
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final String propertyNameParameter = "propertyName";
    private final String preferredValueParameter = "preferredValue";
    private final String actualValueParameter = "actualValue";

    public VoidResponse logAssetAuditMessage(String serverName, String serviceURLMarker, String userId, String assetGUID, String governanceService, String message) {
        String methodName = "logAssetAuditMessage";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "logAssetAuditMessage");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "logAssetAuditMessage");
            this.getMetadataElementByGUID(serverName, serviceURLMarker, userId, assetGUID, false, false, new Date().getTime());
            auditLog.logMessage("logAssetAuditMessage", OpenMetadataStoreAuditCode.ASSET_AUDIT_LOG.getMessageDefinition(new String[]{assetGUID, governanceService, message}));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "logAssetAuditMessage", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private Date getEffectiveTimeFromLong(long effectiveTime) {
        Date result = null;
        if (effectiveTime != 0L) {
            result = new Date(effectiveTime);
        }
        return result;
    }

    public OpenMetadataElementResponse getMetadataElementByGUID(String serverName, String serviceURLMarker, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime) {
        String methodName = "getMetadataElementByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataElementByGUID");
        AuditLog auditLog = null;
        OpenMetadataElementResponse response = new OpenMetadataElementResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementByGUID");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getMetadataElementByGUID");
            response.setElement(handler.getMetadataElementByGUID(userId, elementGUID, forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getMetadataElementByGUID"), this.getEffectiveTimeFromLong(effectiveTime), "getMetadataElementByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataElementByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementResponse getMetadataElementByUniqueName(String serverName, String serviceURLMarker, String userId, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime, NameRequestBody requestBody) {
        String methodName = "getMetadataElementByUniqueName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataElementByUniqueName");
        AuditLog auditLog = null;
        OpenMetadataElementResponse response = new OpenMetadataElementResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementByUniqueName");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getMetadataElementByUniqueName");
                response.setElement(handler.getMetadataElementByUniqueName(userId, requestBody.getName(), requestBody.getNameParameterName(), requestBody.getNamePropertyName(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getMetadataElementByUniqueName"), this.getEffectiveTimeFromLong(effectiveTime), "getMetadataElementByUniqueName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMetadataElementByUniqueName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataElementByUniqueName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getMetadataElementGUIDByUniqueName(String serverName, String serviceURLMarker, String userId, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime, NameRequestBody requestBody) {
        String methodName = "getMetadataElementGUIDByUniqueName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataElementGUIDByUniqueName");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementGUIDByUniqueName");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getMetadataElementGUIDByUniqueName");
                response.setGUID(handler.getMetadataElementGUIDByUniqueName(userId, requestBody.getName(), requestBody.getNameParameterName(), requestBody.getNamePropertyName(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getMetadataElementGUIDByUniqueName"), this.getEffectiveTimeFromLong(effectiveTime), "getMetadataElementGUIDByUniqueName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMetadataElementGUIDByUniqueName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataElementGUIDByUniqueName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementsResponse findMetadataElementsWithString(String serverName, String serviceURLMarker, String userId, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findMetadataElementsWithString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMetadataElementsWithString");
        AuditLog auditLog = null;
        OpenMetadataElementsResponse response = new OpenMetadataElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMetadataElementsWithString");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "findMetadataElementsWithString");
                response.setElementList(handler.findMetadataElementsWithString(userId, requestBody.getSearchString(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "findMetadataElementsWithString"), this.getEffectiveTimeFromLong(effectiveTime), startFrom, pageSize, "findMetadataElementsWithString"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findMetadataElementsWithString", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findMetadataElementsWithString", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementListResponse getRelatedMetadataElements(String serverName, String serviceURLMarker, String userId, String elementGUID, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime, int startingAtEnd, int startFrom, int pageSize) {
        String methodName = "getRelatedMetadataElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelatedMetadataElements");
        AuditLog auditLog = null;
        RelatedMetadataElementListResponse response = new RelatedMetadataElementListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedMetadataElements");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getRelatedMetadataElements");
            response.setElementList(handler.getRelatedMetadataElements(userId, elementGUID, startingAtEnd, relationshipTypeName, forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getRelatedMetadataElements"), this.getEffectiveTimeFromLong(effectiveTime), startFrom, pageSize, "getRelatedMetadataElements"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRelatedMetadataElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementsResponse findMetadataElements(String serverName, String serviceURLMarker, String userId, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime, int startFrom, int pageSize, FindRequestBody requestBody) {
        String methodName = "findMetadataElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMetadataElements");
        AuditLog auditLog = null;
        OpenMetadataElementsResponse response = new OpenMetadataElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMetadataElements");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "findMetadataElements");
                response.setElementList(handler.findMetadataElements(userId, requestBody.getMetadataElementTypeName(), requestBody.getMetadataElementSubtypeName(), requestBody.getSearchProperties(), requestBody.getLimitResultsByStatus(), requestBody.getMatchClassifications(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "findMetadataElements"), this.getEffectiveTimeFromLong(effectiveTime), startFrom, pageSize, "findMetadataElements"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findMetadataElements", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findMetadataElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementsListResponse findRelationshipsBetweenMetadataElements(String serverName, String serviceURLMarker, String userId, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime, int startFrom, int pageSize, FindRequestBody requestBody) {
        String methodName = "findRelationshipsBetweenMetadataElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findRelationshipsBetweenMetadataElements");
        AuditLog auditLog = null;
        RelatedMetadataElementsListResponse response = new RelatedMetadataElementsListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findRelationshipsBetweenMetadataElements");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "findRelationshipsBetweenMetadataElements");
                response.setElementList(handler.findRelationshipsBetweenMetadataElements(userId, requestBody.getMetadataElementTypeName(), requestBody.getSearchProperties(), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "findRelationshipsBetweenMetadataElements"), this.getEffectiveTimeFromLong(effectiveTime), startFrom, pageSize, "findRelationshipsBetweenMetadataElements"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findRelationshipsBetweenMetadataElements", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findRelationshipsBetweenMetadataElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementsResponse getRelationshipByGUID(String serverName, String serviceURLMarker, String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime) {
        String methodName = "getRelationshipByGUID";
        String guidParameterName = "relationshipGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelationshipByGUID");
        AuditLog auditLog = null;
        RelatedMetadataElementsResponse response = new RelatedMetadataElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelationshipByGUID");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getRelationshipByGUID");
            Relationship relationship = handler.getAttachmentLink(userId, relationshipGUID, "relationshipGUID", null, this.getEffectiveTimeFromLong(effectiveTime), "getRelationshipByGUID");
            if (relationship != null) {
                RelatedElementsConverter<RelatedMetadataElements> converter = new RelatedElementsConverter<RelatedMetadataElements>(handler.getRepositoryHelper(), handler.getServiceName(), serverName);
                response.setElement(converter.getNewRelationshipBean(RelatedMetadataElements.class, relationship, "getRelationshipByGUID"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRelationshipByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createMetadataElementInStore(String serverName, String serviceURLMarker, String userId, NewMetadataElementRequestBody requestBody) {
        String methodName = "createMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createMetadataElementInStore");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "createMetadataElementInStore");
                response.setGUID(handler.createMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getTypeName(), requestBody.getInitialStatus(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), requestBody.getTemplateGUID(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createMetadataElementInStore"), requestBody.getEffectiveTime(), "createMetadataElementInStore"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, UpdatePropertiesRequestBody requestBody) {
        String methodName = "updateMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateMetadataElementInStore");
                handler.updateMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getReplaceProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateMetadataElementInStore"), requestBody.getEffectiveTime(), "updateMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateMetadataElementStatusInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, UpdateStatusRequestBody requestBody) {
        String methodName = "updateMetadataElementStatusInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateMetadataElementStatusInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateMetadataElementStatusInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateMetadataElementStatusInStore");
                handler.updateMetadataElementStatusInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getNewStatus(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateMetadataElementStatusInStore"), requestBody.getEffectiveTime(), "updateMetadataElementStatusInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateMetadataElementStatusInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateMetadataElementStatusInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateMetadataElementEffectivityInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, UpdateEffectivityDatesRequestBody requestBody) {
        String methodName = "updateMetadataElementEffectivityInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateMetadataElementEffectivityInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateMetadataElementEffectivityInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateMetadataElementEffectivityInStore");
                handler.updateMetadataElementEffectivityInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateMetadataElementEffectivityInStore"), requestBody.getEffectiveTime(), "updateMetadataElementEffectivityInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateMetadataElementEffectivityInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateMetadataElementEffectivityInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, UpdateRequestBody requestBody) {
        String methodName = "deleteMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "deleteMetadataElementInStore");
                handler.deleteMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "deleteMetadataElementInStore"), requestBody.getEffectiveTime(), "deleteMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse classifyMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, String classificationName, NewClassificationRequestBody requestBody) {
        String methodName = "classifyMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "classifyMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "classifyMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "classifyMetadataElementInStore");
                handler.classifyMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, classificationName, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "classifyMetadataElementInStore"), requestBody.getEffectiveTime(), "classifyMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "classifyMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "classifyMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse reclassifyMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, String classificationName, UpdatePropertiesRequestBody requestBody) {
        String methodName = "reclassifyMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "reclassifyMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "reclassifyMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "reclassifyMetadataElementInStore");
                handler.reclassifyMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, classificationName, requestBody.getReplaceProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "reclassifyMetadataElementInStore"), requestBody.getEffectiveTime(), "reclassifyMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "reclassifyMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "reclassifyMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateClassificationEffectivityInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, String classificationName, UpdateEffectivityDatesRequestBody requestBody) {
        String methodName = "updateClassificationStatusInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateClassificationStatusInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateClassificationStatusInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateClassificationStatusInStore");
                handler.updateClassificationStatusInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, classificationName, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateClassificationStatusInStore"), requestBody.getEffectiveTime(), "updateClassificationStatusInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateClassificationStatusInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateClassificationStatusInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse declassifyMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, String classificationName, UpdateRequestBody requestBody) {
        String methodName = "unclassifyMetadataElementInStore";
        String metadataElementGUIDParameterName = "metadataElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unclassifyMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unclassifyMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "unclassifyMetadataElementInStore");
                handler.unclassifyMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, "metadataElementGUID", "OpenMetadataRoot", classificationName, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "unclassifyMetadataElementInStore"), requestBody.getEffectiveTime(), "unclassifyMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "unclassifyMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unclassifyMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createRelatedElementsInStore(String serverName, String serviceURLMarker, String userId, NewRelatedElementsRequestBody requestBody) {
        String methodName = "createRelatedElementsInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createRelatedElementsInStore");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createRelatedElementsInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "createRelatedElementsInStore");
                response.setGUID(handler.createRelatedElementsInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getTypeName(), requestBody.getMetadataElement1GUID(), requestBody.getMetadataElement2GUID(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createRelatedElementsInStore"), requestBody.getEffectiveTime(), "createRelatedElementsInStore"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createRelatedElementsInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createRelatedElementsInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateRelatedElementsInStore(String serverName, String serviceURLMarker, String userId, String relationshipGUID, UpdatePropertiesRequestBody requestBody) {
        String methodName = "updateRelatedElementsInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateRelatedElementsInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateRelatedElementsInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateRelatedElementsInStore");
                handler.updateRelatedElementsInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), relationshipGUID, requestBody.getReplaceProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateRelatedElementsInStore"), requestBody.getEffectiveTime(), "updateRelatedElementsInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateRelatedElementsInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateRelatedElementsInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateRelatedElementsEffectivityInStore(String serverName, String serviceURLMarker, String userId, String relationshipGUID, UpdateEffectivityDatesRequestBody requestBody) {
        String methodName = "updateRelatedElementsStatusInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateRelatedElementsStatusInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateRelatedElementsStatusInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateRelatedElementsStatusInStore");
                handler.updateRelatedElementsStatusInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), relationshipGUID, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateRelatedElementsStatusInStore"), requestBody.getEffectiveTime(), "updateRelatedElementsStatusInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateRelatedElementsStatusInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateRelatedElementsStatusInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteRelatedElementsInStore(String serverName, String serviceURLMarker, String userId, String relationshipGUID, UpdateRequestBody requestBody) {
        String methodName = "deleteRelatedElementsInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteRelatedElementsInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteRelatedElementsInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "deleteRelatedElementsInStore");
                handler.deleteRelatedElementsInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), relationshipGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "deleteRelatedElementsInStore"), requestBody.getEffectiveTime(), "deleteRelatedElementsInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteRelatedElementsInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteRelatedElementsInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createIncidentReport(String serverName, String serviceURLMarker, String userId, IncidentReportRequestBody requestBody) {
        String methodName = "createIncidentReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createIncidentReport");
        Object auditLog = null;
        GUIDResponse response = new GUIDResponse();
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse openToDo(String serverName, String serviceURLMarker, String userId, ToDoRequestBody requestBody) {
        String methodName = "openToDo";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "openToDo");
        Object auditLog = null;
        GUIDResponse response = new GUIDResponse();
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTranslation(String serverName, String serviceURLMarker, String userId, String elementGUID, TranslationDetail translationDetail) {
        String methodName = "setTranslation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTranslation");
        Object auditLog = null;
        VoidResponse response = new VoidResponse();
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTranslation(String serverName, String serviceURLMarker, String userId, String elementGUID, String language, String locale, NullRequestBody requestBody) {
        String methodName = "clearTranslation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTranslation");
        Object auditLog = null;
        VoidResponse response = new VoidResponse();
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TranslationDetailResponse getTranslation(String serverName, String serviceURLMarker, String userId, String elementGUID, String language, String locale) {
        String methodName = "getTranslation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTranslation");
        Object auditLog = null;
        TranslationDetailResponse response = new TranslationDetailResponse();
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TranslationListResponse getTranslations(String serverName, String serviceURLMarker, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getTranslations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTranslations");
        Object auditLog = null;
        TranslationListResponse response = new TranslationListResponse();
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private String constructValidValueQualifiedName(String typeName, String propertyName, String mapName, String preferredValue) {
        Object qualifiedName = "Egeria:ValidMetadataValue:";
        if (typeName != null || propertyName != null) {
            qualifiedName = typeName != null ? (String)qualifiedName + typeName + ":" : (String)qualifiedName + ":";
            if (propertyName != null) {
                qualifiedName = (String)qualifiedName + propertyName + "-";
                if (mapName != null) {
                    qualifiedName = (String)qualifiedName + "-" + mapName + "--";
                }
                if (preferredValue != null) {
                    qualifiedName = (String)qualifiedName + "(" + preferredValue + ")";
                }
            }
        }
        return qualifiedName;
    }

    private String getParentSet(String userId, String typeName, String propertyName, String mapName, ValidValuesHandler<ValidMetadataValue> handler, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String parentDescription = "Organizing set for valid metadata values";
        String parentScope = "Open Metadata Ecosystem";
        String parentUsage = "Used to control valid values in the open metadata ecosystem.";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        String parentQualifiedName = this.constructValidValueQualifiedName(typeName, propertyName, mapName, null);
        EntityDetail parentSet = handler.getEntityByValue(userId, parentQualifiedName, "qualifiedName", "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", specificMatchPropertyNames, true, false, null, methodName);
        if (parentSet == null) {
            String grandParentSetGUID = null;
            String parentDisplayName = parentQualifiedName.substring(26);
            if (mapName != null) {
                grandParentSetGUID = this.getParentSet(userId, typeName, propertyName, null, handler, methodName);
            } else if (propertyName != null) {
                grandParentSetGUID = this.getParentSet(userId, typeName, null, null, handler, methodName);
            } else if (typeName != null) {
                grandParentSetGUID = this.getParentSet(userId, null, null, null, handler, methodName);
            }
            return handler.createValidValue(userId, null, null, grandParentSetGUID, grandParentSetGUID, "ValidValuesSet", false, parentQualifiedName, parentDisplayName, "Organizing set for valid metadata values", "Used to control valid values in the open metadata ecosystem.", "Open Metadata Ecosystem", null, false, null, null, null, null, false, false, null, methodName);
        }
        return parentSet.getGUID();
    }

    private EntityDetail getValidMetadataElement(String userId, String qualifiedName, ValidValuesHandler<ValidMetadataValue> handler, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        return handler.getEntityByValue(userId, qualifiedName, "qualifiedName", "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", specificMatchPropertyNames, true, false, null, methodName);
    }

    private ValidMetadataValue getValidMetadataBean(String userId, String qualifiedName, ValidValuesHandler<ValidMetadataValue> handler, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail element = this.getValidMetadataElement(userId, qualifiedName, handler, methodName);
        if (element != null) {
            OpenMetadataAPIGenericConverter converter = handler.getConverter();
            return (ValidMetadataValue)converter.getNewBean(ValidMetadataValue.class, element, methodName);
        }
        return null;
    }

    public VoidResponse setUpValidMetadataValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, ValidMetadataValue requestBody) {
        String methodName = "setUpValidMetadataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setUpValidMetadataValue");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setUpValidMetadataValue");
            if (requestBody != null) {
                this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataValue");
                this.invalidParameterHandler.validateName(requestBody.getPreferredValue(), "preferredValue", "setUpValidMetadataValue");
                ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "setUpValidMetadataValue");
                String setGUID = this.getParentSet(userId, typeName, propertyName, null, handler, "setUpValidMetadataValue");
                handler.createValidValue(userId, null, null, setGUID, setGUID, "ValidValuesSet", false, this.constructValidValueQualifiedName(typeName, propertyName, null, requestBody.getPreferredValue()), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), requestBody.getPreferredValue(), requestBody.getIsDeprecated(), requestBody.getAdditionalProperties(), null, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), false, false, null, "setUpValidMetadataValue");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setUpValidMetadataValue", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setUpValidMetadataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setUpValidMetadataMapName(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, ValidMetadataValue requestBody) {
        String methodName = "setUpValidMetadataMapName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setUpValidMetadataMapName");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setUpValidMetadataMapName");
            if (requestBody != null) {
                this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataMapName");
                this.invalidParameterHandler.validateName(requestBody.getPreferredValue(), "preferredValue", "setUpValidMetadataMapName");
                ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "setUpValidMetadataMapName");
                String setGUID = this.getParentSet(userId, typeName, propertyName, null, handler, "setUpValidMetadataMapName");
                handler.createValidValue(userId, null, null, setGUID, setGUID, "ValidValuesSet", false, this.constructValidValueQualifiedName(typeName, propertyName, requestBody.getPreferredValue(), null), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), requestBody.getPreferredValue(), requestBody.getIsDeprecated(), requestBody.getAdditionalProperties(), null, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), false, false, null, "setUpValidMetadataMapName");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setUpValidMetadataMapName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setUpValidMetadataMapName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setUpValidMetadataMapValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String mapName, ValidMetadataValue requestBody) {
        String methodName = "setUpValidMetadataMapValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setUpValidMetadataMapValue");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setUpValidMetadataMapValue");
            if (requestBody != null) {
                this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataMapValue");
                this.invalidParameterHandler.validateName(requestBody.getPreferredValue(), "preferredValue", "setUpValidMetadataMapValue");
                ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "setUpValidMetadataMapValue");
                String setGUID = this.getParentSet(userId, typeName, propertyName, mapName, handler, "setUpValidMetadataMapValue");
                handler.createValidValue(userId, null, null, setGUID, setGUID, "ValidValuesSet", false, this.constructValidValueQualifiedName(typeName, propertyName, mapName, requestBody.getPreferredValue()), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), requestBody.getPreferredValue(), requestBody.getIsDeprecated(), requestBody.getAdditionalProperties(), null, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), false, false, null, "setUpValidMetadataMapValue");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setUpValidMetadataMapValue", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setUpValidMetadataMapValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearValidMetadataValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String preferredValue, NullRequestBody requestBody) {
        String methodName = "clearValidMetadataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearValidMetadataValue");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearValidMetadataValue");
            if (requestBody != null) {
                this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataValue");
                this.invalidParameterHandler.validateName(preferredValue, "preferredValue", "clearValidMetadataValue");
                ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "clearValidMetadataValue");
                String qualifiedName = this.constructValidValueQualifiedName(typeName, propertyName, null, preferredValue);
                EntityDetail element = this.getValidMetadataElement(userId, qualifiedName, handler, "clearValidMetadataValue");
                if (element != null) {
                    handler.deleteValidValue(userId, null, null, element.getGUID(), qualifiedName, false, false, null, "clearValidMetadataValue");
                } else {
                    this.invalidParameterHandler.throwUnknownElement(userId, qualifiedName, typeName, instanceHandler.getServiceName(serviceURLMarker), serverName, "clearValidMetadataValue");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearValidMetadataValue", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearValidMetadataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearValidMetadataMapName(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String preferredValue, NullRequestBody requestBody) {
        String methodName = "clearValidMetadataMapName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearValidMetadataMapName");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearValidMetadataMapName");
            if (requestBody != null) {
                this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataMapName");
                this.invalidParameterHandler.validateName(preferredValue, "preferredValue", "clearValidMetadataMapName");
                ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "clearValidMetadataMapName");
                String qualifiedName = this.constructValidValueQualifiedName(typeName, propertyName, preferredValue, null);
                EntityDetail element = this.getValidMetadataElement(userId, qualifiedName, handler, "clearValidMetadataMapName");
                if (element != null) {
                    handler.deleteValidValue(userId, null, null, element.getGUID(), qualifiedName, false, false, null, "clearValidMetadataMapName");
                } else {
                    this.invalidParameterHandler.throwUnknownElement(userId, qualifiedName, typeName, instanceHandler.getServiceName(serviceURLMarker), serverName, "clearValidMetadataMapName");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearValidMetadataMapName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearValidMetadataMapName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearValidMetadataMapValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String mapName, String preferredValue, NullRequestBody requestBody) {
        String methodName = "clearValidMetadataMapValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearValidMetadataMapValue");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearValidMetadataMapValue");
            if (requestBody != null) {
                this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataMapValue");
                this.invalidParameterHandler.validateName(preferredValue, "preferredValue", "clearValidMetadataMapValue");
                ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "clearValidMetadataMapValue");
                String qualifiedName = this.constructValidValueQualifiedName(typeName, propertyName, mapName, preferredValue);
                EntityDetail element = this.getValidMetadataElement(userId, qualifiedName, handler, "clearValidMetadataMapValue");
                if (element != null) {
                    handler.deleteValidValue(userId, null, null, element.getGUID(), qualifiedName, false, false, null, "clearValidMetadataMapValue");
                } else {
                    this.invalidParameterHandler.throwUnknownElement(userId, qualifiedName, typeName, instanceHandler.getServiceName(serviceURLMarker), serverName, "clearValidMetadataMapValue");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearValidMetadataMapValue", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearValidMetadataMapValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public BooleanResponse validateMetadataValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String actualValue) {
        String methodName = "validateMetadataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "validateMetadataValue");
        AuditLog auditLog = null;
        BooleanResponse response = new BooleanResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateMetadataValue");
            this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataValue");
            this.invalidParameterHandler.validateName(actualValue, "actualValue", "validateMetadataValue");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "validateMetadataValue");
            String qualifiedName = this.constructValidValueQualifiedName(typeName, propertyName, null, actualValue);
            EntityDetail element = this.getValidMetadataElement(userId, qualifiedName, handler, "validateMetadataValue");
            response.setFlag(false);
            if (element != null) {
                response.setFlag(true);
            } else if (typeName != null && (element = this.getValidMetadataElement(userId, qualifiedName = this.constructValidValueQualifiedName(null, propertyName, null, actualValue), handler, "validateMetadataValue")) != null) {
                response.setFlag(true);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "validateMetadataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public BooleanResponse validateMetadataMapName(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String actualValue) {
        String methodName = "validateMetadataMapName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "validateMetadataMapName");
        AuditLog auditLog = null;
        BooleanResponse response = new BooleanResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateMetadataMapName");
            this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataMapName");
            this.invalidParameterHandler.validateName(actualValue, "actualValue", "validateMetadataMapName");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "validateMetadataMapName");
            String qualifiedName = this.constructValidValueQualifiedName(typeName, propertyName, actualValue, null);
            EntityDetail element = this.getValidMetadataElement(userId, qualifiedName, handler, "validateMetadataMapName");
            response.setFlag(false);
            if (element != null) {
                response.setFlag(true);
            } else if (typeName != null && (element = this.getValidMetadataElement(userId, qualifiedName = this.constructValidValueQualifiedName(null, propertyName, actualValue, null), handler, "validateMetadataMapName")) != null) {
                response.setFlag(true);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "validateMetadataMapName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public BooleanResponse validateMetadataMapValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String mapName, String actualValue) {
        String methodName = "validateMetadataMapValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "validateMetadataMapValue");
        AuditLog auditLog = null;
        BooleanResponse response = new BooleanResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateMetadataMapValue");
            this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataMapValue");
            this.invalidParameterHandler.validateName(actualValue, "actualValue", "validateMetadataMapValue");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "validateMetadataMapValue");
            String qualifiedName = this.constructValidValueQualifiedName(typeName, propertyName, mapName, actualValue);
            EntityDetail element = this.getValidMetadataElement(userId, qualifiedName, handler, "validateMetadataMapValue");
            response.setFlag(false);
            if (element != null) {
                response.setFlag(true);
            } else if (typeName != null && (element = this.getValidMetadataElement(userId, qualifiedName = this.constructValidValueQualifiedName(null, propertyName, mapName, actualValue), handler, "validateMetadataMapValue")) != null) {
                response.setFlag(true);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "validateMetadataMapValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidMetadataValueResponse getValidMetadataValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String preferredValue) {
        String methodName = "getValidMetadataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidMetadataValue");
        AuditLog auditLog = null;
        ValidMetadataValueResponse response = new ValidMetadataValueResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidMetadataValue");
            this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataValue");
            this.invalidParameterHandler.validateName(preferredValue, "preferredValue", "getValidMetadataValue");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "getValidMetadataValue");
            String qualifiedName = this.constructValidValueQualifiedName(typeName, propertyName, null, preferredValue);
            ValidMetadataValue element = this.getValidMetadataBean(userId, qualifiedName, handler, "getValidMetadataValue");
            if (element != null) {
                response.setElement(element);
            } else {
                this.invalidParameterHandler.throwUnknownElement(userId, qualifiedName, "ValidValueDefinition", instanceHandler.getServiceName(serviceURLMarker), serverName, "getValidMetadataValue");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidMetadataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidMetadataValueResponse getValidMetadataMapName(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String preferredValue) {
        String methodName = "getValidMetadataMapName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidMetadataMapName");
        AuditLog auditLog = null;
        ValidMetadataValueResponse response = new ValidMetadataValueResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidMetadataMapName");
            this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataMapName");
            this.invalidParameterHandler.validateName(preferredValue, "preferredValue", "getValidMetadataMapName");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "getValidMetadataMapName");
            String qualifiedName = this.constructValidValueQualifiedName(typeName, propertyName, preferredValue, null);
            ValidMetadataValue element = this.getValidMetadataBean(userId, qualifiedName, handler, "getValidMetadataMapName");
            if (element != null) {
                response.setElement(element);
            } else {
                this.invalidParameterHandler.throwUnknownElement(userId, qualifiedName, "ValidValueDefinition", instanceHandler.getServiceName(serviceURLMarker), serverName, "getValidMetadataMapName");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidMetadataMapName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidMetadataValueResponse getValidMetadataMapValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String mapName, String preferredValue) {
        String methodName = "getValidMetadataMapValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidMetadataMapValue");
        AuditLog auditLog = null;
        ValidMetadataValueResponse response = new ValidMetadataValueResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidMetadataMapValue");
            this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataMapValue");
            this.invalidParameterHandler.validateName(preferredValue, "preferredValue", "getValidMetadataMapValue");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "getValidMetadataMapValue");
            String qualifiedName = this.constructValidValueQualifiedName(typeName, propertyName, mapName, preferredValue);
            ValidMetadataValue element = this.getValidMetadataBean(userId, qualifiedName, handler, "getValidMetadataMapValue");
            if (element != null) {
                response.setElement(element);
            } else {
                this.invalidParameterHandler.throwUnknownElement(userId, qualifiedName, "ValidValueDefinition", instanceHandler.getServiceName(serviceURLMarker), serverName, "getValidMetadataMapValue");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidMetadataMapValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidMetadataValueListResponse getValidMetadataValues(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, int startFrom, int pageSize) {
        String methodName = "getValidMetadataValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidMetadataValues");
        AuditLog auditLog = null;
        ValidMetadataValueListResponse response = new ValidMetadataValueListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidMetadataValues");
            this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataValues");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "getValidMetadataValues");
            String qualifiedName = this.constructValidValueQualifiedName(typeName, propertyName, null, null);
            EntityDetail element = this.getValidMetadataElement(userId, qualifiedName, handler, "getValidMetadataValues");
            if (element != null) {
                ValidValuesHandler<ValidMetadataValueDetail> detailsHandler = instanceHandler.getValidMetadataValuesDetailHandler(userId, serverName, "getValidMetadataValues");
                List details = detailsHandler.getValidValueSetMembers(userId, element.getGUID(), "element.getGUID()", startFrom, pageSize, false, false, null, "getValidMetadataValues");
                if (details != null) {
                    for (ValidMetadataValueDetail detail : details) {
                        EntityDetail detailElement = this.getValidMetadataElement(userId, this.constructValidValueQualifiedName(typeName, propertyName, null, detail.getPreferredValue()), handler, "getValidMetadataValues");
                        if (detailElement == null) {
                            detailElement = this.getValidMetadataElement(userId, this.constructValidValueQualifiedName(typeName, propertyName, detail.getPreferredValue(), null), handler, "getValidMetadataValues");
                        }
                        if (detailElement == null) continue;
                        List mapDetails = handler.getValidValueSetMembers(userId, detailElement.getGUID(), "detail.getGUID()", 0, 0, false, false, null, "getValidMetadataValues");
                        detail.setValidMapNameValues(mapDetails);
                    }
                }
                response.setElementList(details);
            } else {
                this.invalidParameterHandler.throwUnknownElement(userId, qualifiedName, "ValidValueDefinition", instanceHandler.getServiceName(serviceURLMarker), serverName, "getValidMetadataValues");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidMetadataValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

