/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.admin;

import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworkservices.gaf.ffdc.OpenMetadataStoreAuditCode;
import org.odpi.openmetadata.frameworkservices.gaf.server.GAFMetadataManagementInstance;
import org.odpi.openmetadata.frameworkservices.gaf.server.GAFMetadataManagementInstanceHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class GAFMetadataOperationalServices {
    private final String serverName;
    private final AuditLog auditLog;

    public GAFMetadataOperationalServices(String serverName, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        this.serverName = serverName;
        this.auditLog = auditLog;
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", OpenMetadataStoreAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        try {
            auditLog.logMessage("initialize", OpenMetadataStoreAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{serverName}));
            new GAFMetadataManagementInstance(repositoryConnector, auditLog, localServerUserId, maxPageSize);
        }
        catch (NewInstanceException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("initialize", OpenMetadataStoreAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        this.auditLog.logMessage("shutdown", OpenMetadataStoreAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
        new GAFMetadataManagementInstanceHandler().removeServerServiceInstance(this.serverName);
    }
}

