/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementControlHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworkservices.gaf.converters.OpenMetadataStoreConverter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RelatedElementsConverter<B>
extends OpenMetadataStoreConverter<B> {
    public RelatedElementsConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewRelationshipBean(Class<B> beanClass, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof RelatedMetadataElements) {
                RelatedMetadataElements bean = (RelatedMetadataElements)returnBean;
                this.fillElementControlHeader((ElementControlHeader)bean, (InstanceAuditHeader)relationship);
                bean.setRelationshipGUID(relationship.getGUID());
                bean.setRelationshipType(super.getElementType((InstanceAuditHeader)relationship));
                InstanceProperties instanceProperties = relationship.getProperties();
                if (instanceProperties != null) {
                    bean.setEffectiveFromTime(instanceProperties.getEffectiveFromTime());
                    bean.setEffectiveToTime(instanceProperties.getEffectiveToTime());
                    bean.setRelationshipProperties(this.mapElementProperties(instanceProperties));
                }
                EntityProxy entityProxy = relationship.getEntityOneProxy();
                ElementStub elementStub = new ElementStub();
                bean.setElementGUIDAtEnd1(entityProxy.getGUID());
                this.fillElementControlHeader((ElementControlHeader)elementStub, (InstanceAuditHeader)entityProxy);
                elementStub.setUniqueName(this.getQualifiedName(entityProxy.getUniqueProperties()));
                bean.setElementAtEnd1(elementStub);
                entityProxy = relationship.getEntityTwoProxy();
                elementStub = new ElementStub();
                bean.setElementGUIDAtEnd2(entityProxy.getGUID());
                this.fillElementControlHeader((ElementControlHeader)elementStub, (InstanceAuditHeader)entityProxy);
                elementStub.setUniqueName(this.getQualifiedName(entityProxy.getUniqueProperties()));
                bean.setElementAtEnd2(elementStub);
                TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.serviceName, relationship.getType().getTypeDefName());
                if (typeDef instanceof RelationshipDef) {
                    RelationshipDef relationshipDef = (RelationshipDef)typeDef;
                    bean.setLabelAtEnd1(relationshipDef.getEndDef1().getAttributeName());
                    bean.setLabelAtEnd2(relationshipDef.getEndDef2().getAttributeName());
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

