/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceEngineElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceServiceElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredGovernanceServiceElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredGovernanceServiceProperties;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworkservices.gaf.converters.GovernanceEngineConverter;
import org.odpi.openmetadata.frameworkservices.gaf.converters.GovernanceServiceConverter;
import org.odpi.openmetadata.frameworkservices.gaf.converters.RegisteredGovernanceServiceConverter;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceEngineConfigurationHandler {
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final SoftwareCapabilityHandler<GovernanceEngineElement> governanceEngineHandler;
    private final AssetHandler<GovernanceServiceElement> governanceServiceHandler;
    private final ConnectionHandler<Connection> connectionHandler;
    private final InvalidParameterHandler invalidParameterHandler;

    public GovernanceEngineConfigurationHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.governanceEngineHandler = new SoftwareCapabilityHandler(new GovernanceEngineConverter(repositoryHelper, serviceName, serverName), GovernanceEngineElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.governanceServiceHandler = new AssetHandler(new GovernanceServiceConverter(repositoryHelper, serviceName, serverName), GovernanceServiceElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.connectionHandler = new ConnectionHandler((OpenMetadataAPIGenericConverter)new ConnectionConverter(repositoryHelper, serviceName, serverName), Connection.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGovernanceEngine(String userId, String typeName, String qualifiedName, String displayName, String description, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceEngine";
        String typeNameParameterName = "typeName";
        this.invalidParameterHandler.validateName(typeName, "typeName", "createGovernanceEngine");
        return this.governanceEngineHandler.createSoftwareCapability(userId, null, null, typeName, null, qualifiedName, displayName, description, DeployedImplementationType.GOVERNANCE_ENGINE.getDeployedImplementationType(), null, null, null, null, null, null, null, null, false, false, new Date(), "createGovernanceEngine");
    }

    public GovernanceEngineElement getGovernanceEngineByGUID(String userId, String guid, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceEngineByGUID";
        String guidParameter = "guid";
        return (GovernanceEngineElement)this.governanceEngineHandler.getBeanFromRepository(userId, guid, "guid", OpenMetadataType.GOVERNANCE_ENGINE.typeName, false, false, serviceSupportedZones, new Date(), "getGovernanceEngineByGUID");
    }

    public GovernanceEngineElement getGovernanceEngineByName(String userId, String name, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceEngineByName";
        String nameParameter = "name";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        return (GovernanceEngineElement)this.governanceEngineHandler.getBeanByValue(userId, name, "name", OpenMetadataType.GOVERNANCE_ENGINE.typeGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, specificMatchPropertyNames, false, false, serviceSupportedZones, null, "getGovernanceEngineByName");
    }

    public List<GovernanceEngineElement> getAllGovernanceEngines(String userId, int startingFrom, int maximumResults, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllGovernanceEngines";
        return this.governanceEngineHandler.getBeansByType(userId, OpenMetadataType.GOVERNANCE_ENGINE.typeGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, null, false, false, serviceSupportedZones, startingFrom, maximumResults, new Date(), "getAllGovernanceEngines");
    }

    public void updateGovernanceEngine(String userId, String guid, String qualifiedName, String displayName, String description, String typeDescription, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceEngine";
        String guidParameter = "guid";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateGovernanceEngine");
        SoftwareCapabilityBuilder builder = new SoftwareCapabilityBuilder(qualifiedName, displayName, description, typeDescription, version, patchLevel, source, additionalProperties, OpenMetadataType.GOVERNANCE_ENGINE.typeGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties instanceProperties = builder.getInstanceProperties("updateGovernanceEngine");
        this.governanceEngineHandler.updateBeanInRepository(userId, null, null, guid, "guid", OpenMetadataType.GOVERNANCE_ENGINE.typeGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, false, false, serviceSupportedZones, instanceProperties, false, new Date(), "updateGovernanceEngine");
    }

    public void deleteGovernanceEngine(String userId, String guid, String qualifiedName, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceEngine";
        String guidParameter = "governanceEngineGUID";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteGovernanceEngine");
        this.governanceEngineHandler.deleteBeanInRepository(userId, null, null, guid, "governanceEngineGUID", OpenMetadataType.GOVERNANCE_ENGINE.typeGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, "qualifiedName", qualifiedName, false, false, serviceSupportedZones, new Date(), "deleteGovernanceEngine");
    }

    public String createGovernanceService(String userId, String typeName, String qualifiedName, String displayName, String description, Connection connection, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceService";
        String connectionParameterName = "createGovernanceService";
        String assetGUIDParameterName = "assetGUID";
        String typeNameParameterName = "typeName";
        this.invalidParameterHandler.validateName(typeName, "typeName", "createGovernanceService");
        this.invalidParameterHandler.validateConnection(connection, "createGovernanceService", "createGovernanceService");
        Date effectiveTime = new Date();
        String assetGUID = this.governanceServiceHandler.createAssetInRepository(userId, null, null, qualifiedName, displayName, null, description, null, typeName, null, InstanceStatus.ACTIVE, null, null, effectiveTime, "createGovernanceService");
        if (assetGUID != null) {
            this.connectionHandler.saveConnection(userId, null, null, assetGUID, assetGUID, "assetGUID", typeName, qualifiedName, connection, "Connection to create governance service", false, false, serviceSupportedZones, effectiveTime, "createGovernanceService");
        }
        return assetGUID;
    }

    public GovernanceServiceElement getGovernanceServiceByGUID(String userId, String guid, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServiceByGUID";
        String guidParameter = "guid";
        return (GovernanceServiceElement)this.governanceServiceHandler.getAssetWithConnection(userId, guid, "guid", OpenMetadataType.GOVERNANCE_SERVICE.typeName, false, false, serviceSupportedZones, new Date(), "getGovernanceServiceByGUID");
    }

    public GovernanceServiceElement getGovernanceServiceByName(String userId, String name, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServiceByName";
        String nameParameter = "name";
        return (GovernanceServiceElement)this.governanceServiceHandler.getAssetByNameWithConnection(userId, name, "name", OpenMetadataType.GOVERNANCE_SERVICE.typeGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, false, false, serviceSupportedZones, new Date(), "getGovernanceServiceByName");
    }

    public List<GovernanceServiceElement> getAllGovernanceServices(String userId, int startingFrom, int maximumResults, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllGovernanceServices";
        return this.governanceServiceHandler.getAllAssetsWithConnection(userId, OpenMetadataType.GOVERNANCE_SERVICE.typeGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, startingFrom, maximumResults, false, false, serviceSupportedZones, new Date(), "getAllGovernanceServices");
    }

    public List<String> getGovernanceServiceRegistrations(String userId, String governanceServiceGUID, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllGovernanceServices";
        String guidParameter = "governanceServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAllGovernanceServices");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "getAllGovernanceServices");
        Date effectiveTime = new Date();
        this.connectionHandler.getBeanFromRepository(userId, governanceServiceGUID, "governanceServiceGUID", OpenMetadataType.GOVERNANCE_SERVICE.typeName, false, false, serviceSupportedZones, effectiveTime, "getAllGovernanceServices");
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, governanceServiceGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", 1, false, false, 0, 0, effectiveTime, "getAllGovernanceServices");
        ArrayList<String> results = new ArrayList<String>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || relationship.getGUID() == null) continue;
                results.add(relationship.getGUID());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public void updateGovernanceService(String userId, String guid, String qualifiedName, String displayName, String description, Connection connection, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceService";
        String guidParameter = "guid";
        this.governanceServiceHandler.updateAssetWithConnection(userId, null, null, guid, "guid", qualifiedName, displayName, null, description, additionalProperties, OpenMetadataType.GOVERNANCE_SERVICE.typeGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, extendedProperties, null, null, false, null, connection, false, false, serviceSupportedZones, new Date(), "updateGovernanceService");
    }

    public void deleteGovernanceService(String userId, String guid, String qualifiedName, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceService";
        String qualifiedNameParameter = "qualifiedName";
        String guidParameter = "governanceServiceGUID";
        this.connectionHandler.deleteBeanInRepository(userId, null, null, guid, "governanceServiceGUID", OpenMetadataType.GOVERNANCE_SERVICE.typeGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, "qualifiedName", qualifiedName, false, false, serviceSupportedZones, new Date(), "deleteGovernanceService");
    }

    public void registerGovernanceServiceWithEngine(String userId, String governanceEngineGUID, String governanceServiceGUID, String governanceRequestType, String serviceRequestType, Map<String, String> defaultAnalysisParameters, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "registerGovernanceServiceWithEngine";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        String governanceRequestTypeParameter = "governanceRequestType";
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "registerGovernanceServiceWithEngine");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "registerGovernanceServiceWithEngine");
        this.invalidParameterHandler.validateName(governanceRequestType, "governanceRequestType", "registerGovernanceServiceWithEngine");
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, governanceEngineGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, 2, false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), null, "registerGovernanceServiceWithEngine");
        while (iterator.moreToReceive()) {
            String existingRequestType;
            Relationship supportedGovernanceService = iterator.getNext();
            if (supportedGovernanceService == null || !governanceRequestType.equals(existingRequestType = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.REQUEST_TYPE.name, supportedGovernanceService.getProperties(), "registerGovernanceServiceWithEngine"))) continue;
            EntityProxy existingGovernanceServiceProxy = supportedGovernanceService.getEntityTwoProxy();
            if (existingGovernanceServiceProxy != null && governanceServiceGUID.equals(existingGovernanceServiceProxy.getGUID())) {
                InstanceProperties properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, supportedGovernanceService.getProperties(), OpenMetadataProperty.REQUEST_PARAMETERS.name, defaultAnalysisParameters, "registerGovernanceServiceWithEngine");
                properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SERVICE_REQUEST_TYPE.name, serviceRequestType, "registerGovernanceServiceWithEngine");
                this.repositoryHandler.updateRelationshipProperties(userId, null, null, supportedGovernanceService, properties, "registerGovernanceServiceWithEngine");
                return;
            }
            this.repositoryHandler.removeRelationship(userId, null, null, supportedGovernanceService, "registerGovernanceServiceWithEngine");
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, OpenMetadataProperty.REQUEST_TYPE.name, governanceRequestType, "registerGovernanceServiceWithEngine");
        instanceProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, OpenMetadataProperty.SERVICE_REQUEST_TYPE.name, serviceRequestType, "registerGovernanceServiceWithEngine");
        instanceProperties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, instanceProperties, OpenMetadataProperty.REQUEST_PARAMETERS.name, defaultAnalysisParameters, "registerGovernanceServiceWithEngine");
        this.governanceEngineHandler.multiLinkElementToElement(userId, null, null, governanceEngineGUID, "governanceEngineGUID", OpenMetadataType.GOVERNANCE_ENGINE.typeName, governanceServiceGUID, "governanceServiceGUID", OpenMetadataType.GOVERNANCE_SERVICE.typeName, false, false, this.governanceEngineHandler.getSupportedZones(), OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, instanceProperties, new Date(), "registerGovernanceServiceWithEngine");
    }

    public RegisteredGovernanceServiceElement getRegisteredGovernanceService(String userId, String governanceEngineGUID, String governanceServiceGUID, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredGovernanceService";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredGovernanceService");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "getRegisteredGovernanceService");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "getRegisteredGovernanceService");
        List relationships = this.repositoryHandler.getRelationshipsBetweenEntities(userId, governanceServiceGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, governanceEngineGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, 1, false, false, null, "getRegisteredGovernanceService");
        if (relationships != null) {
            RegisteredGovernanceServiceConverter converter = new RegisteredGovernanceServiceConverter(this.repositoryHelper, this.serviceName);
            return converter.getBean(this.getGovernanceServiceByGUID(userId, governanceServiceGUID, serviceSupportedZones), relationships);
        }
        return null;
    }

    public List<RegisteredGovernanceServiceElement> getRegisteredGovernanceServices(String userId, String governanceEngineGUID, int startingFrom, int maximumResults, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredGovernanceServices";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        List relationships = this.governanceEngineHandler.getAttachmentLinks(userId, governanceEngineGUID, "governanceEngineGUID", OpenMetadataType.GOVERNANCE_ENGINE.typeName, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, null, OpenMetadataType.GOVERNANCE_SERVICE.typeName, 2, false, false, startingFrom, maximumResults, new Date(), "getRegisteredGovernanceServices");
        if (relationships != null) {
            HashMap<String, RegisteredGovernanceServiceElement> governanceServices = new HashMap<String, RegisteredGovernanceServiceElement>();
            for (Relationship relationship : relationships) {
                String requestType;
                EntityProxy end2 = relationship.getEntityTwoProxy();
                RegisteredGovernanceServiceElement governanceService = (RegisteredGovernanceServiceElement)governanceServices.get(end2.getGUID());
                if (governanceService == null) {
                    try {
                        GovernanceServiceElement newElement = this.getGovernanceServiceByGUID(userId, end2.getGUID(), serviceSupportedZones);
                        if (newElement != null) {
                            governanceService = new RegisteredGovernanceServiceElement(newElement);
                            governanceServices.put(end2.getGUID(), governanceService);
                        }
                    }
                    catch (Exception newElement) {
                        // empty catch block
                    }
                }
                if (governanceService == null || (requestType = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.REQUEST_TYPE.name, relationship.getProperties(), "getRegisteredGovernanceServices")) == null) continue;
                RegisteredGovernanceServiceProperties relationshipProperties = new RegisteredGovernanceServiceProperties();
                relationshipProperties.setServiceRequestType(this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.SERVICE_REQUEST_TYPE.name, relationship.getProperties(), "getRegisteredGovernanceServices"));
                relationshipProperties.setRequestParameters(this.repositoryHelper.getStringMapFromProperty(this.serviceName, OpenMetadataProperty.REQUEST_PARAMETERS.name, relationship.getProperties(), "getRegisteredGovernanceServices"));
                HashMap<String, RegisteredGovernanceServiceProperties> requestTypes = governanceService.getProperties().getRequestTypes();
                if (requestTypes == null) {
                    requestTypes = new HashMap<String, RegisteredGovernanceServiceProperties>();
                }
                requestTypes.put(requestType, relationshipProperties);
                governanceService.getProperties().setRequestTypes(requestTypes);
            }
            if (!governanceServices.isEmpty()) {
                return new ArrayList<RegisteredGovernanceServiceElement>(governanceServices.values());
            }
        }
        return null;
    }

    public void unregisterGovernanceServiceRequestFromEngine(String userId, String requestType, String governanceEngineGUID, String governanceServiceGUID, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterGovernanceServiceFromEngine";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "unregisterGovernanceServiceFromEngine");
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, governanceEngineGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, 2, false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), null, "unregisterGovernanceServiceFromEngine");
        while (iterator.moreToReceive()) {
            String existingRequestType;
            Relationship supportedGovernanceService = iterator.getNext();
            if (supportedGovernanceService == null || !requestType.equals(existingRequestType = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.REQUEST_TYPE.name, supportedGovernanceService.getProperties(), "unregisterGovernanceServiceFromEngine"))) continue;
            this.governanceEngineHandler.unlinkElementFromElement(userId, false, null, null, governanceEngineGUID, "governanceEngineGUID", OpenMetadataType.GOVERNANCE_ENGINE.typeName, governanceServiceGUID, "governanceServiceGUID", OpenMetadataType.GOVERNANCE_SERVICE.typeGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, false, false, serviceSupportedZones, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, supportedGovernanceService, new Date(), "unregisterGovernanceServiceFromEngine");
            return;
        }
    }

    public void unregisterGovernanceServiceFromEngine(String userId, String governanceEngineGUID, String governanceServiceGUID, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterGovernanceServiceFromEngine";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "unregisterGovernanceServiceFromEngine");
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, governanceEngineGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, 2, false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), null, "unregisterGovernanceServiceFromEngine");
        while (iterator.moreToReceive()) {
            EntityProxy governanceServiceProxy;
            Relationship supportedGovernanceService = iterator.getNext();
            if (supportedGovernanceService == null || (governanceServiceProxy = supportedGovernanceService.getEntityTwoProxy()) == null || !governanceServiceProxy.getGUID().equals(governanceServiceGUID)) continue;
            this.governanceEngineHandler.unlinkElementFromElement(userId, false, null, null, governanceEngineGUID, "governanceEngineGUID", OpenMetadataType.GOVERNANCE_ENGINE.typeName, governanceServiceGUID, "governanceServiceGUID", OpenMetadataType.GOVERNANCE_SERVICE.typeGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, false, false, serviceSupportedZones, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, supportedGovernanceService, new Date(), "unregisterGovernanceServiceFromEngine");
        }
    }
}

