/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server;

import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.DeleteRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworkservices.gaf.handlers.GovernanceEngineConfigurationHandler;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceEngineElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceEngineElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceRegistrationRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceEngineRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceServiceRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredGovernanceServiceResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredGovernanceServicesResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceEngineRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceServiceRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.server.GAFMetadataManagementInstanceHandler;
import org.slf4j.LoggerFactory;

public class GovernanceConfigRESTServices {
    private static final GAFMetadataManagementInstanceHandler instanceHandler = new GAFMetadataManagementInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceConfigRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createGovernanceEngine(String serverName, String serviceURLMarker, String userId, String typeName, NewGovernanceEngineRequestBody requestBody) {
        String methodName = "createGovernanceEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceEngine");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "createGovernanceEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceEngine");
            if (requestBody != null) {
                response.setGUID(handler.createGovernanceEngine(userId, typeName, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createGovernanceEngine")));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceEngine", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceEngineElementResponse getGovernanceEngineByGUID(String serverName, String serviceURLMarker, String userId, String guid) {
        String methodName = "getGovernanceEngineByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceEngineByGUID");
        GovernanceEngineElementResponse response = new GovernanceEngineElementResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getGovernanceEngineByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceEngineByGUID");
            response.setElement(handler.getGovernanceEngineByGUID(userId, guid, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceEngineByGUID")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceEngineByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceEngineElementResponse getGovernanceEngineByName(String serverName, String serviceURLMarker, String userId, NameRequestBody requestBody) {
        String methodName = "getGovernanceEngineByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceEngineByName");
        GovernanceEngineElementResponse response = new GovernanceEngineElementResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getGovernanceEngineByName");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceEngineByName");
                response.setElement(handler.getGovernanceEngineByName(userId, requestBody.getName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceEngineByName")));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceEngineByName", serverName, NameRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceEngineByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceEngineElementsResponse getAllGovernanceEngines(String serverName, String serviceURLMarker, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllGovernanceEngines";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllGovernanceEngines");
        GovernanceEngineElementsResponse response = new GovernanceEngineElementsResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getAllGovernanceEngines");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllGovernanceEngines");
            response.setElements(handler.getAllGovernanceEngines(userId, startingFrom, maximumResults, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getAllGovernanceEngines")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAllGovernanceEngines", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceEngine(String serverName, String serviceURLMarker, String userId, String guid, UpdateGovernanceEngineRequestBody requestBody) {
        String methodName = "updateGovernanceEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "updateGovernanceEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceEngine");
            if (requestBody != null) {
                handler.updateGovernanceEngine(userId, guid, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getTypeDescription(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateGovernanceEngine"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceEngine", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteGovernanceEngine(String serverName, String serviceURLMarker, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteGovernanceEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteGovernanceEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "deleteGovernanceEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteGovernanceEngine");
            if (requestBody != null) {
                handler.deleteGovernanceEngine(userId, guid, requestBody.getQualifiedName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "deleteGovernanceEngine"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteGovernanceEngine", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteGovernanceEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGovernanceService(String serverName, String serviceURLMarker, String userId, String typeName, NewGovernanceServiceRequestBody requestBody) {
        String methodName = "createGovernanceService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceService");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "createGovernanceService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceService");
            if (requestBody != null) {
                response.setGUID(handler.createGovernanceService(userId, typeName, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getConnection(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createGovernanceService")));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceService", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceServiceElementResponse getGovernanceServiceByGUID(String serverName, String serviceURLMarker, String userId, String guid) {
        String methodName = "getGovernanceServiceByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceServiceByGUID");
        GovernanceServiceElementResponse response = new GovernanceServiceElementResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getGovernanceServiceByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceServiceByGUID");
            response.setElement(handler.getGovernanceServiceByGUID(userId, guid, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceServiceByGUID")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceServiceByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceServiceElementResponse getGovernanceServiceByName(String serverName, String serviceURLMarker, String userId, NameRequestBody requestBody) {
        String methodName = "getGovernanceServiceByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceServiceByName");
        GovernanceServiceElementResponse response = new GovernanceServiceElementResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getGovernanceServiceByName");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceServiceByName");
                response.setElement(handler.getGovernanceServiceByName(userId, requestBody.getName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceServiceByName")));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceServiceByName", serverName, NameRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceServiceByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceServiceElementsResponse getAllGovernanceServices(String serverName, String serviceURLMarker, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllGovernanceServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllGovernanceServices");
        GovernanceServiceElementsResponse response = new GovernanceServiceElementsResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getAllGovernanceServices");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllGovernanceServices");
            response.setElements(handler.getAllGovernanceServices(userId, startingFrom, maximumResults, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getAllGovernanceServices")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAllGovernanceServices", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getGovernanceServiceRegistrations(String serverName, String serviceURLMarker, String userId, String governanceServiceGUID) {
        String methodName = "getGovernanceServiceRegistrations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceServiceRegistrations");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getGovernanceServiceRegistrations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceServiceRegistrations");
            response.setGUIDs(handler.getGovernanceServiceRegistrations(userId, governanceServiceGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceServiceRegistrations")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceServiceRegistrations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceService(String serverName, String serviceURLMarker, String userId, String guid, UpdateGovernanceServiceRequestBody requestBody) {
        String methodName = "updateGovernanceService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceService");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "updateGovernanceService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceService");
            if (requestBody != null) {
                handler.updateGovernanceService(userId, guid, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getConnection(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateGovernanceService"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceService", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteGovernanceService(String serverName, String serviceURLMarker, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteGovernanceService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteGovernanceService");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "deleteGovernanceService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteGovernanceService");
            if (requestBody != null) {
                handler.deleteGovernanceService(userId, guid, requestBody.getQualifiedName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "deleteGovernanceService"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteGovernanceService", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteGovernanceService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse registerGovernanceServiceWithEngine(String serverName, String serviceURLMarker, String userId, String governanceEngineGUID, GovernanceServiceRegistrationRequestBody requestBody) {
        String methodName = "registerGovernanceServiceWithEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "registerGovernanceServiceWithEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "registerGovernanceServiceWithEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "registerGovernanceServiceWithEngine");
            if (requestBody != null) {
                handler.registerGovernanceServiceWithEngine(userId, governanceEngineGUID, requestBody.getGovernanceServiceGUID(), requestBody.getRequestType(), requestBody.getServiceRequestType(), requestBody.getRequestParameters(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "registerGovernanceServiceWithEngine"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "registerGovernanceServiceWithEngine", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "registerGovernanceServiceWithEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredGovernanceServiceResponse getRegisteredGovernanceService(String serverName, String serviceURLMarker, String userId, String governanceEngineGUID, String governanceServiceGUID) {
        String methodName = "getRegisteredGovernanceService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredGovernanceService");
        RegisteredGovernanceServiceResponse response = new RegisteredGovernanceServiceResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getRegisteredGovernanceService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredGovernanceService");
            response.setRegisteredGovernanceService(handler.getRegisteredGovernanceService(userId, governanceEngineGUID, governanceServiceGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getRegisteredGovernanceService")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredGovernanceService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredGovernanceServicesResponse getRegisteredGovernanceServices(String serverName, String serviceURLMarker, String userId, String governanceEngineGUID, int startingFrom, int maximumResults) {
        String methodName = "getRegisteredGovernanceServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredGovernanceServices");
        RegisteredGovernanceServicesResponse response = new RegisteredGovernanceServicesResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getRegisteredGovernanceServices");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredGovernanceServices");
            response.setElements(handler.getRegisteredGovernanceServices(userId, governanceEngineGUID, startingFrom, maximumResults, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getRegisteredGovernanceServices")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredGovernanceServices", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unregisterGovernanceServiceRequestFromEngine(String serverName, String serviceURLMarker, String userId, String requestType, String governanceEngineGUID, String governanceServiceGUID, NullRequestBody requestBody) {
        String methodName = "unregisterGovernanceServiceRequestFromEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unregisterGovernanceServiceRequestFromEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "unregisterGovernanceServiceRequestFromEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unregisterGovernanceServiceRequestFromEngine");
            handler.unregisterGovernanceServiceRequestFromEngine(userId, requestType, governanceEngineGUID, governanceServiceGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "unregisterGovernanceServiceRequestFromEngine"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unregisterGovernanceServiceRequestFromEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unregisterGovernanceServiceFromEngine(String serverName, String serviceURLMarker, String userId, String governanceEngineGUID, String governanceServiceGUID, NullRequestBody requestBody) {
        String methodName = "unregisterGovernanceServiceFromEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unregisterGovernanceServiceFromEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "unregisterGovernanceServiceFromEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unregisterGovernanceServiceFromEngine");
            handler.unregisterGovernanceServiceFromEngine(userId, governanceEngineGUID, governanceServiceGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "unregisterGovernanceServiceFromEngine"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unregisterGovernanceServiceFromEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

