/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.converters;

import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceServiceElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredGovernanceService;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredGovernanceServiceElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredGovernanceServiceProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RegisteredGovernanceServiceConverter {
    private final OMRSRepositoryHelper repositoryHelper;
    private final String serviceName;

    public RegisteredGovernanceServiceConverter(OMRSRepositoryHelper repositoryHelper, String serviceName) {
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
    }

    public RegisteredGovernanceServiceElement getBean(GovernanceServiceElement governanceService, List<Relationship> relationships) {
        String methodName = "getBean";
        RegisteredGovernanceServiceElement bean = new RegisteredGovernanceServiceElement(governanceService);
        if (relationships != null) {
            RegisteredGovernanceService properties;
            HashMap<String, RegisteredGovernanceServiceProperties> requestTypeMappings = new HashMap<String, RegisteredGovernanceServiceProperties>();
            for (Relationship relationship : relationships) {
                InstanceProperties instanceProperties;
                if (relationship == null || (instanceProperties = relationship.getProperties()) == null) continue;
                String requestType = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.REQUEST_TYPE.name, instanceProperties, "getBean");
                RegisteredGovernanceServiceProperties registeredGovernanceServiceProperties = new RegisteredGovernanceServiceProperties();
                String serviceRequestType = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.SERVICE_REQUEST_TYPE.name, instanceProperties, "getBean");
                if (requestType == null) continue;
                if (serviceRequestType == null) {
                    registeredGovernanceServiceProperties.setServiceRequestType(requestType);
                } else {
                    registeredGovernanceServiceProperties.setServiceRequestType(serviceRequestType);
                }
                registeredGovernanceServiceProperties.setRequestParameters(this.repositoryHelper.getStringMapFromProperty(this.serviceName, OpenMetadataProperty.REQUEST_PARAMETERS.name, instanceProperties, "getBean"));
                requestTypeMappings.put(requestType, registeredGovernanceServiceProperties);
            }
            if (!requestTypeMappings.isEmpty() && (properties = bean.getProperties()) != null) {
                properties.setRequestTypes(requestTypeMappings);
                bean.setProperties(properties);
            }
        }
        return bean;
    }
}

