/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server;

import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.DeleteRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationConnectorProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationGroupProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredIntegrationConnectorProperties;
import org.odpi.openmetadata.frameworkservices.gaf.handlers.GovernanceEngineConfigurationHandler;
import org.odpi.openmetadata.frameworkservices.gaf.handlers.IntegrationGroupConfigurationHandler;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CatalogTargetResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceEngineElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceEngineElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceRegistrationRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IntegrationConnectorElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IntegrationConnectorElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IntegrationGroupElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IntegrationGroupElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceEngineRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceServiceRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredGovernanceServiceResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredGovernanceServicesResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredIntegrationConnectorResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredIntegrationConnectorsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceEngineRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceServiceRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.server.GAFMetadataManagementInstanceHandler;
import org.slf4j.LoggerFactory;

public class GovernanceConfigRESTServices {
    private static final GAFMetadataManagementInstanceHandler instanceHandler = new GAFMetadataManagementInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceConfigRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createGovernanceEngine(String serverName, String serviceURLMarker, String userId, String typeName, NewGovernanceEngineRequestBody requestBody) {
        String methodName = "createGovernanceEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceEngine");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "createGovernanceEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceEngine");
            if (requestBody != null) {
                response.setGUID(handler.createGovernanceEngine(userId, typeName, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createGovernanceEngine")));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceEngine", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceEngineElementResponse getGovernanceEngineByGUID(String serverName, String serviceURLMarker, String userId, String guid) {
        String methodName = "getGovernanceEngineByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceEngineByGUID");
        GovernanceEngineElementResponse response = new GovernanceEngineElementResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "getGovernanceEngineByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceEngineByGUID");
            response.setElement(handler.getGovernanceEngineByGUID(userId, guid, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceEngineByGUID")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceEngineByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceEngineElementResponse getGovernanceEngineByName(String serverName, String serviceURLMarker, String userId, NameRequestBody requestBody) {
        String methodName = "getGovernanceEngineByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceEngineByName");
        GovernanceEngineElementResponse response = new GovernanceEngineElementResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "getGovernanceEngineByName");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceEngineByName");
                response.setElement(handler.getGovernanceEngineByName(userId, requestBody.getName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceEngineByName")));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceEngineByName", serverName, NameRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceEngineByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceEngineElementsResponse getAllGovernanceEngines(String serverName, String serviceURLMarker, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllGovernanceEngines";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllGovernanceEngines");
        GovernanceEngineElementsResponse response = new GovernanceEngineElementsResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "getAllGovernanceEngines");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllGovernanceEngines");
            response.setElements(handler.getAllGovernanceEngines(userId, startingFrom, maximumResults, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getAllGovernanceEngines")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAllGovernanceEngines", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceEngine(String serverName, String serviceURLMarker, String userId, String guid, UpdateGovernanceEngineRequestBody requestBody) {
        String methodName = "updateGovernanceEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "updateGovernanceEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceEngine");
            if (requestBody != null) {
                handler.updateGovernanceEngine(userId, guid, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getTypeDescription(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateGovernanceEngine"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceEngine", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteGovernanceEngine(String serverName, String serviceURLMarker, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteGovernanceEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteGovernanceEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "deleteGovernanceEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteGovernanceEngine");
            if (requestBody != null) {
                handler.deleteGovernanceEngine(userId, guid, requestBody.getQualifiedName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "deleteGovernanceEngine"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteGovernanceEngine", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteGovernanceEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGovernanceService(String serverName, String serviceURLMarker, String userId, String typeName, NewGovernanceServiceRequestBody requestBody) {
        String methodName = "createGovernanceService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceService");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "createGovernanceService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceService");
            if (requestBody != null) {
                response.setGUID(handler.createGovernanceService(userId, typeName, requestBody.getQualifiedName(), requestBody.getName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), requestBody.getDeployedImplementationType(), requestBody.getConnection(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createGovernanceService")));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceService", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceServiceElementResponse getGovernanceServiceByGUID(String serverName, String serviceURLMarker, String userId, String guid) {
        String methodName = "getGovernanceServiceByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceServiceByGUID");
        GovernanceServiceElementResponse response = new GovernanceServiceElementResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "getGovernanceServiceByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceServiceByGUID");
            response.setElement(handler.getGovernanceServiceByGUID(userId, guid, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceServiceByGUID")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceServiceByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceServiceElementResponse getGovernanceServiceByName(String serverName, String serviceURLMarker, String userId, NameRequestBody requestBody) {
        String methodName = "getGovernanceServiceByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceServiceByName");
        GovernanceServiceElementResponse response = new GovernanceServiceElementResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "getGovernanceServiceByName");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceServiceByName");
                response.setElement(handler.getGovernanceServiceByName(userId, requestBody.getName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceServiceByName")));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceServiceByName", serverName, NameRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceServiceByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceServiceElementsResponse getAllGovernanceServices(String serverName, String serviceURLMarker, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllGovernanceServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllGovernanceServices");
        GovernanceServiceElementsResponse response = new GovernanceServiceElementsResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "getAllGovernanceServices");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllGovernanceServices");
            response.setElements(handler.getAllGovernanceServices(userId, startingFrom, maximumResults, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getAllGovernanceServices")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAllGovernanceServices", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getGovernanceServiceRegistrations(String serverName, String serviceURLMarker, String userId, String governanceServiceGUID) {
        String methodName = "getGovernanceServiceRegistrations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceServiceRegistrations");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "getGovernanceServiceRegistrations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceServiceRegistrations");
            response.setGUIDs(handler.getGovernanceServiceRegistrations(userId, governanceServiceGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceServiceRegistrations")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceServiceRegistrations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceService(String serverName, String serviceURLMarker, String userId, String guid, UpdateGovernanceServiceRequestBody requestBody) {
        String methodName = "updateGovernanceService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceService");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "updateGovernanceService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceService");
            if (requestBody != null) {
                handler.updateGovernanceService(userId, guid, requestBody.getQualifiedName(), requestBody.getName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), requestBody.getDeployedImplementationType(), requestBody.getConnection(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateGovernanceService"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceService", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteGovernanceService(String serverName, String serviceURLMarker, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteGovernanceService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteGovernanceService");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "deleteGovernanceService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteGovernanceService");
            if (requestBody != null) {
                handler.deleteGovernanceService(userId, guid, requestBody.getQualifiedName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "deleteGovernanceService"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteGovernanceService", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteGovernanceService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse registerGovernanceServiceWithEngine(String serverName, String serviceURLMarker, String userId, String governanceEngineGUID, GovernanceServiceRegistrationRequestBody requestBody) {
        String methodName = "registerGovernanceServiceWithEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "registerGovernanceServiceWithEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "registerGovernanceServiceWithEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "registerGovernanceServiceWithEngine");
            if (requestBody != null) {
                handler.registerGovernanceServiceWithEngine(userId, governanceEngineGUID, requestBody.getGovernanceServiceGUID(), requestBody.getRequestType(), requestBody.getServiceRequestType(), requestBody.getRequestParameters(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "registerGovernanceServiceWithEngine"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "registerGovernanceServiceWithEngine", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "registerGovernanceServiceWithEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredGovernanceServiceResponse getRegisteredGovernanceService(String serverName, String serviceURLMarker, String userId, String governanceEngineGUID, String governanceServiceGUID) {
        String methodName = "getRegisteredGovernanceService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredGovernanceService");
        RegisteredGovernanceServiceResponse response = new RegisteredGovernanceServiceResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "getRegisteredGovernanceService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredGovernanceService");
            response.setRegisteredGovernanceService(handler.getRegisteredGovernanceService(userId, governanceEngineGUID, governanceServiceGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getRegisteredGovernanceService")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredGovernanceService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredGovernanceServicesResponse getRegisteredGovernanceServices(String serverName, String serviceURLMarker, String userId, String governanceEngineGUID, int startingFrom, int maximumResults) {
        String methodName = "getRegisteredGovernanceServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredGovernanceServices");
        RegisteredGovernanceServicesResponse response = new RegisteredGovernanceServicesResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "getRegisteredGovernanceServices");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredGovernanceServices");
            response.setElements(handler.getRegisteredGovernanceServices(userId, governanceEngineGUID, startingFrom, maximumResults, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getRegisteredGovernanceServices")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredGovernanceServices", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unregisterGovernanceServiceRequestFromEngine(String serverName, String serviceURLMarker, String userId, String requestType, String governanceEngineGUID, String governanceServiceGUID, NullRequestBody requestBody) {
        String methodName = "unregisterGovernanceServiceRequestFromEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unregisterGovernanceServiceRequestFromEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "unregisterGovernanceServiceRequestFromEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unregisterGovernanceServiceRequestFromEngine");
            handler.unregisterGovernanceServiceRequestFromEngine(userId, requestType, governanceEngineGUID, governanceServiceGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "unregisterGovernanceServiceRequestFromEngine"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unregisterGovernanceServiceRequestFromEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unregisterGovernanceServiceFromEngine(String serverName, String serviceURLMarker, String userId, String governanceEngineGUID, String governanceServiceGUID, NullRequestBody requestBody) {
        String methodName = "unregisterGovernanceServiceFromEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unregisterGovernanceServiceFromEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceEngineConfigurationHandler handler = instanceHandler.getGovernanceEngineConfigurationHandler(userId, serverName, "unregisterGovernanceServiceFromEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unregisterGovernanceServiceFromEngine");
            handler.unregisterGovernanceServiceFromEngine(userId, governanceEngineGUID, governanceServiceGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "unregisterGovernanceServiceFromEngine"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unregisterGovernanceServiceFromEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createIntegrationGroup(String serverName, String serviceURLMarker, String userId, IntegrationGroupProperties requestBody) {
        String methodName = "createIntegrationGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createIntegrationGroup");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "createIntegrationGroup");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createIntegrationGroup");
            if (requestBody != null) {
                response.setGUID(handler.createIntegrationGroup(userId, requestBody, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createIntegrationGroup")));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createIntegrationGroup", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createIntegrationGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationGroupElementResponse getIntegrationGroupByGUID(String serverName, String serviceURLMarker, String userId, String guid) {
        String methodName = "getIntegrationGroupByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationGroupByGUID");
        IntegrationGroupElementResponse response = new IntegrationGroupElementResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getIntegrationGroupByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationGroupByGUID");
            response.setElement(handler.getIntegrationGroupByGUID(userId, guid, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getIntegrationGroupByGUID")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationGroupByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationGroupElementResponse getIntegrationGroupByName(String serverName, String serviceURLMarker, String userId, String name) {
        String methodName = "getIntegrationGroupByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationGroupByName");
        IntegrationGroupElementResponse response = new IntegrationGroupElementResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getIntegrationGroupByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationGroupByName");
            response.setElement(handler.getIntegrationGroupByName(userId, name, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getIntegrationGroupByName")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationGroupByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationGroupElementsResponse getAllIntegrationGroups(String serverName, String serviceURLMarker, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllIntegrationGroups";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllIntegrationGroups");
        IntegrationGroupElementsResponse response = new IntegrationGroupElementsResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getAllIntegrationGroups");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllIntegrationGroups");
            response.setElements(handler.getAllIntegrationGroups(userId, startingFrom, maximumResults, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getAllIntegrationGroups")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAllIntegrationGroups", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateIntegrationGroup(String serverName, String serviceURLMarker, String userId, String guid, boolean isMergeUpdate, IntegrationGroupProperties requestBody) {
        String methodName = "updateIntegrationGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateIntegrationGroup");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "updateIntegrationGroup");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateIntegrationGroup");
            if (requestBody != null) {
                handler.updateIntegrationGroup(userId, guid, isMergeUpdate, requestBody, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateIntegrationGroup"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateIntegrationGroup", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateIntegrationGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteIntegrationGroup(String serverName, String serviceURLMarker, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteIntegrationGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteIntegrationGroup");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "deleteIntegrationGroup");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteIntegrationGroup");
            if (requestBody != null) {
                handler.deleteIntegrationGroup(userId, guid, requestBody.getQualifiedName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "deleteIntegrationGroup"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteIntegrationGroup", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteIntegrationGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createIntegrationConnector(String serverName, String serviceURLMarker, String userId, IntegrationConnectorProperties requestBody) {
        String methodName = "createIntegrationConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createIntegrationConnector");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "createIntegrationConnector");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createIntegrationConnector");
            if (requestBody != null) {
                response.setGUID(handler.createIntegrationConnector(userId, requestBody.getQualifiedName(), requestBody.getVersionIdentifier(), requestBody.getName(), requestBody.getDescription(), requestBody.getDeployedImplementationType(), requestBody.getUsesBlockingCalls(), requestBody.getAdditionalProperties(), requestBody.getConnection(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createIntegrationConnector")));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createIntegrationConnector", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createIntegrationConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationConnectorElementResponse getIntegrationConnectorByGUID(String serverName, String serviceURLMarker, String userId, String guid) {
        String methodName = "getIntegrationConnectorByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationConnectorByGUID");
        IntegrationConnectorElementResponse response = new IntegrationConnectorElementResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getIntegrationConnectorByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationConnectorByGUID");
            response.setElement(handler.getIntegrationConnectorByGUID(userId, guid, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getIntegrationConnectorByGUID")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationConnectorByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationConnectorElementResponse getIntegrationConnectorByName(String serverName, String serviceURLMarker, String userId, String name) {
        String methodName = "getIntegrationConnectorByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationConnectorByName");
        IntegrationConnectorElementResponse response = new IntegrationConnectorElementResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getIntegrationConnectorByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationConnectorByName");
            response.setElement(handler.getIntegrationConnectorByName(userId, name, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getIntegrationConnectorByName")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationConnectorByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationConnectorElementsResponse getAllIntegrationConnectors(String serverName, String serviceURLMarker, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllIntegrationConnectors";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllIntegrationConnectors");
        IntegrationConnectorElementsResponse response = new IntegrationConnectorElementsResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getAllIntegrationConnectors");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllIntegrationConnectors");
            response.setElements(handler.getAllIntegrationConnectors(userId, startingFrom, maximumResults, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getAllIntegrationConnectors")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAllIntegrationConnectors", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getIntegrationConnectorRegistrations(String serverName, String serviceURLMarker, String userId, String integrationConnectorGUID) {
        String methodName = "getIntegrationConnectorRegistrations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationConnectorRegistrations");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getIntegrationConnectorRegistrations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationConnectorRegistrations");
            response.setGUIDs(handler.getIntegrationConnectorRegistrations(userId, integrationConnectorGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getIntegrationConnectorRegistrations")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationConnectorRegistrations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateIntegrationConnector(String serverName, String serviceURLMarker, String userId, String guid, boolean isMergeUpdate, IntegrationConnectorProperties requestBody) {
        String methodName = "updateIntegrationConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateIntegrationConnector");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "updateIntegrationConnector");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateIntegrationConnector");
            if (requestBody != null) {
                handler.updateIntegrationConnector(userId, guid, isMergeUpdate, requestBody.getQualifiedName(), requestBody.getVersionIdentifier(), requestBody.getName(), requestBody.getDescription(), requestBody.getDeployedImplementationType(), requestBody.getConnection(), requestBody.getAdditionalProperties(), null, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateIntegrationConnector"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateIntegrationConnector", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateIntegrationConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteIntegrationConnector(String serverName, String serviceURLMarker, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteIntegrationConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteIntegrationConnector");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "deleteIntegrationConnector");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteIntegrationConnector");
            if (requestBody != null) {
                handler.deleteIntegrationConnector(userId, guid, requestBody.getQualifiedName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "deleteIntegrationConnector"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteIntegrationConnector", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteIntegrationConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse registerIntegrationConnectorWithGroup(String serverName, String serviceURLMarker, String userId, String integrationGroupGUID, String integrationConnectorGUID, RegisteredIntegrationConnectorProperties requestBody) {
        String methodName = "registerIntegrationConnectorWithEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "registerIntegrationConnectorWithEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "registerIntegrationConnectorWithEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "registerIntegrationConnectorWithEngine");
            if (requestBody != null) {
                handler.registerIntegrationConnectorWithGroup(userId, integrationGroupGUID, integrationConnectorGUID, requestBody.getConnectorName(), requestBody.getConnectorUserId(), requestBody.getMetadataSourceQualifiedName(), requestBody.getStartDate(), requestBody.getRefreshTimeInterval(), requestBody.getStopDate(), requestBody.getPermittedSynchronization(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "registerIntegrationConnectorWithEngine"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "registerIntegrationConnectorWithEngine", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "registerIntegrationConnectorWithEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredIntegrationConnectorResponse getRegisteredIntegrationConnector(String serverName, String serviceURLMarker, String userId, String integrationGroupGUID, String integrationConnectorGUID) {
        String methodName = "getRegisteredIntegrationConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredIntegrationConnector");
        RegisteredIntegrationConnectorResponse response = new RegisteredIntegrationConnectorResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getRegisteredIntegrationConnector");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredIntegrationConnector");
            response.setRegisteredIntegrationConnector(handler.getRegisteredIntegrationConnector(userId, integrationGroupGUID, integrationConnectorGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getRegisteredIntegrationConnector")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredIntegrationConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredIntegrationConnectorsResponse getRegisteredIntegrationConnectors(String serverName, String serviceURLMarker, String userId, String integrationGroupGUID, int startingFrom, int maximumResults) {
        String methodName = "getRegisteredIntegrationConnectors";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredIntegrationConnectors");
        RegisteredIntegrationConnectorsResponse response = new RegisteredIntegrationConnectorsResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getRegisteredIntegrationConnectors");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredIntegrationConnectors");
            response.setElements(handler.getRegisteredIntegrationConnectors(userId, integrationGroupGUID, startingFrom, maximumResults, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getRegisteredIntegrationConnectors")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredIntegrationConnectors", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unregisterIntegrationConnectorFromGroup(String serverName, String serviceURLMarker, String userId, String integrationGroupGUID, String integrationConnectorGUID, NullRequestBody requestBody) {
        String methodName = "unregisterIntegrationConnectorFromGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unregisterIntegrationConnectorFromGroup");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "unregisterIntegrationConnectorFromGroup");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unregisterIntegrationConnectorFromGroup");
            handler.unregisterIntegrationConnectorFromGroup(userId, integrationGroupGUID, integrationConnectorGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "unregisterIntegrationConnectorFromGroup"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unregisterIntegrationConnectorFromGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCatalogTarget(String serverName, String serviceURLMarker, String userId, String integrationConnectorGUID, String metadataElementGUID, CatalogTargetProperties requestBody) {
        String methodName = "addCatalogTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCatalogTarget");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "addCatalogTarget");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addCatalogTarget");
            if (requestBody != null) {
                response.setGUID(handler.addCatalogTarget(userId, integrationConnectorGUID, metadataElementGUID, requestBody, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "addCatalogTarget")));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addCatalogTarget", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addCatalogTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateCatalogTarget(String serverName, String serviceURLMarker, String userId, String relationshipGUID, CatalogTargetProperties requestBody) {
        String methodName = "updateCatalogTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateCatalogTarget");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "updateCatalogTarget");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCatalogTarget");
            if (requestBody != null) {
                handler.updateCatalogTarget(userId, relationshipGUID, requestBody, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateCatalogTarget"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateCatalogTarget", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateCatalogTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CatalogTargetResponse getCatalogTarget(String serverName, String serviceURLMarker, String userId, String relationshipGUID) {
        String methodName = "getCatalogTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCatalogTarget");
        CatalogTargetResponse response = new CatalogTargetResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getCatalogTarget");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCatalogTarget");
            response.setElement(handler.getCatalogTarget(userId, relationshipGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getCatalogTarget")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCatalogTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CatalogTargetsResponse getCatalogTargets(String serverName, String serviceURLMarker, String userId, String integrationConnectorGUID, int startingFrom, int maximumResults) {
        String methodName = "getCatalogTargets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCatalogTargets");
        CatalogTargetsResponse response = new CatalogTargetsResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getCatalogTargets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCatalogTargets");
            response.setElements(handler.getCatalogTargets(userId, integrationConnectorGUID, startingFrom, maximumResults, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getCatalogTargets")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCatalogTargets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeCatalogTarget(String serverName, String serviceURLMarker, String userId, String relationshipGUID, NullRequestBody requestBody) {
        String methodName = "removeCatalogTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeCatalogTarget");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "removeCatalogTarget");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeCatalogTarget");
            handler.removeCatalogTarget(userId, relationshipGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "removeCatalogTarget"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeCatalogTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

