/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EngineActionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionProcessStepHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.EngineActionElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.FirstGovernanceActionProcessStepElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessGraph;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessStepElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessStepProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionTypeElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionTypeProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NextGovernanceActionProcessStepElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NextGovernanceActionProcessStepLink;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ProcessStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworkservices.gaf.handlers.MetadataElementHandler;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ActionTargetStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CompletionStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ConsolidatedDuplicatesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.FirstGovernanceActionProcessStepResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessGraphResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessStepResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessStepsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypeResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypesResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateEngineActionRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NextGovernanceActionProcessStepRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NextGovernanceActionProcessStepsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.PeerDuplicatesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionProcessStepRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.server.GAFMetadataManagementInstanceHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class OpenGovernanceRESTServices {
    private static final GAFMetadataManagementInstanceHandler instanceHandler = new GAFMetadataManagementInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OpenGovernanceRESTServices.class), instanceHandler.getServiceName());
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public GUIDResponse createGovernanceActionType(String serverName, String serviceURLMarker, String userId, GovernanceActionTypeProperties requestBody) {
        String methodName = "createGovernanceActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceActionType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceActionType");
                GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "createGovernanceActionType");
                response.setGUID(handler.createGovernanceActionType(userId, requestBody.getQualifiedName(), requestBody.getDomainIdentifier(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), requestBody.getGovernanceEngineGUID(), requestBody.getRequestType(), requestBody.getFixedRequestParameters(), requestBody.getWaitTime(), null, null, false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createGovernanceActionType"), new Date(), "createGovernanceActionType"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceActionType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceActionType(String serverName, String serviceURLMarker, String userId, String governanceActionTypeGUID, UpdateGovernanceActionTypeRequestBody requestBody) {
        String methodName = "updateGovernanceActionType";
        String propertiesParameterName = "requestBody.getProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceActionType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceActionType");
                GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "updateGovernanceActionType");
                GovernanceActionTypeProperties properties = requestBody.getProperties();
                this.invalidParameterHandler.validateObject((Object)properties, "requestBody.getProperties", "updateGovernanceActionType");
                handler.updateGovernanceActionType(userId, governanceActionTypeGUID, requestBody.getMergeUpdate(), properties.getQualifiedName(), properties.getDomainIdentifier(), properties.getDisplayName(), properties.getDescription(), properties.getAdditionalProperties(), properties.getGovernanceEngineGUID(), properties.getRequestType(), properties.getFixedRequestParameters(), properties.getWaitTime(), null, null, false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateGovernanceActionType"), new Date(), "updateGovernanceActionType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceActionType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGovernanceActionType(String serverName, String serviceURLMarker, String userId, String governanceActionTypeGUID, NullRequestBody requestBody) {
        String methodName = "removeGovernanceActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGovernanceActionType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGovernanceActionType");
            GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "removeGovernanceActionType");
            handler.removeGovernanceActionType(userId, governanceActionTypeGUID, false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "removeGovernanceActionType"), new Date(), "removeGovernanceActionType");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGovernanceActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypesResponse findGovernanceActionTypes(String serverName, String serviceURLMarker, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGovernanceActionTypes";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGovernanceActionTypes");
        GovernanceActionTypesResponse response = new GovernanceActionTypesResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActionTypes");
                List supportedZones = instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "findGovernanceActionTypes");
                GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "findGovernanceActionTypes");
                if (requestBody.getSearchStringParameterName() != null) {
                    searchStringParameterName = requestBody.getSearchStringParameterName();
                }
                List governanceActionTypeElements = handler.findGovernanceActionTypes(userId, requestBody.getSearchString(), searchStringParameterName, startFrom, pageSize, false, false, supportedZones, new Date(), "findGovernanceActionTypes");
                response.setElements(this.addGovernanceActionTypeSpecification(userId, (OpenMetadataAPIGenericHandler<GovernanceActionTypeElement>)handler, supportedZones, governanceActionTypeElements));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGovernanceActionTypes", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActionTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<GovernanceActionTypeElement> addGovernanceActionTypeSpecification(String userId, OpenMetadataAPIGenericHandler<GovernanceActionTypeElement> handler, List<String> supportedZones, List<GovernanceActionTypeElement> elements) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (elements != null) {
            String elementGUIDParameterName = "governanceActionTypeGUID";
            ArrayList<GovernanceActionTypeElement> results = new ArrayList<GovernanceActionTypeElement>();
            for (GovernanceActionTypeElement element : elements) {
                if (element != null) {
                    element.setSpecification(handler.getSpecification(userId, element.getElementHeader().getGUID(), "governanceActionTypeGUID", "GovernanceActionType", supportedZones));
                    results.add(element);
                    continue;
                }
                results.add(null);
            }
            return results;
        }
        return null;
    }

    public GovernanceActionTypesResponse getGovernanceActionTypesByName(String serverName, String serviceURLMarker, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGovernanceActionTypesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionTypesByName");
        GovernanceActionTypesResponse response = new GovernanceActionTypesResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionTypesByName");
                List supportedZones = instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceActionTypesByName");
                GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "getGovernanceActionTypesByName");
                if (requestBody.getNameParameterName() != null) {
                    nameParameterName = requestBody.getNameParameterName();
                }
                List governanceActionTypeElements = handler.getGovernanceActionTypesByName(userId, requestBody.getName(), nameParameterName, startFrom, pageSize, supportedZones, null, "getGovernanceActionTypesByName");
                response.setElements(this.addGovernanceActionTypeSpecification(userId, (OpenMetadataAPIGenericHandler<GovernanceActionTypeElement>)handler, supportedZones, governanceActionTypeElements));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionTypesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionTypesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypeResponse getGovernanceActionTypeByGUID(String serverName, String serviceURLMarker, String userId, String governanceActionTypeGUID) {
        String methodName = "getGovernanceActionTypeByGUID";
        String elementGUIDParameterName = "governanceActionTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionTypeByGUID");
        GovernanceActionTypeResponse response = new GovernanceActionTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionTypeByGUID");
            List supportedZones = instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceActionTypeByGUID");
            GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "getGovernanceActionTypeByGUID");
            GovernanceActionTypeElement element = (GovernanceActionTypeElement)handler.getGovernanceActionTypeByGUID(userId, governanceActionTypeGUID, supportedZones, null, "getGovernanceActionTypeByGUID");
            element.setSpecification(handler.getSpecification(userId, element.getElementHeader().getGUID(), "governanceActionTypeGUID", "GovernanceActionType", supportedZones));
            response.setElement(element);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGovernanceActionProcess(String serverName, String serviceURLMarker, String userId, NewGovernanceActionProcessRequestBody requestBody) {
        String methodName = "createGovernanceActionProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceActionProcess");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceActionProcess");
                AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "createGovernanceActionProcess");
                GovernanceActionProcessProperties processProperties = requestBody.getProperties();
                HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
                extendedProperties.put(OpenMetadataProperty.FORMULA.name, processProperties.getFormula());
                extendedProperties.put(OpenMetadataProperty.FORMULA_TYPE.name, processProperties.getFormulaType());
                extendedProperties.put("domainIdentifier", processProperties.getDomainIdentifier());
                Date effectiveTime = new Date();
                response.setGUID(handler.createAssetInRepository(userId, null, null, processProperties.getQualifiedName(), processProperties.getDisplayName(), processProperties.getVersionIdentifier(), processProperties.getDescription(), null, processProperties.getAdditionalProperties(), "GovernanceActionProcess", extendedProperties, this.getProcessStatus(requestBody.getProcessStatus()), null, null, effectiveTime, "createGovernanceActionProcess"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceActionProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private InstanceStatus getProcessStatus(ProcessStatus processStatus) {
        if (processStatus != null) {
            return switch (processStatus) {
                default -> throw new IncompatibleClassChangeError();
                case ProcessStatus.UNKNOWN -> InstanceStatus.UNKNOWN;
                case ProcessStatus.DRAFT -> InstanceStatus.DRAFT;
                case ProcessStatus.PROPOSED -> InstanceStatus.PROPOSED;
                case ProcessStatus.APPROVED -> InstanceStatus.APPROVED;
                case ProcessStatus.ACTIVE -> InstanceStatus.ACTIVE;
            };
        }
        return InstanceStatus.ACTIVE;
    }

    public VoidResponse updateGovernanceActionProcess(String serverName, String serviceURLMarker, String userId, String processGUID, UpdateGovernanceActionProcessRequestBody requestBody) {
        String methodName = "updateGovernanceActionProcess";
        String processGUIDParameterName = "processGUID";
        String newStatusParameterName = "requestBody.getProcessStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceActionProcess");
                AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "updateGovernanceActionProcess");
                GovernanceActionProcessProperties processProperties = requestBody.getProperties();
                HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
                extendedProperties.put(OpenMetadataProperty.FORMULA.name, processProperties.getFormula());
                extendedProperties.put(OpenMetadataProperty.FORMULA_TYPE.name, processProperties.getFormulaType());
                extendedProperties.put("domainIdentifier", processProperties.getDomainIdentifier());
                Date effectiveTime = new Date();
                handler.updateAsset(userId, null, null, processGUID, "processGUID", processProperties.getQualifiedName(), processProperties.getVersionIdentifier(), processProperties.getDisplayName(), processProperties.getDisplayName(), processProperties.getDescription(), null, processProperties.getAdditionalProperties(), "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateGovernanceActionProcess"), extendedProperties, null, null, requestBody.getMergeUpdate(), false, false, effectiveTime, "updateGovernanceActionProcess");
                if (requestBody.getProcessStatus() != null) {
                    handler.updateBeanStatusInRepository(userId, null, null, processGUID, "processGUID", "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateGovernanceActionProcess"), this.getProcessStatus(requestBody.getProcessStatus()), "requestBody.getProcessStatus", effectiveTime, "updateGovernanceActionProcess");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceActionProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishGovernanceActionProcess(String serverName, String serviceURLMarker, String userId, String processGUID, NullRequestBody requestBody) {
        String methodName = "publishGovernanceActionProcess";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishGovernanceActionProcess");
            AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "publishGovernanceActionProcess");
            handler.updateAssetZones(userId, processGUID, "processGUID", instanceHandler.getPublishZones(userId, serverName, serviceURLMarker, "publishGovernanceActionProcess"), true, false, false, new Date(), "publishGovernanceActionProcess");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "publishGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawGovernanceActionProcess(String serverName, String serviceURLMarker, String userId, String processGUID, NullRequestBody requestBody) {
        String methodName = "withdrawGovernanceActionProcess";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawGovernanceActionProcess");
            AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "withdrawGovernanceActionProcess");
            handler.updateAssetZones(userId, processGUID, "processGUID", instanceHandler.getDefaultZones(userId, serverName, serviceURLMarker, "withdrawGovernanceActionProcess"), true, false, false, new Date(), "withdrawGovernanceActionProcess");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "withdrawGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGovernanceActionProcess(String serverName, String serviceURLMarker, String userId, String processGUID, NullRequestBody requestBody) {
        String methodName = "removeGovernanceActionProcess";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGovernanceActionProcess");
            AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "removeGovernanceActionProcess");
            handler.deleteBeanInRepository(userId, null, null, processGUID, "processGUID", "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", null, null, false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "removeGovernanceActionProcess"), new Date(), "removeGovernanceActionProcess");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementsResponse findGovernanceActionProcesses(String serverName, String serviceURLMarker, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGovernanceActionProcesses";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGovernanceActionProcesses");
        GovernanceActionProcessElementsResponse response = new GovernanceActionProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActionProcesses");
                List supportedZones = instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "findGovernanceActionProcesses");
                AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "findGovernanceActionProcesses");
                List results = handler.findBeans(userId, requestBody.getSearchString(), "searchString", "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", false, false, supportedZones, null, startFrom, pageSize, new Date(), "findGovernanceActionProcesses");
                response.setElements(this.addGovernanceActionProcessSpecification(userId, (OpenMetadataAPIGenericHandler<GovernanceActionProcessElement>)handler, supportedZones, results));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGovernanceActionProcesses", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActionProcesses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<GovernanceActionProcessElement> addGovernanceActionProcessSpecification(String userId, OpenMetadataAPIGenericHandler<GovernanceActionProcessElement> handler, List<String> supportedZones, List<GovernanceActionProcessElement> elements) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (elements != null) {
            String elementGUIDParameterName = "governanceActionProcessGUID";
            ArrayList<GovernanceActionProcessElement> results = new ArrayList<GovernanceActionProcessElement>();
            for (GovernanceActionProcessElement element : elements) {
                if (element != null) {
                    element.setSpecification(handler.getSpecification(userId, element.getElementHeader().getGUID(), "governanceActionProcessGUID", "GovernanceActionProcess", supportedZones));
                    results.add(element);
                    continue;
                }
                results.add(null);
            }
            return results;
        }
        return null;
    }

    public GovernanceActionProcessElementsResponse getGovernanceActionProcessesByName(String serverName, String serviceURLMarker, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGovernanceActionProcessesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionProcessesByName");
        GovernanceActionProcessElementsResponse response = new GovernanceActionProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessesByName");
                List supportedZones = instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceActionProcessesByName");
                AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "getGovernanceActionProcessesByName");
                List results = handler.findAssetsByName(userId, "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", requestBody.getName(), "name", supportedZones, startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "getGovernanceActionProcessesByName");
                response.setElements(this.addGovernanceActionProcessSpecification(userId, (OpenMetadataAPIGenericHandler<GovernanceActionProcessElement>)handler, supportedZones, results));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionProcessesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementResponse getGovernanceActionProcessByGUID(String serverName, String serviceURLMarker, String userId, String processGUID) {
        String methodName = "getGovernanceActionProcessByGUID";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionProcessByGUID");
        GovernanceActionProcessElementResponse response = new GovernanceActionProcessElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessByGUID");
            List supportedZones = instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceActionProcessByGUID");
            AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "getGovernanceActionProcessByGUID");
            GovernanceActionProcessElement element = (GovernanceActionProcessElement)handler.getBeanFromRepository(userId, processGUID, "processGUID", "GovernanceActionProcess", false, false, supportedZones, new Date(), "getGovernanceActionProcessByGUID");
            element.setSpecification(handler.getSpecification(userId, element.getElementHeader().getGUID(), "processGUID", "GovernanceActionProcess", supportedZones));
            response.setElement(element);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessGraphResponse getGovernanceActionProcessGraph(String serverName, String serviceURLMarker, String userId, String processGUID, EffectiveTimeRequestBody requestBody) {
        String methodName = "getGovernanceActionProcessGraph";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGovernanceActionProcessGraph");
        GovernanceActionProcessGraphResponse response = new GovernanceActionProcessGraphResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessGraph");
            AssetHandler<GovernanceActionProcessElement> processHandler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "getGovernanceActionProcessGraph");
            GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "getGovernanceActionProcessGraph");
            GovernanceActionProcessGraph governanceActionProcessGraph = new GovernanceActionProcessGraph();
            if (requestBody != null) {
                governanceActionProcessGraph.setGovernanceActionProcess((GovernanceActionProcessElement)processHandler.getBeanFromRepository(userId, processGUID, "processGUID", "GovernanceActionProcess", false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceActionProcessGraph"), requestBody.getEffectiveTime(), "getGovernanceActionProcessGraph"));
            } else {
                governanceActionProcessGraph.setGovernanceActionProcess((GovernanceActionProcessElement)processHandler.getBeanFromRepository(userId, processGUID, "processGUID", "GovernanceActionProcess", false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceActionProcessGraph"), new Date(), "getGovernanceActionProcessGraph"));
            }
            governanceActionProcessGraph.setFirstProcessStep(this.getFirstProcessStepElement(serverName, serviceURLMarker, userId, processGUID, "getGovernanceActionProcessGraph"));
            if (governanceActionProcessGraph.getFirstProcessStep() != null) {
                String firstProcessStepGUID = governanceActionProcessGraph.getFirstProcessStep().getElement().getElementHeader().getGUID();
                ArrayList<String> processedGUIDs = new ArrayList<String>();
                processedGUIDs.add(firstProcessStepGUID);
                this.getNextProcessSteps(userId, handler, firstProcessStepGUID, governanceActionProcessGraph, processedGUIDs, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceActionProcessGraph"), this.invalidParameterHandler.getMaxPagingSize());
            }
            response.setElement(governanceActionProcessGraph);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessGraph", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private void getNextProcessSteps(String userId, GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler, String processStepGUID, GovernanceActionProcessGraph governanceActionProcessGraph, List<String> processedGUIDs, List<String> supportedZones, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getNextProcessSteps";
        RepositoryHandler repositoryHandler = handler.getRepositoryHandler();
        int startFrom = 0;
        List nextProcessStepRelationships = repositoryHandler.getRelationshipsByType(userId, processStepGUID, "GovernanceActionProcessStep", "d9567840-9904-43a5-990b-4585c0446e00", "NextGovernanceActionProcessStep", 2, false, false, startFrom, pageSize, null, "getNextProcessSteps");
        while (nextProcessStepRelationships != null) {
            for (Relationship relationship : nextProcessStepRelationships) {
                this.addProcessStep(userId, handler, relationship.getEntityOneProxy().getGUID(), governanceActionProcessGraph, processedGUIDs, supportedZones);
                NextGovernanceActionProcessStepLink processStepLink = new NextGovernanceActionProcessStepLink();
                processStepLink.setPreviousProcessStep(handler.getElementStub(relationship.getEntityOneProxy()));
                processStepLink.setNextProcessStep(handler.getElementStub(relationship.getEntityTwoProxy()));
                processStepLink.setNextProcessStepLinkGUID(relationship.getGUID());
                processStepLink.setGuard(handler.getRepositoryHelper().getStringProperty(handler.getServiceName(), "guard", relationship.getProperties(), "getNextProcessSteps"));
                processStepLink.setMandatoryGuard(handler.getRepositoryHelper().getBooleanProperty(handler.getServiceName(), "mandatoryGuard", relationship.getProperties(), "getNextProcessSteps"));
                ArrayList<NextGovernanceActionProcessStepLink> processStepLinks = governanceActionProcessGraph.getProcessStepLinks();
                if (processStepLinks == null) {
                    processStepLinks = new ArrayList<NextGovernanceActionProcessStepLink>();
                }
                processStepLinks.add(processStepLink);
                governanceActionProcessGraph.setProcessStepLinks(processStepLinks);
                if (processedGUIDs.contains(relationship.getEntityTwoProxy().getGUID())) continue;
                this.addProcessStep(userId, handler, relationship.getEntityTwoProxy().getGUID(), governanceActionProcessGraph, processedGUIDs, supportedZones);
                this.getNextProcessSteps(userId, handler, relationship.getEntityTwoProxy().getGUID(), governanceActionProcessGraph, processedGUIDs, supportedZones, pageSize);
            }
            nextProcessStepRelationships = repositoryHandler.getRelationshipsByType(userId, processStepGUID, "GovernanceActionProcessStep", "d9567840-9904-43a5-990b-4585c0446e00", "NextGovernanceActionProcessStep", 2, false, false, startFrom += pageSize, pageSize, null, "getNextProcessSteps");
        }
    }

    private void addProcessStep(String userId, GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler, String processStepGUID, GovernanceActionProcessGraph governanceActionProcessGraph, List<String> processedGUIDs, List<String> supportedZones) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addProcessStep";
        if (!processedGUIDs.contains(processStepGUID)) {
            GovernanceActionProcessStepElement processStepElement = (GovernanceActionProcessStepElement)handler.getGovernanceActionProcessStepByGUID(userId, processStepGUID, supportedZones, null, "addProcessStep");
            ArrayList<GovernanceActionProcessStepElement> processStepElements = governanceActionProcessGraph.getNextProcessSteps();
            if (processStepElements == null) {
                processStepElements = new ArrayList<GovernanceActionProcessStepElement>();
            }
            processStepElements.add(processStepElement);
            governanceActionProcessGraph.setNextProcessSteps(processStepElements);
            processedGUIDs.add(processStepGUID);
        }
    }

    public GUIDResponse createGovernanceActionProcessStep(String serverName, String serviceURLMarker, String userId, GovernanceActionProcessStepProperties requestBody) {
        String methodName = "createGovernanceActionProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceActionProcessStep");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceActionProcessStep");
                GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "createGovernanceActionProcessStep");
                response.setGUID(handler.createGovernanceActionProcessStep(userId, requestBody.getQualifiedName(), requestBody.getDomainIdentifier(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), requestBody.getGovernanceEngineGUID(), requestBody.getRequestType(), requestBody.getFixedRequestParameters(), requestBody.getIgnoreMultipleTriggers(), requestBody.getWaitTime(), null, null, false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createGovernanceActionProcessStep"), new Date(), "createGovernanceActionProcessStep"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceActionProcessStep", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceActionProcessStep(String serverName, String serviceURLMarker, String userId, String processStepGUID, UpdateGovernanceActionProcessStepRequestBody requestBody) {
        String methodName = "updateGovernanceActionProcessStep";
        String propertiesParameterName = "requestBody.getProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceActionProcessStep");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceActionProcessStep");
                GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "updateGovernanceActionProcessStep");
                GovernanceActionProcessStepProperties properties = requestBody.getProperties();
                this.invalidParameterHandler.validateObject((Object)properties, "requestBody.getProperties", "updateGovernanceActionProcessStep");
                handler.updateGovernanceActionProcessStep(userId, processStepGUID, requestBody.getMergeUpdate(), properties.getQualifiedName(), properties.getDomainIdentifier(), properties.getDisplayName(), properties.getDescription(), properties.getAdditionalProperties(), properties.getGovernanceEngineGUID(), properties.getRequestType(), properties.getFixedRequestParameters(), properties.getIgnoreMultipleTriggers(), properties.getWaitTime(), null, null, false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateGovernanceActionProcessStep"), new Date(), "updateGovernanceActionProcessStep");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceActionProcessStep", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGovernanceActionProcessStep(String serverName, String serviceURLMarker, String userId, String processStepGUID, NullRequestBody requestBody) {
        String methodName = "removeGovernanceActionProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGovernanceActionProcessStep");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGovernanceActionProcessStep");
            GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "removeGovernanceActionProcessStep");
            handler.removeGovernanceActionProcessStep(userId, processStepGUID, false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "removeGovernanceActionProcessStep"), new Date(), "removeGovernanceActionProcessStep");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGovernanceActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessStepsResponse findGovernanceActionProcessSteps(String serverName, String serviceURLMarker, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGovernanceActionProcessSteps";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGovernanceActionProcessSteps");
        GovernanceActionProcessStepsResponse response = new GovernanceActionProcessStepsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActionProcessSteps");
                List supportedZones = instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "findGovernanceActionProcessSteps");
                GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "findGovernanceActionProcessSteps");
                if (requestBody.getSearchStringParameterName() != null) {
                    searchStringParameterName = requestBody.getSearchStringParameterName();
                }
                List results = handler.findGovernanceActionProcessSteps(userId, requestBody.getSearchString(), searchStringParameterName, startFrom, pageSize, false, false, supportedZones, new Date(), "findGovernanceActionProcessSteps");
                response.setElements(this.addGovernanceActionProcessStepSpecification(userId, (OpenMetadataAPIGenericHandler<GovernanceActionProcessStepElement>)handler, supportedZones, results));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGovernanceActionProcessSteps", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActionProcessSteps", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<GovernanceActionProcessStepElement> addGovernanceActionProcessStepSpecification(String userId, OpenMetadataAPIGenericHandler<GovernanceActionProcessStepElement> handler, List<String> supportedZones, List<GovernanceActionProcessStepElement> elements) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (elements != null) {
            String elementGUIDParameterName = "governanceActionProcessStepGUID";
            ArrayList<GovernanceActionProcessStepElement> results = new ArrayList<GovernanceActionProcessStepElement>();
            for (GovernanceActionProcessStepElement element : elements) {
                if (element != null) {
                    element.setSpecification(handler.getSpecification(userId, element.getElementHeader().getGUID(), "governanceActionProcessStepGUID", "GovernanceActionProcessStep", supportedZones));
                    results.add(element);
                    continue;
                }
                results.add(null);
            }
            return results;
        }
        return null;
    }

    public GovernanceActionProcessStepsResponse getGovernanceActionProcessStepsByName(String serverName, String serviceURLMarker, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGovernanceActionProcessStepsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionProcessStepsByName");
        GovernanceActionProcessStepsResponse response = new GovernanceActionProcessStepsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessStepsByName");
                List supportedZones = instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceActionProcessStepsByName");
                GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "getGovernanceActionProcessStepsByName");
                if (requestBody.getNameParameterName() != null) {
                    nameParameterName = requestBody.getNameParameterName();
                }
                List results = handler.getGovernanceActionProcessStepsByName(userId, requestBody.getName(), nameParameterName, startFrom, pageSize, supportedZones, null, "getGovernanceActionProcessStepsByName");
                response.setElements(this.addGovernanceActionProcessStepSpecification(userId, (OpenMetadataAPIGenericHandler<GovernanceActionProcessStepElement>)handler, supportedZones, results));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionProcessStepsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessStepsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessStepResponse getGovernanceActionProcessStepByGUID(String serverName, String serviceURLMarker, String userId, String processStepGUID) {
        String methodName = "getGovernanceActionProcessStepByGUID";
        String elementGUIDParameterName = "processStepGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionProcessStepByGUID");
        GovernanceActionProcessStepResponse response = new GovernanceActionProcessStepResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessStepByGUID");
            List supportedZones = instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getGovernanceActionProcessStepByGUID");
            GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "getGovernanceActionProcessStepByGUID");
            GovernanceActionProcessStepElement element = (GovernanceActionProcessStepElement)handler.getGovernanceActionProcessStepByGUID(userId, processStepGUID, supportedZones, null, "getGovernanceActionProcessStepByGUID");
            element.setSpecification(handler.getSpecification(userId, element.getElementHeader().getGUID(), "processStepGUID", "GovernanceActionProcessStep", supportedZones));
            response.setElement(element);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessStepByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupFirstProcessStep(String serverName, String serviceURLMarker, String userId, String processGUID, String processStepGUID, String requestBody) {
        String methodName = "setupFirstActionProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupFirstActionProcessStep");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupFirstActionProcessStep");
            GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "setupFirstActionProcessStep");
            handler.setupFirstProcessStep(userId, processGUID, processStepGUID, requestBody, null, null, false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "setupFirstActionProcessStep"), new Date(), "setupFirstActionProcessStep");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupFirstActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FirstGovernanceActionProcessStepResponse getFirstProcessStep(String serverName, String serviceURLMarker, String userId, String processGUID) {
        String methodName = "getFirstActionProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFirstActionProcessStep");
        FirstGovernanceActionProcessStepResponse response = new FirstGovernanceActionProcessStepResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFirstActionProcessStep");
            response.setElement(this.getFirstProcessStepElement(serverName, serviceURLMarker, userId, processGUID, "getFirstActionProcessStep"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getFirstActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private FirstGovernanceActionProcessStepElement getFirstProcessStepElement(String serverName, String serviceURLMarker, String userId, String processGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, methodName);
        String processGUIDParameterName = "processGUID";
        Relationship firstActionProcessStepLink = handler.getUniqueAttachmentLink(userId, processGUID, "processGUID", "GovernanceActionProcess", "5f6ddee5-31ea-4d4f-9c3f-00ad2fcb2aa0", "GovernanceActionProcessFlow", null, "GovernanceActionProcessStep", 0, false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, methodName), null, methodName);
        if (firstActionProcessStepLink != null && firstActionProcessStepLink.getEntityTwoProxy() != null) {
            FirstGovernanceActionProcessStepElement firstProcessStep = new FirstGovernanceActionProcessStepElement();
            firstProcessStep.setLinkGUID(firstActionProcessStepLink.getGUID());
            firstProcessStep.setGuard(handler.getRepositoryHelper().getStringProperty(instanceHandler.getServiceName(serviceURLMarker), "guard", firstActionProcessStepLink.getProperties(), methodName));
            firstProcessStep.setElement((GovernanceActionProcessStepElement)handler.getGovernanceActionProcessStepByGUID(userId, firstActionProcessStepLink.getEntityTwoProxy().getGUID(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, methodName), null, methodName));
            return firstProcessStep;
        }
        return null;
    }

    public VoidResponse removeFirstProcessStep(String serverName, String serviceURLMarker, String userId, String processGUID, NullRequestBody requestBody) {
        String methodName = "removeFirstActionProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeFirstActionProcessStep");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeFirstActionProcessStep");
            GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "removeFirstActionProcessStep");
            handler.removeFirstProcessStep(userId, processGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "removeFirstActionProcessStep"), null, "removeFirstActionProcessStep");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeFirstActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse setupNextProcessStep(String serverName, String serviceURLMarker, String userId, String currentProcessStepGUID, String nextProcessStepGUID, NextGovernanceActionProcessStepRequestBody requestBody) {
        String methodName = "setupNextActionProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupNextActionProcessStep");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "setupNextActionProcessStep");
                GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "setupNextActionProcessStep");
                response.setGUID(handler.setupNextProcessStep(userId, currentProcessStepGUID, nextProcessStepGUID, requestBody.getGuard(), requestBody.getMandatoryGuard(), null, null, false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "setupNextActionProcessStep"), new Date(), "setupNextActionProcessStep"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupNextActionProcessStep", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupNextActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateNextProcessStep(String serverName, String serviceURLMarker, String userId, String nextProcessStepLinkGUID, NextGovernanceActionProcessStepRequestBody requestBody) {
        String methodName = "updateNextActionProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateNextActionProcessStep");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateNextActionProcessStep");
                GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "updateNextActionProcessStep");
                handler.updateNextProcessStep(userId, nextProcessStepLinkGUID, requestBody.getGuard(), requestBody.getMandatoryGuard(), null, null, "updateNextActionProcessStep");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateNextActionProcessStep", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateNextActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NextGovernanceActionProcessStepsResponse getNextProcessSteps(String serverName, String serviceURLMarker, String userId, String processStepGUID, int startFrom, int pageSize) {
        String methodName = "getNextGovernanceActionProcessSteps";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNextGovernanceActionProcessSteps");
        NextGovernanceActionProcessStepsResponse response = new NextGovernanceActionProcessStepsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNextGovernanceActionProcessSteps");
            GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "getNextGovernanceActionProcessSteps");
            List relationships = handler.getNextGovernanceActionProcessSteps(userId, processStepGUID, startFrom, pageSize, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getNextGovernanceActionProcessSteps"), new Date(), "getNextGovernanceActionProcessSteps");
            if (relationships != null) {
                OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "getNextGovernanceActionProcessSteps");
                ArrayList<NextGovernanceActionProcessStepElement> elements = new ArrayList<NextGovernanceActionProcessStepElement>();
                for (Relationship relationship : relationships) {
                    if (relationship == null) continue;
                    NextGovernanceActionProcessStepElement element = new NextGovernanceActionProcessStepElement();
                    element.setNextProcessStepLinkGUID(relationship.getGUID());
                    element.setGuard(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), "guard", relationship.getProperties(), "getNextGovernanceActionProcessSteps"));
                    element.setMandatoryGuard(repositoryHelper.getBooleanProperty(instanceHandler.getServiceName(), "mandatoryGuard", relationship.getProperties(), "getNextGovernanceActionProcessSteps"));
                    element.setNextProcessStep((GovernanceActionProcessStepElement)handler.getGovernanceActionProcessStepByGUID(userId, relationship.getEntityTwoProxy().getGUID(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getNextGovernanceActionProcessSteps"), null, "getNextGovernanceActionProcessSteps"));
                    elements.add(element);
                }
                response.setElements(elements);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNextGovernanceActionProcessSteps", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeNextProcessStep(String serverName, String serviceURLMarker, String userId, String actionLinkGUID, NullRequestBody requestBody) {
        String methodName = "removeNextProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeNextProcessStep");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeNextProcessStep");
            GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "removeNextProcessStep");
            handler.removeNextProcessStep(userId, actionLinkGUID, "removeNextProcessStep");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeNextProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EngineActionElementResponse getEngineAction(String serverName, String serviceURLMarker, String userId, String engineActionGUID) {
        String methodName = "getEngineAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEngineAction");
        AuditLog auditLog = null;
        EngineActionElementResponse response = new EngineActionElementResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEngineAction");
            EngineActionHandler<EngineActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "getEngineAction");
            response.setElement((EngineActionElement)handler.getEngineAction(userId, engineActionGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getEngineAction"), new Date(), "getEngineAction"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEngineAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EngineActionElementsResponse getEngineActions(String serverName, String serviceURLMarker, String userId, int startFrom, int pageSize) {
        String methodName = "getEngineActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEngineActions");
        AuditLog auditLog = null;
        EngineActionElementsResponse response = new EngineActionElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEngineActions");
            EngineActionHandler<EngineActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "getEngineActions");
            response.setElements(handler.getEngineActions(userId, startFrom, pageSize, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getEngineActions"), new Date(), "getEngineActions"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEngineActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EngineActionElementsResponse getActiveEngineActions(String serverName, String serviceURLMarker, String userId, int startFrom, int pageSize) {
        String methodName = "getActiveEngineActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveEngineActions");
        AuditLog auditLog = null;
        EngineActionElementsResponse response = new EngineActionElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActiveEngineActions");
            EngineActionHandler<EngineActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "getActiveEngineActions");
            response.setElements(handler.getActiveEngineActions(userId, startFrom, pageSize, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getActiveEngineActions"), new Date(), "getActiveEngineActions"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActiveEngineActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EngineActionElementsResponse getActiveClaimedEngineActions(String serverName, String serviceURLMarker, String userId, String governanceEngineGUID, int startFrom, int pageSize) {
        String methodName = "getActiveClaimedEngineActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveClaimedEngineActions");
        AuditLog auditLog = null;
        EngineActionElementsResponse response = new EngineActionElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActiveClaimedEngineActions");
            EngineActionHandler<EngineActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "getActiveClaimedEngineActions");
            response.setElements(handler.getActiveClaimedEngineActions(userId, governanceEngineGUID, startFrom, pageSize, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getActiveClaimedEngineActions"), new Date(), "getActiveClaimedEngineActions"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActiveClaimedEngineActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EngineActionElementsResponse findEngineActions(String serverName, String serviceURLMarker, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findEngineActions";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findEngineActions");
        EngineActionElementsResponse response = new EngineActionElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findEngineActions");
                EngineActionHandler<EngineActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "findEngineActions");
                if (requestBody.getSearchStringParameterName() != null) {
                    searchStringParameterName = requestBody.getSearchStringParameterName();
                }
                response.setElements(handler.findEngineActions(userId, requestBody.getSearchString(), searchStringParameterName, startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "findEngineActions"), new Date(), "findEngineActions"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findEngineActions", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findEngineActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EngineActionElementsResponse getEngineActionsByName(String serverName, String serviceURLMarker, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getEngineActionsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEngineActionsByName");
        EngineActionElementsResponse response = new EngineActionElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getEngineActionsByName");
                EngineActionHandler<EngineActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "getEngineActionsByName");
                if (requestBody.getNameParameterName() != null) {
                    nameParameterName = requestBody.getNameParameterName();
                }
                response.setElements(handler.getEngineActionsByName(userId, requestBody.getName(), nameParameterName, startFrom, pageSize, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getEngineActionsByName"), null, "getEngineActionsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getEngineActionsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEngineActionsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse claimEngineAction(String serverName, String serviceURLMarker, String userId, String engineActionGUID, NullRequestBody requestBody) {
        String methodName = "claimEngineAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "claimEngineAction");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "claimEngineAction");
            EngineActionHandler<EngineActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "claimEngineAction");
            handler.claimEngineAction(userId, engineActionGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "claimEngineAction"), new Date(), "claimEngineAction");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "claimEngineAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse cancelEngineAction(String serverName, String serviceURLMarker, String userId, String engineActionGUID, NullRequestBody requestBody) {
        String methodName = "cancelEngineAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "cancelEngineAction");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "cancelEngineAction");
            EngineActionHandler<EngineActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "cancelEngineAction");
            handler.cancelEngineAction(userId, engineActionGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "cancelEngineAction"), new Date(), "cancelEngineAction");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "cancelEngineAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateEngineActionStatus(String serverName, String serviceURLMarker, String userId, String engineActionGUID, EngineActionStatusRequestBody requestBody) {
        String methodName = "updateEngineActionStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateEngineActionStatus");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateEngineActionStatus");
            if (requestBody != null) {
                EngineActionHandler<EngineActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "updateEngineActionStatus");
                int statusOrdinal = EngineActionStatus.ACTIONED.getOrdinal();
                if (requestBody.getStatus() != null) {
                    statusOrdinal = requestBody.getStatus().getOrdinal();
                }
                handler.updateEngineActionStatus(userId, engineActionGUID, statusOrdinal, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateEngineActionStatus"), new Date(), "updateEngineActionStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateEngineActionStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateEngineActionStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkElementsAsDuplicates(String serverName, String serviceURLMarker, String userId, PeerDuplicatesRequestBody requestBody) {
        String methodName = "linkElementsAsDuplicates";
        String element1GUIDParameterName = "element1GUID";
        String element2GUIDParameterName = "element2GUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkElementsAsDuplicates");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkElementsAsDuplicates");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "linkElementsAsDuplicates");
            if (requestBody != null) {
                handler.linkElementsAsPeerDuplicates(userId, requestBody.getMetadataElement1GUID(), "element1GUID", requestBody.getMetadataElement2GUID(), "element2GUID", requestBody.getSetKnownDuplicate(), requestBody.getStatusIdentifier(), requestBody.getSteward(), requestBody.getStewardTypeName(), requestBody.getStewardPropertyName(), requestBody.getSource(), requestBody.getNotes(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "linkElementsAsDuplicates"), "linkElementsAsDuplicates");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkElementsAsDuplicates", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkElementsAsDuplicates", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkConsolidatedDuplicate(String serverName, String serviceURLMarker, String userId, ConsolidatedDuplicatesRequestBody requestBody) {
        String methodName = "linkConsolidatedDuplicate";
        String elementGUIDParameterName = "consolidatedElementGUID";
        String sourceElementGUIDsParameterName = "sourceElementGUIDs";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkConsolidatedDuplicate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkConsolidatedDuplicate");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "linkConsolidatedDuplicate");
            if (requestBody != null) {
                handler.linkConsolidatedDuplicate(userId, requestBody.getConsolidatedElementGUID(), "consolidatedElementGUID", requestBody.getStatusIdentifier(), requestBody.getSteward(), requestBody.getStewardTypeName(), requestBody.getStewardPropertyName(), requestBody.getSource(), requestBody.getNotes(), requestBody.getSourceElementGUIDs(), "sourceElementGUIDs", instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "linkConsolidatedDuplicate"), "linkConsolidatedDuplicate");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkConsolidatedDuplicate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkConsolidatedDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateActionTargetStatus(String serverName, String serviceURLMarker, String userId, ActionTargetStatusRequestBody requestBody) {
        String methodName = "updateActionTargetStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateActionTargetStatus");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateActionTargetStatus");
            if (requestBody != null) {
                EngineActionHandler<EngineActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "updateActionTargetStatus");
                int statusOrdinal = EngineActionStatus.ACTIONED.getOrdinal();
                if (requestBody.getStatus() != null) {
                    statusOrdinal = requestBody.getStatus().getOrdinal();
                }
                handler.updateActionTargetStatus(userId, requestBody.getActionTargetGUID(), statusOrdinal, requestBody.getStartDate(), requestBody.getCompletionDate(), requestBody.getCompletionMessage(), new Date(), "updateActionTargetStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateActionTargetStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateActionTargetStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse recordCompletionStatus(String serverName, String serviceURLMarker, String userId, String governanceActionGUID, CompletionStatusRequestBody requestBody) {
        String methodName = "recordCompletionStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "recordCompletionStatus");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "recordCompletionStatus");
            if (requestBody != null) {
                EngineActionHandler<EngineActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "recordCompletionStatus");
                int statusOrdinal = EngineActionStatus.ACTIONED.getOrdinal();
                if (requestBody.getStatus() != null) {
                    statusOrdinal = requestBody.getStatus().getOpenTypeOrdinal();
                }
                handler.recordCompletionStatus(userId, governanceActionGUID, statusOrdinal, requestBody.getRequestParameters(), requestBody.getOutputGuards(), requestBody.getNewActionTargets(), requestBody.getCompletionMessage(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "recordCompletionStatus"), new Date(), "recordCompletionStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "recordCompletionStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "recordCompletionStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse initiateEngineAction(String serverName, String serviceURLMarker, String userId, String governanceEngineName, InitiateEngineActionRequestBody requestBody) {
        String methodName = "initiateEngineAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "initiateEngineAction");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "initiateEngineAction");
            if (requestBody != null) {
                String engineActionGUID;
                EngineActionHandler<EngineActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "initiateEngineAction");
                Date startTime = requestBody.getStartDate();
                if (startTime == null) {
                    startTime = new Date();
                }
                if ((engineActionGUID = handler.createEngineAction(userId, requestBody.getQualifiedName(), requestBody.getDomainIdentifier(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getRequestSourceGUIDs(), requestBody.getActionTargets(), null, requestBody.getReceivedGuards(), startTime, governanceEngineName, userId, requestBody.getRequestType(), requestBody.getRequestParameters(), null, null, null, requestBody.getProcessName(), null, null, requestBody.getRequestSourceName(), requestBody.getOriginatorServiceName(), requestBody.getOriginatorEngineName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "initiateEngineAction"), "initiateEngineAction")) != null) {
                    handler.approveEngineAction(userId, engineActionGUID, requestBody.getQualifiedName(), null, requestBody.getReceivedGuards(), requestBody.getStartDate(), governanceEngineName, requestBody.getRequestType(), requestBody.getRequestParameters(), null, requestBody.getProcessName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "initiateEngineAction"), "initiateEngineAction");
                    response.setGUID(engineActionGUID);
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "initiateEngineAction", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "initiateEngineAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse initiateGovernanceActionType(String serverName, String serviceURLMarker, String userId, InitiateGovernanceActionTypeRequestBody requestBody) {
        String methodName = "initiateGovernanceActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "initiateGovernanceActionType");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "initiateGovernanceActionType");
            if (requestBody != null) {
                EngineActionHandler<EngineActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "initiateGovernanceActionType");
                response.setGUID(handler.initiateGovernanceActionType(userId, requestBody.getGovernanceActionTypeQualifiedName(), requestBody.getRequestSourceGUIDs(), requestBody.getActionTargets(), requestBody.getRequestParameters(), requestBody.getStartDate(), requestBody.getOriginatorServiceName(), requestBody.getOriginatorEngineName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "initiateGovernanceActionType"), "initiateGovernanceActionType"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "initiateGovernanceActionType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "initiateGovernanceActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse initiateGovernanceActionProcess(String serverName, String serviceURLMarker, String userId, InitiateGovernanceActionProcessRequestBody requestBody) {
        String methodName = "initiateGovernanceActionProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "initiateGovernanceActionProcess");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "initiateGovernanceActionProcess");
            if (requestBody != null) {
                EngineActionHandler<EngineActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "initiateGovernanceActionProcess");
                response.setGUID(handler.initiateGovernanceActionProcess(userId, requestBody.getProcessQualifiedName(), requestBody.getRequestSourceGUIDs(), requestBody.getActionTargets(), requestBody.getRequestParameters(), requestBody.getStartDate(), requestBody.getOriginatorServiceName(), requestBody.getOriginatorEngineName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "initiateGovernanceActionProcess"), "initiateGovernanceActionProcess"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "initiateGovernanceActionProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "initiateGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

