/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DeleteMethod;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CatalogTargetConverter<B>
extends OMFConverter<B> {
    public CatalogTargetConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean;
            if (relationship != null && (returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) instanceof CatalogTarget) {
                CatalogTarget bean = (CatalogTarget)returnBean;
                bean.setRelationshipGUID(relationship.getGUID());
                bean.setRelationshipVersions(super.getElementVersions((InstanceAuditHeader)relationship));
                bean.setCatalogTargetName(this.repositoryHelper.getStringProperty(this.serviceName, "catalogTargetName", relationship.getProperties(), methodName));
                bean.setMetadataSourceQualifiedName(this.repositoryHelper.getStringProperty(this.serviceName, "metadataSourceQualifiedName", relationship.getProperties(), methodName));
                bean.setConnectionName(this.repositoryHelper.getStringProperty(this.serviceName, "connectionName", relationship.getProperties(), methodName));
                bean.setTemplateProperties(this.repositoryHelper.getStringMapFromProperty(this.serviceName, "templates", relationship.getProperties(), methodName));
                bean.setConfigurationProperties(this.repositoryHelper.getMapFromProperty(this.serviceName, OpenMetadataProperty.CONFIGURATION_PROPERTIES.name, relationship.getProperties(), methodName));
                bean.setPermittedSynchronization(this.getPermittedSynchronization(relationship.getProperties()));
                bean.setDeleteMethod(this.getDeleteMethod(relationship.getProperties()));
                bean.setCatalogTargetElement(super.getElementStub(beanClass, relationship.getEntityTwoProxy(), methodName));
                return returnBean;
            }
            return null;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public List<B> getNewBeans(Class<B> beanClass, List<Relationship> relationships, String methodName) throws PropertyServerException {
        if (relationships != null) {
            ArrayList<B> beans = new ArrayList<B>();
            for (Relationship relationship : relationships) {
                B bean;
                if (relationship == null || (bean = this.getNewBean(beanClass, relationship, methodName)) == null) continue;
                beans.add(bean);
            }
            if (!beans.isEmpty()) {
                return beans;
            }
        }
        return null;
    }

    PermittedSynchronization getPermittedSynchronization(InstanceProperties instanceProperties) {
        String methodName = "getPermittedSynchronization";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.name, instanceProperties, "getPermittedSynchronization");
            for (PermittedSynchronization permittedSynchronization : PermittedSynchronization.values()) {
                if (permittedSynchronization.getOrdinal() != ordinal) continue;
                return permittedSynchronization;
            }
        }
        return PermittedSynchronization.BOTH_DIRECTIONS;
    }

    DeleteMethod getDeleteMethod(InstanceProperties instanceProperties) {
        String methodName = "getDeleteMethod";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.DELETE_METHOD.name, instanceProperties, "getDeleteMethod");
            for (DeleteMethod deleteMethod : DeleteMethod.values()) {
                if (deleteMethod.getOrdinal() != ordinal) continue;
                return deleteMethod;
            }
        }
        return DeleteMethod.ARCHIVE;
    }
}

