/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.EngineActionElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedEngineActionElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworkservices.gaf.converters.OpenMetadataStoreConverter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class EngineActionConverter<B>
extends OpenMetadataStoreConverter<B> {
    public EngineActionConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof EngineActionElement) {
                EngineActionElement bean = (EngineActionElement)returnBean;
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                    bean.setRequestedTime(primaryEntity.getCreateTime());
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    bean.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    bean.setDomainIdentifier(this.removeDomainIdentifier(instanceProperties));
                    bean.setDisplayName(this.removeDisplayName(instanceProperties));
                    bean.setDescription(this.removeDescription(instanceProperties));
                    bean.setRequesterUserId(this.removeRequesterUserId(instanceProperties));
                    bean.setRequestType(this.removeRequestType(instanceProperties));
                    bean.setRequestParameters(this.removeRequestParameters(instanceProperties));
                    bean.setGovernanceEngineGUID(this.removeExecutorEngineGUID(instanceProperties));
                    bean.setGovernanceEngineName(this.removeExecutorEngineName(instanceProperties));
                    bean.setProcessName(this.removeProcessName(instanceProperties));
                    bean.setProcessStepGUID(this.removeProcessStepGUID(instanceProperties));
                    bean.setProcessStepName(this.removeProcessStepName(instanceProperties));
                    bean.setGovernanceActionTypeGUID(this.removeGovernanceActionTypeGUID(instanceProperties));
                    bean.setGovernanceActionTypeName(this.removeGovernanceActionTypeName(instanceProperties));
                    bean.setMandatoryGuards(this.removeMandatoryGuards(instanceProperties));
                    bean.setReceivedGuards(this.removeReceivedGuards(instanceProperties));
                    bean.setActionStatus(this.removeActionStatus(OpenMetadataProperty.ACTION_STATUS.name, instanceProperties));
                    bean.setRequestedStartTime(this.removeRequestedStartDate(instanceProperties));
                    bean.setStartTime(this.removeStartDate(instanceProperties));
                    bean.setProcessingEngineUserId(this.removeProcessingEngineUserId(instanceProperties));
                    bean.setCompletionTime(this.removeCompletionDate(instanceProperties));
                    bean.setCompletionGuards(this.removeCompletionGuards(instanceProperties));
                    bean.setCompletionMessage(this.removeCompletionMessage(instanceProperties));
                    bean.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    if (relationships != null) {
                        ArrayList<RequestSourceElement> requestSourceElements = new ArrayList<RequestSourceElement>();
                        ArrayList<ActionTargetElement> actionTargetElements = new ArrayList<ActionTargetElement>();
                        ArrayList<RelatedEngineActionElement> previousActions = new ArrayList<RelatedEngineActionElement>();
                        ArrayList<RelatedEngineActionElement> followOnActions = new ArrayList<RelatedEngineActionElement>();
                        for (Relationship relationship : relationships) {
                            if (relationship == null || relationship.getType() == null) continue;
                            String actualTypeName = relationship.getType().getTypeDefName();
                            instanceProperties = new InstanceProperties(relationship.getProperties());
                            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.ENGINE_ACTION_EXECUTOR.typeName)) {
                                if (bean.getRequestType() == null) {
                                    bean.setRequestType(this.removeRequestType(instanceProperties));
                                    bean.setRequestParameters(this.removeRequestParameters(instanceProperties));
                                }
                                if (bean.getGovernanceEngineGUID() != null) continue;
                                EntityProxy entityProxy = relationship.getEntityTwoProxy();
                                bean.setGovernanceEngineGUID(entityProxy.getGUID());
                                if (entityProxy.getUniqueProperties() == null) continue;
                                bean.setGovernanceEngineName(this.getQualifiedName(entityProxy.getUniqueProperties()));
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.TARGET_FOR_ACTION.typeName)) {
                                ActionTargetElement actionTargetElement = new ActionTargetElement();
                                actionTargetElement.setActionTargetRelationshipGUID(relationship.getGUID());
                                actionTargetElement.setActionTargetName(this.removeActionTargetName(instanceProperties));
                                actionTargetElement.setStatus(this.removeActionStatus(OpenMetadataProperty.ACTION_STATUS.name, instanceProperties));
                                actionTargetElement.setStartDate(this.removeStartDate(instanceProperties));
                                actionTargetElement.setCompletionDate(this.removeCompletionDate(instanceProperties));
                                actionTargetElement.setCompletionMessage(this.removeCompletionMessage(instanceProperties));
                                String actionTargetGUID = relationship.getEntityTwoProxy().getGUID();
                                if (actionTargetGUID != null) {
                                    actionTargetElement.setActionTargetGUID(actionTargetGUID);
                                    actionTargetElement.setTargetElement(this.getOpenMetadataElement(actionTargetGUID, supplementaryEntities));
                                }
                                actionTargetElements.add(actionTargetElement);
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.ENGINE_ACTION_REQUEST_SOURCE.typeName)) {
                                String requestSourceGUID = relationship.getEntityOneProxy().getGUID();
                                if (requestSourceGUID == null) continue;
                                RequestSourceElement requestSourceElement = new RequestSourceElement();
                                requestSourceElement.setRequestSourceElement(this.getOpenMetadataElement(requestSourceGUID, supplementaryEntities));
                                instanceProperties = new InstanceProperties(relationship.getProperties());
                                requestSourceElement.setRequestSourceName(this.removeRequestSourceName(instanceProperties));
                                requestSourceElement.setOriginGovernanceService(this.removeOriginGovernanceService(instanceProperties));
                                requestSourceElement.setOriginGovernanceEngine(this.removeOriginGovernanceEngine(instanceProperties));
                                requestSourceElements.add(requestSourceElement);
                                continue;
                            }
                            if (!this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.NEXT_ENGINE_ACTION.typeName)) continue;
                            RelatedEngineActionElement relatedAction = new RelatedEngineActionElement();
                            relatedAction.setGuard(this.removeGuard(relationship.getProperties()));
                            relatedAction.setMandatoryGuard(this.removeMandatoryGuard(relationship.getProperties()));
                            relatedAction.setRelatedActionLinkGUID(relationship.getGUID());
                            if (primaryEntity.getGUID().equals(relationship.getEntityTwoProxy().getGUID())) {
                                relatedAction.setRelatedAction(this.getElementStub(beanClass, relationship.getEntityOneProxy(), methodName));
                                previousActions.add(relatedAction);
                                continue;
                            }
                            relatedAction.setRelatedAction(this.getElementStub(beanClass, relationship.getEntityTwoProxy(), methodName));
                            followOnActions.add(relatedAction);
                        }
                        if (!requestSourceElements.isEmpty()) {
                            bean.setRequestSourceElements(requestSourceElements);
                        }
                        if (!actionTargetElements.isEmpty()) {
                            bean.setActionTargetElements(actionTargetElements);
                        }
                        if (!previousActions.isEmpty()) {
                            bean.setPreviousActions(previousActions);
                        }
                        if (!followOnActions.isEmpty()) {
                            bean.setFollowOnActions(followOnActions);
                        }
                    }
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            } else {
                this.handleUnexpectedBeanClass(beanClass.getName(), EngineActionElement.class.getName(), methodName);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

