/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.FilesAndFoldersHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ArrayTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.ClassificationCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.EnumTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.MapTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.StructTypePropertyValue;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ArchiveProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworkservices.gaf.converters.RelatedElementConverter;
import org.odpi.openmetadata.frameworkservices.gaf.converters.RelatedElementsConverter;
import org.odpi.openmetadata.frameworkservices.gaf.handlers.MetadataElementBuilder;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataElementHandler<B>
extends ReferenceableHandler<B> {
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private final RelatedElementsConverter<OpenMetadataRelationship> openMetadataRelationshipsConverter;
    private final RelatedElementConverter<RelatedMetadataElement> relatedElementConverter;
    private final FilesAndFoldersHandler<Object, Object, Object> filesAndFoldersHandler;
    private static final Logger log = LoggerFactory.getLogger(MetadataElementHandler.class);

    public MetadataElementHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.openMetadataRelationshipsConverter = new RelatedElementsConverter(repositoryHelper, serviceName, serverName);
        this.relatedElementConverter = new RelatedElementConverter(repositoryHelper, serviceName, serverName);
        this.filesAndFoldersHandler = new FilesAndFoldersHandler(null, Object.class, null, Object.class, null, Object.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public B getMetadataElementByGUID(String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date asOfTime, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", methodName);
        return (B)this.getBeanFromRepository(userId, elementGUID, "elementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, asOfTime, effectiveTime, methodName);
    }

    public B getMetadataElementByUniqueName(String userId, String uniqueName, String uniqueNameParameterName, String uniqueNamePropertyName, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "uniqueName";
        String namePropertyName = "uniqueNamePropertyName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(uniqueNamePropertyName, "uniqueNamePropertyName", methodName);
        if (uniqueNameParameterName != null) {
            this.invalidParameterHandler.validateName(uniqueName, uniqueNameParameterName, methodName);
            return (B)this.getBeanByUniqueName(userId, uniqueName, uniqueNameParameterName, uniqueNamePropertyName, OpenMetadataType.OPEN_METADATA_ROOT.typeGUID, OpenMetadataType.OPEN_METADATA_ROOT.typeName, this.getInstanceStatuses(limitResultsByStatus), asOfTime, this.getSequencingOrder(sequencingOrder), sequencingPropertyName, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        }
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", methodName);
        return (B)this.getBeanByUniqueName(userId, uniqueName, "uniqueName", uniqueNamePropertyName, OpenMetadataType.OPEN_METADATA_ROOT.typeGUID, OpenMetadataType.OPEN_METADATA_ROOT.typeName, this.getInstanceStatuses(limitResultsByStatus), asOfTime, this.getSequencingOrder(sequencingOrder), sequencingPropertyName, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public String getMetadataElementGUIDByUniqueName(String userId, String uniqueName, String uniqueNameParameterName, String uniqueNamePropertyName, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "uniqueName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        if (uniqueNameParameterName != null) {
            this.invalidParameterHandler.validateName(uniqueName, uniqueNameParameterName, methodName);
        } else {
            this.invalidParameterHandler.validateName(uniqueName, "uniqueName", methodName);
        }
        return this.getBeanGUIDByUniqueName(userId, uniqueName, uniqueNameParameterName, uniqueNamePropertyName, OpenMetadataType.OPEN_METADATA_ROOT.typeGUID, OpenMetadataType.OPEN_METADATA_ROOT.typeName, this.getInstanceStatuses(limitResultsByStatus), asOfTime, this.getSequencingOrder(sequencingOrder), sequencingPropertyName, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public List<B> findMetadataElementsWithString(String userId, String searchString, String typeName, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        if (typeName == null) {
            this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        } else if (searchString == null) {
            searchString = ".*";
        }
        String searchTypeName = OpenMetadataType.OPEN_METADATA_ROOT.typeName;
        if (typeName != null) {
            searchTypeName = typeName;
        }
        String searchTypeGUID = this.invalidParameterHandler.validateTypeName(searchTypeName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, this.serviceName, methodName, this.repositoryHelper);
        return this.findBeans(userId, searchString, "searchString", searchTypeGUID, searchTypeName, this.getInstanceStatuses(limitResultsByStatus), asOfTime, this.getSequencingOrder(sequencingOrder), sequencingProperty, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getMetadataElementsByType(String userId, String typeName, boolean forLineage, boolean forDuplicateProcessing, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, List<String> serviceSupportedZones, Date effectiveTime, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeParameterName = "typeName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(typeName, "typeName", methodName);
        String entityTypeGUID = this.invalidParameterHandler.validateTypeName(typeName, null, this.serviceName, methodName, this.repositoryHelper);
        List entities = this.repositoryHandler.getEntitiesByType(userId, entityTypeGUID, this.getInstanceStatuses(limitResultsByStatus), asOfTime, sequencingProperty, this.getSequencingOrder(sequencingOrder), forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
        return super.getValidatedBeans(userId, effectiveTime, forLineage, forDuplicateProcessing, serviceSupportedZones, methodName, entities);
    }

    public List<RelatedMetadataElement> getRelatedMetadataElements(String userId, String elementGUID, int startingAtEnd, String relationshipTypeName, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", methodName);
        String relationshipTypeGUID = null;
        if (relationshipTypeName != null) {
            relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        }
        int selectionEnd = 0;
        if (startingAtEnd == 1) {
            selectionEnd = 2;
        } else if (startingAtEnd == 2) {
            selectionEnd = 1;
        }
        EntityDetail startingEntity = this.getEntityFromRepository(userId, elementGUID, "elementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, startingEntity, startingEntity.getType().getTypeDefName(), relationshipTypeGUID, relationshipTypeName, selectionEnd, this.getInstanceStatuses(limitResultsByStatus), asOfTime, this.getSequencingOrder(sequencingOrder), sequencingProperty, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
        if (relationships == null) {
            return null;
        }
        Map retrievedEntities = this.getValidatedEntities(userId, startingEntity.getGUID(), startingEntity.getType().getTypeDefName(), relationships, OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, null, selectionEnd, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        ArrayList<RelatedMetadataElement> results = new ArrayList<RelatedMetadataElement>();
        if (retrievedEntities != null) {
            retrievedEntities.put(startingEntity.getGUID(), startingEntity);
            for (Relationship relationship : relationships) {
                EntityDetail retrievedEntity;
                EntityProxy otherEnd;
                if (!this.visibleToUserThroughRelationship(userId, relationship, methodName) || (otherEnd = this.repositoryHandler.getOtherEnd(startingEntity.getGUID(), relationship)) == null || (retrievedEntity = (EntityDetail)retrievedEntities.get(otherEnd.getGUID())) == null) continue;
                results.add(this.relatedElementConverter.getNewBean(RelatedMetadataElement.class, retrievedEntity, relationship, methodName));
            }
        }
        return results;
    }

    public List<OpenMetadataRelationship> getMetadataElementRelationships(String userId, String metadataElementAtEnd1GUID, String relationshipTypeName, String metadataElementAtEnd2GUID, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List relationships;
        String end1ParameterName = "metadataElementAtEnd1GUID";
        String relationshipTypeGUID = null;
        if (relationshipTypeName != null) {
            relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        }
        if ((relationships = super.getAttachmentLinks(userId, metadataElementAtEnd1GUID, "metadataElementAtEnd1GUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, relationshipTypeGUID, relationshipTypeName, metadataElementAtEnd2GUID, OpenMetadataType.OPEN_METADATA_ROOT.typeName, 0, this.getInstanceStatuses(limitResultsByStatus), asOfTime, this.getSequencingOrder(sequencingOrder), sequencingProperty, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName)) != null) {
            ArrayList<OpenMetadataRelationship> results = new ArrayList<OpenMetadataRelationship>();
            for (Relationship relationship : relationships) {
                results.add(this.openMetadataRelationshipsConverter.getNewRelationshipBean(OpenMetadataRelationship.class, relationship, methodName));
            }
            return results;
        }
        return null;
    }

    public List<B> findMetadataElements(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeName, org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, SearchClassifications searchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return super.findBeans(userId, metadataElementTypeName, metadataElementSubtypeName, this.getSearchProperties(searchProperties), this.getInstanceStatuses(limitResultsByStatus), this.getSearchClassifications(searchClassifications), asOfTime, sequencingProperty, this.getSequencingOrder(sequencingOrder), forLineage, forDuplicateProcessing, startingFrom, pageSize, serviceSupportedZones, effectiveTime, methodName);
    }

    private SearchProperties getSearchProperties(org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties gafSearchProperties) throws InvalidParameterException {
        if (gafSearchProperties != null) {
            SearchProperties omrsSearchProperties = new SearchProperties();
            omrsSearchProperties.setConditions(this.getPropertyConditions(gafSearchProperties.getConditions()));
            omrsSearchProperties.setMatchCriteria(this.getMatchCriteria(gafSearchProperties.getMatchCriteria()));
            return omrsSearchProperties;
        }
        return null;
    }

    private org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications getSearchClassifications(SearchClassifications gafSearchClassifications) throws InvalidParameterException {
        if (gafSearchClassifications != null) {
            org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications omrsSearchClassifications = new org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications();
            if (gafSearchClassifications.getConditions() != null && !gafSearchClassifications.getConditions().isEmpty()) {
                ArrayList<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition> omrsClassificationConditions = new ArrayList<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition>();
                for (ClassificationCondition gafClassificationCondition : gafSearchClassifications.getConditions()) {
                    org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition omrsClassificationCondition = new org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition();
                    omrsClassificationCondition.setName(gafClassificationCondition.getName());
                    omrsClassificationCondition.setMatchProperties(this.getSearchProperties(gafClassificationCondition.getSearchProperties()));
                    omrsClassificationConditions.add(omrsClassificationCondition);
                }
                if (!omrsClassificationConditions.isEmpty()) {
                    omrsSearchClassifications.setConditions(omrsClassificationConditions);
                }
            }
            omrsSearchClassifications.setMatchCriteria(this.getMatchCriteria(gafSearchClassifications.getMatchCriteria()));
            return omrsSearchClassifications;
        }
        return null;
    }

    private List<PropertyCondition> getPropertyConditions(List<org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition> gafPropertyConditions) throws InvalidParameterException {
        if (gafPropertyConditions != null && !gafPropertyConditions.isEmpty()) {
            ArrayList<PropertyCondition> omrsPropertyConditions = new ArrayList<PropertyCondition>();
            for (org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition propertyCondition : gafPropertyConditions) {
                if (propertyCondition == null) continue;
                PropertyCondition omrsPropertyCondition = new PropertyCondition();
                omrsPropertyCondition.setProperty(propertyCondition.getProperty());
                omrsPropertyCondition.setOperator(this.getPropertyComparisonOperator(propertyCondition.getOperator()));
                omrsPropertyCondition.setValue(this.getInstancePropertyValue(propertyCondition.getValue()));
                omrsPropertyCondition.setNestedConditions(this.getSearchProperties(propertyCondition.getNestedConditions()));
                omrsPropertyConditions.add(omrsPropertyCondition);
            }
            return omrsPropertyConditions;
        }
        return null;
    }

    private InstancePropertyValue getInstancePropertyValue(PropertyValue propertyValue) throws InvalidParameterException {
        if (propertyValue != null) {
            String methodName = "getInstancePropertyValue";
            String typeParameterName = "propertyValue.getTypeName()";
            AttributeTypeDef typeDef = this.repositoryHelper.getAttributeTypeDefByName(this.serviceName, propertyValue.getTypeName());
            this.invalidParameterHandler.validateObject((Object)typeDef, "propertyValue.getTypeName()", "getInstancePropertyValue");
            if (propertyValue instanceof ArrayTypePropertyValue) {
                ArrayTypePropertyValue gafPropertyValue = (ArrayTypePropertyValue)propertyValue;
                return this.getArrayPropertyValue(typeDef, gafPropertyValue.getArrayCount(), this.propertyHelper.getElementPropertiesAsMap(gafPropertyValue.getArrayValues()));
            }
            if (propertyValue instanceof EnumTypePropertyValue) {
                EnumTypePropertyValue gafPropertyValue = (EnumTypePropertyValue)propertyValue;
                return this.getEnumPropertyValue(typeDef, gafPropertyValue.getSymbolicName());
            }
            if (propertyValue instanceof MapTypePropertyValue) {
                MapTypePropertyValue gafPropertyValue = (MapTypePropertyValue)propertyValue;
                return this.getMapPropertyValue(typeDef, this.propertyHelper.getElementPropertiesAsMap(gafPropertyValue.getMapValues()));
            }
            if (propertyValue instanceof PrimitiveTypePropertyValue) {
                PrimitiveTypePropertyValue gafPropertyValue = (PrimitiveTypePropertyValue)propertyValue;
                return this.getPrimitivePropertyValue(typeDef, gafPropertyValue.getPrimitiveTypeCategory(), gafPropertyValue.getPrimitiveValue());
            }
            if (propertyValue instanceof StructTypePropertyValue) {
                StructTypePropertyValue gafPropertyValue = (StructTypePropertyValue)propertyValue;
                return this.getStructPropertyValue(typeDef, this.propertyHelper.getElementPropertiesAsMap(gafPropertyValue.getAttributes()));
            }
        }
        return null;
    }

    private ArrayPropertyValue getArrayPropertyValue(AttributeTypeDef typeDef, int arrayCount, Map<String, Object> arrayValues) throws InvalidParameterException {
        String methodName = "getArrayPropertyValue";
        ArrayPropertyValue omrsPropertyValue = new ArrayPropertyValue();
        omrsPropertyValue.setHeaderVersion(1L);
        omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.ARRAY);
        omrsPropertyValue.setTypeGUID(typeDef.getGUID());
        omrsPropertyValue.setTypeName(typeDef.getName());
        omrsPropertyValue.setArrayCount(arrayCount);
        try {
            omrsPropertyValue.setArrayValues(this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, arrayValues, "getArrayPropertyValue"));
        }
        catch (OCFCheckedExceptionBase error) {
            String parameterName = "searchProperties";
            throw new InvalidParameterException(error, "searchProperties");
        }
        return omrsPropertyValue;
    }

    private EnumPropertyValue getEnumPropertyValue(AttributeTypeDef typeDef, String symbolicName) throws InvalidParameterException {
        EnumDef enumDef;
        List enumElementDefs;
        String methodName = "getEnumPropertyValue";
        String symbolicNameParameterName = "symbolicName";
        String propertyParameterName = "omrsPropertyValue";
        this.invalidParameterHandler.validateName(symbolicName, "symbolicName", "getEnumPropertyValue");
        EnumPropertyValue omrsPropertyValue = null;
        if (typeDef instanceof EnumDef && (enumElementDefs = (enumDef = (EnumDef)typeDef).getElementDefs()) != null && !enumElementDefs.isEmpty()) {
            for (EnumElementDef enumElementDef : enumElementDefs) {
                if (enumElementDef == null || enumElementDef.getValue() == null || !symbolicName.equalsIgnoreCase(enumElementDef.getValue())) continue;
                omrsPropertyValue = new EnumPropertyValue();
                omrsPropertyValue.setHeaderVersion(1L);
                omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.ENUM);
                omrsPropertyValue.setTypeGUID(typeDef.getGUID());
                omrsPropertyValue.setTypeName(typeDef.getName());
                omrsPropertyValue.setSymbolicName(enumElementDef.getValue());
                omrsPropertyValue.setOrdinal(enumElementDef.getOrdinal());
                omrsPropertyValue.setDescription(enumElementDef.getDescription());
            }
        }
        this.invalidParameterHandler.validateObject(omrsPropertyValue, "omrsPropertyValue", "getEnumPropertyValue");
        return omrsPropertyValue;
    }

    private MapPropertyValue getMapPropertyValue(AttributeTypeDef typeDef, Map<String, Object> mapValues) throws InvalidParameterException {
        String methodName = "getMapPropertyValue";
        MapPropertyValue omrsPropertyValue = new MapPropertyValue();
        omrsPropertyValue.setHeaderVersion(1L);
        omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.MAP);
        omrsPropertyValue.setTypeGUID(typeDef.getGUID());
        omrsPropertyValue.setTypeName(typeDef.getName());
        try {
            omrsPropertyValue.setMapValues(this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, mapValues, "getMapPropertyValue"));
        }
        catch (OCFCheckedExceptionBase error) {
            String parameterName = "searchProperties";
            throw new InvalidParameterException(error, "searchProperties");
        }
        return omrsPropertyValue;
    }

    private PrimitivePropertyValue getPrimitivePropertyValue(AttributeTypeDef typeDef, PrimitiveTypeCategory primitiveTypeCategory, Object primitiveValue) throws InvalidParameterException {
        String methodName = "getPrimitivePropertyValue";
        String valueParameterName = "primitiveValue";
        String categoryParameterName = "primitiveTypeCategory";
        this.invalidParameterHandler.validateObject((Object)primitiveTypeCategory, "primitiveTypeCategory", "getPrimitivePropertyValue");
        this.invalidParameterHandler.validateObject(primitiveValue, "primitiveValue", "getPrimitivePropertyValue");
        PrimitivePropertyValue omrsPropertyValue = new PrimitivePropertyValue();
        omrsPropertyValue.setHeaderVersion(1L);
        omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.PRIMITIVE);
        omrsPropertyValue.setTypeGUID(typeDef.getGUID());
        omrsPropertyValue.setTypeName(typeDef.getName());
        omrsPropertyValue.setPrimitiveDefCategory(this.getPrimitiveDefCategory(primitiveTypeCategory));
        omrsPropertyValue.setPrimitiveValue(primitiveValue);
        return omrsPropertyValue;
    }

    private PrimitiveDefCategory getPrimitiveDefCategory(PrimitiveTypeCategory gafPrimitiveTypeCategory) {
        if (gafPrimitiveTypeCategory != null) {
            return switch (gafPrimitiveTypeCategory) {
                default -> throw new IncompatibleClassChangeError();
                case PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_UNKNOWN -> PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                case PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BOOLEAN -> PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN;
                case PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BYTE -> PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE;
                case PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_CHAR -> PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR;
                case PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_SHORT -> PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT;
                case PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT -> PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT;
                case PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_LONG -> PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG;
                case PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_FLOAT -> PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT;
                case PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DOUBLE -> PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE;
                case PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BIGINTEGER -> PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER;
                case PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL -> PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL;
                case PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING -> PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING;
                case PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DATE -> PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE;
            };
        }
        return null;
    }

    private StructPropertyValue getStructPropertyValue(AttributeTypeDef typeDef, Map<String, Object> attributes) throws InvalidParameterException {
        String methodName = "getStructPropertyValue";
        StructPropertyValue omrsPropertyValue = new StructPropertyValue();
        omrsPropertyValue.setHeaderVersion(1L);
        omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.STRUCT);
        omrsPropertyValue.setTypeGUID(typeDef.getGUID());
        omrsPropertyValue.setTypeName(typeDef.getName());
        try {
            omrsPropertyValue.setAttributes(this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, attributes, "getStructPropertyValue"));
        }
        catch (OCFCheckedExceptionBase error) {
            String parameterName = "searchProperties";
            throw new InvalidParameterException(error, "searchProperties");
        }
        return omrsPropertyValue;
    }

    private org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria getMatchCriteria(MatchCriteria gafMatchCriteria) {
        if (gafMatchCriteria != null) {
            return switch (gafMatchCriteria) {
                default -> throw new IncompatibleClassChangeError();
                case MatchCriteria.ALL -> org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria.ALL;
                case MatchCriteria.ANY -> org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria.ANY;
                case MatchCriteria.NONE -> org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria.NONE;
            };
        }
        return null;
    }

    private PropertyComparisonOperator getPropertyComparisonOperator(org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator gafPropertyComparisonOperator) {
        if (gafPropertyComparisonOperator != null) {
            return switch (gafPropertyComparisonOperator) {
                default -> throw new IncompatibleClassChangeError();
                case org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator.EQ -> PropertyComparisonOperator.EQ;
                case org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator.NEQ -> PropertyComparisonOperator.NEQ;
                case org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator.LT -> PropertyComparisonOperator.LT;
                case org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator.LTE -> PropertyComparisonOperator.LTE;
                case org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator.GT -> PropertyComparisonOperator.GT;
                case org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator.GTE -> PropertyComparisonOperator.GTE;
                case org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator.IN -> PropertyComparisonOperator.IN;
                case org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator.IS_NULL -> PropertyComparisonOperator.IS_NULL;
                case org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator.NOT_NULL -> PropertyComparisonOperator.NOT_NULL;
                case org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator.LIKE -> PropertyComparisonOperator.LIKE;
            };
        }
        return null;
    }

    private org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder getSequencingOrder(SequencingOrder gafSequencingOrder) {
        if (gafSequencingOrder != null) {
            return switch (gafSequencingOrder) {
                default -> throw new IncompatibleClassChangeError();
                case SequencingOrder.ANY -> org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.ANY;
                case SequencingOrder.GUID -> org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.GUID;
                case SequencingOrder.CREATION_DATE_RECENT -> org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.CREATION_DATE_RECENT;
                case SequencingOrder.CREATION_DATE_OLDEST -> org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.CREATION_DATE_OLDEST;
                case SequencingOrder.LAST_UPDATE_RECENT -> org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.LAST_UPDATE_RECENT;
                case SequencingOrder.LAST_UPDATE_OLDEST -> org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.LAST_UPDATE_OLDEST;
                case SequencingOrder.PROPERTY_ASCENDING -> org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.PROPERTY_ASCENDING;
                case SequencingOrder.PROPERTY_DESCENDING -> org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.PROPERTY_DESCENDING;
            };
        }
        return null;
    }

    private List<InstanceStatus> getInstanceStatuses(List<ElementStatus> elementStatuses) {
        if (elementStatuses != null) {
            ArrayList<InstanceStatus> instanceStatuses = new ArrayList<InstanceStatus>();
            for (ElementStatus elementStatus : elementStatuses) {
                if (elementStatus == null) continue;
                instanceStatuses.add(this.getInstanceStatus(elementStatus));
            }
            if (!instanceStatuses.isEmpty()) {
                return instanceStatuses;
            }
        }
        return null;
    }

    private InstanceStatus getInstanceStatus(ElementStatus elementStatus) {
        if (elementStatus != null) {
            return switch (elementStatus) {
                default -> throw new IncompatibleClassChangeError();
                case ElementStatus.UNKNOWN -> InstanceStatus.UNKNOWN;
                case ElementStatus.DRAFT -> InstanceStatus.DRAFT;
                case ElementStatus.PREPARED -> InstanceStatus.PREPARED;
                case ElementStatus.PROPOSED -> InstanceStatus.PROPOSED;
                case ElementStatus.APPROVED -> InstanceStatus.APPROVED;
                case ElementStatus.REJECTED -> InstanceStatus.REJECTED;
                case ElementStatus.APPROVED_CONCEPT -> InstanceStatus.APPROVED_CONCEPT;
                case ElementStatus.UNDER_DEVELOPMENT -> InstanceStatus.UNDER_DEVELOPMENT;
                case ElementStatus.DEVELOPMENT_COMPLETE -> InstanceStatus.DEVELOPMENT_COMPLETE;
                case ElementStatus.APPROVED_FOR_DEPLOYMENT -> InstanceStatus.APPROVED_FOR_DEPLOYMENT;
                case ElementStatus.STANDBY -> InstanceStatus.STANDBY;
                case ElementStatus.ACTIVE -> InstanceStatus.ACTIVE;
                case ElementStatus.FAILED -> InstanceStatus.FAILED;
                case ElementStatus.DISABLED -> InstanceStatus.DISABLED;
                case ElementStatus.COMPLETE -> InstanceStatus.COMPLETE;
                case ElementStatus.DEPRECATED -> InstanceStatus.DEPRECATED;
                case ElementStatus.DELETED -> InstanceStatus.DELETED;
                case ElementStatus.OTHER -> InstanceStatus.OTHER;
            };
        }
        return null;
    }

    public List<OpenMetadataRelationship> findRelationshipsBetweenMetadataElements(String userId, String relationshipTypeName, org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        List relationships = this.findAttachmentLinks(userId, relationshipTypeName, this.getSearchProperties(searchProperties), this.getInstanceStatuses(limitResultsByStatus), asOfTime, sequencingProperty, this.getSequencingOrder(sequencingOrder), forLineage, forDuplicateProcessing, startFrom, pageSize, serviceSupportedZones, effectiveTime, methodName);
        if (relationships != null) {
            ArrayList<OpenMetadataRelationship> results = new ArrayList<OpenMetadataRelationship>();
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                results.add(this.openMetadataRelationshipsConverter.getNewRelationshipBean(OpenMetadataRelationship.class, relationship, methodName));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<OpenMetadataRelationship> getRelationshipsByType(String userId, String typeName, boolean forLineage, boolean forDuplicateProcessing, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, List<String> serviceSupportedZones, Date effectiveTime, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeParameterName = "typeName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(typeName, "typeName", methodName);
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, null, this.serviceName, methodName, this.repositoryHelper);
        List relationships = this.repositoryHandler.getRelationshipsForType(userId, typeGUID, typeName, this.getInstanceStatuses(limitResultsByStatus), startFrom, pageSize, asOfTime, sequencingProperty, this.getSequencingOrder(sequencingOrder), effectiveTime, methodName);
        if (relationships != null) {
            ArrayList<OpenMetadataRelationship> results = new ArrayList<OpenMetadataRelationship>();
            ArrayList validatedAnchorGUIDs = new ArrayList();
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                try {
                    this.validateRelationship(userId, relationship, validatedAnchorGUIDs, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                    results.add(this.openMetadataRelationshipsConverter.getNewRelationshipBean(OpenMetadataRelationship.class, relationship, methodName));
                }
                catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException notVisible) {
                    log.debug("Skip relationship " + relationship.getGUID());
                }
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<OpenMetadataRelationship> convertOpenMetadataRelationships(List<Relationship> relationships, String methodName) throws PropertyServerException {
        if (relationships != null) {
            ArrayList<OpenMetadataRelationship> results = new ArrayList<OpenMetadataRelationship>();
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                results.add(this.openMetadataRelationshipsConverter.getNewRelationshipBean(OpenMetadataRelationship.class, relationship, methodName));
            }
            return results;
        }
        return null;
    }

    public String createMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementTypeName, ElementStatus initialStatus, Map<String, ElementProperties> initialClassifications, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail anchorEntity;
        String elementTypeParameterName = "metadataElementTypeName";
        String anchorGUIDParameterName = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(metadataElementTypeName, "metadataElementTypeName", methodName);
        String parentRelationshipTypeGUID = null;
        if (parentGUID != null) {
            String parentRelationshipTypeNameParameterName = "parentRelationshipTypeName";
            this.invalidParameterHandler.validateName(parentRelationshipTypeName, "parentRelationshipTypeName", methodName);
            parentRelationshipTypeGUID = this.invalidParameterHandler.validateTypeName(parentRelationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        }
        String metadataElementTypeGUID = this.invalidParameterHandler.validateTypeName(metadataElementTypeName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, this.serviceName, methodName, this.repositoryHelper);
        if (this.repositoryHelper.isTypeOf(this.serviceName, metadataElementTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
            String qualifiedName = this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, properties, methodName);
            this.invalidParameterHandler.validateName(qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, methodName);
        }
        MetadataElementBuilder builder = new MetadataElementBuilder(metadataElementTypeGUID, metadataElementTypeName, this.getElementPropertiesAsOMRSMap(properties), this.getInstanceStatus(initialStatus), effectiveFrom, effectiveTo, this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorGUID != null && (anchorEntity = this.getEntityFromRepository(userId, anchorGUID, "anchorGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, null, false, false, serviceSupportedZones, effectiveTime, methodName)) != null) {
            builder.setAnchors(userId, anchorEntity.getGUID(), anchorEntity.getType().getTypeDefName(), this.getDomainName((EntitySummary)anchorEntity), methodName);
        }
        if (initialClassifications != null) {
            for (String classificationName : initialClassifications.keySet()) {
                ElementProperties classificationProperties = initialClassifications.get(classificationName);
                Map<String, InstancePropertyValue> instancePropertyValueMap = null;
                if (classificationProperties != null) {
                    instancePropertyValueMap = this.getElementPropertiesAsOMRSMap(classificationProperties);
                }
                try {
                    Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, classificationName, metadataElementTypeName, ClassificationOrigin.ASSIGNED, null, builder.getInstanceProperties(instancePropertyValueMap, null, null));
                    builder.setClassification(classification);
                }
                catch (TypeErrorException error) {
                    this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, classificationName);
                }
            }
        }
        String metadataElementGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, metadataElementTypeGUID, metadataElementTypeName, this.getDomainName(metadataElementTypeName), builder, isOwnAnchor, effectiveTime, methodName);
        String pathName = this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.PATH_NAME.name, properties, methodName);
        this.createParentRelationships(userId, externalSourceGUID, externalSourceName, metadataElementGUID, metadataElementTypeName, pathName, parentGUID, parentRelationshipTypeGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1, serviceSupportedZones, effectiveTime, methodName);
        return metadataElementGUID;
    }

    private void createParentRelationships(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String metadataElementTypeName, String pathName, String parentGUID, String parentRelationshipTypeGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String parentGUIDParameterName = "parentGUID";
        String metadataElementGUIDParameterName = "metadataElementGUID";
        if (metadataElementGUID != null) {
            if (parentGUID != null) {
                MetadataElementBuilder builder = new MetadataElementBuilder(this.repositoryHelper, this.serviceName, this.serverName);
                InstanceProperties relationshipProperties = builder.getInstanceProperties(this.getElementPropertiesAsOMRSMap(parentRelationshipProperties), null, null);
                if (parentAtEnd1) {
                    this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, parentGUID, "parentGUID", metadataElementGUID, "metadataElementGUID", parentRelationshipTypeGUID, relationshipProperties, methodName);
                } else {
                    this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, metadataElementGUID, "metadataElementGUID", parentGUID, "parentGUID", parentRelationshipTypeGUID, relationshipProperties, methodName);
                }
            }
            if ((this.repositoryHelper.isTypeOf(this.serviceName, metadataElementTypeName, OpenMetadataType.DATA_FILE.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, metadataElementTypeName, OpenMetadataType.FILE_FOLDER.typeName)) && pathName != null) {
                this.filesAndFoldersHandler.addFileAssetPath(userId, externalSourceGUID, externalSourceName, metadataElementGUID, "metadataElementGUID", metadataElementTypeName, pathName, OpenMetadataProperty.PATH_NAME.name, false, false, effectiveTime, methodName);
            }
        }
    }

    public String createMetadataElementFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String suppliedMetadataElementTypeName, String anchorGUID, boolean isOwnAnchor, boolean allowRetrieve, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties templateProperties, Map<String, String> placeholderPropertyValues, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail templateEntity;
        String metadataElementTypeName;
        String templateGUIDParameterName = "templateGUID";
        String anchorGUIDParameterName = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        String parentRelationshipTypeGUID = null;
        if (parentGUID != null) {
            String parentRelationshipTypeNameParameterName = "parentRelationshipTypeName";
            this.invalidParameterHandler.validateName(parentRelationshipTypeName, "parentRelationshipTypeName", methodName);
            parentRelationshipTypeGUID = this.invalidParameterHandler.validateTypeName(parentRelationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        }
        if ((metadataElementTypeName = suppliedMetadataElementTypeName) == null && (templateEntity = this.getEntityFromRepository(userId, templateGUID, "templateGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, null, false, false, serviceSupportedZones, effectiveTime, methodName)) != null) {
            metadataElementTypeName = templateEntity.getType().getTypeDefName();
        }
        String metadataElementTypeGUID = this.invalidParameterHandler.validateTypeName(metadataElementTypeName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, this.serviceName, methodName, this.repositoryHelper);
        MetadataElementBuilder builder = new MetadataElementBuilder(metadataElementTypeGUID, metadataElementTypeName, this.getElementPropertiesAsOMRSMap(templateProperties), null, effectiveFrom, effectiveTo, this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorGUID != null) {
            EntityDetail anchorEntity = this.getEntityFromRepository(userId, anchorGUID, "anchorGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, null, false, false, serviceSupportedZones, effectiveTime, methodName);
            if (anchorEntity != null) {
                builder.setAnchors(userId, anchorEntity.getGUID(), anchorEntity.getType().getTypeDefName(), this.getDomainName((EntitySummary)anchorEntity), methodName);
            }
        } else if (isOwnAnchor) {
            builder.setAnchors(userId, null, metadataElementTypeName, this.getDomainName(metadataElementTypeName), methodName);
        }
        String metadataElementGUID = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", metadataElementTypeGUID, metadataElementTypeName, null, null, builder, serviceSupportedZones, true, false, allowRetrieve, placeholderPropertyValues, methodName);
        if (metadataElementGUID != null && parentGUID != null) {
            String metadataElementGUIDParameterName = "metadataElementGUID";
            EntityDetail entityDetail = this.getEntityFromRepository(userId, metadataElementGUID, "metadataElementGUID", metadataElementTypeName, null, null, false, false, serviceSupportedZones, null, methodName);
            List existingRelationships = null;
            if (allowRetrieve) {
                int attachmentEnd = 2;
                if (parentAtEnd1) {
                    attachmentEnd = 1;
                }
                existingRelationships = this.repositoryHandler.getRelationshipsBetweenEntities(userId, entityDetail, metadataElementTypeName, parentGUID, parentRelationshipTypeGUID, parentRelationshipTypeName, attachmentEnd, null, null, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.CREATION_DATE_RECENT, null, false, false, effectiveFrom, effectiveTo, true, methodName);
            }
            if (existingRelationships == null || existingRelationships.isEmpty()) {
                String pathName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.PATH_NAME.name, entityDetail.getProperties(), methodName);
                this.createParentRelationships(userId, externalSourceGUID, externalSourceName, metadataElementGUID, metadataElementTypeName, pathName, parentGUID, parentRelationshipTypeGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1, serviceSupportedZones, effectiveTime, methodName);
            }
        }
        return metadataElementGUID;
    }

    public void updateMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.getElementPropertiesAsOMRSMap(properties), this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, metadataElementGUID, "metadataElementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeGUID, OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, builder.getInstanceProperties(methodName), !replaceProperties, effectiveTime, methodName);
    }

    public void updateMetadataElementStatusInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, ElementStatus newElementStatus, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        String statusParameterName = "newElementStatus";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        super.updateBeanStatusInRepository(userId, externalSourceGUID, externalSourceName, metadataElementGUID, "metadataElementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeGUID, OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, this.getInstanceStatus(newElementStatus), "newElementStatus", effectiveTime, methodName);
    }

    public void updateMetadataElementEffectivityInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        super.updateBeanEffectivityDates(userId, externalSourceGUID, externalSourceName, metadataElementGUID, "metadataElementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeGUID, OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, serviceSupportedZones, effectiveTime, methodName);
    }

    public void deleteMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        super.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, metadataElementGUID, "metadataElementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeGUID, OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public void archiveMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, ArchiveProperties archiveProperties, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        ReferenceableBuilder builder = new ReferenceableBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        if (archiveProperties != null) {
            super.archiveBeanInRepository(userId, externalSourceGUID, externalSourceName, metadataElementGUID, "metadataElementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, builder.getMementoProperties(archiveProperties.getArchiveDate(), userId, archiveProperties.getArchiveProcess(), archiveProperties.getArchiveProperties(), methodName), forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        } else {
            super.archiveBeanInRepository(userId, externalSourceGUID, externalSourceName, metadataElementGUID, "metadataElementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, builder.getMementoProperties(null, userId, null, null, methodName), forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        }
    }

    public void classifyMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        this.invalidParameterHandler.validateName(classificationName, "classificationName", methodName);
        String classificationTypeGUID = this.invalidParameterHandler.validateTypeName(classificationName, null, this.serviceName, methodName, this.repositoryHelper);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties classificationProperties = builder.getInstanceProperties(this.getElementPropertiesAsOMRSMap(properties), effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, metadataElementGUID, "metadataElementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, classificationTypeGUID, classificationName, classificationProperties, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public void reclassifyMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        this.invalidParameterHandler.validateName(classificationName, "classificationName", methodName);
        String classificationTypeGUID = this.invalidParameterHandler.validateTypeName(classificationName, null, this.serviceName, methodName, this.repositoryHelper);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties classificationProperties = builder.getInstanceProperties(this.getElementPropertiesAsOMRSMap(properties), null, null);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, metadataElementGUID, "metadataElementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, classificationTypeGUID, classificationName, classificationProperties, !replaceProperties, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public void updateClassificationStatusInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        this.invalidParameterHandler.validateName(classificationName, "classificationName", methodName);
        String classificationTypeGUID = this.invalidParameterHandler.validateTypeName(classificationName, null, this.serviceName, methodName, this.repositoryHelper);
        super.updateClassificationEffectivityDates(userId, externalSourceGUID, externalSourceName, metadataElementGUID, "metadataElementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, classificationTypeGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, serviceSupportedZones, effectiveTime, methodName);
    }

    public void declassifyMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String metadataElementGUIDParameterName, String metadataElementTypeName, String classificationName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String classificationParameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, metadataElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(classificationName, "classificationName", methodName);
        String classificationTypeGUID = this.invalidParameterHandler.validateTypeName(classificationName, null, this.serviceName, methodName, this.repositoryHelper);
        super.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, metadataElementGUID, metadataElementGUIDParameterName, metadataElementTypeName, classificationTypeGUID, classificationName, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public String createRelatedElementsInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementTypeParameterName = "relationshipTypeName";
        String end1ParameterName = "metadataElement1GUID";
        String end2ParameterName = "metadataElement2GUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", methodName);
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getInstanceProperties(this.getElementPropertiesAsOMRSMap(properties), effectiveFrom, effectiveTo);
        super.linkElementToElement(userId, externalSourceGUID, externalSourceName, metadataElement1GUID, "metadataElement1GUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, metadataElement2GUID, "metadataElement2GUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, relationshipTypeGUID, relationshipTypeName, relationshipProperties, effectiveFrom, effectiveTo, effectiveTime, methodName);
        return null;
    }

    public Map<String, InstancePropertyValue> getElementPropertiesAsOMRSMap(ElementProperties properties) throws InvalidParameterException {
        if (properties != null) {
            Map propertyValues = properties.getPropertyValueMap();
            HashMap<String, InstancePropertyValue> resultingMap = new HashMap<String, InstancePropertyValue>();
            if (propertyValues != null) {
                for (String mapPropertyName : propertyValues.keySet()) {
                    PropertyValue actualPropertyValue = properties.getPropertyValue(mapPropertyName);
                    InstancePropertyValue instancePropertyValue = this.getInstancePropertyValue(actualPropertyValue);
                    resultingMap.put(mapPropertyName, instancePropertyValue);
                }
            }
            return resultingMap;
        }
        return null;
    }

    public void updateRelatedElementsInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationshipGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", methodName);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getInstanceProperties(this.getElementPropertiesAsOMRSMap(properties), null, null);
        this.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationshipGUID, "relationshipGUID", null, !replaceProperties, relationshipProperties, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public void updateRelatedElementsStatusInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationshipGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", methodName);
        super.updateRelationshipEffectivityDates(userId, externalSourceGUID, externalSourceName, relationshipGUID, "relationshipGUID", null, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public void deleteRelatedElementsInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationshipGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", methodName);
        this.repositoryHandler.removeRelationship(userId, externalSourceGUID, externalSourceName, null, relationshipGUID, methodName);
    }
}

