/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server;

import java.util.Date;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementHeadersResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ExternalIdentifierHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.governanceaction.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.KeyPattern;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.MetadataCorrelationHeadersResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateMetadataCorrelatorsRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.server.GAFMetadataManagementInstanceHandler;
import org.slf4j.LoggerFactory;

public class ExternalIdentifierRESTServices {
    private static final GAFMetadataManagementInstanceHandler instanceHandler = new GAFMetadataManagementInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ExternalIdentifierRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public VoidResponse addExternalIdentifier(String serverName, String serviceURLMarker, String userId, String openMetadataElementGUID, String openMetadataElementTypeName, boolean forLineage, boolean forDuplicateProcessing, UpdateMetadataCorrelatorsRequestBody requestBody) {
        String methodName = "addExternalIdentifier";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        String identifierParameterName = "correlationProperties.externalIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addExternalIdentifier");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addExternalIdentifier");
            if (requestBody != null && requestBody.getMetadataCorrelationProperties() != null) {
                ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> handler = instanceHandler.getExternalIdentifierHandler(userId, serverName, "addExternalIdentifier");
                int permittedSynchronizationOrdinal = PermittedSynchronization.BOTH_DIRECTIONS.getOrdinal();
                if (requestBody.getMetadataCorrelationProperties().getSynchronizationDirection() != null) {
                    permittedSynchronizationOrdinal = requestBody.getMetadataCorrelationProperties().getSynchronizationDirection().getOrdinal();
                }
                int keyPatternOrdinal = KeyPattern.LOCAL_KEY.getOrdinal();
                if (requestBody.getMetadataCorrelationProperties().getKeyPattern() != null) {
                    keyPatternOrdinal = requestBody.getMetadataCorrelationProperties().getKeyPattern().getOrdinal();
                }
                handler.setUpExternalIdentifier(userId, openMetadataElementGUID, "openMetadataElementGUID", openMetadataElementTypeName, requestBody.getMetadataCorrelationProperties().getExternalIdentifier(), "correlationProperties.externalIdentifier", keyPatternOrdinal, requestBody.getMetadataCorrelationProperties().getExternalIdentifierName(), requestBody.getMetadataCorrelationProperties().getExternalIdentifierUsage(), requestBody.getMetadataCorrelationProperties().getExternalIdentifierSource(), requestBody.getMetadataCorrelationProperties().getMappingProperties(), requestBody.getMetadataCorrelationProperties().getExternalInstanceCreatedBy(), requestBody.getMetadataCorrelationProperties().getExternalInstanceCreationTime(), requestBody.getMetadataCorrelationProperties().getExternalInstanceLastUpdatedBy(), requestBody.getMetadataCorrelationProperties().getExternalInstanceLastUpdateTime(), requestBody.getMetadataCorrelationProperties().getExternalInstanceVersion(), requestBody.getMetadataCorrelationProperties().getExternalScopeGUID(), "externalScopeGUID", requestBody.getMetadataCorrelationProperties().getExternalScopeName(), requestBody.getMetadataCorrelationProperties().getExternalScopeTypeName(), OpenMetadataType.SOFTWARE_CAPABILITY.typeName, permittedSynchronizationOrdinal, requestBody.getMetadataCorrelationProperties().getSynchronizationDescription(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "addExternalIdentifier"), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "addExternalIdentifier");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addExternalIdentifier", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addExternalIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateExternalIdentifier(String serverName, String serviceURLMarker, String userId, String openMetadataElementGUID, String openMetadataElementTypeName, boolean forLineage, boolean forDuplicateProcessing, UpdateMetadataCorrelatorsRequestBody requestBody) {
        String methodName = "updateExternalIdentifier";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        String identifierParameterName = "correlationProperties.externalIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateExternalIdentifier");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateExternalIdentifier");
            if (requestBody != null && requestBody.getMetadataCorrelationProperties() != null) {
                ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> handler = instanceHandler.getExternalIdentifierHandler(userId, serverName, "updateExternalIdentifier");
                int permittedSynchronizationOrdinal = PermittedSynchronization.BOTH_DIRECTIONS.getOrdinal();
                if (requestBody.getMetadataCorrelationProperties().getSynchronizationDirection() != null) {
                    permittedSynchronizationOrdinal = requestBody.getMetadataCorrelationProperties().getSynchronizationDirection().getOrdinal();
                }
                int keyPatternOrdinal = KeyPattern.LOCAL_KEY.getOrdinal();
                if (requestBody.getMetadataCorrelationProperties().getKeyPattern() != null) {
                    keyPatternOrdinal = requestBody.getMetadataCorrelationProperties().getKeyPattern().getOrdinal();
                }
                handler.setUpExternalIdentifier(userId, openMetadataElementGUID, "openMetadataElementGUID", openMetadataElementTypeName, requestBody.getMetadataCorrelationProperties().getExternalIdentifier(), "correlationProperties.externalIdentifier", keyPatternOrdinal, requestBody.getMetadataCorrelationProperties().getExternalIdentifierName(), requestBody.getMetadataCorrelationProperties().getExternalIdentifierUsage(), requestBody.getMetadataCorrelationProperties().getExternalIdentifierSource(), requestBody.getMetadataCorrelationProperties().getMappingProperties(), requestBody.getMetadataCorrelationProperties().getExternalInstanceCreatedBy(), requestBody.getMetadataCorrelationProperties().getExternalInstanceCreationTime(), requestBody.getMetadataCorrelationProperties().getExternalInstanceLastUpdatedBy(), requestBody.getMetadataCorrelationProperties().getExternalInstanceLastUpdateTime(), requestBody.getMetadataCorrelationProperties().getExternalInstanceVersion(), requestBody.getMetadataCorrelationProperties().getExternalScopeGUID(), "externalScopeGUID", requestBody.getMetadataCorrelationProperties().getExternalScopeName(), requestBody.getMetadataCorrelationProperties().getExternalScopeTypeName(), OpenMetadataType.SOFTWARE_CAPABILITY.typeName, permittedSynchronizationOrdinal, requestBody.getMetadataCorrelationProperties().getSynchronizationDescription(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateExternalIdentifier"), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateExternalIdentifier");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateExternalIdentifier", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateExternalIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public BooleanResponse validateExternalIdentifier(String serverName, String serviceURLMarker, String userId, String openMetadataElementGUID, String openMetadataElementTypeName, boolean forLineage, boolean forDuplicateProcessing, UpdateMetadataCorrelatorsRequestBody requestBody) {
        String methodName = "validateExternalIdentifier";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        String externalIdentifierParameterName = "requestBody.externalIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "validateExternalIdentifier");
        BooleanResponse response = new BooleanResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateExternalIdentifier");
            if (requestBody != null && requestBody.getMetadataCorrelationProperties() != null) {
                ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> handler = instanceHandler.getExternalIdentifierHandler(userId, serverName, "validateExternalIdentifier");
                if (requestBody.getMetadataCorrelationProperties().getExternalIdentifier() != null && requestBody.getMetadataCorrelationProperties().getExternalScopeGUID() != null && requestBody.getMetadataCorrelationProperties().getExternalScopeName() != null) {
                    response.setFlag(handler.confirmSynchronization(userId, openMetadataElementGUID, "openMetadataElementGUID", openMetadataElementTypeName, requestBody.getMetadataCorrelationProperties().getExternalIdentifier(), "requestBody.externalIdentifier", requestBody.getMetadataCorrelationProperties().getExternalScopeGUID(), "externalScopeGUID", requestBody.getMetadataCorrelationProperties().getExternalScopeName(), OpenMetadataType.SOFTWARE_CAPABILITY.typeName, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "validateExternalIdentifier"), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "validateExternalIdentifier") != null);
                } else {
                    response.setFlag(true);
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "validateExternalIdentifier", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "validateExternalIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeExternalIdentifier(String serverName, String serviceURLMarker, String userId, String openMetadataElementGUID, String openMetadataElementTypeName, boolean forLineage, boolean forDuplicateProcessing, UpdateMetadataCorrelatorsRequestBody requestBody) {
        String methodName = "removeExternalIdentifier";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        String identifierParameterName = "correlationProperties.externalIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeExternalIdentifier");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeExternalIdentifier");
            if (requestBody != null && requestBody.getMetadataCorrelationProperties() != null) {
                ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> handler = instanceHandler.getExternalIdentifierHandler(userId, serverName, "removeExternalIdentifier");
                handler.removeExternalIdentifier(userId, openMetadataElementGUID, "openMetadataElementGUID", openMetadataElementTypeName, requestBody.getMetadataCorrelationProperties().getExternalIdentifier(), "correlationProperties.externalIdentifier", instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "removeExternalIdentifier"), requestBody.getMetadataCorrelationProperties().getExternalScopeGUID(), "externalScopeGUID", requestBody.getMetadataCorrelationProperties().getExternalScopeName(), OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeExternalIdentifier");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeExternalIdentifier", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeExternalIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeExternalScope(String serverName, String serviceURLMarker, String userId, String externalScopeGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeRequestBody requestBody) {
        String methodName = "removeExternalIdentifier";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeExternalIdentifier");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeExternalIdentifier");
            if (requestBody != null) {
                ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> handler = instanceHandler.getExternalIdentifierHandler(userId, serverName, "removeExternalIdentifier");
                handler.removeExternalScope(userId, externalScopeGUID, "externalScopeGUID", instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "removeExternalIdentifier"), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeExternalIdentifier");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeExternalIdentifier", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeExternalIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse confirmSynchronization(String serverName, String serviceURLMarker, String userId, String openMetadataElementGUID, String openMetadataElementTypeName, MetadataCorrelationProperties requestBody) {
        String methodName = "confirmSynchronization";
        String openMetadataElementGUIDParameterName = "openMetadataElementGUID";
        String externalIdentifierParameterName = "externalIdentifier";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "confirmSynchronization");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "confirmSynchronization");
            if (requestBody != null) {
                boolean forLineage = false;
                boolean forDuplicateProcessing = false;
                Date effectiveTime = new Date();
                ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> handler = instanceHandler.getExternalIdentifierHandler(userId, serverName, "confirmSynchronization");
                handler.confirmSynchronization(userId, openMetadataElementGUID, "openMetadataElementGUID", openMetadataElementTypeName, requestBody.getExternalIdentifier(), "externalIdentifier", requestBody.getExternalScopeGUID(), "externalScopeGUID", requestBody.getExternalScopeName(), OpenMetadataType.SOFTWARE_CAPABILITY.typeName, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "confirmSynchronization"), forLineage, forDuplicateProcessing, effectiveTime, "confirmSynchronization");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "confirmSynchronization", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "confirmSynchronization", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataCorrelationHeadersResponse getExternalIdentifiers(String serverName, String serviceURLMarker, String userId, String openMetadataElementGUID, String openMetadataElementTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getMetadataCorrelationHeaders";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataCorrelationHeaders");
        MetadataCorrelationHeadersResponse response = new MetadataCorrelationHeadersResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataCorrelationHeaders");
            if (requestBody != null) {
                ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> handler = instanceHandler.getExternalIdentifierHandler(userId, serverName, "getMetadataCorrelationHeaders");
                response.setElementList(handler.getExternalIdentifiersForScope(userId, openMetadataElementGUID, "openMetadataElementGUID", openMetadataElementTypeName, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getMetadataCorrelationHeaders"), requestBody.getExternalScopeGUID(), OpenMetadataType.SOFTWARE_CAPABILITY.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getMetadataCorrelationHeaders"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMetadataCorrelationHeaders", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataCorrelationHeaders", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementHeadersResponse getElementsForExternalIdentifier(String serverName, String serviceURLMarker, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, UpdateMetadataCorrelatorsRequestBody requestBody) {
        String methodName = "getElementsForExternalIdentifier";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getElementsForExternalIdentifier");
        ElementHeadersResponse response = new ElementHeadersResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElementsForExternalIdentifier");
            if (requestBody != null && requestBody.getMetadataCorrelationProperties() != null) {
                ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> handler = instanceHandler.getExternalIdentifierHandler(userId, serverName, "getElementsForExternalIdentifier");
                response.setElementHeaders(handler.getElementsForExternalIdentifier(userId, requestBody.getMetadataCorrelationProperties().getExternalScopeGUID(), "externalScopeGUID", OpenMetadataType.REFERENCEABLE.typeName, requestBody.getMetadataCorrelationProperties().getExternalScopeName(), requestBody.getMetadataCorrelationProperties().getExternalIdentifier(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getElementsForExternalIdentifier"), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getElementsForExternalIdentifier"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getElementsForExternalIdentifier", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getElementsForExternalIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

