/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ValidValuesHandler;
import org.odpi.openmetadata.commonservices.mermaid.OpenMetadataMermaidGraphBuilder;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ExternalStandardTypeMapping;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataAttributeCardinality;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataAttributeTypeDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataAttributeTypeDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataClassificationDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataClassificationPropagationRule;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataCollectionDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataCollectionDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElementGraph;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataEntityDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataEnumDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataEnumElementDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataPrimitiveDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataPrimitiveDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationshipDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationshipEndCardinality;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationshipEndDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationshipList;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefAttribute;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefAttributeStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefLink;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.properties.TranslationDetail;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValue;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValueDetail;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworkservices.gaf.converters.RelatedElementsConverter;
import org.odpi.openmetadata.frameworkservices.gaf.ffdc.OpenMetadataStoreAuditCode;
import org.odpi.openmetadata.frameworkservices.gaf.handlers.MetadataElementHandler;
import org.odpi.openmetadata.frameworkservices.gaf.rest.AnyTimeRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ArchiveRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.AttributeTypeDefListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.AttributeTypeDefResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.FindRelationshipRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.FindRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.HistoryRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewClassificationRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewOpenMetadataElementRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewRelatedElementsRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataGraphResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataRelationshipListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataRelationshipResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RelatedMetadataElementListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TemplateRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TranslationDetailResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TranslationListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TypeDefGalleryResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TypeDefListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TypeDefResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateEffectivityDatesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdatePropertiesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueDetailListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueResponse;
import org.odpi.openmetadata.frameworkservices.gaf.server.GAFMetadataManagementInstanceHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ExternalStandardMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class OpenMetadataStoreRESTServices {
    private static final GAFMetadataManagementInstanceHandler instanceHandler = new GAFMetadataManagementInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OpenMetadataStoreRESTServices.class), instanceHandler.getServiceName());
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final String propertyNameParameter = "propertyName";
    private final String preferredValueParameter = "preferredValue";
    private final String actualValueParameter = "actualValue";
    private final String validValueGUIDParameter = "element.getGUID";

    public VoidResponse logAssetAuditMessage(String serverName, String serviceURLMarker, String userId, String assetGUID, String governanceService, String message) {
        String methodName = "logAssetAuditMessage";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "logAssetAuditMessage");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "logAssetAuditMessage");
            this.getMetadataElementByGUID(serverName, serviceURLMarker, userId, assetGUID, false, false, null);
            auditLog.logMessage("logAssetAuditMessage", OpenMetadataStoreAuditCode.ASSET_AUDIT_LOG.getMessageDefinition(new String[]{assetGUID, governanceService, message}));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "logAssetAuditMessage", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TypeDefGalleryResponse getAllTypes(String serverName, String serviceURLMarker, String userId) {
        String methodName = "getAllTypes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllTypes");
        AuditLog auditLog = null;
        TypeDefGalleryResponse response = new TypeDefGalleryResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllTypes");
            OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "getAllTypes");
            response.setTypeDefs(this.getTypeDefs(repositoryHelper.getKnownTypeDefs()));
            response.setAttributeTypeDefs(this.getAttributeTypeDefs(repositoryHelper.getKnownAttributeTypeDefs()));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAllTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TypeDefListResponse findTypeDefsByCategory(String serverName, String serviceURLMarker, String userId, OpenMetadataTypeDefCategory category) {
        String methodName = "findTypeDefsByCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findTypeDefsByCategory");
        AuditLog auditLog = null;
        TypeDefListResponse response = new TypeDefListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTypeDefsByCategory");
            OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "findTypeDefsByCategory");
            List allTypeDefs = repositoryHelper.getKnownTypeDefs();
            if (allTypeDefs != null) {
                ArrayList<OpenMetadataTypeDef> openMetadataTypeDefList = new ArrayList<OpenMetadataTypeDef>();
                for (TypeDef typeDef : allTypeDefs) {
                    if (!(category == OpenMetadataTypeDefCategory.ENTITY_DEF && typeDef.getCategory() == TypeDefCategory.ENTITY_DEF || category == OpenMetadataTypeDefCategory.RELATIONSHIP_DEF && typeDef.getCategory() == TypeDefCategory.RELATIONSHIP_DEF) && (category != OpenMetadataTypeDefCategory.CLASSIFICATION_DEF || typeDef.getCategory() != TypeDefCategory.CLASSIFICATION_DEF)) continue;
                    openMetadataTypeDefList.add(this.getTypeDef(typeDef));
                }
                if (!openMetadataTypeDefList.isEmpty()) {
                    response.setTypeDefs(openMetadataTypeDefList);
                }
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findTypeDefsByCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AttributeTypeDefListResponse findAttributeTypeDefsByCategory(String serverName, String serviceURLMarker, String userId, OpenMetadataAttributeTypeDefCategory category) {
        String methodName = "findAttributeTypeDefsByCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAttributeTypeDefsByCategory");
        AuditLog auditLog = null;
        AttributeTypeDefListResponse response = new AttributeTypeDefListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAttributeTypeDefsByCategory");
            OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "findAttributeTypeDefsByCategory");
            List allAttributeTypeDefs = repositoryHelper.getKnownAttributeTypeDefs();
            if (allAttributeTypeDefs != null) {
                ArrayList<OpenMetadataAttributeTypeDef> openMetadataAttributeTypeDefList = new ArrayList<OpenMetadataAttributeTypeDef>();
                for (AttributeTypeDef attributeTypeDef : allAttributeTypeDefs) {
                    if (!(category == OpenMetadataAttributeTypeDefCategory.ENUM_DEF && attributeTypeDef.getCategory() == AttributeTypeDefCategory.ENUM_DEF || category == OpenMetadataAttributeTypeDefCategory.COLLECTION && attributeTypeDef.getCategory() == AttributeTypeDefCategory.COLLECTION) && (category != OpenMetadataAttributeTypeDefCategory.PRIMITIVE || attributeTypeDef.getCategory() != AttributeTypeDefCategory.PRIMITIVE)) continue;
                    openMetadataAttributeTypeDefList.add(this.getAttributeTypeDef(attributeTypeDef));
                }
                if (!openMetadataAttributeTypeDefList.isEmpty()) {
                    response.setAttributeTypeDefs(openMetadataAttributeTypeDefList);
                }
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findAttributeTypeDefsByCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TypeDefListResponse findTypesByExternalId(String serverName, String serviceURLMarker, String userId, String standard, String organization, String identifier) {
        String methodName = "findTypesByExternalId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findTypesByExternalId");
        AuditLog auditLog = null;
        TypeDefListResponse response = new TypeDefListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTypesByExternalId");
            OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "findTypesByExternalId");
            List allTypeDefs = repositoryHelper.getKnownTypeDefs();
            if (allTypeDefs != null) {
                ArrayList<OpenMetadataTypeDef> openMetadataTypeDefList = new ArrayList<OpenMetadataTypeDef>();
                for (TypeDef typeDef : allTypeDefs) {
                    if (typeDef.getExternalStandardMappings() == null) continue;
                    for (ExternalStandardMapping externalStandardMapping : typeDef.getExternalStandardMappings()) {
                        if (standard != null && !standard.equals(externalStandardMapping.getStandardName()) || organization != null && !organization.equals(externalStandardMapping.getStandardOrganization()) || identifier != null && !identifier.equals(externalStandardMapping.getStandardTypeName())) continue;
                        openMetadataTypeDefList.add(this.getTypeDef(typeDef));
                    }
                }
                if (!openMetadataTypeDefList.isEmpty()) {
                    response.setTypeDefs(openMetadataTypeDefList);
                }
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findTypesByExternalId", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TypeDefListResponse getSubTypes(String serverName, String serviceURLMarker, String userId, String typeName) {
        String methodName = "getSubTypes";
        String parameterName = "typeName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSubTypes");
        AuditLog auditLog = null;
        TypeDefListResponse response = new TypeDefListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSubTypes");
            OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "getSubTypes");
            String serviceName = instanceHandler.getServiceName(serviceURLMarker);
            this.invalidParameterHandler.validateName(typeName, "typeName", "getSubTypes");
            List subTypeNames = repositoryHelper.getSubTypesOf(serviceName, typeName);
            if (subTypeNames != null) {
                ArrayList<OpenMetadataTypeDef> openMetadataTypeDefList = new ArrayList<OpenMetadataTypeDef>();
                for (String subTypeName : subTypeNames) {
                    if (subTypeName == null) continue;
                    TypeDef subType = repositoryHelper.getTypeDefByName(serviceName, subTypeName);
                    openMetadataTypeDefList.add(this.getTypeDef(subType));
                }
                if (!openMetadataTypeDefList.isEmpty()) {
                    response.setTypeDefs(openMetadataTypeDefList);
                }
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSubTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TypeDefResponse getTypeDefByGUID(String serverName, String serviceURLMarker, String userId, String guid) {
        String methodName = "getTypeDefByGUID";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTypeDefByGUID");
        AuditLog auditLog = null;
        TypeDefResponse response = new TypeDefResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTypeDefByGUID");
            OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "getTypeDefByGUID");
            TypeDef typeDef = repositoryHelper.getTypeDef(instanceHandler.getServiceName(serviceURLMarker), "guid", guid, "getTypeDefByGUID");
            response.setTypeDef(this.getTypeDef(typeDef));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTypeDefByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AttributeTypeDefResponse getAttributeTypeDefByGUID(String serverName, String serviceURLMarker, String userId, String guid) {
        String methodName = "getAttributeTypeDefByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAttributeTypeDefByGUID");
        AuditLog auditLog = null;
        AttributeTypeDefResponse response = new AttributeTypeDefResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAttributeTypeDefByGUID");
            OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "getAttributeTypeDefByGUID");
            AttributeTypeDef attributeTypeDef = repositoryHelper.getAttributeTypeDef(instanceHandler.getServiceName(serviceURLMarker), guid, "getAttributeTypeDefByGUID");
            response.setAttributeTypeDef(this.getAttributeTypeDef(attributeTypeDef));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAttributeTypeDefByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TypeDefResponse getTypeDefByName(String serverName, String serviceURLMarker, String userId, String name) {
        String methodName = "getTypeDefByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTypeDefByName");
        AuditLog auditLog = null;
        TypeDefResponse response = new TypeDefResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTypeDefByName");
            OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "getTypeDefByName");
            TypeDef typeDef = repositoryHelper.getTypeDefByName(instanceHandler.getServiceName(serviceURLMarker), name);
            response.setTypeDef(this.getTypeDef(typeDef));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTypeDefByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AttributeTypeDefResponse getAttributeTypeDefByName(String serverName, String serviceURLMarker, String userId, String name) {
        String methodName = "getAttributeTypeDefByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAttributeTypeDefByName");
        AuditLog auditLog = null;
        AttributeTypeDefResponse response = new AttributeTypeDefResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAttributeTypeDefByName");
            OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "getAttributeTypeDefByName");
            AttributeTypeDef attributeTypeDef = repositoryHelper.getAttributeTypeDefByName(instanceHandler.getServiceName(serviceURLMarker), name);
            response.setAttributeTypeDef(this.getAttributeTypeDef(attributeTypeDef));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAttributeTypeDefByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementResponse getMetadataElementByGUID(String serverName, String serviceURLMarker, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime) {
        if (effectiveTime != 0L) {
            AnyTimeRequestBody requestBody = new AnyTimeRequestBody();
            requestBody.setEffectiveTime(new Date(effectiveTime));
            return this.getMetadataElementByGUID(serverName, serviceURLMarker, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
        }
        return this.getMetadataElementByGUID(serverName, serviceURLMarker, userId, elementGUID, forLineage, forDuplicateProcessing, null);
    }

    public OpenMetadataElementResponse getMetadataElementByGUID(String serverName, String serviceURLMarker, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, AnyTimeRequestBody requestBody) {
        String methodName = "getMetadataElementByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataElementByGUID");
        AuditLog auditLog = null;
        OpenMetadataElementResponse response = new OpenMetadataElementResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementByGUID");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getMetadataElementByGUID");
            if (requestBody != null) {
                response.setElement(handler.getMetadataElementByGUID(userId, elementGUID, forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getMetadataElementByGUID"), requestBody.getAsOfTime(), requestBody.getEffectiveTime(), "getMetadataElementByGUID"));
            } else {
                response.setElement(handler.getMetadataElementByGUID(userId, elementGUID, forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getMetadataElementByGUID"), null, new Date(), "getMetadataElementByGUID"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataElementByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementResponse getMetadataElementByUniqueName(String serverName, String serviceURLMarker, String userId, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getMetadataElementByUniqueName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataElementByUniqueName");
        AuditLog auditLog = null;
        OpenMetadataElementResponse response = new OpenMetadataElementResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementByUniqueName");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getMetadataElementByUniqueName");
                response.setElement(handler.getMetadataElementByUniqueName(userId, requestBody.getName(), requestBody.getNameParameterName(), requestBody.getNamePropertyName(), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingOrder(), requestBody.getSequencingProperty(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getMetadataElementByUniqueName"), requestBody.getEffectiveTime(), "getMetadataElementByUniqueName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMetadataElementByUniqueName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataElementByUniqueName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getMetadataElementGUIDByUniqueName(String serverName, String serviceURLMarker, String userId, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getMetadataElementGUIDByUniqueName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataElementGUIDByUniqueName");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementGUIDByUniqueName");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getMetadataElementGUIDByUniqueName");
                response.setGUID(handler.getMetadataElementGUIDByUniqueName(userId, requestBody.getName(), requestBody.getNameParameterName(), requestBody.getNamePropertyName(), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingOrder(), requestBody.getSequencingProperty(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getMetadataElementGUIDByUniqueName"), requestBody.getEffectiveTime(), "getMetadataElementGUIDByUniqueName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMetadataElementGUIDByUniqueName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataElementGUIDByUniqueName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementsResponse getMetadataElementHistory(String serverName, String serviceURLMarker, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, boolean oldestFirst, HistoryRequestBody requestBody) {
        String methodName = "getMetadataElementHistory";
        String guidParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataElementHistory");
        AuditLog auditLog = null;
        OpenMetadataElementsResponse response = new OpenMetadataElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementHistory");
            HistorySequencingOrder sequencingOrder = HistorySequencingOrder.BACKWARDS;
            if (oldestFirst) {
                sequencingOrder = HistorySequencingOrder.FORWARDS;
            }
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getMetadataElementHistory");
            if (requestBody != null) {
                response.setElementList(handler.getBeanHistory(userId, elementGUID, "elementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, requestBody.getFromTime(), requestBody.getToTime(), startFrom, pageSize, sequencingOrder, forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getMetadataElementHistory"), requestBody.getEffectiveTime(), "getMetadataElementHistory"));
            } else {
                response.setElementList(handler.getBeanHistory(userId, elementGUID, "elementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, null, startFrom, pageSize, sequencingOrder, forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getMetadataElementHistory"), null, "getMetadataElementHistory"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataElementHistory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementsResponse findMetadataElementsWithString(String serverName, String serviceURLMarker, String userId, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findMetadataElementsWithString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMetadataElementsWithString");
        AuditLog auditLog = null;
        OpenMetadataElementsResponse response = new OpenMetadataElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMetadataElementsWithString");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "findMetadataElementsWithString");
                response.setElementList(handler.findMetadataElementsWithString(userId, requestBody.getSearchString(), requestBody.getTypeName(), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "findMetadataElementsWithString"), requestBody.getEffectiveTime(), startFrom, pageSize, "findMetadataElementsWithString"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findMetadataElementsWithString", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findMetadataElementsWithString", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementListResponse getRelatedMetadataElements(String serverName, String serviceURLMarker, String userId, String elementGUID, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime, int startingAtEnd, int startFrom, int pageSize) {
        if (effectiveTime != 0L) {
            ResultsRequestBody requestBody = new ResultsRequestBody();
            requestBody.setEffectiveTime(new Date(effectiveTime));
            return this.getRelatedMetadataElements(serverName, serviceURLMarker, userId, elementGUID, relationshipTypeName, forLineage, forDuplicateProcessing, startingAtEnd, startFrom, pageSize, requestBody);
        }
        return this.getRelatedMetadataElements(serverName, serviceURLMarker, userId, elementGUID, relationshipTypeName, forLineage, forDuplicateProcessing, startingAtEnd, startFrom, pageSize, null);
    }

    public RelatedMetadataElementListResponse getRelatedMetadataElements(String serverName, String serviceURLMarker, String userId, String elementGUID, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, int startingAtEnd, int startFrom, int pageSize, ResultsRequestBody requestBody) {
        String methodName = "getRelatedMetadataElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelatedMetadataElements");
        AuditLog auditLog = null;
        RelatedMetadataElementListResponse response = new RelatedMetadataElementListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedMetadataElements");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getRelatedMetadataElements");
            RelatedMetadataElementList relatedElementList = new RelatedMetadataElementList();
            if (requestBody != null) {
                relatedElementList.setElementList(handler.getRelatedMetadataElements(userId, elementGUID, startingAtEnd, relationshipTypeName, requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getRelatedMetadataElements"), requestBody.getEffectiveTime(), startFrom, pageSize, "getRelatedMetadataElements"));
            } else {
                relatedElementList.setElementList(handler.getRelatedMetadataElements(userId, elementGUID, startingAtEnd, relationshipTypeName, null, null, null, null, forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getRelatedMetadataElements"), null, startFrom, pageSize, "getRelatedMetadataElements"));
            }
            if (relatedElementList.getElementList() != null) {
                OpenMetadataMermaidGraphBuilder graphBuilder = new OpenMetadataMermaidGraphBuilder(elementGUID, relatedElementList.getElementList());
                relatedElementList.setMermaidGraph(graphBuilder.getMermaidGraph());
            }
            response.setRelatedElementList(relatedElementList);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRelatedMetadataElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataRelationshipListResponse getMetadataElementRelationships(String serverName, String serviceURLMarker, String userId, String metadataElementAtEnd1GUID, String relationshipTypeName, String metadataElementAtEnd2GUID, boolean forLineage, boolean forDuplicateProcessing, long effectiveTime, int startFrom, int pageSize) {
        if (effectiveTime != 0L) {
            ResultsRequestBody requestBody = new ResultsRequestBody();
            requestBody.setEffectiveTime(new Date(effectiveTime));
            return this.getMetadataElementRelationships(serverName, serviceURLMarker, userId, metadataElementAtEnd1GUID, relationshipTypeName, metadataElementAtEnd2GUID, forLineage, forDuplicateProcessing, startFrom, pageSize, requestBody);
        }
        return this.getMetadataElementRelationships(serverName, serviceURLMarker, userId, metadataElementAtEnd1GUID, relationshipTypeName, metadataElementAtEnd2GUID, forLineage, forDuplicateProcessing, startFrom, pageSize, null);
    }

    public OpenMetadataRelationshipListResponse getMetadataElementRelationships(String serverName, String serviceURLMarker, String userId, String metadataElementAtEnd1GUID, String relationshipTypeName, String metadataElementAtEnd2GUID, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, ResultsRequestBody requestBody) {
        String methodName = "getMetadataElementRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataElementRelationships");
        AuditLog auditLog = null;
        OpenMetadataRelationshipListResponse response = new OpenMetadataRelationshipListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementRelationships");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getMetadataElementRelationships");
            OpenMetadataRelationshipList relationshipList = new OpenMetadataRelationshipList();
            if (requestBody != null) {
                relationshipList.setElementList(handler.getMetadataElementRelationships(userId, metadataElementAtEnd1GUID, relationshipTypeName, metadataElementAtEnd2GUID, requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getMetadataElementRelationships"), requestBody.getEffectiveTime(), startFrom, pageSize, "getMetadataElementRelationships"));
            } else {
                relationshipList.setElementList(handler.getMetadataElementRelationships(userId, metadataElementAtEnd1GUID, relationshipTypeName, metadataElementAtEnd2GUID, null, null, null, null, forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getMetadataElementRelationships"), null, startFrom, pageSize, "getMetadataElementRelationships"));
            }
            if (response.getRelationshipList() != null) {
                OpenMetadataMermaidGraphBuilder graphBuilder = new OpenMetadataMermaidGraphBuilder(metadataElementAtEnd1GUID, metadataElementAtEnd2GUID, relationshipList.getElementList());
                relationshipList.setMermaidGraph(graphBuilder.getMermaidGraph());
            }
            response.setRelationshipList(relationshipList);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataElementRelationships", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementsResponse findMetadataElements(String serverName, String serviceURLMarker, String userId, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, FindRequestBody requestBody) {
        String methodName = "findMetadataElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMetadataElements");
        AuditLog auditLog = null;
        OpenMetadataElementsResponse response = new OpenMetadataElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMetadataElements");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "findMetadataElements");
                if (requestBody.getSearchProperties() != null || requestBody.getMatchClassifications() != null) {
                    response.setElementList(handler.findMetadataElements(userId, requestBody.getMetadataElementTypeName(), requestBody.getMetadataElementSubtypeNames(), requestBody.getSearchProperties(), requestBody.getLimitResultsByStatus(), requestBody.getMatchClassifications(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "findMetadataElements"), requestBody.getEffectiveTime(), startFrom, pageSize, "findMetadataElements"));
                } else {
                    response.setElementList(handler.getMetadataElementsByType(userId, requestBody.getMetadataElementTypeName(), forLineage, forDuplicateProcessing, requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "findMetadataElements"), requestBody.getEffectiveTime(), startFrom, pageSize, "findMetadataElements"));
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findMetadataElements", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findMetadataElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataGraphResponse getAnchoredElementsGraph(String serverName, String serviceURLMarker, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, AnyTimeRequestBody requestBody) {
        String parameterName = "elementGUID";
        String methodName = "getAnchoredElementsGraph";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAnchoredElementsGraph");
        OpenMetadataGraphResponse response = new OpenMetadataGraphResponse();
        AuditLog auditLog = null;
        try {
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getAnchoredElementsGraph");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAnchoredElementsGraph");
            OpenMetadataElement anchorElement = requestBody != null ? (OpenMetadataElement)handler.getBeanFromRepository(userId, elementGUID, "elementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getAnchoredElementsGraph"), requestBody.getAsOfTime(), requestBody.getEffectiveTime(), "getAnchoredElementsGraph") : (OpenMetadataElement)handler.getBeanFromRepository(userId, elementGUID, "elementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getAnchoredElementsGraph"), null, new Date(), "getAnchoredElementsGraph");
            if (anchorElement != null) {
                OpenMetadataElementGraph elementGraph = new OpenMetadataElementGraph(anchorElement);
                HashMap<String, Relationship> receivedRelationships = new HashMap<String, Relationship>();
                List relationships = handler.getAllAttachmentLinks(userId, anchorElement.getElementGUID(), "elementGUID", anchorElement.getType().getTypeName(), null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, new Date(), "getAnchoredElementsGraph");
                if (relationships != null) {
                    for (Relationship relationship : relationships) {
                        if (relationship == null) continue;
                        receivedRelationships.put(relationship.getGUID(), relationship);
                    }
                }
                SearchClassifications searchClassifications = new SearchClassifications();
                ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
                ClassificationCondition classificationCondition = new ClassificationCondition();
                SearchProperties searchProperties = new SearchProperties();
                ArrayList<PropertyCondition> propertyConditions = new ArrayList<PropertyCondition>();
                PropertyCondition propertyCondition = new PropertyCondition();
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue.setPrimitiveValue((Object)anchorElement.getElementGUID());
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                propertyCondition.setProperty(OpenMetadataProperty.ANCHOR_GUID.name);
                propertyCondition.setOperator(PropertyComparisonOperator.EQ);
                propertyCondition.setValue((InstancePropertyValue)primitivePropertyValue);
                propertyConditions.add(propertyCondition);
                searchProperties.setMatchCriteria(MatchCriteria.ALL);
                searchProperties.setConditions(propertyConditions);
                classificationCondition.setName(OpenMetadataType.ANCHORS_CLASSIFICATION.typeName);
                classificationCondition.setMatchProperties(searchProperties);
                classificationConditions.add(classificationCondition);
                searchClassifications.setMatchCriteria(MatchCriteria.ALL);
                searchClassifications.setConditions(classificationConditions);
                List anchoredElements = handler.findBeans(userId, null, null, null, null, searchClassifications, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, startFrom, pageSize, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getAnchoredElementsGraph"), new Date(), "getAnchoredElementsGraph");
                elementGraph.setAnchoredElements(anchoredElements);
                if (anchoredElements != null) {
                    String anchoredElementParameterName = "anchoredElement.getGUID";
                    for (OpenMetadataElement metadataElement : anchoredElements) {
                        if (metadataElement == null || (relationships = handler.getAllAttachmentLinks(userId, metadataElement.getElementGUID(), "anchoredElement.getGUID", metadataElement.getType().getTypeName(), null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, new Date(), "getAnchoredElementsGraph")) == null) continue;
                        for (Relationship relationship : relationships) {
                            if (relationship == null) continue;
                            receivedRelationships.put(relationship.getGUID(), relationship);
                        }
                    }
                }
                if (!receivedRelationships.isEmpty()) {
                    RelatedElementsConverter<OpenMetadataRelationship> converter = new RelatedElementsConverter<OpenMetadataRelationship>(handler.getRepositoryHelper(), handler.getServiceName(), serverName);
                    ArrayList<OpenMetadataRelationship> metadataRelationships = new ArrayList<OpenMetadataRelationship>();
                    for (Relationship relationship : receivedRelationships.values()) {
                        if (relationship == null) continue;
                        OpenMetadataRelationship metadataRelationship = converter.getNewRelationshipBean(OpenMetadataRelationship.class, relationship, "getAnchoredElementsGraph");
                        metadataRelationships.add(metadataRelationship);
                    }
                    elementGraph.setRelationships(metadataRelationships);
                }
                OpenMetadataMermaidGraphBuilder graphBuilder = new OpenMetadataMermaidGraphBuilder(elementGraph);
                elementGraph.setMermaidGraph(graphBuilder.getMermaidGraph());
                response.setElementGraph(elementGraph);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAnchoredElementsGraph", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataRelationshipListResponse findRelationshipsBetweenMetadataElements(String serverName, String serviceURLMarker, String userId, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, FindRelationshipRequestBody requestBody) {
        String methodName = "findRelationshipsBetweenMetadataElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findRelationshipsBetweenMetadataElements");
        AuditLog auditLog = null;
        OpenMetadataRelationshipListResponse response = new OpenMetadataRelationshipListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findRelationshipsBetweenMetadataElements");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "findRelationshipsBetweenMetadataElements");
                OpenMetadataRelationshipList relationshipList = new OpenMetadataRelationshipList();
                if (requestBody.getSearchProperties() != null) {
                    relationshipList.setElementList(handler.findRelationshipsBetweenMetadataElements(userId, requestBody.getRelationshipTypeName(), requestBody.getSearchProperties(), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "findRelationshipsBetweenMetadataElements"), requestBody.getEffectiveTime(), startFrom, pageSize, "findRelationshipsBetweenMetadataElements"));
                } else {
                    relationshipList.setElementList(handler.getRelationshipsByType(userId, requestBody.getRelationshipTypeName(), forLineage, forDuplicateProcessing, requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "findRelationshipsBetweenMetadataElements"), null, startFrom, pageSize, "findRelationshipsBetweenMetadataElements"));
                }
                if (relationshipList.getElementList() != null) {
                    OpenMetadataMermaidGraphBuilder graphBuilder = new OpenMetadataMermaidGraphBuilder(relationshipList.getElementList());
                    relationshipList.setMermaidGraph(graphBuilder.getMermaidGraph());
                }
                response.setRelationshipList(relationshipList);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findRelationshipsBetweenMetadataElements", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findRelationshipsBetweenMetadataElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataRelationshipResponse getRelationshipByGUID(String serverName, String serviceURLMarker, String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, AnyTimeRequestBody requestBody) {
        String methodName = "getRelationshipByGUID";
        String guidParameterName = "relationshipGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelationshipByGUID");
        AuditLog auditLog = null;
        OpenMetadataRelationshipResponse response = new OpenMetadataRelationshipResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelationshipByGUID");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getRelationshipByGUID");
            Relationship relationship = requestBody != null ? handler.getAttachmentLink(userId, relationshipGUID, "relationshipGUID", null, requestBody.getAsOfTime(), false, false, handler.getSupportedZones(), requestBody.getEffectiveTime(), "getRelationshipByGUID") : handler.getAttachmentLink(userId, relationshipGUID, "relationshipGUID", null, new Date(), "getRelationshipByGUID");
            if (relationship != null) {
                RelatedElementsConverter<OpenMetadataRelationship> converter = new RelatedElementsConverter<OpenMetadataRelationship>(handler.getRepositoryHelper(), handler.getServiceName(), serverName);
                response.setElement(converter.getNewRelationshipBean(OpenMetadataRelationship.class, relationship, "getRelationshipByGUID"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRelationshipByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataRelationshipListResponse getRelationshipHistory(String serverName, String serviceURLMarker, String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, boolean oldestFirst, HistoryRequestBody requestBody) {
        String methodName = "getRelationshipHistory";
        String guidParameterName = "relationshipGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelationshipHistory");
        AuditLog auditLog = null;
        OpenMetadataRelationshipListResponse response = new OpenMetadataRelationshipListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelationshipHistory");
            HistorySequencingOrder sequencingOrder = HistorySequencingOrder.BACKWARDS;
            if (oldestFirst) {
                sequencingOrder = HistorySequencingOrder.FORWARDS;
            }
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getRelationshipHistory");
            List relationships = requestBody != null ? handler.getRelationshipHistory(userId, relationshipGUID, "relationshipGUID", requestBody.getFromTime(), requestBody.getToTime(), startFrom, pageSize, sequencingOrder, forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getRelationshipHistory"), requestBody.getEffectiveTime(), "getRelationshipHistory") : handler.getRelationshipHistory(userId, relationshipGUID, "relationshipGUID", null, null, startFrom, pageSize, sequencingOrder, forLineage, forDuplicateProcessing, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getRelationshipHistory"), null, "getRelationshipHistory");
            OpenMetadataRelationshipList openMetadataRelationshipList = new OpenMetadataRelationshipList();
            openMetadataRelationshipList.setElementList(handler.convertOpenMetadataRelationships(relationships, "getRelationshipHistory"));
            response.setRelationshipList(openMetadataRelationshipList);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRelationshipHistory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createMetadataElementInStore(String serverName, String serviceURLMarker, String userId, NewOpenMetadataElementRequestBody requestBody) {
        String methodName = "createMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createMetadataElementInStore");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "createMetadataElementInStore");
                response.setGUID(handler.createMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getTypeName(), requestBody.getInitialStatus(), requestBody.getInitialClassifications(), requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createMetadataElementInStore"), requestBody.getEffectiveTime(), "createMetadataElementInStore"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createMetadataElementFromTemplate(String serverName, String serviceURLMarker, String userId, boolean allowRetrieve, TemplateRequestBody requestBody) {
        String methodName = "createMetadataElementFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createMetadataElementFromTemplate");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createMetadataElementFromTemplate");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "createMetadataElementFromTemplate");
                response.setGUID(handler.createMetadataElementFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getTypeName(), requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), allowRetrieve, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getTemplateGUID(), requestBody.getReplacementProperties(), requestBody.getPlaceholderPropertyValues(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createMetadataElementFromTemplate"), requestBody.getEffectiveTime(), "createMetadataElementFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createMetadataElementFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createMetadataElementFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, UpdatePropertiesRequestBody requestBody) {
        String methodName = "updateMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateMetadataElementInStore");
                handler.updateMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getReplaceProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateMetadataElementInStore"), requestBody.getEffectiveTime(), "updateMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateMetadataElementStatusInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, UpdateStatusRequestBody requestBody) {
        String methodName = "updateMetadataElementStatusInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateMetadataElementStatusInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateMetadataElementStatusInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateMetadataElementStatusInStore");
                handler.updateMetadataElementStatusInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getNewStatus(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateMetadataElementStatusInStore"), requestBody.getEffectiveTime(), "updateMetadataElementStatusInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateMetadataElementStatusInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateMetadataElementStatusInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateMetadataElementEffectivityInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, UpdateEffectivityDatesRequestBody requestBody) {
        String methodName = "updateMetadataElementEffectivityInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateMetadataElementEffectivityInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateMetadataElementEffectivityInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateMetadataElementEffectivityInStore");
                handler.updateMetadataElementEffectivityInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateMetadataElementEffectivityInStore"), requestBody.getEffectiveTime(), "updateMetadataElementEffectivityInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateMetadataElementEffectivityInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateMetadataElementEffectivityInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, UpdateRequestBody requestBody) {
        String methodName = "deleteMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteMetadataElementInStore");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "deleteMetadataElementInStore");
            if (requestBody != null) {
                handler.deleteMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "deleteMetadataElementInStore"), requestBody.getEffectiveTime(), "deleteMetadataElementInStore");
            } else {
                handler.deleteMetadataElementInStore(userId, null, null, metadataElementGUID, false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "deleteMetadataElementInStore"), null, "deleteMetadataElementInStore");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse archiveMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, ArchiveRequestBody requestBody) {
        String methodName = "archiveMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "archiveMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "archiveMetadataElementInStore");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "archiveMetadataElementInStore");
            if (requestBody != null) {
                handler.archiveMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getArchiveProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "archiveMetadataElementInStore"), requestBody.getEffectiveTime(), "archiveMetadataElementInStore");
            } else {
                handler.archiveMetadataElementInStore(userId, null, null, metadataElementGUID, null, false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "archiveMetadataElementInStore"), null, "archiveMetadataElementInStore");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "archiveMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse classifyMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, String classificationName, NewClassificationRequestBody requestBody) {
        String methodName = "classifyMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "classifyMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "classifyMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "classifyMetadataElementInStore");
                handler.classifyMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, classificationName, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "classifyMetadataElementInStore"), requestBody.getEffectiveTime(), "classifyMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "classifyMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "classifyMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse reclassifyMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, String classificationName, UpdatePropertiesRequestBody requestBody) {
        String methodName = "reclassifyMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "reclassifyMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "reclassifyMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "reclassifyMetadataElementInStore");
                handler.reclassifyMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, classificationName, requestBody.getReplaceProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "reclassifyMetadataElementInStore"), requestBody.getEffectiveTime(), "reclassifyMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "reclassifyMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "reclassifyMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateClassificationEffectivityInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, String classificationName, UpdateEffectivityDatesRequestBody requestBody) {
        String methodName = "updateClassificationStatusInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateClassificationStatusInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateClassificationStatusInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateClassificationStatusInStore");
                handler.updateClassificationStatusInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, classificationName, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateClassificationStatusInStore"), requestBody.getEffectiveTime(), "updateClassificationStatusInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateClassificationStatusInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateClassificationStatusInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse declassifyMetadataElementInStore(String serverName, String serviceURLMarker, String userId, String metadataElementGUID, String classificationName, UpdateRequestBody requestBody) {
        String methodName = "unclassifyMetadataElementInStore";
        String metadataElementGUIDParameterName = "metadataElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unclassifyMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unclassifyMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "unclassifyMetadataElementInStore");
                handler.declassifyMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, "metadataElementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, classificationName, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "unclassifyMetadataElementInStore"), requestBody.getEffectiveTime(), "unclassifyMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "unclassifyMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unclassifyMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createRelatedElementsInStore(String serverName, String serviceURLMarker, String userId, NewRelatedElementsRequestBody requestBody) {
        String methodName = "createRelatedElementsInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createRelatedElementsInStore");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createRelatedElementsInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "createRelatedElementsInStore");
                response.setGUID(handler.createRelatedElementsInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getTypeName(), requestBody.getMetadataElement1GUID(), requestBody.getMetadataElement2GUID(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createRelatedElementsInStore"), requestBody.getEffectiveTime(), "createRelatedElementsInStore"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createRelatedElementsInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createRelatedElementsInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateRelatedElementsInStore(String serverName, String serviceURLMarker, String userId, String relationshipGUID, UpdatePropertiesRequestBody requestBody) {
        String methodName = "updateRelatedElementsInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateRelatedElementsInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateRelatedElementsInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateRelatedElementsInStore");
                handler.updateRelatedElementsInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), relationshipGUID, requestBody.getReplaceProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getProperties(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateRelatedElementsInStore"), requestBody.getEffectiveTime(), "updateRelatedElementsInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateRelatedElementsInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateRelatedElementsInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateRelatedElementsEffectivityInStore(String serverName, String serviceURLMarker, String userId, String relationshipGUID, UpdateEffectivityDatesRequestBody requestBody) {
        String methodName = "updateRelatedElementsStatusInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateRelatedElementsStatusInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateRelatedElementsStatusInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateRelatedElementsStatusInStore");
                handler.updateRelatedElementsStatusInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), relationshipGUID, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateRelatedElementsStatusInStore"), requestBody.getEffectiveTime(), "updateRelatedElementsStatusInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateRelatedElementsStatusInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateRelatedElementsStatusInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteRelatedElementsInStore(String serverName, String serviceURLMarker, String userId, String relationshipGUID, UpdateRequestBody requestBody) {
        String methodName = "deleteRelatedElementsInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteRelatedElementsInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteRelatedElementsInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "deleteRelatedElementsInStore");
                handler.deleteRelatedElementsInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), relationshipGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "deleteRelatedElementsInStore"), requestBody.getEffectiveTime(), "deleteRelatedElementsInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteRelatedElementsInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteRelatedElementsInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTranslation(String serverName, String serviceURLMarker, String userId, String elementGUID, TranslationDetail translationDetail) {
        String methodName = "setTranslation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTranslation");
        Object auditLog = null;
        VoidResponse response = new VoidResponse();
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTranslation(String serverName, String serviceURLMarker, String userId, String elementGUID, String language, String locale, NullRequestBody requestBody) {
        String methodName = "clearTranslation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTranslation");
        Object auditLog = null;
        VoidResponse response = new VoidResponse();
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TranslationDetailResponse getTranslation(String serverName, String serviceURLMarker, String userId, String elementGUID, String language, String locale) {
        String methodName = "getTranslation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTranslation");
        Object auditLog = null;
        TranslationDetailResponse response = new TranslationDetailResponse();
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TranslationListResponse getTranslations(String serverName, String serviceURLMarker, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getTranslations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTranslations");
        Object auditLog = null;
        TranslationListResponse response = new TranslationListResponse();
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private String getParentSet(String userId, String typeName, String propertyName, String mapName, ValidValuesHandler<ValidMetadataValue> handler, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String parentDescription = "Organizing set for valid metadata values";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        String parentQualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)typeName, (String)propertyName, (String)mapName, null);
        EntityDetail parentSet = handler.getEntityByValue(userId, parentQualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataType.VALID_VALUE_DEFINITION.typeGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, specificMatchPropertyNames, null, null, SequencingOrder.CREATION_DATE_RECENT, null, true, false, null, methodName);
        if (parentSet == null) {
            String grandParentSetGUID = null;
            String parentDisplayName = parentQualifiedName.substring(26);
            if (mapName != null) {
                grandParentSetGUID = this.getParentSet(userId, typeName, propertyName, null, handler, methodName);
            } else if (propertyName != null) {
                grandParentSetGUID = this.getParentSet(userId, typeName, null, null, handler, methodName);
            } else if (typeName != null) {
                grandParentSetGUID = this.getParentSet(userId, null, null, null, handler, methodName);
            }
            return handler.createValidValue(userId, null, null, grandParentSetGUID, grandParentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, false, parentQualifiedName, parentDisplayName, "Organizing set for valid metadata values", OpenMetadataValidValues.constructValidValueCategory((String)typeName, (String)propertyName, (String)mapName), "Used to control valid values in open metadata.", "Open Metadata Ecosystem", null, null, false, false, null, null, null, null, null, false, false, null, methodName);
        }
        return parentSet.getGUID();
    }

    private EntityDetail getValidMetadataElement(String userId, String typeName, String propertyName, String mapName, String preferredValue, ValidValuesHandler<ValidMetadataValue> handler, String methodName) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        String qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)typeName, (String)propertyName, (String)mapName, (String)preferredValue);
        EntityDetail element = handler.getEntityByValue(userId, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataType.VALID_VALUE_DEFINITION.typeGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, specificMatchPropertyNames, null, null, SequencingOrder.CREATION_DATE_RECENT, null, true, false, null, methodName);
        if (element == null) {
            qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName(null, (String)propertyName, (String)mapName, (String)preferredValue);
            element = handler.getEntityByValue(userId, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataType.VALID_VALUE_DEFINITION.typeGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, specificMatchPropertyNames, null, null, SequencingOrder.CREATION_DATE_RECENT, null, true, false, null, methodName);
        }
        return element;
    }

    private ValidMetadataValue getValidMetadataBean(String userId, String typeName, String propertyName, String mapName, String preferredValue, ValidValuesHandler<ValidMetadataValue> handler, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail element = this.getValidMetadataElement(userId, typeName, propertyName, mapName, preferredValue, handler, methodName);
        if (element != null) {
            OpenMetadataAPIGenericConverter converter = handler.getConverter();
            return (ValidMetadataValue)converter.getNewBean(ValidMetadataValue.class, element, methodName);
        }
        return null;
    }

    public VoidResponse setUpValidMetadataValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, ValidMetadataValue requestBody) {
        String methodName = "setUpValidMetadataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setUpValidMetadataValue");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setUpValidMetadataValue");
            if (requestBody != null) {
                this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataValue");
                this.invalidParameterHandler.validateName(requestBody.getPreferredValue(), "preferredValue", "setUpValidMetadataValue");
                ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "setUpValidMetadataValue");
                String setGUID = this.getParentSet(userId, typeName, propertyName, null, handler, "setUpValidMetadataValue");
                handler.createValidValue(userId, null, null, setGUID, setGUID, OpenMetadataType.VALID_VALUE_SET.typeName, false, OpenMetadataValidValues.constructValidValueQualifiedName((String)typeName, (String)propertyName, null, (String)requestBody.getPreferredValue()), requestBody.getDisplayName(), requestBody.getDescription(), OpenMetadataValidValues.constructValidValueCategory((String)typeName, (String)propertyName, null), "Used to control valid values in open metadata.", "Open Metadata Ecosystem", requestBody.getPreferredValue(), requestBody.getDataType(), requestBody.getIsDeprecated(), requestBody.getIsCaseSensitive(), requestBody.getAdditionalProperties(), null, null, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), false, false, null, "setUpValidMetadataValue");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setUpValidMetadataValue", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setUpValidMetadataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setUpValidMetadataMapName(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, ValidMetadataValue requestBody) {
        String methodName = "setUpValidMetadataMapName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setUpValidMetadataMapName");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setUpValidMetadataMapName");
            if (requestBody != null) {
                this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataMapName");
                this.invalidParameterHandler.validateName(requestBody.getPreferredValue(), "preferredValue", "setUpValidMetadataMapName");
                ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "setUpValidMetadataMapName");
                String setGUID = this.getParentSet(userId, typeName, propertyName, null, handler, "setUpValidMetadataMapName");
                handler.createValidValue(userId, null, null, setGUID, setGUID, OpenMetadataType.VALID_VALUE_SET.typeName, false, OpenMetadataValidValues.constructValidValueQualifiedName((String)typeName, (String)propertyName, (String)requestBody.getPreferredValue(), null), requestBody.getDisplayName(), requestBody.getDescription(), OpenMetadataValidValues.constructValidValueCategory((String)typeName, (String)propertyName, null), "Used to control valid values in open metadata.", "Open Metadata Ecosystem", requestBody.getPreferredValue(), "string", requestBody.getIsDeprecated(), requestBody.getIsCaseSensitive(), requestBody.getAdditionalProperties(), null, null, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), false, false, null, "setUpValidMetadataMapName");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setUpValidMetadataMapName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setUpValidMetadataMapName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setUpValidMetadataMapValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String mapName, ValidMetadataValue requestBody) {
        String methodName = "setUpValidMetadataMapValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setUpValidMetadataMapValue");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setUpValidMetadataMapValue");
            if (requestBody != null) {
                this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataMapValue");
                this.invalidParameterHandler.validateName(requestBody.getPreferredValue(), "preferredValue", "setUpValidMetadataMapValue");
                ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "setUpValidMetadataMapValue");
                String setGUID = this.getParentSet(userId, typeName, propertyName, mapName, handler, "setUpValidMetadataMapValue");
                handler.createValidValue(userId, null, null, setGUID, setGUID, OpenMetadataType.VALID_VALUE_SET.typeName, false, OpenMetadataValidValues.constructValidValueQualifiedName((String)typeName, (String)propertyName, (String)mapName, (String)requestBody.getPreferredValue()), requestBody.getDisplayName(), requestBody.getDescription(), OpenMetadataValidValues.constructValidValueCategory((String)typeName, (String)propertyName, (String)mapName), "Used to control valid values in open metadata.", "Open Metadata Ecosystem", requestBody.getPreferredValue(), null, requestBody.getIsDeprecated(), requestBody.getIsCaseSensitive(), requestBody.getAdditionalProperties(), null, null, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), false, false, null, "setUpValidMetadataMapValue");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setUpValidMetadataMapValue", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setUpValidMetadataMapValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearValidMetadataValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String preferredValue, NullRequestBody requestBody) {
        String methodName = "clearValidMetadataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearValidMetadataValue");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearValidMetadataValue");
            if (requestBody != null) {
                this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataValue");
                this.invalidParameterHandler.validateName(preferredValue, "preferredValue", "clearValidMetadataValue");
                ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "clearValidMetadataValue");
                EntityDetail element = this.getValidMetadataElement(userId, typeName, propertyName, null, preferredValue, handler, "clearValidMetadataValue");
                if (element != null) {
                    handler.deleteValidValue(userId, null, null, element.getGUID(), null, false, false, null, "clearValidMetadataValue");
                } else {
                    this.invalidParameterHandler.throwUnknownElementQualifiedName(userId, OpenMetadataValidValues.constructValidValueQualifiedName((String)typeName, (String)propertyName, null, (String)preferredValue), typeName, instanceHandler.getServiceName(serviceURLMarker), serverName, "clearValidMetadataValue");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearValidMetadataValue", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearValidMetadataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearValidMetadataMapName(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String preferredValue, NullRequestBody requestBody) {
        String methodName = "clearValidMetadataMapName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearValidMetadataMapName");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearValidMetadataMapName");
            if (requestBody != null) {
                this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataMapName");
                this.invalidParameterHandler.validateName(preferredValue, "preferredValue", "clearValidMetadataMapName");
                ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "clearValidMetadataMapName");
                EntityDetail element = this.getValidMetadataElement(userId, typeName, propertyName, null, preferredValue, handler, "clearValidMetadataMapName");
                if (element != null) {
                    handler.deleteValidValue(userId, null, null, element.getGUID(), null, false, false, null, "clearValidMetadataMapName");
                } else {
                    this.invalidParameterHandler.throwUnknownElementQualifiedName(userId, OpenMetadataValidValues.constructValidValueQualifiedName((String)typeName, (String)propertyName, null, (String)preferredValue), typeName, instanceHandler.getServiceName(serviceURLMarker), serverName, "clearValidMetadataMapName");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearValidMetadataMapName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearValidMetadataMapName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearValidMetadataMapValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String mapName, String preferredValue, NullRequestBody requestBody) {
        String methodName = "clearValidMetadataMapValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearValidMetadataMapValue");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearValidMetadataMapValue");
            if (requestBody != null) {
                this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataMapValue");
                this.invalidParameterHandler.validateName(preferredValue, "preferredValue", "clearValidMetadataMapValue");
                ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "clearValidMetadataMapValue");
                String qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)typeName, (String)propertyName, (String)mapName, (String)preferredValue);
                EntityDetail element = this.getValidMetadataElement(userId, typeName, propertyName, mapName, preferredValue, handler, "clearValidMetadataMapValue");
                if (element != null) {
                    handler.deleteValidValue(userId, null, null, element.getGUID(), null, false, false, null, "clearValidMetadataMapValue");
                } else {
                    this.invalidParameterHandler.throwUnknownElementQualifiedName(userId, qualifiedName, typeName, instanceHandler.getServiceName(serviceURLMarker), serverName, "clearValidMetadataMapValue");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearValidMetadataMapValue", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearValidMetadataMapValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public BooleanResponse validateMetadataValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String actualValue) {
        String methodName = "validateMetadataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "validateMetadataValue");
        AuditLog auditLog = null;
        BooleanResponse response = new BooleanResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateMetadataValue");
            this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataValue");
            this.invalidParameterHandler.validateName(actualValue, "actualValue", "validateMetadataValue");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "validateMetadataValue");
            EntityDetail element = this.getValidMetadataElement(userId, typeName, propertyName, null, actualValue, handler, "validateMetadataValue");
            response.setFlag(false);
            if (element != null) {
                response.setFlag(true);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "validateMetadataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public BooleanResponse validateMetadataMapName(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String actualValue) {
        String methodName = "validateMetadataMapName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "validateMetadataMapName");
        AuditLog auditLog = null;
        BooleanResponse response = new BooleanResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateMetadataMapName");
            this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataMapName");
            this.invalidParameterHandler.validateName(actualValue, "actualValue", "validateMetadataMapName");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "validateMetadataMapName");
            EntityDetail element = this.getValidMetadataElement(userId, typeName, propertyName, actualValue, null, handler, "validateMetadataMapName");
            response.setFlag(false);
            if (element != null) {
                response.setFlag(true);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "validateMetadataMapName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public BooleanResponse validateMetadataMapValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String mapName, String actualValue) {
        String methodName = "validateMetadataMapValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "validateMetadataMapValue");
        AuditLog auditLog = null;
        BooleanResponse response = new BooleanResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateMetadataMapValue");
            this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataMapValue");
            this.invalidParameterHandler.validateName(actualValue, "actualValue", "validateMetadataMapValue");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "validateMetadataMapValue");
            EntityDetail element = this.getValidMetadataElement(userId, typeName, propertyName, mapName, actualValue, handler, "validateMetadataMapValue");
            response.setFlag(false);
            if (element != null) {
                response.setFlag(true);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "validateMetadataMapValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidMetadataValueResponse getValidMetadataValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String preferredValue) {
        String methodName = "getValidMetadataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidMetadataValue");
        AuditLog auditLog = null;
        ValidMetadataValueResponse response = new ValidMetadataValueResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidMetadataValue");
            this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataValue");
            this.invalidParameterHandler.validateName(preferredValue, "preferredValue", "getValidMetadataValue");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "getValidMetadataValue");
            String qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)typeName, (String)propertyName, null, (String)preferredValue);
            ValidMetadataValue element = this.getValidMetadataBean(userId, typeName, propertyName, null, preferredValue, handler, "getValidMetadataValue");
            if (element != null) {
                response.setElement(element);
            } else {
                this.invalidParameterHandler.throwUnknownElementQualifiedName(userId, qualifiedName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, instanceHandler.getServiceName(serviceURLMarker), serverName, "getValidMetadataValue");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidMetadataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidMetadataValueResponse getValidMetadataMapName(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String preferredValue) {
        String methodName = "getValidMetadataMapName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidMetadataMapName");
        AuditLog auditLog = null;
        ValidMetadataValueResponse response = new ValidMetadataValueResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidMetadataMapName");
            this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataMapName");
            this.invalidParameterHandler.validateName(preferredValue, "preferredValue", "getValidMetadataMapName");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "getValidMetadataMapName");
            response.setElement(this.getValidMetadataBean(userId, typeName, propertyName, preferredValue, null, handler, "getValidMetadataMapName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidMetadataMapName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidMetadataValueResponse getValidMetadataMapValue(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String mapName, String preferredValue) {
        String methodName = "getValidMetadataMapValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidMetadataMapValue");
        AuditLog auditLog = null;
        ValidMetadataValueResponse response = new ValidMetadataValueResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidMetadataMapValue");
            this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataMapValue");
            this.invalidParameterHandler.validateName(preferredValue, "preferredValue", "getValidMetadataMapValue");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "getValidMetadataMapValue");
            response.setElement(this.getValidMetadataBean(userId, typeName, propertyName, mapName, preferredValue, handler, "getValidMetadataMapValue"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidMetadataMapValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidMetadataValueDetailListResponse getValidMetadataValues(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, int startFrom, int pageSize) {
        String methodName = "getValidMetadataValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidMetadataValues");
        AuditLog auditLog = null;
        ValidMetadataValueDetailListResponse response = new ValidMetadataValueDetailListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidMetadataValues");
            this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataValues");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "getValidMetadataValues");
            EntityDetail element = this.getValidMetadataElement(userId, typeName, propertyName, null, null, handler, "getValidMetadataValues");
            if (element != null) {
                ValidValuesHandler<ValidMetadataValueDetail> detailsHandler = instanceHandler.getValidMetadataValuesDetailHandler(userId, serverName, "getValidMetadataValues");
                List details = detailsHandler.getValidValueSetMembers(userId, element.getGUID(), "element.getGUID", startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getValidMetadataValues"), null, "getValidMetadataValues");
                if (details != null) {
                    for (ValidMetadataValueDetail detail : details) {
                        EntityDetail detailElement = this.getValidMetadataElement(userId, typeName, propertyName, null, detail.getPreferredValue(), handler, "getValidMetadataValues");
                        if (detailElement == null) {
                            detailElement = this.getValidMetadataElement(userId, typeName, propertyName, detail.getPreferredValue(), null, handler, "getValidMetadataValues");
                        }
                        if (detailElement == null) continue;
                        List mapDetails = handler.getValidValueSetMembers(userId, detailElement.getGUID(), "element.getGUID", 0, 0, false, false, null, null, "getValidMetadataValues");
                        detail.setValidMapNameValues(mapDetails);
                    }
                }
                response.setElementList(details);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidMetadataValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidMetadataValueListResponse getConsistentMetadataValues(String serverName, String serviceURLMarker, String userId, String typeName, String propertyName, String mapName, String preferredValue, int startFrom, int pageSize) {
        String methodName = "getConsistentMetadataValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConsistentMetadataValues");
        AuditLog auditLog = null;
        ValidMetadataValueListResponse response = new ValidMetadataValueListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConsistentMetadataValues");
            this.invalidParameterHandler.validateName(propertyName, "propertyName", "getConsistentMetadataValues");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "getConsistentMetadataValues");
            EntityDetail element = this.getValidMetadataElement(userId, typeName, propertyName, mapName, preferredValue, handler, "getConsistentMetadataValues");
            if (element != null) {
                List details = handler.getConsistentValidValues(userId, element.getGUID(), "element.getGUID", startFrom, pageSize, false, false, null, null, "getConsistentMetadataValues");
                response.setElementList(details);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConsistentMetadataValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setConsistentMetadataValues(String serverName, String serviceURLMarker, String userId, String typeName1, String propertyName1, String mapName1, String preferredValue1, String typeName2, String propertyName2, String mapName2, String preferredValue2, NullRequestBody requestBody) {
        String methodName = "setConsistentMetadataValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setConsistentMetadataValues");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            EntityDetail element2;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setConsistentMetadataValues");
            this.invalidParameterHandler.validateName(propertyName1, "propertyName", "setConsistentMetadataValues");
            ValidValuesHandler<ValidMetadataValue> handler = instanceHandler.getValidMetadataValuesHandler(userId, serverName, "setConsistentMetadataValues");
            EntityDetail element1 = this.getValidMetadataElement(userId, typeName1, propertyName1, mapName1, preferredValue1, handler, "setConsistentMetadataValues");
            if (element1 == null) {
                this.invalidParameterHandler.throwUnknownElementQualifiedName(userId, OpenMetadataValidValues.constructValidValueQualifiedName((String)typeName1, (String)propertyName1, (String)mapName1, (String)preferredValue1), OpenMetadataType.VALID_VALUE_DEFINITION.typeName, instanceHandler.getServiceName(serviceURLMarker), serverName, "setConsistentMetadataValues");
            }
            if ((element2 = this.getValidMetadataElement(userId, typeName2, propertyName2, mapName2, preferredValue2, handler, "setConsistentMetadataValues")) == null) {
                this.invalidParameterHandler.throwUnknownElementQualifiedName(userId, OpenMetadataValidValues.constructValidValueQualifiedName((String)typeName2, (String)propertyName2, (String)mapName2, (String)preferredValue2), OpenMetadataType.VALID_VALUE_DEFINITION.typeName, instanceHandler.getServiceName(serviceURLMarker), serverName, "setConsistentMetadataValues");
            }
            handler.attachConsistentValidValues(userId, null, null, element1.getGUID(), element2.getGUID(), null, null, null, false, false, null, "setConsistentMetadataValues");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setConsistentMetadataValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private OpenMetadataTypeDef getTypeDef(TypeDef typeDef) {
        if (typeDef != null) {
            OpenMetadataEntityDef openMetadataTypeDef;
            if (typeDef instanceof EntityDef) {
                openMetadataTypeDef = new OpenMetadataEntityDef();
                openMetadataTypeDef.setCategory(OpenMetadataTypeDefCategory.ENTITY_DEF);
            } else if (typeDef instanceof RelationshipDef) {
                RelationshipDef relationshipDef = (RelationshipDef)typeDef;
                OpenMetadataRelationshipDef openMetadataRelationshipDef = new OpenMetadataRelationshipDef();
                openMetadataRelationshipDef.setPropagationRule(this.getPropagationRule(relationshipDef.getPropagationRule()));
                openMetadataRelationshipDef.setEndDef1(this.getRelationshipEndDef(relationshipDef.getEndDef1()));
                openMetadataRelationshipDef.setEndDef2(this.getRelationshipEndDef(relationshipDef.getEndDef2()));
                openMetadataRelationshipDef.setMultiLink(relationshipDef.getMultiLink());
                openMetadataTypeDef = openMetadataRelationshipDef;
                openMetadataTypeDef.setCategory(OpenMetadataTypeDefCategory.RELATIONSHIP_DEF);
            } else if (typeDef instanceof ClassificationDef) {
                ClassificationDef classificationDef = (ClassificationDef)typeDef;
                OpenMetadataClassificationDef openMetadataClassificationDef = new OpenMetadataClassificationDef();
                openMetadataClassificationDef.setValidEntityDefs(this.getTypeDefLinks(classificationDef.getValidEntityDefs()));
                openMetadataClassificationDef.setPropagatable(classificationDef.isPropagatable());
                openMetadataTypeDef = openMetadataClassificationDef;
                openMetadataTypeDef.setCategory(OpenMetadataTypeDefCategory.CLASSIFICATION_DEF);
            } else {
                return null;
            }
            openMetadataTypeDef.setGUID(typeDef.getGUID());
            openMetadataTypeDef.setName(typeDef.getName());
            openMetadataTypeDef.setStatus(this.getTypeDefStatus(typeDef.getStatus()));
            openMetadataTypeDef.setReplacedByTypeGUID(typeDef.getReplacedByTypeGUID());
            openMetadataTypeDef.setReplacedByTypeName(typeDef.getReplacedByTypeName());
            openMetadataTypeDef.setVersionName(typeDef.getVersionName());
            openMetadataTypeDef.setVersion(typeDef.getVersion());
            openMetadataTypeDef.setSuperType(this.getTypeDefLink(typeDef.getSuperType()));
            openMetadataTypeDef.setDescription(typeDef.getDescription());
            openMetadataTypeDef.setDescriptionGUID(typeDef.getDescriptionGUID());
            openMetadataTypeDef.setDescriptionWiki(typeDef.getDescriptionWiki());
            openMetadataTypeDef.setOrigin(typeDef.getOrigin());
            openMetadataTypeDef.setCreatedBy(typeDef.getCreatedBy());
            openMetadataTypeDef.setUpdatedBy(typeDef.getUpdatedBy());
            openMetadataTypeDef.setCreateTime(typeDef.getCreateTime());
            openMetadataTypeDef.setUpdateTime(typeDef.getUpdateTime());
            openMetadataTypeDef.setOptions(typeDef.getOptions());
            openMetadataTypeDef.setExternalStandardMappings(this.getExternalStandardMappings(typeDef.getExternalStandardMappings()));
            openMetadataTypeDef.setValidElementStatusList(this.getElementStatuses(typeDef.getValidInstanceStatusList()));
            openMetadataTypeDef.setAttributeDefinitions(this.getTypeDefAttributes(typeDef.getPropertiesDefinition()));
            openMetadataTypeDef.setInitialStatus(this.getElementStatus(typeDef.getInitialStatus()));
            return openMetadataTypeDef;
        }
        return null;
    }

    private List<OpenMetadataTypeDefAttribute> getTypeDefAttributes(List<TypeDefAttribute> typeDefAttributes) {
        if (typeDefAttributes != null) {
            ArrayList<OpenMetadataTypeDefAttribute> externalStandardTypeMappings = new ArrayList<OpenMetadataTypeDefAttribute>();
            for (TypeDefAttribute typeDefAttribute : typeDefAttributes) {
                externalStandardTypeMappings.add(this.getTypeDefAttribute(typeDefAttribute));
            }
            if (!externalStandardTypeMappings.isEmpty()) {
                return externalStandardTypeMappings;
            }
        }
        return null;
    }

    private OpenMetadataTypeDefAttribute getTypeDefAttribute(TypeDefAttribute typeDefAttribute) {
        if (typeDefAttribute != null) {
            OpenMetadataTypeDefAttribute openMetadataTypeDefAttribute = new OpenMetadataTypeDefAttribute();
            openMetadataTypeDefAttribute.setAttributeName(typeDefAttribute.getAttributeName());
            openMetadataTypeDefAttribute.setAttributeType(this.getAttributeTypeDef(typeDefAttribute.getAttributeType()));
            openMetadataTypeDefAttribute.setAttributeStatus(this.getAttributeStatus(typeDefAttribute.getAttributeStatus()));
            openMetadataTypeDefAttribute.setReplacedByAttribute(typeDefAttribute.getReplacedByAttribute());
            openMetadataTypeDefAttribute.setAttributeDescription(typeDefAttribute.getAttributeDescription());
            openMetadataTypeDefAttribute.setAttributeDescriptionGUID(typeDefAttribute.getAttributeDescriptionGUID());
            openMetadataTypeDefAttribute.setAttributeCardinality(this.getAttributeCardinality(typeDefAttribute.getAttributeCardinality()));
            openMetadataTypeDefAttribute.setValuesMinCount(typeDefAttribute.getValuesMinCount());
            openMetadataTypeDefAttribute.setValuesMaxCount(typeDefAttribute.getValuesMaxCount());
            openMetadataTypeDefAttribute.setUnique(typeDefAttribute.isUnique());
            openMetadataTypeDefAttribute.setIndexable(typeDefAttribute.isIndexable());
            openMetadataTypeDefAttribute.setDefaultValue(typeDefAttribute.getDefaultValue());
            openMetadataTypeDefAttribute.setExternalStandardMappings(this.getExternalStandardMappings(typeDefAttribute.getExternalStandardMappings()));
            return openMetadataTypeDefAttribute;
        }
        return null;
    }

    private OpenMetadataAttributeCardinality getAttributeCardinality(AttributeCardinality attributeCardinality) {
        if (attributeCardinality != null) {
            switch (attributeCardinality) {
                case UNKNOWN: {
                    return OpenMetadataAttributeCardinality.UNKNOWN;
                }
                case AT_MOST_ONE: {
                    return OpenMetadataAttributeCardinality.AT_MOST_ONE;
                }
                case ONE_ONLY: {
                    return OpenMetadataAttributeCardinality.ONE_ONLY;
                }
                case AT_LEAST_ONE_ORDERED: {
                    return OpenMetadataAttributeCardinality.AT_LEAST_ONE_ORDERED;
                }
                case AT_LEAST_ONE_UNORDERED: {
                    return OpenMetadataAttributeCardinality.AT_LEAST_ONE_UNORDERED;
                }
                case ANY_NUMBER_ORDERED: {
                    return OpenMetadataAttributeCardinality.ANY_NUMBER_ORDERED;
                }
                case ANY_NUMBER_UNORDERED: {
                    return OpenMetadataAttributeCardinality.ANY_NUMBER_UNORDERED;
                }
            }
        }
        return OpenMetadataAttributeCardinality.UNKNOWN;
    }

    private OpenMetadataTypeDefAttributeStatus getAttributeStatus(TypeDefAttributeStatus typeDefAttributeStatus) {
        if (typeDefAttributeStatus != null) {
            switch (typeDefAttributeStatus) {
                case ACTIVE_ATTRIBUTE: {
                    return OpenMetadataTypeDefAttributeStatus.ACTIVE_ATTRIBUTE;
                }
                case RENAMED_ATTRIBUTE: {
                    return OpenMetadataTypeDefAttributeStatus.RENAMED_ATTRIBUTE;
                }
                case DEPRECATED_ATTRIBUTE: {
                    return OpenMetadataTypeDefAttributeStatus.DEPRECATED_ATTRIBUTE;
                }
            }
        }
        return null;
    }

    private List<ExternalStandardTypeMapping> getExternalStandardMappings(List<ExternalStandardMapping> externalStandardMappings) {
        if (externalStandardMappings != null) {
            ArrayList<ExternalStandardTypeMapping> externalStandardTypeMappings = new ArrayList<ExternalStandardTypeMapping>();
            for (ExternalStandardMapping externalStandardMapping : externalStandardMappings) {
                externalStandardTypeMappings.add(this.getExternalStandardMapping(externalStandardMapping));
            }
            if (!externalStandardTypeMappings.isEmpty()) {
                return externalStandardTypeMappings;
            }
        }
        return null;
    }

    private ExternalStandardTypeMapping getExternalStandardMapping(ExternalStandardMapping externalStandardMapping) {
        if (externalStandardMapping != null) {
            ExternalStandardTypeMapping externalStandardTypeMapping = new ExternalStandardTypeMapping();
            externalStandardTypeMapping.setStandardName(externalStandardMapping.getStandardName());
            externalStandardTypeMapping.setStandardOrganization(externalStandardMapping.getStandardOrganization());
            externalStandardTypeMapping.setStandardTypeName(externalStandardMapping.getStandardTypeName());
            return externalStandardTypeMapping;
        }
        return null;
    }

    private List<ElementStatus> getElementStatuses(List<InstanceStatus> instanceStatusList) {
        if (instanceStatusList != null) {
            ArrayList<ElementStatus> elementStatusList = new ArrayList<ElementStatus>();
            for (InstanceStatus instanceStatus : instanceStatusList) {
                elementStatusList.add(this.getElementStatus(instanceStatus));
            }
            if (!elementStatusList.isEmpty()) {
                return elementStatusList;
            }
        }
        return null;
    }

    protected ElementStatus getElementStatus(InstanceStatus instanceStatus) {
        if (instanceStatus != null) {
            switch (instanceStatus) {
                case UNKNOWN: {
                    return ElementStatus.UNKNOWN;
                }
                case DRAFT: {
                    return ElementStatus.DRAFT;
                }
                case PREPARED: {
                    return ElementStatus.PREPARED;
                }
                case PROPOSED: {
                    return ElementStatus.PROPOSED;
                }
                case APPROVED: {
                    return ElementStatus.APPROVED;
                }
                case REJECTED: {
                    return ElementStatus.REJECTED;
                }
                case APPROVED_CONCEPT: {
                    return ElementStatus.APPROVED_CONCEPT;
                }
                case UNDER_DEVELOPMENT: {
                    return ElementStatus.UNDER_DEVELOPMENT;
                }
                case DEVELOPMENT_COMPLETE: {
                    return ElementStatus.DEVELOPMENT_COMPLETE;
                }
                case APPROVED_FOR_DEPLOYMENT: {
                    return ElementStatus.APPROVED_FOR_DEPLOYMENT;
                }
                case STANDBY: {
                    return ElementStatus.STANDBY;
                }
                case ACTIVE: {
                    return ElementStatus.ACTIVE;
                }
                case FAILED: {
                    return ElementStatus.FAILED;
                }
                case DISABLED: {
                    return ElementStatus.DISABLED;
                }
                case COMPLETE: {
                    return ElementStatus.COMPLETE;
                }
                case DEPRECATED: {
                    return ElementStatus.DEPRECATED;
                }
                case DELETED: {
                    return ElementStatus.DELETED;
                }
                case OTHER: {
                    return ElementStatus.OTHER;
                }
            }
        }
        return ElementStatus.UNKNOWN;
    }

    private List<OpenMetadataTypeDef> getTypeDefs(List<TypeDef> typeDefs) {
        if (typeDefs != null) {
            ArrayList<OpenMetadataTypeDef> openMetadataTypeDefs = new ArrayList<OpenMetadataTypeDef>();
            for (TypeDef typeDef : typeDefs) {
                openMetadataTypeDefs.add(this.getTypeDef(typeDef));
            }
            if (!openMetadataTypeDefs.isEmpty()) {
                return openMetadataTypeDefs;
            }
        }
        return null;
    }

    private OpenMetadataClassificationPropagationRule getPropagationRule(ClassificationPropagationRule propagationRule) {
        if (propagationRule != null) {
            switch (propagationRule) {
                case NONE: {
                    return OpenMetadataClassificationPropagationRule.NONE;
                }
                case ONE_TO_TWO: {
                    return OpenMetadataClassificationPropagationRule.ONE_TO_TWO;
                }
                case TWO_TO_ONE: {
                    return OpenMetadataClassificationPropagationRule.TWO_TO_ONE;
                }
                case BOTH: {
                    return OpenMetadataClassificationPropagationRule.BOTH;
                }
            }
        }
        return OpenMetadataClassificationPropagationRule.NONE;
    }

    private OpenMetadataRelationshipEndDef getRelationshipEndDef(RelationshipEndDef relationshipEndDef) {
        if (relationshipEndDef != null) {
            OpenMetadataRelationshipEndDef openMetadataRelationshipEndDef = new OpenMetadataRelationshipEndDef();
            openMetadataRelationshipEndDef.setEntityType(this.getTypeDefLink(relationshipEndDef.getEntityType()));
            openMetadataRelationshipEndDef.setAttributeName(relationshipEndDef.getAttributeName());
            openMetadataRelationshipEndDef.setAttributeCardinality(this.getRelationshipEndCardinality(relationshipEndDef.getAttributeCardinality()));
            openMetadataRelationshipEndDef.setAttributeDescription(relationshipEndDef.getAttributeDescription());
            openMetadataRelationshipEndDef.setAttributeDescriptionGUID(relationshipEndDef.getAttributeDescriptionGUID());
            return openMetadataRelationshipEndDef;
        }
        return null;
    }

    private List<OpenMetadataTypeDefLink> getTypeDefLinks(List<TypeDefLink> typeDefLinks) {
        if (typeDefLinks != null) {
            ArrayList<OpenMetadataTypeDefLink> openMetadataTypeDefs = new ArrayList<OpenMetadataTypeDefLink>();
            for (TypeDefLink typeDefLink : typeDefLinks) {
                openMetadataTypeDefs.add(this.getTypeDefLink(typeDefLink));
            }
            if (!openMetadataTypeDefs.isEmpty()) {
                return openMetadataTypeDefs;
            }
        }
        return null;
    }

    private OpenMetadataTypeDefLink getTypeDefLink(TypeDefLink typeDefLink) {
        if (typeDefLink != null) {
            OpenMetadataTypeDefLink openMetadataTypeDefLink = new OpenMetadataTypeDefLink();
            openMetadataTypeDefLink.setGUID(typeDefLink.getGUID());
            openMetadataTypeDefLink.setName(typeDefLink.getName());
            openMetadataTypeDefLink.setStatus(this.getTypeDefStatus(typeDefLink.getStatus()));
            openMetadataTypeDefLink.setReplacedByTypeGUID(typeDefLink.getReplacedByTypeGUID());
            openMetadataTypeDefLink.setReplacedByTypeName(typeDefLink.getReplacedByTypeName());
            return openMetadataTypeDefLink;
        }
        return null;
    }

    private OpenMetadataTypeDefStatus getTypeDefStatus(TypeDefStatus typeDefStatus) {
        if (typeDefStatus != null) {
            switch (typeDefStatus) {
                case ACTIVE_TYPEDEF: {
                    return OpenMetadataTypeDefStatus.ACTIVE_TYPEDEF;
                }
                case RENAMED_TYPEDEF: {
                    return OpenMetadataTypeDefStatus.RENAMED_TYPEDEF;
                }
                case DEPRECATED_TYPEDEF: {
                    return OpenMetadataTypeDefStatus.DEPRECATED_TYPEDEF;
                }
            }
        }
        return null;
    }

    private OpenMetadataRelationshipEndCardinality getRelationshipEndCardinality(RelationshipEndCardinality relationshipEndCardinality) {
        if (relationshipEndCardinality != null) {
            switch (relationshipEndCardinality) {
                case UNKNOWN: {
                    return OpenMetadataRelationshipEndCardinality.UNKNOWN;
                }
                case ANY_NUMBER: {
                    return OpenMetadataRelationshipEndCardinality.ANY_NUMBER;
                }
                case AT_MOST_ONE: {
                    return OpenMetadataRelationshipEndCardinality.AT_MOST_ONE;
                }
            }
        }
        return OpenMetadataRelationshipEndCardinality.UNKNOWN;
    }

    private OpenMetadataAttributeTypeDef getAttributeTypeDef(AttributeTypeDef attributeTypeDef) {
        if (attributeTypeDef != null) {
            OpenMetadataPrimitiveDef openMetadataAttributeTypeDef;
            if (attributeTypeDef instanceof PrimitiveDef) {
                PrimitiveDef primitiveDef = (PrimitiveDef)attributeTypeDef;
                OpenMetadataPrimitiveDef openMetadataPrimitiveDef = new OpenMetadataPrimitiveDef();
                openMetadataPrimitiveDef.setPrimitiveDefCategory(this.getPrimitiveDefCategory(primitiveDef.getPrimitiveDefCategory()));
                openMetadataAttributeTypeDef = openMetadataPrimitiveDef;
                openMetadataAttributeTypeDef.setCategory(OpenMetadataAttributeTypeDefCategory.PRIMITIVE);
            } else if (attributeTypeDef instanceof CollectionDef) {
                CollectionDef collectionDef = (CollectionDef)attributeTypeDef;
                OpenMetadataCollectionDef openMetadataCollectionDef = new OpenMetadataCollectionDef();
                openMetadataCollectionDef.setCollectionDefCategory(this.getCollectionDefCategory(collectionDef.getCollectionDefCategory()));
                openMetadataCollectionDef.setArgumentCount(collectionDef.getArgumentCount());
                if (collectionDef.getArgumentTypes() != null) {
                    ArrayList<OpenMetadataPrimitiveDefCategory> argumentTypes = new ArrayList<OpenMetadataPrimitiveDefCategory>();
                    for (PrimitiveDefCategory argumentType : collectionDef.getArgumentTypes()) {
                        argumentTypes.add(this.getPrimitiveDefCategory(argumentType));
                    }
                    if (!argumentTypes.isEmpty()) {
                        openMetadataCollectionDef.setArgumentTypes(argumentTypes);
                    }
                }
                openMetadataAttributeTypeDef = openMetadataCollectionDef;
                openMetadataAttributeTypeDef.setCategory(OpenMetadataAttributeTypeDefCategory.COLLECTION);
            } else if (attributeTypeDef instanceof EnumDef) {
                EnumDef enumDef = (EnumDef)attributeTypeDef;
                OpenMetadataEnumDef openMetadataEnumDef = new OpenMetadataEnumDef();
                openMetadataEnumDef.setElementDefs(this.getEnumElementDefs(enumDef.getElementDefs()));
                openMetadataEnumDef.setDefaultValue(this.getEnumElementDef(enumDef.getDefaultValue()));
                openMetadataAttributeTypeDef = openMetadataEnumDef;
                openMetadataAttributeTypeDef.setCategory(OpenMetadataAttributeTypeDefCategory.ENUM_DEF);
            } else {
                return null;
            }
            openMetadataAttributeTypeDef.setGUID(attributeTypeDef.getGUID());
            openMetadataAttributeTypeDef.setName(attributeTypeDef.getName());
            openMetadataAttributeTypeDef.setDescription(attributeTypeDef.getDescription());
            openMetadataAttributeTypeDef.setDescriptionGUID(attributeTypeDef.getDescriptionGUID());
            openMetadataAttributeTypeDef.setVersion(attributeTypeDef.getVersion());
            openMetadataAttributeTypeDef.setVersionName(attributeTypeDef.getVersionName());
            return openMetadataAttributeTypeDef;
        }
        return null;
    }

    private List<OpenMetadataEnumElementDef> getEnumElementDefs(List<EnumElementDef> enumElementDefs) {
        if (enumElementDefs != null) {
            ArrayList<OpenMetadataEnumElementDef> openMetadataEnumElementDefs = new ArrayList<OpenMetadataEnumElementDef>();
            for (EnumElementDef enumElementDef : enumElementDefs) {
                if (enumElementDef == null) continue;
                openMetadataEnumElementDefs.add(this.getEnumElementDef(enumElementDef));
            }
            if (!openMetadataEnumElementDefs.isEmpty()) {
                return openMetadataEnumElementDefs;
            }
        }
        return null;
    }

    private OpenMetadataEnumElementDef getEnumElementDef(EnumElementDef enumElementDef) {
        if (enumElementDef != null) {
            OpenMetadataEnumElementDef openMetadataEnumElementDef = new OpenMetadataEnumElementDef();
            openMetadataEnumElementDef.setOrdinal(enumElementDef.getOrdinal());
            openMetadataEnumElementDef.setValue(enumElementDef.getValue());
            openMetadataEnumElementDef.setDescription(enumElementDef.getDescription());
            openMetadataEnumElementDef.setDescriptionGUID(enumElementDef.getDescriptionGUID());
            return openMetadataEnumElementDef;
        }
        return null;
    }

    private OpenMetadataPrimitiveDefCategory getPrimitiveDefCategory(PrimitiveDefCategory primitiveDefCategory) {
        if (primitiveDefCategory != null) {
            switch (primitiveDefCategory) {
                case OM_PRIMITIVE_TYPE_UNKNOWN: {
                    return OpenMetadataPrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                }
                case OM_PRIMITIVE_TYPE_BOOLEAN: {
                    return OpenMetadataPrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN;
                }
                case OM_PRIMITIVE_TYPE_BYTE: {
                    return OpenMetadataPrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE;
                }
                case OM_PRIMITIVE_TYPE_CHAR: {
                    return OpenMetadataPrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR;
                }
                case OM_PRIMITIVE_TYPE_SHORT: {
                    return OpenMetadataPrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT;
                }
                case OM_PRIMITIVE_TYPE_INT: {
                    return OpenMetadataPrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT;
                }
                case OM_PRIMITIVE_TYPE_LONG: {
                    return OpenMetadataPrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG;
                }
                case OM_PRIMITIVE_TYPE_FLOAT: {
                    return OpenMetadataPrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT;
                }
                case OM_PRIMITIVE_TYPE_DOUBLE: {
                    return OpenMetadataPrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE;
                }
                case OM_PRIMITIVE_TYPE_BIGINTEGER: {
                    return OpenMetadataPrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER;
                }
                case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                    return OpenMetadataPrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL;
                }
                case OM_PRIMITIVE_TYPE_STRING: {
                    return OpenMetadataPrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING;
                }
                case OM_PRIMITIVE_TYPE_DATE: {
                    return OpenMetadataPrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE;
                }
            }
        }
        return null;
    }

    private OpenMetadataCollectionDefCategory getCollectionDefCategory(CollectionDefCategory collectionDefCategory) {
        if (collectionDefCategory != null) {
            switch (collectionDefCategory) {
                case OM_COLLECTION_UNKNOWN: {
                    return OpenMetadataCollectionDefCategory.OM_COLLECTION_UNKNOWN;
                }
                case OM_COLLECTION_MAP: {
                    return OpenMetadataCollectionDefCategory.OM_COLLECTION_MAP;
                }
                case OM_COLLECTION_ARRAY: {
                    return OpenMetadataCollectionDefCategory.OM_COLLECTION_ARRAY;
                }
                case OM_COLLECTION_STRUCT: {
                    return OpenMetadataCollectionDefCategory.OM_COLLECTION_STRUCT;
                }
            }
        }
        return null;
    }

    private List<OpenMetadataAttributeTypeDef> getAttributeTypeDefs(List<AttributeTypeDef> attributeTypeDefs) {
        if (attributeTypeDefs != null) {
            ArrayList<OpenMetadataAttributeTypeDef> openMetadataAttributeTypeDefs = new ArrayList<OpenMetadataAttributeTypeDef>();
            for (AttributeTypeDef attributeTypeDef : attributeTypeDefs) {
                openMetadataAttributeTypeDefs.add(this.getAttributeTypeDef(attributeTypeDef));
            }
            if (!openMetadataAttributeTypeDefs.isEmpty()) {
                return openMetadataAttributeTypeDefs;
            }
        }
        return null;
    }
}

