/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessStepElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessStepProperties;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworkservices.omf.converters.OpenMetadataStoreConverter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceActionProcessStepConverter<B>
extends OpenMetadataStoreConverter<B> {
    public GovernanceActionProcessStepConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, null, methodName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof GovernanceActionProcessStepElement) {
                InstanceProperties instanceProperties;
                GovernanceActionProcessStepElement bean = (GovernanceActionProcessStepElement)returnBean;
                GovernanceActionProcessStepProperties actionTypeProperties = new GovernanceActionProcessStepProperties();
                if (entity != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                    instanceProperties = new InstanceProperties(entity.getProperties());
                    actionTypeProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    actionTypeProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    actionTypeProperties.setDomainIdentifier(this.removeDomainIdentifier(instanceProperties));
                    actionTypeProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    actionTypeProperties.setDescription(this.removeDescription(instanceProperties));
                    actionTypeProperties.setIgnoreMultipleTriggers(this.removeIgnoreMultipleTriggers(instanceProperties));
                    actionTypeProperties.setWaitTime(this.removeWaitTime(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                if (relationship != null) {
                    instanceProperties = new InstanceProperties(relationship.getProperties());
                    actionTypeProperties.setRequestType(this.removeRequestType(instanceProperties));
                    actionTypeProperties.setFixedRequestParameters(this.removeRequestParameters(instanceProperties));
                    EntityProxy entityProxy = relationship.getEntityTwoProxy();
                    if (entityProxy != null) {
                        actionTypeProperties.setGovernanceEngineGUID(entityProxy.getGUID());
                    }
                }
                bean.setProcessStepProperties(actionTypeProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

