/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationGroupElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationGroupProperties;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class IntegrationGroupConverter<B>
extends OMFConverter<B> {
    public IntegrationGroupConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof IntegrationGroupElement) {
                IntegrationGroupElement bean = (IntegrationGroupElement)returnBean;
                IntegrationGroupProperties properties = new IntegrationGroupProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                InstanceProperties instanceProperties = null;
                if (entity != null) {
                    instanceProperties = new InstanceProperties(entity.getProperties());
                }
                properties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                properties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                properties.setDisplayName(this.removeName(instanceProperties));
                properties.setDescription(this.removeDescription(instanceProperties));
                properties.setVersion(this.removeCapabilityVersion(instanceProperties));
                properties.setPatchLevel(this.removePatchLevel(instanceProperties));
                properties.setSource(this.removeSource(instanceProperties));
                bean.setProperties(properties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

