/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.converters;

import java.util.Map;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.frameworkservices.omf.converters.OpenMetadataStoreConverter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OpenGovernanceConverterBase<B>
extends OpenMetadataStoreConverter<B> {
    private static final Logger log = LoggerFactory.getLogger(OpenGovernanceConverterBase.class);

    protected OpenGovernanceConverterBase(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    protected EngineActionStatus removeActionStatus(String propertyName, InstanceProperties properties) {
        EngineActionStatus actionStatus = this.getActionStatus(propertyName, properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove(propertyName);
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return actionStatus;
    }

    private EngineActionStatus getActionStatus(String propertyName, InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        EngineActionStatus engineActionStatus = EngineActionStatus.OTHER;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get(propertyName)) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            engineActionStatus = switch (enumPropertyValue.getOrdinal()) {
                case 0 -> EngineActionStatus.REQUESTED;
                case 1 -> EngineActionStatus.APPROVED;
                case 2 -> EngineActionStatus.WAITING;
                case 3 -> EngineActionStatus.ACTIVATING;
                case 4 -> EngineActionStatus.IN_PROGRESS;
                case 10 -> EngineActionStatus.ACTIONED;
                case 11 -> EngineActionStatus.INVALID;
                case 12 -> EngineActionStatus.IGNORED;
                case 13 -> EngineActionStatus.FAILED;
                case 14 -> EngineActionStatus.CANCELLED;
                default -> engineActionStatus;
            };
        }
        return engineActionStatus;
    }
}

