/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.converters;

import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationConnectorElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredIntegrationConnectorElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredIntegrationConnectorProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RegisteredIntegrationConnectorConverter {
    private final OMRSRepositoryHelper repositoryHelper;
    private final String serviceName;

    public RegisteredIntegrationConnectorConverter(OMRSRepositoryHelper repositoryHelper, String serviceName) {
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
    }

    public RegisteredIntegrationConnectorElement getBean(IntegrationConnectorElement integrationConnector, Relationship registrationRelationship) {
        InstanceProperties instanceProperties;
        String methodName = "getBean";
        RegisteredIntegrationConnectorElement bean = new RegisteredIntegrationConnectorElement(integrationConnector);
        if (registrationRelationship != null && (instanceProperties = registrationRelationship.getProperties()) != null) {
            RegisteredIntegrationConnectorProperties registrationProperties = new RegisteredIntegrationConnectorProperties();
            bean.setConnectorId(registrationRelationship.getGUID());
            registrationProperties.setConnectorName(this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.CONNECTOR_NAME.name, instanceProperties, "getBean"));
            registrationProperties.setConnectorUserId(this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.CONNECTOR_USER_ID.name, instanceProperties, "getBean"));
            registrationProperties.setMetadataSourceQualifiedName(this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.METADATA_SOURCE_QUALIFIED_NAME.name, instanceProperties, "getBean"));
            registrationProperties.setStartDate(this.repositoryHelper.getDateProperty(this.serviceName, OpenMetadataProperty.START_DATE.name, instanceProperties, "getBean"));
            registrationProperties.setRefreshTimeInterval(this.repositoryHelper.getLongProperty(this.serviceName, OpenMetadataProperty.REFRESH_TIME_INTERVAL.name, instanceProperties, "getBean"));
            registrationProperties.setStopDate(this.repositoryHelper.getDateProperty(this.serviceName, OpenMetadataProperty.STOP_DATE.name, instanceProperties, "getBean"));
            registrationProperties.setGenerateIntegrationReports(this.repositoryHelper.getBooleanProperty(this.serviceName, OpenMetadataProperty.GENERATE_INTEGRATION_REPORT.name, instanceProperties, "getBean"));
            registrationProperties.setPermittedSynchronization(this.removePermittedSynchronization(instanceProperties));
            bean.setRegistrationProperties(registrationProperties);
        }
        return bean;
    }

    PermittedSynchronization removePermittedSynchronization(InstanceProperties instanceProperties) {
        String methodName = "removePermittedSynchronization";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.name, instanceProperties, "removePermittedSynchronization");
            for (PermittedSynchronization permittedSynchronization : PermittedSynchronization.values()) {
                if (permittedSynchronization.getOrdinal() != ordinal) continue;
                return permittedSynchronization;
            }
        }
        return PermittedSynchronization.BOTH_DIRECTIONS;
    }
}

