/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server;

import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EngineActionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionProcessStepHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.MetadataElementConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.properties.EngineActionElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessStepElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworkservices.gaf.converters.EngineActionConverter;
import org.odpi.openmetadata.frameworkservices.gaf.converters.GovernanceActionProcessConverter;
import org.odpi.openmetadata.frameworkservices.gaf.converters.GovernanceActionProcessStepConverter;
import org.odpi.openmetadata.frameworkservices.gaf.converters.GovernanceActionTypeConverter;
import org.odpi.openmetadata.frameworkservices.gaf.ffdc.OpenGovernanceErrorCode;
import org.odpi.openmetadata.frameworkservices.gaf.handlers.GovernanceEngineConfigurationHandler;
import org.odpi.openmetadata.frameworkservices.gaf.handlers.IntegrationGroupConfigurationHandler;
import org.odpi.openmetadata.frameworkservices.omf.handlers.MetadataElementHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class GAFMetadataManagementInstance
extends OMASServiceInstance {
    private static final CommonServicesDescription myDescription = CommonServicesDescription.GAF_METADATA_MANAGEMENT;
    private final GovernanceEngineConfigurationHandler governanceEngineConfigurationHandler;
    private final IntegrationGroupConfigurationHandler integrationGroupConfigurationHandler;
    private final MetadataElementHandler<OpenMetadataElement> metadataElementHandler;
    private final EngineActionHandler<EngineActionElement> engineActionHandler;
    private final AssetHandler<GovernanceActionProcessElement> governanceActionProcessHandler;
    private final GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> governanceActionProcessStepHandler;
    private final GovernanceActionTypeHandler<GovernanceActionTypeElement> governanceActionTypeHandler;

    public GAFMetadataManagementInstance(OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        super(myDescription.getServiceName(), repositoryConnector, null, null, null, auditLog, localServerUserId, maxPageSize, null, null, null, null);
        String methodName = "new ServiceInstance";
        if (this.repositoryHandler == null) {
            throw new NewInstanceException(OpenGovernanceErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.governanceEngineConfigurationHandler = new GovernanceEngineConfigurationHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, this.supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.integrationGroupConfigurationHandler = new IntegrationGroupConfigurationHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, this.supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.metadataElementHandler = new MetadataElementHandler((OpenMetadataAPIGenericConverter)new MetadataElementConverter(this.repositoryHelper, this.serviceName, this.serverName), OpenMetadataElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, this.supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.engineActionHandler = new EngineActionHandler(new EngineActionConverter(this.repositoryHelper, this.serviceName, this.serverName), EngineActionElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, this.supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.governanceActionProcessHandler = new AssetHandler(new GovernanceActionProcessConverter(this.repositoryHelper, this.serviceName, this.serverName), GovernanceActionProcessElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, this.supportedZones, this.defaultZones, this.publishZones, null, auditLog);
        this.governanceActionProcessStepHandler = new GovernanceActionProcessStepHandler(new GovernanceActionProcessStepConverter(this.repositoryHelper, this.serviceName, this.serverName), GovernanceActionProcessStepElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, this.supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.governanceActionTypeHandler = new GovernanceActionTypeHandler(new GovernanceActionTypeConverter(this.repositoryHelper, this.serviceName, this.serverName), GovernanceActionTypeElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, this.supportedZones, this.defaultZones, this.publishZones, auditLog);
    }

    public GovernanceEngineConfigurationHandler getGovernanceConfigurationHandler() {
        return this.governanceEngineConfigurationHandler;
    }

    IntegrationGroupConfigurationHandler getIntegrationGroupConfigurationHandler() {
        return this.integrationGroupConfigurationHandler;
    }

    public MetadataElementHandler<OpenMetadataElement> getMetadataElementHandler() {
        return this.metadataElementHandler;
    }

    AssetHandler<GovernanceActionProcessElement> getGovernanceActionProcessHandler() {
        return this.governanceActionProcessHandler;
    }

    GovernanceActionProcessStepHandler<GovernanceActionProcessStepElement> getGovernanceActionProcessStepHandler() {
        return this.governanceActionProcessStepHandler;
    }

    GovernanceActionTypeHandler<GovernanceActionTypeElement> getGovernanceActionTypeHandler() {
        return this.governanceActionTypeHandler;
    }

    public EngineActionHandler<EngineActionElement> getEngineActionHandler() {
        return this.engineActionHandler;
    }
}

