/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.gaf.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.ConsolidatedDuplicatesRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.FindRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.IncidentReportRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.NewClassificationRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.NewMetadataElementRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.NewRelatedElementsRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.PeerDuplicatesRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.RelatedMetadataElementListResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.RelatedMetadataElementsListResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdateEffectivityDatesRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdatePropertiesRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdateRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdateStatusRequestBody;
import org.odpi.openmetadata.commonservices.gaf.server.OpenMetadataStoreRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/common-services/{serviceURLMarker}/open-metadata-store/users/{userId}"})
@Tag(name="Open Metadata Store Services", description="Provides generic open metadata retrieval and management services for Open Metadata Access Services (OMASs).", externalDocs=@ExternalDocumentation(description="Open Metadata Store Services", url="https://egeria-project.org/services/gaf-metadata-management/"))
public class OpenMetadataStoreResource {
    private final OpenMetadataStoreRESTServices restAPI = new OpenMetadataStoreRESTServices();

    @GetMapping(path={"/metadata-elements/{elementGUID}"})
    public OpenMetadataElementResponse getMetadataElementByGUID(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime) {
        return this.restAPI.getMetadataElementByGUID(serverName, serviceURLMarker, userId, elementGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @PostMapping(path={"/metadata-elements/by-unique-name"})
    public OpenMetadataElementResponse getMetadataElementByUniqueName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getMetadataElementByUniqueName(serverName, serviceURLMarker, userId, forLineage, forDuplicateProcessing, effectiveTime, requestBody);
    }

    @PostMapping(path={"/metadata-elements/guid-by-unique-name"})
    public GUIDResponse getMetadataElementGUIDByUniqueName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getMetadataElementGUIDByUniqueName(serverName, serviceURLMarker, userId, forLineage, forDuplicateProcessing, effectiveTime, requestBody);
    }

    @PostMapping(path={"/metadata-elements/by-search-string"})
    public OpenMetadataElementsResponse findMetadataElementsWithString(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findMetadataElementsWithString(serverName, serviceURLMarker, userId, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/related-elements/{elementGUID}/type/{relationshipTypeName}"})
    public RelatedMetadataElementListResponse getRelatedMetadataElements(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String relationshipTypeName, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestParam int startingAtEnd, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getRelatedMetadataElements(serverName, serviceURLMarker, userId, elementGUID, relationshipTypeName, forLineage, forDuplicateProcessing, effectiveTime, startingAtEnd, startFrom, pageSize);
    }

    @PostMapping(path={"/metadata-elements/by-search-specification"})
    public OpenMetadataElementsResponse findMetadataElements(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody FindRequestBody requestBody) {
        return this.restAPI.findMetadataElements(serverName, serviceURLMarker, userId, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/related-elements/by-search-specification"})
    public RelatedMetadataElementsListResponse findRelationshipsBetweenMetadataElements(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody FindRequestBody requestBody) {
        return this.restAPI.findRelationshipsBetweenMetadataElements(serverName, serviceURLMarker, userId, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/metadata-elements/new"})
    public GUIDResponse createMetadataElementInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody NewMetadataElementRequestBody requestBody) {
        return this.restAPI.createMetadataElementInStore(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/update-properties"})
    public VoidResponse updateMetadataElementInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @RequestBody UpdatePropertiesRequestBody requestBody) {
        return this.restAPI.updateMetadataElementInStore(serverName, serviceURLMarker, userId, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/update-status"})
    public VoidResponse updateMetadataElementStatusInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @RequestBody UpdateStatusRequestBody requestBody) {
        return this.restAPI.updateMetadataElementStatusInStore(serverName, serviceURLMarker, userId, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/update-effectivity"})
    public VoidResponse updateMetadataElementEffectivityInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @RequestBody UpdateEffectivityDatesRequestBody requestBody) {
        return this.restAPI.updateMetadataElementEffectivityInStore(serverName, serviceURLMarker, userId, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/delete"})
    public VoidResponse deleteMetadataElementInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.deleteMetadataElementInStore(serverName, serviceURLMarker, userId, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/classifications/{classificationName}/new"})
    public VoidResponse classifyMetadataElementInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody NewClassificationRequestBody requestBody) {
        return this.restAPI.classifyMetadataElementInStore(serverName, serviceURLMarker, userId, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/classifications/{classificationName}/update-properties"})
    public VoidResponse reclassifyMetadataElementInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody UpdatePropertiesRequestBody requestBody) {
        return this.restAPI.reclassifyMetadataElementInStore(serverName, serviceURLMarker, userId, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/classifications/{classificationName}/update-effectivity"})
    public VoidResponse updateClassificationEffectivityInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody UpdateEffectivityDatesRequestBody requestBody) {
        return this.restAPI.updateClassificationEffectivityInStore(serverName, serviceURLMarker, userId, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/classifications/{classificationName}/delete"})
    public VoidResponse unclassifyMetadataElementInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.unclassifyMetadataElementInStore(serverName, serviceURLMarker, userId, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/related-elements/new"})
    public GUIDResponse createRelatedElementsInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody NewRelatedElementsRequestBody requestBody) {
        return this.restAPI.createRelatedElementsInStore(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/related-elements/{relationshipGUID}/update-properties"})
    public VoidResponse updateRelatedElementsInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestBody UpdatePropertiesRequestBody requestBody) {
        return this.restAPI.updateRelatedElementsInStore(serverName, serviceURLMarker, userId, relationshipGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{relationshipGUID}/update-effectivity"})
    public VoidResponse updateRelatedElementsEffectivityInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestBody UpdateEffectivityDatesRequestBody requestBody) {
        return this.restAPI.updateRelatedElementsEffectivityInStore(serverName, serviceURLMarker, userId, relationshipGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{relationshipGUID}/delete"})
    public VoidResponse deleteRelatedElementsInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.deleteRelatedElementsInStore(serverName, serviceURLMarker, userId, relationshipGUID, requestBody);
    }

    @PostMapping(path={"/incident-reports"})
    public GUIDResponse createIncidentReport(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody IncidentReportRequestBody requestBody) {
        return this.restAPI.createIncidentReport(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/related-elements/link-as-peer-duplicate"})
    public VoidResponse linkElementsAsPeerDuplicates(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody PeerDuplicatesRequestBody requestBody) {
        return this.restAPI.linkElementsAsDuplicates(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/related-elements/link-as-consolidated-duplicate"})
    public VoidResponse linkConsolidatedDuplicate(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody ConsolidatedDuplicatesRequestBody requestBody) {
        return this.restAPI.linkConsolidatedDuplicate(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/log-records/{callingService}"})
    public VoidResponse logAssetAuditMessage(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String callingService, @RequestBody String message) {
        return this.restAPI.logAssetAuditMessage(serverName, serviceURLMarker, userId, assetGUID, callingService, message);
    }
}

