/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ActionTargetStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CompletionStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ConsolidatedDuplicatesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.PeerDuplicatesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.server.OpenGovernanceRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/framework-services/{serviceURLMarker}/open-governance-service/users/{userId}"})
@Tag(name="Open Governance Service", description="Provides support for common governance services used across thee OMASs.", externalDocs=@ExternalDocumentation(description="Open Governance Service", url="https://egeria-project.org/services/gaf-metadata-management/"))
public class OpenGovernanceResource {
    private final OpenGovernanceRESTServices restAPI = new OpenGovernanceRESTServices();

    @PostMapping(path={"/governance-actions/action-targets/update"})
    public VoidResponse updateActionTargetStatus(@PathVariable String serverName, @PathVariable String userId, @RequestBody ActionTargetStatusRequestBody requestBody) {
        return this.restAPI.updateActionTargetStatus(serverName, userId, requestBody);
    }

    @PostMapping(path={"/governance-actions/{governanceActionGUID}/completion-status"})
    public VoidResponse recordCompletionStatus(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceActionGUID, @RequestBody CompletionStatusRequestBody requestBody) {
        return this.restAPI.recordCompletionStatus(serverName, userId, governanceActionGUID, requestBody);
    }

    @PostMapping(path={"/governance-engines/{governanceEngineName}/governance-actions/initiate"})
    public GUIDResponse initiateGovernanceAction(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceEngineName, @RequestBody GovernanceActionRequestBody requestBody) {
        return this.restAPI.initiateGovernanceAction(serverName, userId, governanceEngineName, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/initiate"})
    public GUIDResponse initiateGovernanceActionProcess(@PathVariable String serverName, @PathVariable String userId, @RequestBody GovernanceActionProcessRequestBody requestBody) {
        return this.restAPI.initiateGovernanceActionProcess(serverName, userId, requestBody);
    }

    @PostMapping(path={"/related-elements/link-as-peer-duplicate"})
    public VoidResponse linkElementsAsPeerDuplicates(@PathVariable String serverName, @PathVariable String userId, @RequestBody PeerDuplicatesRequestBody requestBody) {
        return this.restAPI.linkElementsAsDuplicates(serverName, userId, requestBody);
    }

    @PostMapping(path={"/related-elements/link-as-consolidated-duplicate"})
    public VoidResponse linkConsolidatedDuplicate(@PathVariable String serverName, @PathVariable String userId, @RequestBody ConsolidatedDuplicatesRequestBody requestBody) {
        return this.restAPI.linkConsolidatedDuplicate(serverName, userId, requestBody);
    }
}

