/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.governanceaction.properties.TranslationDetail;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValue;
import org.odpi.openmetadata.frameworkservices.gaf.rest.FindRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IncidentReportRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewClassificationRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewMetadataElementRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewRelatedElementsRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RelatedMetadataElementListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RelatedMetadataElementsListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RelatedMetadataElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ToDoRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TranslationDetailResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TranslationListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateEffectivityDatesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdatePropertiesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueResponse;
import org.odpi.openmetadata.frameworkservices.gaf.server.OpenMetadataStoreRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/framework-services/{serviceURLMarker}/open-metadata-store/users/{userId}"})
@Tag(name="Open Metadata Store Services", description="Provides generic open metadata retrieval and management services for Open Metadata Access Services (OMASs).", externalDocs=@ExternalDocumentation(description="Open Metadata Store Services", url="https://egeria-project.org/services/gaf-metadata-management/"))
public class OpenMetadataStoreResource {
    private final OpenMetadataStoreRESTServices restAPI = new OpenMetadataStoreRESTServices();

    @GetMapping(path={"/metadata-elements/{elementGUID}"})
    public OpenMetadataElementResponse getMetadataElementByGUID(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime) {
        return this.restAPI.getMetadataElementByGUID(serverName, serviceURLMarker, userId, elementGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @PostMapping(path={"/metadata-elements/by-unique-name"})
    public OpenMetadataElementResponse getMetadataElementByUniqueName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getMetadataElementByUniqueName(serverName, serviceURLMarker, userId, forLineage, forDuplicateProcessing, effectiveTime, requestBody);
    }

    @PostMapping(path={"/metadata-elements/guid-by-unique-name"})
    public GUIDResponse getMetadataElementGUIDByUniqueName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getMetadataElementGUIDByUniqueName(serverName, serviceURLMarker, userId, forLineage, forDuplicateProcessing, effectiveTime, requestBody);
    }

    @PostMapping(path={"/metadata-elements/by-search-string"})
    public OpenMetadataElementsResponse findMetadataElementsWithString(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findMetadataElementsWithString(serverName, serviceURLMarker, userId, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/related-elements/{elementGUID}/any-type"})
    public RelatedMetadataElementListResponse getAllRelatedMetadataElements(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestParam int startingAtEnd, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getRelatedMetadataElements(serverName, serviceURLMarker, userId, elementGUID, null, forLineage, forDuplicateProcessing, effectiveTime, startingAtEnd, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/{elementGUID}/type/{relationshipTypeName}"})
    public RelatedMetadataElementListResponse getRelatedMetadataElements(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String relationshipTypeName, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestParam int startingAtEnd, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getRelatedMetadataElements(serverName, serviceURLMarker, userId, elementGUID, relationshipTypeName, forLineage, forDuplicateProcessing, effectiveTime, startingAtEnd, startFrom, pageSize);
    }

    @PostMapping(path={"/metadata-elements/by-search-specification"})
    public OpenMetadataElementsResponse findMetadataElements(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestParam(required=false, defaultValue="0") long effectiveTime, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FindRequestBody requestBody) {
        return this.restAPI.findMetadataElements(serverName, serviceURLMarker, userId, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/related-elements/by-search-specification"})
    public RelatedMetadataElementsListResponse findRelationshipsBetweenMetadataElements(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody FindRequestBody requestBody) {
        return this.restAPI.findRelationshipsBetweenMetadataElements(serverName, serviceURLMarker, userId, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/related-elements/relationship/{relationshipGUID}"})
    public RelatedMetadataElementsResponse getRelationshipByGUID(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime) {
        return this.restAPI.getRelationshipByGUID(serverName, serviceURLMarker, userId, relationshipGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @PostMapping(path={"/metadata-elements/new"})
    public GUIDResponse createMetadataElementInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody NewMetadataElementRequestBody requestBody) {
        return this.restAPI.createMetadataElementInStore(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/update-properties"})
    public VoidResponse updateMetadataElementInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @RequestBody UpdatePropertiesRequestBody requestBody) {
        return this.restAPI.updateMetadataElementInStore(serverName, serviceURLMarker, userId, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/update-status"})
    public VoidResponse updateMetadataElementStatusInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @RequestBody UpdateStatusRequestBody requestBody) {
        return this.restAPI.updateMetadataElementStatusInStore(serverName, serviceURLMarker, userId, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/update-effectivity"})
    public VoidResponse updateMetadataElementEffectivityInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @RequestBody UpdateEffectivityDatesRequestBody requestBody) {
        return this.restAPI.updateMetadataElementEffectivityInStore(serverName, serviceURLMarker, userId, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/delete"})
    public VoidResponse deleteMetadataElementInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.deleteMetadataElementInStore(serverName, serviceURLMarker, userId, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/classifications/{classificationName}/new"})
    public VoidResponse classifyMetadataElementInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody NewClassificationRequestBody requestBody) {
        return this.restAPI.classifyMetadataElementInStore(serverName, serviceURLMarker, userId, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/classifications/{classificationName}/update-properties"})
    public VoidResponse reclassifyMetadataElementInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody UpdatePropertiesRequestBody requestBody) {
        return this.restAPI.reclassifyMetadataElementInStore(serverName, serviceURLMarker, userId, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/classifications/{classificationName}/update-effectivity"})
    public VoidResponse updateClassificationEffectivityInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody UpdateEffectivityDatesRequestBody requestBody) {
        return this.restAPI.updateClassificationEffectivityInStore(serverName, serviceURLMarker, userId, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/classifications/{classificationName}/delete"})
    public VoidResponse declassifyMetadataElementInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.declassifyMetadataElementInStore(serverName, serviceURLMarker, userId, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/related-elements/new"})
    public GUIDResponse createRelatedElementsInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody NewRelatedElementsRequestBody requestBody) {
        return this.restAPI.createRelatedElementsInStore(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/related-elements/{relationshipGUID}/update-properties"})
    public VoidResponse updateRelatedElementsInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestBody UpdatePropertiesRequestBody requestBody) {
        return this.restAPI.updateRelatedElementsInStore(serverName, serviceURLMarker, userId, relationshipGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{relationshipGUID}/update-effectivity"})
    public VoidResponse updateRelatedElementsEffectivityInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestBody UpdateEffectivityDatesRequestBody requestBody) {
        return this.restAPI.updateRelatedElementsEffectivityInStore(serverName, serviceURLMarker, userId, relationshipGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{relationshipGUID}/delete"})
    public VoidResponse deleteRelatedElementsInStore(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.deleteRelatedElementsInStore(serverName, serviceURLMarker, userId, relationshipGUID, requestBody);
    }

    @PostMapping(path={"/incident-reports"})
    public GUIDResponse createIncidentReport(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody IncidentReportRequestBody requestBody) {
        return this.restAPI.createIncidentReport(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/to-dos"})
    public GUIDResponse openToDo(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody ToDoRequestBody requestBody) {
        return this.restAPI.openToDo(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/multi-language/set-translation/{elementGUID}"})
    public VoidResponse setTranslation(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String elementGUID, @RequestBody TranslationDetail translationDetail) {
        return this.restAPI.setTranslation(serverName, serviceURLMarker, userId, elementGUID, translationDetail);
    }

    @PostMapping(path={"/multi-language/clear-translation/{elementGUID}"})
    public VoidResponse clearTranslation(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false) String language, @RequestParam(required=false) String locale, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.clearTranslation(serverName, serviceURLMarker, userId, elementGUID, language, locale, requestBody);
    }

    @GetMapping(path={"/multi-language/get-translation/{elementGUID}"})
    public TranslationDetailResponse getTranslation(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false) String language, @RequestParam(required=false) String locale) {
        return this.restAPI.getTranslation(serverName, serviceURLMarker, userId, elementGUID, language, locale);
    }

    @GetMapping(path={"/multi-language/get-translations/{elementGUID}"})
    public TranslationListResponse getTranslations(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getTranslations(serverName, serviceURLMarker, userId, elementGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/valid-metadata-values/setup-value/{propertyName}"})
    public VoidResponse setUpValidMetadataValue(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestBody ValidMetadataValue validMetadataValue) {
        return this.restAPI.setUpValidMetadataValue(serverName, serviceURLMarker, userId, typeName, propertyName, validMetadataValue);
    }

    @PostMapping(path={"/valid-metadata-values/setup-map-name/{propertyName}"})
    public VoidResponse setUpValidMetadataMapName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestBody ValidMetadataValue validMetadataValue) {
        return this.restAPI.setUpValidMetadataMapName(serverName, serviceURLMarker, userId, typeName, propertyName, validMetadataValue);
    }

    @PostMapping(path={"/valid-metadata-values/setup-map-value/{propertyName}/{mapName}"})
    public VoidResponse setUpValidMetadataMapValue(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @PathVariable String mapName, @RequestBody ValidMetadataValue validMetadataValue) {
        return this.restAPI.setUpValidMetadataMapValue(serverName, serviceURLMarker, userId, typeName, propertyName, mapName, validMetadataValue);
    }

    @PostMapping(path={"/valid-metadata-values/clear-value/{propertyName}"})
    public VoidResponse clearValidMetadataValue(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestParam(required=false) String preferredValue, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.clearValidMetadataValue(serverName, serviceURLMarker, userId, typeName, propertyName, preferredValue, requestBody);
    }

    @PostMapping(path={"/valid-metadata-values/clear-map-name/{propertyName}"})
    public VoidResponse clearValidMetadataMapName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestParam(required=false) String preferredValue, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.clearValidMetadataMapName(serverName, serviceURLMarker, userId, typeName, propertyName, preferredValue, requestBody);
    }

    @PostMapping(path={"/valid-metadata-values/clear-map-value/{propertyName}/{mapName}"})
    public VoidResponse clearValidMetadataMapValue(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @PathVariable String mapName, @RequestParam(required=false) String preferredValue, NullRequestBody requestBody) {
        return this.restAPI.clearValidMetadataMapValue(serverName, serviceURLMarker, userId, typeName, propertyName, mapName, preferredValue, requestBody);
    }

    @GetMapping(path={"/valid-metadata-values/validate-value/{propertyName}"})
    public BooleanResponse validateMetadataValue(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestParam String actualValue) {
        return this.restAPI.validateMetadataValue(serverName, serviceURLMarker, userId, typeName, propertyName, actualValue);
    }

    @GetMapping(path={"/valid-metadata-values/validate-map-name/{propertyName}"})
    public BooleanResponse validateMetadataMapName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestParam String actualValue) {
        return this.restAPI.validateMetadataMapName(serverName, serviceURLMarker, userId, typeName, propertyName, actualValue);
    }

    @GetMapping(path={"/valid-metadata-values/validate-map-value/{propertyName}/{mapName}"})
    public BooleanResponse validateMetadataMapValue(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @PathVariable String mapName, @RequestParam String actualValue) {
        return this.restAPI.validateMetadataMapValue(serverName, serviceURLMarker, userId, typeName, propertyName, mapName, actualValue);
    }

    @GetMapping(path={"/valid-metadata-values/get-value/{propertyName}"})
    public ValidMetadataValueResponse getValidMetadataValue(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestParam String preferredValue) {
        return this.restAPI.getValidMetadataValue(serverName, serviceURLMarker, userId, typeName, propertyName, preferredValue);
    }

    @GetMapping(path={"/valid-metadata-values/get-map-name/{propertyName}"})
    public ValidMetadataValueResponse getValidMetadataMapName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestParam String preferredValue) {
        return this.restAPI.getValidMetadataMapName(serverName, serviceURLMarker, userId, typeName, propertyName, preferredValue);
    }

    @GetMapping(path={"/valid-metadata-values/get-map-value/{propertyName}/{mapName}"})
    public ValidMetadataValueResponse getValidMetadataMapValue(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @PathVariable String mapName, @RequestParam String preferredValue) {
        return this.restAPI.getValidMetadataMapValue(serverName, serviceURLMarker, userId, typeName, propertyName, mapName, preferredValue);
    }

    @GetMapping(path={"/valid-metadata-values/get-valid-metadata-values/{propertyName}"})
    public ValidMetadataValueListResponse getValidMetadataValues(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getValidMetadataValues(serverName, serviceURLMarker, userId, typeName, propertyName, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/{assetGUID}/log-records/{callingService}"})
    public VoidResponse logAssetAuditMessage(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String callingService, @RequestBody String message) {
        return this.restAPI.logAssetAuditMessage(serverName, serviceURLMarker, userId, assetGUID, callingService, message);
    }
}

