/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.DeleteRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceEngineElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceEngineElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceRegistrationRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceEngineRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceServiceRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredGovernanceServiceResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredGovernanceServicesResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceEngineRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceServiceRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.server.GovernanceConfigRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/framework-services/{serviceURLMarker}/governance-engine-configuration-service/users/{userId}"})
@Tag(name="Framework Services: Governance Engine Configuration", description="The Governance Engine Configuration Service provides support for creating governance engine definitions in open metadata.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine-definition/"))
public class GovernanceEngineConfigurationResource {
    private final GovernanceConfigRESTServices restAPI = new GovernanceConfigRESTServices();

    @PostMapping(path={"/governance-engines/{typeName}"})
    @Operation(summary="createGovernanceEngine", description="Create a new governance engine definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public GUIDResponse createGovernanceEngine(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String typeName, @RequestBody NewGovernanceEngineRequestBody requestBody) {
        return this.restAPI.createGovernanceEngine(serverName, serviceURLMarker, userId, typeName, requestBody);
    }

    @GetMapping(path={"/governance-engines/{guid}"})
    @Operation(summary="getGovernanceEngineByGUID", description="Return the properties from a governance engine definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public GovernanceEngineElementResponse getGovernanceEngineByGUID(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getGovernanceEngineByGUID(serverName, serviceURLMarker, userId, guid);
    }

    @PostMapping(path={"/governance-engines/by-name"})
    @Operation(summary="getGovernanceEngineByName", description="Return the properties from the named governance engine definition.  The requested name is either the qualified name or display name (if unique).", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public GovernanceEngineElementResponse getGovernanceEngineByName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody NameRequestBody name) {
        return this.restAPI.getGovernanceEngineByName(serverName, serviceURLMarker, userId, name);
    }

    @GetMapping(path={"/governance-engines"})
    @Operation(summary="getAllGovernanceEngines", description="Return the list of governance engine definitions that are stored.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public GovernanceEngineElementsResponse getAllGovernanceEngines(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getAllGovernanceEngines(serverName, serviceURLMarker, userId, startingFrom, maximumResults);
    }

    @PostMapping(path={"/governance-engines/{guid}/update"})
    @Operation(summary="updateGovernanceEngine", description="Update the properties of an existing governance engine definition.  Use the current value to keep a property value the same, or use the new value.  Null means remove the property from the definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public VoidResponse updateGovernanceEngine(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestBody UpdateGovernanceEngineRequestBody requestBody) {
        return this.restAPI.updateGovernanceEngine(serverName, serviceURLMarker, userId, guid, requestBody);
    }

    @PostMapping(path={"/governance-engines/{guid}/delete"})
    @Operation(summary="deleteGovernanceEngine", description="Remove the properties of the governance engine.  Both the guid and the qualified name is supplied to validate that the correct governance engine is being deleted.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public VoidResponse deleteGovernanceEngine(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteGovernanceEngine(serverName, serviceURLMarker, userId, guid, requestBody);
    }

    @PostMapping(path={"/governance-services/types/{typeName}"})
    @Operation(summary="createGovernanceService", description="Create a governance service definition.  The same governance service can be associated with multiple governance engines.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-service/"))
    public GUIDResponse createGovernanceService(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String typeName, @RequestBody NewGovernanceServiceRequestBody requestBody) {
        return this.restAPI.createGovernanceService(serverName, serviceURLMarker, userId, typeName, requestBody);
    }

    @GetMapping(path={"/governance-services/{guid}"})
    @Operation(summary="getGovernanceServiceByGUID", description="Return the properties from a governance service definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-service/"))
    public GovernanceServiceElementResponse getGovernanceServiceByGUID(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getGovernanceServiceByGUID(serverName, serviceURLMarker, userId, guid);
    }

    @GetMapping(path={"/governance-services/by-name"})
    @Operation(summary="getGovernanceServiceByName", description="Return the properties from a named governance service definition. The requested name is either the qualified name or display name (if unique).", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-service/"))
    public GovernanceServiceElementResponse getGovernanceServiceByName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGovernanceServiceByName(serverName, serviceURLMarker, userId, requestBody);
    }

    @GetMapping(path={"/governance-services"})
    @Operation(summary="getAllGovernanceServices", description="Return the list of governance services definitions that are stored.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-service/"))
    public GovernanceServiceElementsResponse getAllGovernanceServices(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getAllGovernanceServices(serverName, serviceURLMarker, userId, startingFrom, maximumResults);
    }

    @GetMapping(path={"/governance-services/{guid}/registrations"})
    @Operation(summary="getGovernanceServiceRegistrations", description="Return the list of governance engines that a specific governance service is registered with.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public GUIDListResponse getGovernanceServiceRegistrations(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getGovernanceServiceRegistrations(serverName, serviceURLMarker, userId, guid);
    }

    @PostMapping(path={"/governance-services/{guid}/update"})
    @Operation(summary="updateGovernanceService", description="Update the properties of an existing governance service definition.  Use the current value to keep a property value the same, or use the new value.  Null means remove the property from the definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-service/"))
    public VoidResponse updateGovernanceService(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestBody UpdateGovernanceServiceRequestBody requestBody) {
        return this.restAPI.updateGovernanceService(serverName, serviceURLMarker, userId, guid, requestBody);
    }

    @PostMapping(path={"/governance-services/{guid}/delete"})
    @Operation(summary="deleteGovernanceService", description="Remove the properties of the governance service.  Both the guid and the qualified name is supplied to validate that the correct governance service is being deleted.  The governance service is also unregistered from its governance engines.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-service/"))
    public VoidResponse deleteGovernanceService(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteGovernanceService(serverName, serviceURLMarker, userId, guid, requestBody);
    }

    @PostMapping(path={"/governance-engines/{guid}/governance-services"})
    @Operation(summary="registerGovernanceServiceWithEngine", description="Register a governance service with a specific governance engine.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public VoidResponse registerGovernanceServiceWithEngine(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestBody GovernanceServiceRegistrationRequestBody requestBody) {
        return this.restAPI.registerGovernanceServiceWithEngine(serverName, serviceURLMarker, userId, guid, requestBody);
    }

    @GetMapping(path={"/governance-engines/{governanceEngineGUID}/governance-services/{governanceServiceGUID}"})
    @Operation(summary="getRegisteredGovernanceService", description="Retrieve a specific governance service registered with a governance engine.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public RegisteredGovernanceServiceResponse getRegisteredGovernanceService(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String governanceEngineGUID, @PathVariable String governanceServiceGUID) {
        return this.restAPI.getRegisteredGovernanceService(serverName, serviceURLMarker, userId, governanceEngineGUID, governanceServiceGUID);
    }

    @GetMapping(path={"/governance-engines/{governanceEngineGUID}/governance-services"})
    @Operation(summary="getRegisteredGovernanceServices", description="Retrieve the identifiers of the governance services registered with a governance engine.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public RegisteredGovernanceServicesResponse getRegisteredGovernanceServices(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String governanceEngineGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getRegisteredGovernanceServices(serverName, serviceURLMarker, userId, governanceEngineGUID, startingFrom, maximumResults);
    }

    @PostMapping(path={"/governance-engines/{governanceEngineGUID}/governance-services/{governanceServiceGUID}/delete"})
    @Operation(summary="unregisterGovernanceServiceFromEngine", description="Unregister a governance service from the governance engine.  The governance engine and governance service are not removed, only the relationship between them.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public VoidResponse unregisterGovernanceServiceFromEngine(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String governanceEngineGUID, @PathVariable String governanceServiceGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unregisterGovernanceServiceFromEngine(serverName, serviceURLMarker, userId, governanceEngineGUID, governanceServiceGUID, requestBody);
    }
}

