/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementHeadersResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.governanceaction.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.MetadataCorrelationHeadersResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateMetadataCorrelatorsRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.server.ExternalIdentifierRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/framework-services/{serviceURLMarker}/open-metadata-store/users/{userId}"})
@Tag(name="Framework Services: Open Metadata Store Services", description="Provides generic open metadata retrieval and management services for Open Metadata Access Services (OMASs).", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/gaf-metadata-management/"))
public class ExternalIdentifierResource {
    private final ExternalIdentifierRESTServices restAPI = new ExternalIdentifierRESTServices();

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers/add"})
    public VoidResponse addExternalIdentifier(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.addExternalIdentifier(serverName, serviceURLMarker, userId, openMetadataElementGUID, openMetadataElementTypeName, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers/update"})
    public VoidResponse updateExternalIdentifier(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.updateExternalIdentifier(serverName, serviceURLMarker, userId, openMetadataElementGUID, openMetadataElementTypeName, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers/validate"})
    public BooleanResponse validateExternalIdentifier(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.validateExternalIdentifier(serverName, serviceURLMarker, userId, openMetadataElementGUID, openMetadataElementTypeName, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers/remove"})
    public VoidResponse removeExternalIdentifier(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateMetadataCorrelatorsRequestBody requestBody) {
        return this.restAPI.removeExternalIdentifier(serverName, serviceURLMarker, userId, openMetadataElementGUID, openMetadataElementTypeName, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/synchronized"})
    public VoidResponse confirmSynchronization(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.confirmSynchronization(serverName, serviceURLMarker, userId, openMetadataElementGUID, openMetadataElementTypeName, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/external-identifiers/open-metadata-elements"})
    public ElementHeadersResponse getElementsForExternalIdentifier(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateMetadataCorrelatorsRequestBody requestBody) {
        return this.restAPI.getElementsForExternalIdentifier(serverName, serviceURLMarker, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers"})
    public MetadataCorrelationHeadersResponse getExternalIdentifiers(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getMetadataCorrelationHeaders(serverName, serviceURLMarker, userId, openMetadataElementGUID, openMetadataElementTypeName, forLineage, forDuplicateProcessing, requestBody);
    }
}

