/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementHeadersResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.governanceaction.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.MetadataCorrelationHeadersResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateMetadataCorrelatorsRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.server.ExternalIdentifierRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/framework-services/{serviceURLMarker}/open-metadata-store/users/{userId}"})
@Tag(name="Framework Services: Open Metadata Store Services", description="Provides generic open metadata retrieval and management services for Open Metadata Access Services (OMASs).", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/gaf-metadata-management/"))
public class ExternalIdentifierResource {
    private final ExternalIdentifierRESTServices restAPI = new ExternalIdentifierRESTServices();

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers/add"})
    @Operation(summary="addExternalIdentifier", description="Add the description of a specific external identifier and link it to the associated metadata element.  Note, the external identifier is anchored to the scope (specified in the request body).", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public VoidResponse addExternalIdentifier(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateMetadataCorrelatorsRequestBody requestBody) {
        return this.restAPI.addExternalIdentifier(serverName, serviceURLMarker, userId, openMetadataElementGUID, openMetadataElementTypeName, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers/update"})
    @Operation(summary="updateExternalIdentifier", description="Update the description of a specific external identifier.", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public VoidResponse updateExternalIdentifier(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateMetadataCorrelatorsRequestBody requestBody) {
        return this.restAPI.updateExternalIdentifier(serverName, serviceURLMarker, userId, openMetadataElementGUID, openMetadataElementTypeName, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers/validate"})
    @Operation(summary="validateExternalIdentifier", description="Validate that the external identifier is linked to the open metadata GUID.", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public BooleanResponse validateExternalIdentifier(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateMetadataCorrelatorsRequestBody requestBody) {
        return this.restAPI.validateExternalIdentifier(serverName, serviceURLMarker, userId, openMetadataElementGUID, openMetadataElementTypeName, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers/remove"})
    @Operation(summary="removeExternalIdentifier", description="Remove an external identifier from an existing open metadata element.  The open metadata element is not affected.", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public VoidResponse removeExternalIdentifier(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateMetadataCorrelatorsRequestBody requestBody) {
        return this.restAPI.removeExternalIdentifier(serverName, serviceURLMarker, userId, openMetadataElementGUID, openMetadataElementTypeName, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/external-scope/{externalScopeGUID}/remove"})
    @Operation(summary="removeExternalScope", description="Remove the scope associated with a collection of external identifiers.  All associated external identifiers are removed too.  The linked open metadata elements are not affected.", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public VoidResponse removeExternalScope(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String externalScopeGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeRequestBody requestBody) {
        return this.restAPI.removeExternalScope(serverName, serviceURLMarker, userId, externalScopeGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/synchronized"})
    @Operation(summary="confirmSynchronization", description="Confirm that the values of a particular metadata element have been synchronized.  This is important from an audit point of view, and to allow bidirectional updates of metadata using optimistic locking.", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public VoidResponse confirmSynchronization(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.confirmSynchronization(serverName, serviceURLMarker, userId, openMetadataElementGUID, openMetadataElementTypeName, requestBody);
    }

    @PostMapping(path={"/external-identifiers/open-metadata-elements"})
    @Operation(summary="getElementsForExternalIdentifier", description="Retrieve the metadata element associated with a particular external identifier.", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public ElementHeadersResponse getElementsForExternalIdentifier(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateMetadataCorrelatorsRequestBody requestBody) {
        return this.restAPI.getElementsForExternalIdentifier(serverName, serviceURLMarker, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers"})
    @Operation(summary="getExternalIdentifiers", description="Retrieve the external identifiers attached to the supplied element guid.", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public MetadataCorrelationHeadersResponse getExternalIdentifiers(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getExternalIdentifiers(serverName, serviceURLMarker, userId, openMetadataElementGUID, openMetadataElementTypeName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }
}

