/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.DeleteRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationConnectorProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationGroupProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredIntegrationConnectorProperties;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CatalogTargetResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceEngineElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceEngineElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceRegistrationRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IntegrationConnectorElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IntegrationConnectorElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IntegrationGroupElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IntegrationGroupElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceEngineRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceServiceRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredGovernanceServiceResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredGovernanceServicesResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredIntegrationConnectorResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredIntegrationConnectorsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceEngineRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceServiceRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.server.GovernanceConfigRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/framework-services/{serviceURLMarker}/governance-configuration-service/users/{userId}"})
@Tag(name="Framework Services: Governance Configuration Service", description="The Governance Configuration Service provides support for maintaining the metadata elements that control the operation of the governance servers.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/gaf-metadata-management/"))
public class GovernanceConfigurationResource {
    private final GovernanceConfigRESTServices restAPI = new GovernanceConfigRESTServices();

    @PostMapping(path={"/governance-engines/{typeName}"})
    @Operation(summary="createGovernanceEngine", description="Create a new governance engine definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public GUIDResponse createGovernanceEngine(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String typeName, @RequestBody NewGovernanceEngineRequestBody requestBody) {
        return this.restAPI.createGovernanceEngine(serverName, serviceURLMarker, userId, typeName, requestBody);
    }

    @GetMapping(path={"/governance-engines/{guid}"})
    @Operation(summary="getGovernanceEngineByGUID", description="Return the properties from a governance engine definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public GovernanceEngineElementResponse getGovernanceEngineByGUID(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getGovernanceEngineByGUID(serverName, serviceURLMarker, userId, guid);
    }

    @PostMapping(path={"/governance-engines/by-name"})
    @Operation(summary="getGovernanceEngineByName", description="Return the properties from the named governance engine definition.  The requested name is either the qualified name or display name (if unique).", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public GovernanceEngineElementResponse getGovernanceEngineByName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody NameRequestBody name) {
        return this.restAPI.getGovernanceEngineByName(serverName, serviceURLMarker, userId, name);
    }

    @GetMapping(path={"/governance-engines"})
    @Operation(summary="getAllGovernanceEngines", description="Return the list of governance engine definitions that are stored.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public GovernanceEngineElementsResponse getAllGovernanceEngines(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getAllGovernanceEngines(serverName, serviceURLMarker, userId, startingFrom, maximumResults);
    }

    @PostMapping(path={"/governance-engines/{guid}/update"})
    @Operation(summary="updateGovernanceEngine", description="Update the properties of an existing governance engine definition.  Use the current value to keep a property value the same, or use the new value.  Null means remove the property from the definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public VoidResponse updateGovernanceEngine(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestBody UpdateGovernanceEngineRequestBody requestBody) {
        return this.restAPI.updateGovernanceEngine(serverName, serviceURLMarker, userId, guid, requestBody);
    }

    @PostMapping(path={"/governance-engines/{guid}/delete"})
    @Operation(summary="deleteGovernanceEngine", description="Remove the properties of the governance engine.  Both the guid and the qualified name is supplied to validate that the correct governance engine is being deleted.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public VoidResponse deleteGovernanceEngine(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteGovernanceEngine(serverName, serviceURLMarker, userId, guid, requestBody);
    }

    @PostMapping(path={"/governance-services/types/{typeName}"})
    @Operation(summary="createGovernanceService", description="Create a governance service definition.  The same governance service can be associated with multiple governance engines.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-service/"))
    public GUIDResponse createGovernanceService(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String typeName, @RequestBody NewGovernanceServiceRequestBody requestBody) {
        return this.restAPI.createGovernanceService(serverName, serviceURLMarker, userId, typeName, requestBody);
    }

    @GetMapping(path={"/governance-services/{guid}"})
    @Operation(summary="getGovernanceServiceByGUID", description="Return the properties from a governance service definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-service/"))
    public GovernanceServiceElementResponse getGovernanceServiceByGUID(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getGovernanceServiceByGUID(serverName, serviceURLMarker, userId, guid);
    }

    @GetMapping(path={"/governance-services/by-name"})
    @Operation(summary="getGovernanceServiceByName", description="Return the properties from a named governance service definition. The requested name is either the qualified name or display name (if unique).", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-service/"))
    public GovernanceServiceElementResponse getGovernanceServiceByName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGovernanceServiceByName(serverName, serviceURLMarker, userId, requestBody);
    }

    @GetMapping(path={"/governance-services"})
    @Operation(summary="getAllGovernanceServices", description="Return the list of governance services definitions that are stored.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-service/"))
    public GovernanceServiceElementsResponse getAllGovernanceServices(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getAllGovernanceServices(serverName, serviceURLMarker, userId, startingFrom, maximumResults);
    }

    @GetMapping(path={"/governance-services/{guid}/registrations"})
    @Operation(summary="getGovernanceServiceRegistrations", description="Return the list of governance engines that a specific governance service is registered with.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public GUIDListResponse getGovernanceServiceRegistrations(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getGovernanceServiceRegistrations(serverName, serviceURLMarker, userId, guid);
    }

    @PostMapping(path={"/governance-services/{guid}/update"})
    @Operation(summary="updateGovernanceService", description="Update the properties of an existing governance service definition.  Use the current value to keep a property value the same, or use the new value.  Null means remove the property from the definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-service/"))
    public VoidResponse updateGovernanceService(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestBody UpdateGovernanceServiceRequestBody requestBody) {
        return this.restAPI.updateGovernanceService(serverName, serviceURLMarker, userId, guid, requestBody);
    }

    @PostMapping(path={"/governance-services/{guid}/delete"})
    @Operation(summary="deleteGovernanceService", description="Remove the properties of the governance service.  Both the guid and the qualified name is supplied to validate that the correct governance service is being deleted.  The governance service is also unregistered from its governance engines.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-service/"))
    public VoidResponse deleteGovernanceService(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteGovernanceService(serverName, serviceURLMarker, userId, guid, requestBody);
    }

    @PostMapping(path={"/governance-engines/{guid}/governance-services"})
    @Operation(summary="registerGovernanceServiceWithEngine", description="Register a governance service with a specific governance engine.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public VoidResponse registerGovernanceServiceWithEngine(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestBody GovernanceServiceRegistrationRequestBody requestBody) {
        return this.restAPI.registerGovernanceServiceWithEngine(serverName, serviceURLMarker, userId, guid, requestBody);
    }

    @GetMapping(path={"/governance-engines/{governanceEngineGUID}/governance-services/{governanceServiceGUID}"})
    @Operation(summary="getRegisteredGovernanceService", description="Retrieve a specific governance service registered with a governance engine.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public RegisteredGovernanceServiceResponse getRegisteredGovernanceService(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String governanceEngineGUID, @PathVariable String governanceServiceGUID) {
        return this.restAPI.getRegisteredGovernanceService(serverName, serviceURLMarker, userId, governanceEngineGUID, governanceServiceGUID);
    }

    @GetMapping(path={"/governance-engines/{governanceEngineGUID}/governance-services"})
    @Operation(summary="getRegisteredGovernanceServices", description="Retrieve the identifiers of the governance services registered with a governance engine.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public RegisteredGovernanceServicesResponse getRegisteredGovernanceServices(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String governanceEngineGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getRegisteredGovernanceServices(serverName, serviceURLMarker, userId, governanceEngineGUID, startingFrom, maximumResults);
    }

    @PostMapping(path={"/governance-engines/{governanceEngineGUID}/governance-services/{governanceServiceGUID}/delete"})
    @Operation(summary="unregisterGovernanceServiceFromEngine", description="Unregister a governance service from the governance engine.  The governance engine and governance service are not removed, only the relationship between them.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public VoidResponse unregisterGovernanceServiceFromEngine(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String governanceEngineGUID, @PathVariable String governanceServiceGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unregisterGovernanceServiceFromEngine(serverName, serviceURLMarker, userId, governanceEngineGUID, governanceServiceGUID, requestBody);
    }

    @PostMapping(path={"/integration-groups/new"})
    @Operation(summary="createIntegrationGroup", description="Create a new integration group definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public GUIDResponse createIntegrationGroup(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody IntegrationGroupProperties requestBody) {
        return this.restAPI.createIntegrationGroup(serverName, serviceURLMarker, userId, requestBody);
    }

    @GetMapping(path={"/integration-groups/{guid}"})
    @Operation(summary="getIntegrationGroupByGUID", description="Return the properties from an integration group definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public IntegrationGroupElementResponse getIntegrationGroupByGUID(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getIntegrationGroupByGUID(serverName, serviceURLMarker, userId, guid);
    }

    @GetMapping(path={"/integration-groups/by-name/{name}"})
    @Operation(summary="getIntegrationGroupByName", description="Return the properties from an integration group definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public IntegrationGroupElementResponse getIntegrationGroupByName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getIntegrationGroupByName(serverName, serviceURLMarker, userId, name);
    }

    @GetMapping(path={"/integration-groups"})
    @Operation(summary="getAllIntegrationGroups", description="Return the list of integration group definitions that are stored.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public IntegrationGroupElementsResponse getAllIntegrationGroups(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getAllIntegrationGroups(serverName, serviceURLMarker, userId, startingFrom, maximumResults);
    }

    @PostMapping(path={"/integration-groups/{guid}/update"})
    @Operation(summary="updateIntegrationGroup", description="Update the properties of an existing integration group definition.  Use the current value to keep a property value the same, or use the new value.  Null means remove the property from the definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public VoidResponse updateIntegrationGroup(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestParam boolean isMergeUpdate, @RequestBody IntegrationGroupProperties requestBody) {
        return this.restAPI.updateIntegrationGroup(serverName, serviceURLMarker, userId, guid, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/integration-groups/{guid}/delete"})
    @Operation(summary="deleteIntegrationGroup", description="Remove the properties of the integration group.  Both the guid and the qualified name is supplied to validate that the correct integration group is being deleted.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public VoidResponse deleteIntegrationGroup(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteIntegrationGroup(serverName, serviceURLMarker, userId, guid, requestBody);
    }

    @PostMapping(path={"/integration-connectors/new"})
    @Operation(summary="createIntegrationConnector", description="Create an integration connector definition.  The same integration connector can be associated with multiple integration groups.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public GUIDResponse createIntegrationConnector(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody IntegrationConnectorProperties requestBody) {
        return this.restAPI.createIntegrationConnector(serverName, serviceURLMarker, userId, requestBody);
    }

    @GetMapping(path={"/integration-connectors/{guid}"})
    @Operation(summary="getIntegrationConnectorByGUID", description="Return the properties from an integration connector definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public IntegrationConnectorElementResponse getIntegrationConnectorByGUID(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getIntegrationConnectorByGUID(serverName, serviceURLMarker, userId, guid);
    }

    @GetMapping(path={"/integration-connectors/by-name/{name}"})
    @Operation(summary="getIntegrationConnectorByName", description="Return the properties from an integration connector definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public IntegrationConnectorElementResponse getIntegrationConnectorByName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getIntegrationConnectorByName(serverName, serviceURLMarker, userId, name);
    }

    @GetMapping(path={"/integration-connectors"})
    @Operation(summary="getAllIntegrationConnectors", description="Return the list of integration connectors definitions that are stored.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public IntegrationConnectorElementsResponse getAllIntegrationConnectors(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getAllIntegrationConnectors(serverName, serviceURLMarker, userId, startingFrom, maximumResults);
    }

    @GetMapping(path={"/integration-connectors/{guid}/registrations"})
    @Operation(summary="getIntegrationConnectorRegistrations", description="Return the list of integration groups that a specific integration connector is registered with.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public GUIDListResponse getIntegrationConnectorRegistrations(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getIntegrationConnectorRegistrations(serverName, serviceURLMarker, userId, guid);
    }

    @PostMapping(path={"/integration-connectors/{guid}/update"})
    @Operation(summary="updateIntegrationConnector", description="Update the properties of an existing integration connector definition. The isMergeUpdate request parameter is used to indicate whether supplied null values mean keep existing value (true) or remove existing value (false).", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse updateIntegrationConnector(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestParam boolean isMergeUpdate, @RequestBody IntegrationConnectorProperties requestBody) {
        return this.restAPI.updateIntegrationConnector(serverName, serviceURLMarker, userId, guid, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/integration-connectors/{guid}/delete"})
    @Operation(summary="deleteIntegrationConnector", description="Remove the properties of the integration connector.  Both the guid and the qualified name is supplied to validate that the correct integration connector is being deleted.  The integration connector is also unregistered from its integration groups.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse deleteIntegrationConnector(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteIntegrationConnector(serverName, serviceURLMarker, userId, guid, requestBody);
    }

    @PostMapping(path={"/integration-groups/{integrationGroupGUID}/integration-connectors/{integrationConnectorGUID}"})
    @Operation(summary="registerIntegrationConnectorWithGroup", description="Register an integration connector with a specific integration group.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public VoidResponse registerIntegrationConnectorWithGroup(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String integrationGroupGUID, @PathVariable String integrationConnectorGUID, @RequestBody RegisteredIntegrationConnectorProperties requestBody) {
        return this.restAPI.registerIntegrationConnectorWithGroup(serverName, serviceURLMarker, userId, integrationGroupGUID, integrationConnectorGUID, requestBody);
    }

    @GetMapping(path={"/integration-groups/{integrationGroupGUID}/integration-connectors/{integrationConnectorGUID}"})
    @Operation(summary="getRegisteredIntegrationConnector", description="Retrieve a specific integration connector registered with an integration group.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public RegisteredIntegrationConnectorResponse getRegisteredIntegrationConnector(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String integrationGroupGUID, @PathVariable String integrationConnectorGUID) {
        return this.restAPI.getRegisteredIntegrationConnector(serverName, serviceURLMarker, userId, integrationGroupGUID, integrationConnectorGUID);
    }

    @GetMapping(path={"/integration-groups/{integrationGroupGUID}/integration-connectors"})
    @Operation(summary="getRegisteredIntegrationConnectors", description="Retrieve the details of the integration connectors registered with an integration group.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public RegisteredIntegrationConnectorsResponse getRegisteredIntegrationConnectors(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String integrationGroupGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getRegisteredIntegrationConnectors(serverName, serviceURLMarker, userId, integrationGroupGUID, startingFrom, maximumResults);
    }

    @PostMapping(path={"/integration-groups/{integrationGroupGUID}/integration-connectors/{integrationConnectorGUID}/delete"})
    @Operation(summary="unregisterIntegrationConnectorFromGroup", description="Unregister an integration connector from the integration group.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public VoidResponse unregisterIntegrationConnectorFromGroup(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String integrationGroupGUID, @PathVariable String integrationConnectorGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unregisterIntegrationConnectorFromGroup(serverName, serviceURLMarker, userId, integrationGroupGUID, integrationConnectorGUID, requestBody);
    }

    @PostMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets/{metadataElementGUID}"})
    @Operation(summary="addCatalogTarget", description="Add a catalog target to an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public GUIDResponse addCatalogTarget(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String integrationConnectorGUID, @PathVariable String metadataElementGUID, @RequestBody CatalogTargetProperties requestBody) {
        return this.restAPI.addCatalogTarget(serverName, serviceURLMarker, userId, integrationConnectorGUID, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/catalog-targets/{relationshipGUID}/update"})
    @Operation(summary="updateCatalogTarget", description="Update a catalog target for an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse updateCatalogTarget(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestBody CatalogTargetProperties requestBody) {
        return this.restAPI.updateCatalogTarget(serverName, serviceURLMarker, userId, relationshipGUID, requestBody);
    }

    @GetMapping(path={"/catalog-targets/{relationshipGUID}"})
    @Operation(summary="getCatalogTarget", description="Retrieve a specific catalog target associated with an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public CatalogTargetResponse getCatalogTarget(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String relationshipGUID) {
        return this.restAPI.getCatalogTarget(serverName, serviceURLMarker, userId, relationshipGUID);
    }

    @GetMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets"})
    @Operation(summary="getCatalogTargets", description="Retrieve the details of the metadata elements identified as catalog targets with an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public CatalogTargetsResponse getCatalogTargets(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String integrationConnectorGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getCatalogTargets(serverName, serviceURLMarker, userId, integrationConnectorGUID, startingFrom, maximumResults);
    }

    @PostMapping(path={"/catalog-targets/{relationshipGUID}/delete"})
    @Operation(summary="removeCatalogTarget", description="Unregister a catalog target from the integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse removeCatalogTarget(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeCatalogTarget(serverName, serviceURLMarker, userId, relationshipGUID, requestBody);
    }
}

