/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CompletionStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.server.OpenGovernanceRESTServices;
import org.odpi.openmetadata.frameworkservices.omf.rest.ActionTargetStatusRequestBody;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/framework-services/{serviceURLMarker}/governance-context-service/users/{userId}"})
@Tag(name="Framework Services: Governance Context Service", description="Provides support for services used to control the status of an Engine Action during the execution of a governance service in an Engine Host.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/gaf-metadata-management/"))
public class GovernanceContextResource {
    private final OpenGovernanceRESTServices restAPI = new OpenGovernanceRESTServices();

    @PostMapping(path={"/engine-actions/{engineActionGUID}/status/update"})
    public VoidResponse updateEngineActionStatus(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String engineActionGUID, @RequestBody EngineActionStatusRequestBody requestBody) {
        return this.restAPI.updateEngineActionStatus(serverName, serviceURLMarker, userId, engineActionGUID, requestBody);
    }

    @GetMapping(path={"/governance-engines/{governanceEngineGUID}/active-engine-actions"})
    public EngineActionElementsResponse getActiveClaimedEngineActions(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String governanceEngineGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getActiveClaimedEngineActions(serverName, serviceURLMarker, userId, governanceEngineGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/engine-actions/{engineActionGUID}/claim"})
    public VoidResponse claimEngineAction(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String engineActionGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.claimEngineAction(serverName, serviceURLMarker, userId, engineActionGUID, requestBody);
    }

    @PostMapping(path={"/engine-actions/action-targets/update"})
    public VoidResponse updateActionTargetStatus(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody ActionTargetStatusRequestBody requestBody) {
        return this.restAPI.updateActionTargetStatus(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/engine-actions/{governanceActionGUID}/completion-status"})
    public VoidResponse recordCompletionStatus(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String governanceActionGUID, @RequestBody CompletionStatusRequestBody requestBody) {
        return this.restAPI.recordCompletionStatus(serverName, serviceURLMarker, userId, governanceActionGUID, requestBody);
    }
}

