/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessStepProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionTypeProperties;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.FirstGovernanceActionProcessStepResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessGraphResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessStepResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessStepsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypeResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypesResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateEngineActionRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NextGovernanceActionProcessStepRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NextGovernanceActionProcessStepsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionProcessStepRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.server.OpenGovernanceRESTServices;
import org.odpi.openmetadata.frameworkservices.omf.rest.ConsolidatedDuplicatesRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.PeerDuplicatesRequestBody;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/framework-services/{serviceURLMarker}/open-governance-service/users/{userId}"})
@Tag(name="Framework Services: Open Governance Service", description="Provides support for common governance services used across the OMASs.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/gaf-metadata-management/"))
public class OpenGovernanceResource {
    private final OpenGovernanceRESTServices restAPI = new OpenGovernanceRESTServices();

    @PostMapping(path={"/governance-action-types"})
    @Operation(summary="createGovernanceActionType", description="Create a new metadata element to represent a governance action type.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GUIDResponse createGovernanceActionType(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody GovernanceActionTypeProperties requestBody) {
        return this.restAPI.createGovernanceActionType(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/governance-action-types/{governanceActionTypeGUID}/update"})
    @Operation(summary="updateGovernanceActionType", description="Create a new metadata element to represent a governance action type.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public VoidResponse updateGovernanceActionType(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String governanceActionTypeGUID, @RequestBody UpdateGovernanceActionTypeRequestBody requestBody) {
        return this.restAPI.updateGovernanceActionType(serverName, serviceURLMarker, userId, governanceActionTypeGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-types/{governanceActionTypeGUID}/remove"})
    @Operation(summary="removeGovernanceActionType", description="Remove the metadata element representing a governance action type.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public VoidResponse removeGovernanceActionType(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String governanceActionTypeGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeGovernanceActionType(serverName, serviceURLMarker, userId, governanceActionTypeGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-types/by-search-string"})
    @Operation(summary="findGovernanceActionTypes", description="Retrieve the list of governance action type metadata elements that contain the search string. The search string is treated as a regular expression.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GovernanceActionTypesResponse findGovernanceActionTypes(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGovernanceActionTypes(serverName, serviceURLMarker, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/governance-action-types/by-name"})
    @Operation(summary="getGovernanceActionTypesByName", description="Retrieve the list of governance action type metadata elements with a matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GovernanceActionTypesResponse getGovernanceActionTypesByName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGovernanceActionTypesByName(serverName, serviceURLMarker, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-action-types/{governanceActionTypeGUID}"})
    @Operation(summary="getGovernanceActionTypeByGUID", description="Retrieve the governance action type metadata element with the supplied unique identifier.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GovernanceActionTypeResponse getGovernanceActionTypeByGUID(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String governanceActionTypeGUID) {
        return this.restAPI.getGovernanceActionTypeByGUID(serverName, serviceURLMarker, userId, governanceActionTypeGUID);
    }

    @PostMapping(path={"/governance-action-processes"})
    @Operation(summary="createGovernanceActionProcess", description="Create a new metadata element to represent a governance action process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GUIDResponse createGovernanceActionProcess(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody NewGovernanceActionProcessRequestBody requestBody) {
        return this.restAPI.createGovernanceActionProcess(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/update"})
    @Operation(summary="updateGovernanceActionProcess", description="Update the metadata element representing a governance action process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse updateGovernanceActionProcess(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String processGUID, @RequestBody UpdateGovernanceActionProcessRequestBody requestBody) {
        return this.restAPI.updateGovernanceActionProcess(serverName, serviceURLMarker, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/publish"})
    @Operation(summary="publishGovernanceActionProcess", description="Update the zones for the governance action process (asset) so that it becomes visible to consumers. (The zones are set to the list of zones in the publishedZones option configured for each instance of an Open Metadata Access Service (OMAS)).", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-zone"))
    public VoidResponse publishGovernanceActionProcess(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String processGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.publishGovernanceActionProcess(serverName, serviceURLMarker, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/withdraw"})
    @Operation(summary="withdrawGovernanceActionProcess", description="Update the zones for the governance action process (asset) so that it is no longer visible to consumers. (The zones are set to the list of zones in the defaultZones option configured for each instance of an Open Metadata Access Service (OMAS). This is also the setting for the zones when the process is first created.)", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-zone"))
    public VoidResponse withdrawGovernanceActionProcess(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String processGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.withdrawGovernanceActionProcess(serverName, serviceURLMarker, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/remove"})
    @Operation(summary="removeGovernanceActionProcess", description="Remove the metadata element representing a governance action process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse removeGovernanceActionProcess(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String processGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeGovernanceActionProcess(serverName, serviceURLMarker, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/by-search-string"})
    @Operation(summary="findGovernanceActionProcesses", description="Retrieve the list of governance action process metadata elements that contain the search string. The search string is treated as a regular expression.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessElementsResponse findGovernanceActionProcesses(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGovernanceActionProcesses(serverName, serviceURLMarker, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/by-name"})
    @Operation(summary="getGovernanceActionProcessesByName", description="Retrieve the list of governance action process metadata elements with a matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessElementsResponse getGovernanceActionProcessesByName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGovernanceActionProcessesByName(serverName, serviceURLMarker, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-action-processes/{processGUID}"})
    @Operation(summary="getGovernanceActionProcessByGUID", description="Retrieve the governance action process metadata element with the supplied unique identifier.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessElementResponse getGovernanceActionProcessByGUID(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String processGUID) {
        return this.restAPI.getGovernanceActionProcessByGUID(serverName, serviceURLMarker, userId, processGUID);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/graph"})
    @Operation(summary="getGovernanceActionProcessGraph", description="Retrieve the governance action process metadata element with the supplied unique identifier along with the flow definition describing its implementation.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessGraphResponse getGovernanceActionProcessGraph(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String processGUID, @RequestBody(required=false) ResultsRequestBody requestBody) {
        return this.restAPI.getGovernanceActionProcessGraph(serverName, serviceURLMarker, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-process-steps"})
    @Operation(summary="createGovernanceActionProcessStep", description="Create a new metadata element to represent a governance action process step.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GUIDResponse createGovernanceActionProcessStep(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody GovernanceActionProcessStepProperties requestBody) {
        return this.restAPI.createGovernanceActionProcessStep(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/governance-action-process-steps/{governanceActionTypeGUID}/update"})
    @Operation(summary="updateGovernanceActionProcessStep", description="Create a new metadata element to represent a governance action process step.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse updateGovernanceActionProcessStep(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String governanceActionTypeGUID, @RequestBody UpdateGovernanceActionProcessStepRequestBody requestBody) {
        return this.restAPI.updateGovernanceActionProcessStep(serverName, serviceURLMarker, userId, governanceActionTypeGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-process-steps/{processStepGUID}/remove"})
    @Operation(summary="removeGovernanceActionProcessStep", description="Remove the metadata element representing a governance action process step.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse removeGovernanceActionProcessStep(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String processStepGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeGovernanceActionProcessStep(serverName, serviceURLMarker, userId, processStepGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-process-steps/by-search-string"})
    @Operation(summary="findGovernanceActionProcessSteps", description="Retrieve the list of governance action process step metadata elements that contain the search string. The search string is treated as a regular expression.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessStepsResponse findGovernanceActionProcessSteps(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGovernanceActionProcessSteps(serverName, serviceURLMarker, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/governance-action-process-steps/by-name"})
    @Operation(summary="getGovernanceActionProcessStepsByName", description="Retrieve the list of governance action process step metadata elements with a matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessStepsResponse getGovernanceActionProcessStepsByName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGovernanceActionProcessStepsByName(serverName, serviceURLMarker, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-action-process-steps/{processStepGUID}"})
    @Operation(summary="getGovernanceActionProcessStepByGUID", description="Retrieve the governance action process step metadata element with the supplied unique identifier.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessStepResponse getGovernanceActionProcessStepByGUID(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String processStepGUID) {
        return this.restAPI.getGovernanceActionProcessStepByGUID(serverName, serviceURLMarker, userId, processStepGUID);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/first-process-step/{processStepGUID}"})
    @Operation(summary="setupFirstProcessStep", description="Set up a link between a governance action process and a governance action process step.  This defines the first step in the process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse setupFirstProcessStep(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String processGUID, @PathVariable String processStepGUID, @RequestBody(required=false) String requestBody) {
        return this.restAPI.setupFirstProcessStep(serverName, serviceURLMarker, userId, processGUID, processStepGUID, requestBody);
    }

    @GetMapping(path={"/governance-action-processes/{processGUID}/first-process-step"})
    @Operation(summary="getFirstProcessStep", description="Return the governance action process step that is the first step in a governance action process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public FirstGovernanceActionProcessStepResponse getFirstProcessStep(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String processGUID) {
        return this.restAPI.getFirstProcessStep(serverName, serviceURLMarker, userId, processGUID);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/first-process-step/remove"})
    @Operation(summary="removeFirstProcessStep", description="Remove the link between a governance process and that governance action process step that defines its first step.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse removeFirstProcessStep(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String processGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeFirstProcessStep(serverName, serviceURLMarker, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-process-steps/{currentProcessStepGUID}/next-process-steps/{nextProcessStepGUID}"})
    @Operation(summary="removeFirstProcessStep", description="Remove the link between a governance process and that governance action process step that defines its first step.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GUIDResponse setupNextProcessStep(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String currentProcessStepGUID, @PathVariable String nextProcessStepGUID, @RequestBody NextGovernanceActionProcessStepRequestBody requestBody) {
        return this.restAPI.setupNextProcessStep(serverName, serviceURLMarker, userId, currentProcessStepGUID, nextProcessStepGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-process-steps/next-process-steps/{nextProcessStepLinkGUID}/update"})
    @Operation(summary="updateNextProcessStep", description="Update the properties of the link between two governance action process steps that shows that one follows on from the other when a governance action process is executing.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse updateNextProcessStep(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String nextProcessStepLinkGUID, @RequestBody NextGovernanceActionProcessStepRequestBody requestBody) {
        return this.restAPI.updateNextProcessStep(serverName, serviceURLMarker, userId, nextProcessStepLinkGUID, requestBody);
    }

    @GetMapping(path={"/governance-action-process-steps/{processStepGUID}/next-process-steps"})
    @Operation(summary="getNextProcessSteps", description="Return the list of next process steps defined for the governance action process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public NextGovernanceActionProcessStepsResponse getNextProcessSteps(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String processStepGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getNextProcessSteps(serverName, serviceURLMarker, userId, processStepGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/governance-action-process-steps/next-process-step/{relationshipGUID}/remove"})
    @Operation(summary="removeNextProcessStep", description="Remove a follow-on step from a governance action process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse removeNextProcessStep(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeNextProcessStep(serverName, serviceURLMarker, userId, relationshipGUID, requestBody);
    }

    @PostMapping(path={"/governance-engines/{governanceEngineName}/engine-actions/initiate"})
    @Operation(summary="initiateEngineAction", description="Create an engine action in the metadata store that will trigger the governance service associated with the supplied request type.  The engine action remains to act as a record of the actions taken for auditing.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public GUIDResponse initiateEngineAction(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String governanceEngineName, @RequestBody InitiateEngineActionRequestBody requestBody) {
        return this.restAPI.initiateEngineAction(serverName, serviceURLMarker, userId, governanceEngineName, requestBody);
    }

    @PostMapping(path={"/governance-action-types/initiate"})
    @Operation(summary="initiateGovernanceActionType", description="Using the named governance action type as a template, initiate an engine action.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GUIDResponse initiateGovernanceActionType(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody InitiateGovernanceActionTypeRequestBody requestBody) {
        return this.restAPI.initiateGovernanceActionType(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/initiate"})
    @Operation(summary="initiateGovernanceActionProcess", description="Using the named governance action process as a template, initiate a chain of engine actions.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GUIDResponse initiateGovernanceActionProcess(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody InitiateGovernanceActionProcessRequestBody requestBody) {
        return this.restAPI.initiateGovernanceActionProcess(serverName, serviceURLMarker, userId, requestBody);
    }

    @GetMapping(path={"/engine-actions/{engineActionGUID}"})
    @Operation(summary="getEngineAction", description="Request the status and properties of an executing engine action request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public EngineActionElementResponse getEngineAction(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String engineActionGUID) {
        return this.restAPI.getEngineAction(serverName, serviceURLMarker, userId, engineActionGUID);
    }

    @PostMapping(path={"/engine-actions/{engineActionGUID}/cancel"})
    @Operation(summary="cancelEngineAction", description="Request that an engine action request is cancelled and any running governance service is stopped.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public VoidResponse cancelEngineAction(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String engineActionGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.cancelEngineAction(serverName, serviceURLMarker, userId, engineActionGUID, requestBody);
    }

    @GetMapping(path={"/engine-actions"})
    @Operation(summary="getEngineActions", description="Retrieve the engine actions that are known to the server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public EngineActionElementsResponse getEngineActions(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getEngineActions(serverName, serviceURLMarker, userId, startFrom, pageSize);
    }

    @GetMapping(path={"/engine-actions/active"})
    @Operation(summary="getActiveEngineActions", description="Retrieve the engine actions that are still in process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public EngineActionElementsResponse getActiveEngineActions(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getActiveEngineActions(serverName, serviceURLMarker, userId, startFrom, pageSize);
    }

    @PostMapping(path={"/engine-actions/by-search-string"})
    @Operation(summary="findEngineActions", description="Retrieve the list of engine action metadata elements that contain the search string. The search string is treated as a regular expression.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public EngineActionElementsResponse findEngineActions(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findEngineActions(serverName, serviceURLMarker, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/engine-actions/by-name"})
    @Operation(summary="getEngineActionsByName", description="Retrieve the list of engine action metadata elements with a matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public EngineActionElementsResponse getEngineActionsByName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getEngineActionsByName(serverName, serviceURLMarker, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/related-elements/link-as-peer-duplicate"})
    @Operation(summary="linkElementsAsPeerDuplicates", description="Create a relationship between two elements that show they represent the same \"thing\". If the relationship already exists, the properties are updated.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/duplicate-management/overview"))
    public VoidResponse linkElementsAsPeerDuplicates(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody PeerDuplicatesRequestBody requestBody) {
        return this.restAPI.linkElementsAsDuplicates(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/related-elements/link-as-consolidated-duplicate"})
    @Operation(summary="linkConsolidatedDuplicate", description="Create a relationship between two elements that shows that one is a combination of a number of duplicates, and it should be used instead. If the relationship already exists, the properties are updated.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/duplicate-management/overview"))
    public VoidResponse linkConsolidatedDuplicate(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody ConsolidatedDuplicatesRequestBody requestBody) {
        return this.restAPI.linkConsolidatedDuplicate(serverName, serviceURLMarker, userId, requestBody);
    }
}

