/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.database.ffdc;

import java.text.MessageFormat;

public enum OCFDatabaseConnectorErrorCode {
    NOT_VALID_QUERY(400, "OCFDATABASECONNECTOR-QUERY-400-001", "In {0}, the query is not valid.", "OCF Database Connector is not able to execute the query.", "Please check the query."),
    ILLEGAL_ACCESS(400, "OCFDATABASECONNECTOR-INSTANCE-400-002", "{0} is not able to create the ligal access", "The method does not have access to the definition of the specified class, field, method or constructor.", "Please check the use of newInstance."),
    ILLEGAL_INSTANCE_CREATION(400, "OCFDATABASECONNECTOR-INSTANCE-400-003", "In {0}, the instance creation is illegal.", "The specified class object using the newInstance method in class Class cannot be instantiated.", "Please check the use of newInstance."),
    CONNECT_FAIL(401, "OCFDATABASECONNECTOR-GAIAN-401-001", "{0} does not get the access to the database.", "OCF Database Connector is not able to connect the database.", "Please check the user id."),
    QUERY_EXECUTION_FAIL(401, "OCFDATABASECONNECTOR-GAIAN-401-002", "{0} can not retrieve the data from database", "OCF Database Connector is not able to access data from the database.", "Please check the query and the connection to Gaian."),
    DISCONNECT_FAIL(401, "OCFDATABASECONNECTOR-GAIAN-401-003", "{0} can not close the connection, statement and resultset properly", "OCF Database Connector is not able to shut down the connection to the database.", "Please check the code for shutting down the connection."),
    UNKNOWN_JDBC_DRIVER(500, "OCFDATABASECONNECTOR-JDBCDRIVER-500-001", "In {0}, this JDBC driver is unknown.", "OCF Database Connector is not able to connect to the database without proper driver.", "Please check the driver name.");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;

    private OCFDatabaseConnectorErrorCode(int newHTTPErrorCode, String newErrorMessageId, String newErrorMessage, String newSystemAction, String newUserAction) {
        this.httpErrorCode = newHTTPErrorCode;
        this.errorMessageId = newErrorMessageId;
        this.errorMessage = newErrorMessage;
        this.systemAction = newSystemAction;
        this.userAction = newUserAction;
    }

    public int getHTTPErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getUnformattedErrorMessage() {
        return this.errorMessage;
    }

    public String getFormattedErrorMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.errorMessage);
        String result = mf.format(params);
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

