/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.database.gaian;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.odpi.openmetadata.adapters.connectors.database.OCFDatabaseConnector;
import org.odpi.openmetadata.adapters.connectors.database.ffdc.OCFDatabaseConnectorErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaianOCFConnector
extends OCFDatabaseConnector {
    private final String connectorName = GaianOCFConnector.class.getName();
    private static final Logger log = LoggerFactory.getLogger(GaianOCFConnector.class);

    public GaianOCFConnector() {
    }

    public GaianOCFConnector(String dburlPrefix, String dburlServeraddress, String dburlServerport, String dburlDatabase, String proxyUser, String proxyPwd, boolean create) {
        super(dburlPrefix, dburlServeraddress, dburlServerport, dburlDatabase, proxyUser, proxyPwd, create);
    }

    public void setDBUrl(String userId) throws ConnectionCheckedException {
        String methodName = "setDBUrl";
        String dbURL = this.dburlPrefix + this.dburlServeraddress + ":" + this.dburlServerport + "/" + this.dburlDatabase + ";create=" + String.valueOf(this.create) + ";user=" + userId + ";password=" + this.proxyPwd + ";proxy-user=" + this.proxyUser + ";proxy-pwd=" + this.proxyPwd;
        log.debug(dbURL);
        this.setUrl(dbURL);
    }

    @Override
    public Connection connect(String userId) throws ConnectionCheckedException {
        String methodName = "createConnection";
        try {
            this.setDBUrl(userId);
        }
        catch (ConnectionCheckedException e) {
            log.error("Exception in set up database url.", e);
        }
        try {
            if (this.getSqlConnection() == null) {
                Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
                if (log.isDebugEnabled()) {
                    log.debug("new instance is successful created");
                }
                this.setSqlConnection(DriverManager.getConnection(this.getUrl()));
            }
        }
        catch (SQLException e) {
            OCFDatabaseConnectorErrorCode errorCode = OCFDatabaseConnectorErrorCode.CONNECT_FAIL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("createConnection", this.connectorName);
            throw new ConnectionCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "createConnection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), e);
        }
        catch (IllegalAccessException e) {
            OCFDatabaseConnectorErrorCode errorCode = OCFDatabaseConnectorErrorCode.ILLEGAL_ACCESS;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("createConnection", this.connectorName);
            throw new ConnectionCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "createConnection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), e);
        }
        catch (InstantiationException e) {
            OCFDatabaseConnectorErrorCode errorCode = OCFDatabaseConnectorErrorCode.ILLEGAL_INSTANCE_CREATION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("createConnection", this.connectorName);
            throw new ConnectionCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "createConnection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), e);
        }
        catch (ClassNotFoundException e) {
            OCFDatabaseConnectorErrorCode errorCode = OCFDatabaseConnectorErrorCode.UNKNOWN_JDBC_DRIVER;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("createConnection", this.connectorName);
            throw new ConnectionCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "createConnection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), e);
        }
        if (log.isDebugEnabled()) {
            log.debug("connect to database successfully");
        }
        return this.getSqlConnection();
    }

    @Override
    public ResultSet executeQuery(String query) throws ConnectorCheckedException {
        String methodName = "executeQuery";
        if (query == null || query.equals("")) {
            OCFDatabaseConnectorErrorCode errorCode = OCFDatabaseConnectorErrorCode.NOT_VALID_QUERY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("executeQuery", this.connectorName);
            throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "executeQuery", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        try {
            if (this.getSqlStatement() == null) {
                this.setSqlStatement(this.getSqlConnection().createStatement());
            }
            this.setSqlResults(this.getSqlStatement().executeQuery(query));
        }
        catch (SQLException e) {
            OCFDatabaseConnectorErrorCode errorCode = OCFDatabaseConnectorErrorCode.QUERY_EXECUTION_FAIL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("executeQuery", this.connectorName);
            throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "executeQuery", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), e);
        }
        return this.getSqlResults();
    }

    @Override
    public void disconnect() throws ConnectorCheckedException {
        String methodName = "disconnect";
        try {
            if (this.getSqlStatement() != null) {
                this.getSqlStatement().close();
            }
            if (this.getSqlResults() != null) {
                this.getSqlResults().close();
            }
            if (this.getSqlConnection() != null) {
                this.getSqlConnection().close();
            }
            if (log.isDebugEnabled()) {
                log.debug("disconnect successfully");
            }
        }
        catch (SQLException sqlExcept) {
            OCFDatabaseConnectorErrorCode errorCode = OCFDatabaseConnectorErrorCode.DISCONNECT_FAIL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("disconnect", this.connectorName);
            throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "disconnect", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), sqlExcept);
        }
    }
}

