/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors;

import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectedAssetProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectorBase
extends Connector {
    protected String connectorInstanceId = null;
    protected ConnectionProperties connectionProperties = null;
    protected Connection connectionBean = null;
    protected ConnectedAssetProperties connectedAssetProperties = null;
    protected boolean isActive = false;
    protected Map<String, Object> securedProperties = null;
    private static final Logger log = LoggerFactory.getLogger(ConnectorBase.class);
    private final int hashCode = UUID.randomUUID().hashCode();

    public ConnectorBase() {
        log.debug("New Connector Requested");
    }

    @Override
    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        this.connectorInstanceId = connectorInstanceId;
        this.connectionProperties = connectionProperties;
        ProtectedConnection protectedConnection = new ProtectedConnection(connectionProperties);
        this.securedProperties = protectedConnection.getSecuredProperties();
        this.connectionBean = protectedConnection.getConnectionBean();
        log.debug("New Connector initialized: " + connectorInstanceId + ", " + connectionProperties.getQualifiedName() + "," + connectionProperties.getDisplayName());
    }

    @Override
    public String getConnectorInstanceId() {
        return this.connectorInstanceId;
    }

    @Override
    public ConnectionProperties getConnection() {
        return this.connectionProperties;
    }

    @Override
    public void initializeConnectedAssetProperties(ConnectedAssetProperties connectedAssetProperties) {
        this.connectedAssetProperties = connectedAssetProperties;
    }

    @Override
    public ConnectedAssetProperties getConnectedAssetProperties(String userId) throws PropertyServerException, UserNotAuthorizedException {
        log.debug("ConnectedAssetProperties requested: " + this.connectorInstanceId + ", " + this.connectionProperties.getQualifiedName() + "," + this.connectionProperties.getDisplayName());
        if (this.connectedAssetProperties != null) {
            this.connectedAssetProperties.refresh();
        }
        return this.connectedAssetProperties;
    }

    @Override
    public void start() throws ConnectorCheckedException {
        this.isActive = true;
    }

    @Override
    public void disconnect() throws ConnectorCheckedException {
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConnectorBase that = (ConnectorBase)object;
        return this.hashCode == that.hashCode;
    }

    public String toString() {
        return "ConnectorBase{connectorInstanceId='" + this.connectorInstanceId + '\'' + ", connectionProperties=" + this.connectionProperties + ", connectedAssetProperties=" + this.connectedAssetProperties + ", isActive=" + this.isActive + ", hashCode=" + this.hashCode + '}';
    }

    protected static class ProtectedConnection
    extends ConnectionProperties {
        private static final long serialVersionUID = 1L;

        ProtectedConnection(ConnectionProperties templateConnection) {
            super(templateConnection);
        }

        @Override
        protected Map<String, Object> getSecuredProperties() {
            return super.getConnectionBean().getSecuredProperties();
        }

        @Override
        protected Connection getConnectionBean() {
            return super.getConnectionBean();
        }
    }
}

