/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetBoundedSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetEnumSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetLiteralSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetMapSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPrimitiveSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaElement;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.BoundedSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EnumSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.LiteralSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.MapSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PrimitiveSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;

public abstract class AssetSchemaType
extends AssetSchemaElement {
    private static final long serialVersionUID = 1L;
    private SchemaType schemaTypeBean = null;

    public static AssetSchemaType createAssetSchemaType(AssetDescriptor parentAsset, SchemaType bean) {
        AssetSchemaType assetSchemaType = null;
        if (bean instanceof PrimitiveSchemaType) {
            assetSchemaType = new AssetPrimitiveSchemaType(parentAsset, (PrimitiveSchemaType)bean);
        } else if (bean instanceof MapSchemaType) {
            assetSchemaType = new AssetMapSchemaType(parentAsset, (MapSchemaType)bean);
        } else if (bean instanceof EnumSchemaType) {
            assetSchemaType = new AssetEnumSchemaType(parentAsset, (EnumSchemaType)bean);
        } else if (bean instanceof BoundedSchemaType) {
            assetSchemaType = new AssetBoundedSchemaType(parentAsset, (BoundedSchemaType)bean);
        } else if (bean instanceof LiteralSchemaType) {
            assetSchemaType = new AssetLiteralSchemaType(parentAsset, (LiteralSchemaType)bean);
        } else if (bean instanceof ComplexSchemaType) {
            assetSchemaType = new AssetComplexSchemaType(parentAsset, (ComplexSchemaType)bean);
        }
        return assetSchemaType;
    }

    protected AssetSchemaType(AssetDescriptor parentAsset) {
        super(parentAsset);
    }

    public AssetSchemaType(SchemaType schemaTypeBean) {
        super(schemaTypeBean);
        this.schemaTypeBean = schemaTypeBean;
    }

    public AssetSchemaType(AssetDescriptor parentAsset, SchemaType schemaTypeBean) {
        super(parentAsset, schemaTypeBean);
        this.schemaTypeBean = schemaTypeBean;
    }

    public AssetSchemaType(AssetDescriptor parentAsset, AssetSchemaType templateSchema) {
        super(parentAsset, templateSchema);
        this.schemaTypeBean = templateSchema == null ? null : templateSchema.getSchemaTypeBean();
    }

    protected abstract AssetSchemaType cloneAssetSchemaType(AssetDescriptor var1);

    protected void setBean(SchemaType bean) {
        super.setBean(bean);
        this.schemaTypeBean = bean;
    }

    protected SchemaType getSchemaTypeBean() {
        return this.schemaTypeBean;
    }

    public String getVersionNumber() {
        if (this.schemaTypeBean == null) {
            return null;
        }
        return this.getSchemaTypeBean().getVersionNumber();
    }

    public String getAuthor() {
        if (this.schemaTypeBean == null) {
            return null;
        }
        return this.getSchemaTypeBean().getAuthor();
    }

    public String getUsage() {
        if (this.schemaTypeBean == null) {
            return null;
        }
        return this.getSchemaTypeBean().getUsage();
    }

    public String getEncodingStandard() {
        if (this.schemaTypeBean == null) {
            return null;
        }
        return this.getSchemaTypeBean().getEncodingStandard();
    }

    @Override
    public String toString() {
        return "AssetSchemaType{parentAsset=" + this.parentAsset + ", versionNumber='" + this.getVersionNumber() + '\'' + ", author='" + this.getAuthor() + '\'' + ", usage='" + this.getUsage() + '\'' + ", encodingStandard='" + this.getEncodingStandard() + '\'' + ", displayName='" + this.getDisplayName() + '\'' + ", description='" + this.getDescription() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", meanings=" + this.getMeanings() + ", additionalProperties=" + this.getAdditionalProperties() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + ", assetClassifications=" + this.getAssetClassifications() + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetSchemaType that = (AssetSchemaType)objectToCompare;
        return Objects.equals(this.getSchemaTypeBean(), that.getSchemaTypeBean());
    }
}

