/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal.cache;

import com.googlecode.download.maven.plugin.internal.SignatureUtils;
import com.googlecode.download.maven.plugin.internal.cache.FileBackedIndex;
import com.googlecode.download.maven.plugin.internal.cache.FileIndex;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import org.apache.commons.codec.digest.DigestUtils;

public class DownloadCache {
    private final File basedir;
    private final FileIndex index;

    public DownloadCache(File cacheDirectory) {
        DownloadCache.createIfNeeded(cacheDirectory);
        this.index = new FileBackedIndex(cacheDirectory);
        this.basedir = cacheDirectory;
    }

    private String getEntry(URI uri, String md5, String sha1, String sha512) throws Exception {
        if (!this.index.contains(uri)) {
            return null;
        }
        String res = this.index.get(uri);
        File resFile = new File(this.basedir, res);
        if (!resFile.isFile()) {
            return null;
        }
        if (md5 != null && !md5.equals(SignatureUtils.getMD5(resFile))) {
            return null;
        }
        if (sha1 != null && !sha1.equals(SignatureUtils.getSHA1(resFile))) {
            return null;
        }
        if (sha512 != null && !sha512.equals(SignatureUtils.getSHA512(resFile))) {
            return null;
        }
        return res;
    }

    public File getArtifact(URI uri, String md5, String sha1, String sha512) throws Exception {
        String res = this.getEntry(uri, md5, sha1, sha512);
        if (res != null) {
            return new File(this.basedir, res);
        }
        return null;
    }

    public void install(URI uri, File outputFile, String md5, String sha1, String sha512) throws Exception {
        String entry;
        if (md5 == null) {
            md5 = SignatureUtils.computeSignatureAsString(outputFile, MessageDigest.getInstance("MD5"));
        }
        if (sha1 == null) {
            sha1 = SignatureUtils.computeSignatureAsString(outputFile, MessageDigest.getInstance("SHA1"));
        }
        if (sha512 == null) {
            sha512 = SignatureUtils.computeSignatureAsString(outputFile, MessageDigest.getInstance("SHA-512"));
        }
        if ((entry = this.getEntry(uri, md5, sha1, sha512)) != null) {
            return;
        }
        String fileName = outputFile.getName() + '_' + DigestUtils.md5Hex(uri.toString());
        Files.copy(outputFile.toPath(), new File(this.basedir, fileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.index.put(uri, fileName);
    }

    private static void createIfNeeded(File basedir) {
        if (!basedir.exists()) {
            basedir.mkdirs();
        } else if (!basedir.isDirectory()) {
            throw new IllegalArgumentException(String.format("Cannot use %s as cache directory: file is already exist", basedir));
        }
    }
}

