/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.plexus.util.StringUtils;

public class DefaultArtifact
implements Artifact {
    private String groupId;
    private String artifactId;
    private String baseVersion;
    private final String type;
    private final String classifier;
    private String scope;
    private File file;
    private ArtifactRepository repository;
    private String downloadUrl;
    private ArtifactFilter dependencyFilter;
    private ArtifactHandler artifactHandler;
    private List dependencyTrail;
    private String version;
    private VersionRange versionRange;
    private boolean resolved;
    private boolean release;
    private List availableVersions;
    private Map metadataMap;
    private boolean optional;

    public DefaultArtifact(String groupId, String artifactId, VersionRange versionRange, String scope, String type, String classifier, ArtifactHandler artifactHandler) {
        this(groupId, artifactId, versionRange, scope, type, classifier, artifactHandler, false);
    }

    public DefaultArtifact(String groupId, String artifactId, VersionRange versionRange, String scope, String type, String classifier, ArtifactHandler artifactHandler, boolean optional) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.setVersionRange(versionRange);
        this.artifactHandler = artifactHandler;
        this.scope = scope;
        this.type = type;
        if (classifier == null) {
            classifier = artifactHandler.getClassifier();
        }
        this.classifier = classifier;
        this.optional = optional;
        this.validateIdentity();
    }

    private void validateIdentity() {
        if (this.empty(this.groupId)) {
            throw new InvalidArtifactRTException(this.groupId, this.artifactId, this.getVersion(), this.type, "The groupId cannot be empty.");
        }
        if (this.artifactId == null) {
            throw new InvalidArtifactRTException(this.groupId, this.artifactId, this.getVersion(), this.type, "The artifactId cannot be empty.");
        }
        if (this.type == null) {
            throw new InvalidArtifactRTException(this.groupId, this.artifactId, this.getVersion(), this.type, "The type cannot be empty.");
        }
        if (this.version == null && this.versionRange == null) {
            throw new InvalidArtifactRTException(this.groupId, this.artifactId, this.getVersion(), this.type, "The version cannot be empty.");
        }
    }

    private boolean empty(String value) {
        return value == null || value.trim().length() < 1;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean hasClassifier() {
        return StringUtils.isNotEmpty(this.classifier);
    }

    public String getScope() {
        return this.scope;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this.baseVersion = version;
        this.versionRange = null;
    }

    public String getType() {
        return this.type;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public void setRepository(ArtifactRepository repository) {
        this.repository = repository;
    }

    public String getId() {
        return this.getDependencyConflictId() + ":" + this.getBaseVersion();
    }

    public String getDependencyConflictId() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getType() + (this.hasClassifier() ? ":" + this.getClassifier() : "");
    }

    public void addMetadata(ArtifactMetadata metadata) {
        ArtifactMetadata m;
        if (this.metadataMap == null) {
            this.metadataMap = new HashMap();
        }
        if ((m = (ArtifactMetadata)this.metadataMap.get(metadata.getKey())) != null) {
            m.merge(metadata);
        } else {
            this.metadataMap.put(metadata.getKey(), metadata);
        }
    }

    public Collection getMetadataList() {
        return this.metadataMap == null ? Collections.EMPTY_LIST : this.metadataMap.values();
    }

    public String toString() {
        return this.getDependencyConflictId() + ":" + (this.version != null || this.baseVersion != null ? this.getBaseVersion() : this.versionRange.toString());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.groupId.hashCode();
        result = 37 * result + this.artifactId.hashCode();
        result = 37 * result + this.type.hashCode();
        if (this.version != null) {
            result = 37 * result + this.version.hashCode();
        }
        result = 37 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        Artifact a = (Artifact)o;
        if (!a.getGroupId().equals(this.groupId)) {
            return false;
        }
        if (!a.getArtifactId().equals(this.artifactId)) {
            return false;
        }
        if (!a.getVersion().equals(this.version)) {
            return false;
        }
        if (!a.getType().equals(this.type)) {
            return false;
        }
        return !(this.classifier == null ? a.getClassifier() != null : !a.getClassifier().equals(this.classifier));
    }

    public String getBaseVersion() {
        if (this.baseVersion == null) {
            this.baseVersion = this.version;
            if (this.version == null) {
                throw new NullPointerException("version was null for " + this.groupId + ":" + this.artifactId);
            }
        }
        return this.baseVersion;
    }

    public void setBaseVersion(String baseVersion) {
        this.baseVersion = baseVersion;
    }

    public int compareTo(Object o) {
        Artifact a = (Artifact)o;
        int result = this.groupId.compareTo(a.getGroupId());
        if (result == 0 && (result = this.artifactId.compareTo(a.getArtifactId())) == 0 && (result = this.type.compareTo(a.getType())) == 0) {
            if (this.classifier == null) {
                if (a.getClassifier() != null) {
                    result = 1;
                }
            } else {
                result = a.getClassifier() != null ? this.classifier.compareTo(a.getClassifier()) : -1;
            }
            if (result == 0) {
                result = this.version.compareTo(a.getVersion());
            }
        }
        return result;
    }

    public void updateVersion(String version, ArtifactRepository localRepository) {
        this.setResolvedVersion(version);
        this.setFile(new File(localRepository.getBasedir(), localRepository.pathOf(this)));
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public ArtifactFilter getDependencyFilter() {
        return this.dependencyFilter;
    }

    public void setDependencyFilter(ArtifactFilter artifactFilter) {
        this.dependencyFilter = artifactFilter;
    }

    public ArtifactHandler getArtifactHandler() {
        return this.artifactHandler;
    }

    public List getDependencyTrail() {
        return this.dependencyTrail;
    }

    public void setDependencyTrail(List dependencyTrail) {
        this.dependencyTrail = dependencyTrail;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    public final void setVersionRange(VersionRange versionRange) {
        this.versionRange = versionRange;
        if (versionRange != null && versionRange.getRecommendedVersion() != null) {
            this.selectVersion(versionRange.getRecommendedVersion().toString());
        } else {
            this.version = null;
            this.baseVersion = null;
        }
    }

    public void selectVersion(String version) {
        this.version = version;
        this.baseVersion = version;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public boolean isSnapshot() {
        if (this.version != null || this.baseVersion != null) {
            Matcher m = Artifact.VERSION_FILE_PATTERN.matcher(this.getBaseVersion());
            if (m.matches()) {
                this.setBaseVersion(m.group(1) + "-" + "SNAPSHOT");
                return true;
            }
            return this.getBaseVersion().endsWith("SNAPSHOT") || this.getBaseVersion().equals("LATEST");
        }
        return false;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolvedVersion(String version) {
        this.version = version;
    }

    public void setArtifactHandler(ArtifactHandler artifactHandler) {
        this.artifactHandler = artifactHandler;
    }

    public void setRelease(boolean release) {
        this.release = release;
    }

    public boolean isRelease() {
        return this.release;
    }

    public List getAvailableVersions() {
        return this.availableVersions;
    }

    public void setAvailableVersions(List availableVersions) {
        this.availableVersions = availableVersions;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public ArtifactVersion getSelectedVersion() throws OverConstrainedVersionException {
        return this.versionRange.getSelectedVersion(this);
    }

    public boolean isSelectedVersionKnown() throws OverConstrainedVersionException {
        return this.versionRange.isSelectedVersionKnown(this);
    }
}

