/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.manager;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.ChecksumFailedException;
import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.ChecksumObserver;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class DefaultWagonManager
extends AbstractLogEnabled
implements WagonManager,
Contextualizable {
    private PlexusContainer container;
    private Map proxies = new HashMap();
    private Map authenticationInfoMap = new HashMap();
    private Map serverPermissionsMap = new HashMap();
    private Map mirrors = new HashMap();
    private Map serverConfigurationMap = new HashMap();
    private TransferListener downloadMonitor;
    private boolean online = true;
    private ArtifactRepositoryFactory repositoryFactory;
    private boolean interactive = true;

    public Wagon getWagon(String protocol) throws UnsupportedProtocolException {
        Wagon wagon;
        try {
            wagon = (Wagon)this.container.lookup(Wagon.ROLE, protocol);
            wagon.setInteractive(this.interactive);
        }
        catch (ComponentLookupException e) {
            throw new UnsupportedProtocolException("Cannot find wagon which supports the requested protocol: " + protocol, e);
        }
        return wagon;
    }

    public void putArtifact(File source, Artifact artifact, ArtifactRepository repository) throws TransferFailedException {
        this.putRemoteFile(repository, source, repository.pathOf(artifact), this.downloadMonitor);
    }

    public void putArtifactMetadata(File source, ArtifactMetadata artifactMetadata, ArtifactRepository repository) throws TransferFailedException {
        this.getLogger().info("Uploading " + artifactMetadata);
        this.putRemoteFile(repository, source, repository.pathOfRemoteRepositoryMetadata(artifactMetadata), null);
    }

    private void putRemoteFile(ArtifactRepository repository, File source, String remotePath, TransferListener downloadMonitor) throws TransferFailedException {
        Wagon wagon;
        this.failIfNotOnline();
        String protocol = repository.getProtocol();
        try {
            wagon = this.getWagon(protocol);
            this.configureWagon(wagon, repository);
        }
        catch (UnsupportedProtocolException e) {
            throw new TransferFailedException("Unsupported Protocol: '" + protocol + "': " + e.getMessage(), e);
        }
        if (downloadMonitor != null) {
            wagon.addTransferListener(downloadMonitor);
        }
        HashMap<String, ChecksumObserver> checksums = new HashMap<String, ChecksumObserver>(2);
        HashMap<String, String> sums = new HashMap<String, String>(2);
        try {
            ChecksumObserver checksumObserver = new ChecksumObserver("MD5");
            wagon.addTransferListener(checksumObserver);
            checksums.put("md5", checksumObserver);
            checksumObserver = new ChecksumObserver("SHA-1");
            wagon.addTransferListener(checksumObserver);
            checksums.put("sha1", checksumObserver);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TransferFailedException("Unable to add checksum methods: " + e.getMessage(), e);
        }
        try {
            String extension;
            Repository artifactRepository = new Repository(repository.getId(), repository.getUrl());
            if (this.serverPermissionsMap.containsKey(repository.getId())) {
                RepositoryPermissions perms = (RepositoryPermissions)this.serverPermissionsMap.get(repository.getId());
                this.getLogger().debug("adding permissions to wagon connection: " + perms.getFileMode() + " " + perms.getDirectoryMode());
                artifactRepository.setPermissions(perms);
            } else {
                this.getLogger().debug("not adding permissions to wagon connection");
            }
            wagon.connect(artifactRepository, this.getAuthenticationInfo(repository.getId()), this.getProxy(protocol));
            wagon.put(source, remotePath);
            wagon.removeTransferListener(downloadMonitor);
            Iterator i = checksums.keySet().iterator();
            while (i.hasNext()) {
                extension = (String)i.next();
                ChecksumObserver observer = (ChecksumObserver)checksums.get(extension);
                sums.put(extension, observer.getActualChecksum());
            }
            i = checksums.keySet().iterator();
            while (i.hasNext()) {
                extension = (String)i.next();
                File temp = File.createTempFile("maven-artifact", null);
                temp.deleteOnExit();
                FileUtils.fileWrite(temp.getAbsolutePath(), (String)sums.get(extension));
                wagon.put(temp, remotePath + "." + extension);
            }
        }
        catch (ConnectionException e) {
            throw new TransferFailedException("Connection failed: " + e.getMessage(), e);
        }
        catch (AuthenticationException e) {
            throw new TransferFailedException("Authentication failed: " + e.getMessage(), e);
        }
        catch (AuthorizationException e) {
            throw new TransferFailedException("Authorization failed: " + e.getMessage(), e);
        }
        catch (ResourceDoesNotExistException e) {
            throw new TransferFailedException("Resource to deploy not found: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error creating temporary file for deployment: " + e.getMessage(), e);
        }
        finally {
            this.disconnectWagon(wagon);
            this.releaseWagon(wagon);
        }
    }

    public void getArtifact(Artifact artifact, List remoteRepositories) throws TransferFailedException, ResourceDoesNotExistException {
        boolean successful = false;
        Iterator iter = remoteRepositories.iterator();
        while (iter.hasNext() && !successful) {
            ArtifactRepository repository = (ArtifactRepository)iter.next();
            try {
                this.getArtifact(artifact, repository);
                successful = artifact.isResolved();
            }
            catch (ResourceDoesNotExistException e) {
                this.getLogger().warn("Unable to get resource from repository " + repository.getId() + " (" + repository.getUrl() + ")");
            }
        }
        if (!successful) {
            throw new ResourceDoesNotExistException("Unable to download the artifact from any repository");
        }
    }

    public void getArtifact(Artifact artifact, ArtifactRepository repository) throws TransferFailedException, ResourceDoesNotExistException {
        ArtifactRepositoryPolicy policy;
        String remotePath = repository.pathOf(artifact);
        ArtifactRepositoryPolicy artifactRepositoryPolicy = policy = artifact.isSnapshot() ? repository.getSnapshots() : repository.getReleases();
        if (!policy.isEnabled()) {
            this.getLogger().debug("Skipping disabled repository " + repository.getId());
        } else if (repository.isBlacklisted()) {
            this.getLogger().debug("Skipping blacklisted repository " + repository.getId());
        } else {
            this.getLogger().debug("Trying repository " + repository.getId());
            this.getRemoteFile(repository, artifact.getFile(), remotePath, this.downloadMonitor, policy.getChecksumPolicy());
            this.getLogger().debug("  Artifact resolved");
            artifact.setResolved(true);
        }
    }

    public void getArtifactMetadata(ArtifactMetadata metadata, ArtifactRepository repository, File destination, String checksumPolicy) throws TransferFailedException, ResourceDoesNotExistException {
        String remotePath = repository.pathOfRemoteRepositoryMetadata(metadata);
        this.getRemoteFile(repository, destination, remotePath, null, checksumPolicy);
    }

    private void getRemoteFile(ArtifactRepository repository, File destination, String remotePath, TransferListener downloadMonitor, String checksumPolicy) throws TransferFailedException, ResourceDoesNotExistException, ChecksumFailedException {
        ChecksumObserver sha1ChecksumObserver;
        ChecksumObserver md5ChecksumObserver;
        Wagon wagon;
        this.failIfNotOnline();
        ArtifactRepository mirror = this.getMirror(repository.getId());
        if (mirror != null) {
            repository = this.repositoryFactory.createArtifactRepository(mirror.getId(), mirror.getUrl(), repository.getLayout(), repository.getSnapshots(), repository.getReleases());
        }
        String protocol = repository.getProtocol();
        try {
            wagon = this.getWagon(protocol);
        }
        catch (UnsupportedProtocolException e) {
            throw new TransferFailedException("Unsupported Protocol: '" + protocol + "': " + e.getMessage(), e);
        }
        if (downloadMonitor != null) {
            wagon.addTransferListener(downloadMonitor);
        }
        try {
            md5ChecksumObserver = new ChecksumObserver("MD5");
            wagon.addTransferListener(md5ChecksumObserver);
            sha1ChecksumObserver = new ChecksumObserver("SHA-1");
            wagon.addTransferListener(sha1ChecksumObserver);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TransferFailedException("Unable to add checksum methods: " + e.getMessage(), e);
        }
        File temp = new File(destination + ".tmp");
        temp.deleteOnExit();
        try {
            wagon.connect(new Repository(repository.getId(), repository.getUrl()), this.getAuthenticationInfo(repository.getId()), this.getProxy(protocol));
            boolean firstRun = true;
            boolean retry = true;
            while (firstRun || retry) {
                retry = false;
                wagon.get(remotePath, temp);
                if (downloadMonitor != null) {
                    wagon.removeTransferListener(downloadMonitor);
                }
                try {
                    this.verifyChecksum(sha1ChecksumObserver, temp, remotePath, ".sha1", wagon);
                }
                catch (ChecksumFailedException e) {
                    if (firstRun) {
                        this.getLogger().warn("*** CHECKSUM FAILED - " + e.getMessage() + " - RETRYING");
                        retry = true;
                    } else {
                        this.handleChecksumFailure(checksumPolicy, e.getMessage(), e.getCause());
                    }
                }
                catch (ResourceDoesNotExistException sha1TryException) {
                    this.getLogger().debug("SHA1 not found, trying MD5", sha1TryException);
                    try {
                        this.verifyChecksum(md5ChecksumObserver, temp, remotePath, ".md5", wagon);
                    }
                    catch (ChecksumFailedException e) {
                        if (firstRun) {
                            retry = true;
                        } else {
                            this.handleChecksumFailure(checksumPolicy, e.getMessage(), e.getCause());
                        }
                    }
                    catch (ResourceDoesNotExistException md5TryException) {
                        this.handleChecksumFailure(checksumPolicy, "Error retrieving checksum file for " + remotePath, md5TryException);
                    }
                }
                if (downloadMonitor != null) {
                    wagon.addTransferListener(downloadMonitor);
                }
                firstRun = false;
            }
        }
        catch (ConnectionException e) {
            throw new TransferFailedException("Connection failed: " + e.getMessage(), e);
        }
        catch (AuthenticationException e) {
            throw new TransferFailedException("Authentication failed: " + e.getMessage(), e);
        }
        catch (AuthorizationException e) {
            throw new TransferFailedException("Authorization failed: " + e.getMessage(), e);
        }
        finally {
            this.disconnectWagon(wagon);
            this.releaseWagon(wagon);
        }
        if (!temp.exists()) {
            throw new ResourceDoesNotExistException("Downloaded file does not exist: " + temp);
        }
        if (!temp.renameTo(destination)) {
            try {
                FileUtils.copyFile(temp, destination);
                temp.delete();
            }
            catch (IOException e) {
                throw new TransferFailedException("Error copying temporary file to the final destination: " + e.getMessage(), e);
            }
        }
    }

    private void failIfNotOnline() throws TransferFailedException {
        if (!this.isOnline()) {
            throw new TransferFailedException("System is offline.");
        }
    }

    private void handleChecksumFailure(String checksumPolicy, String message, Throwable cause) throws ChecksumFailedException {
        if ("fail".equals(checksumPolicy)) {
            throw new ChecksumFailedException(message, cause);
        }
        if (!"ignore".equals(checksumPolicy)) {
            this.getLogger().warn("*** CHECKSUM FAILED - " + message + " - IGNORING");
        }
    }

    private void verifyChecksum(ChecksumObserver checksumObserver, File destination, String remotePath, String checksumFileExtension, Wagon wagon) throws ResourceDoesNotExistException, TransferFailedException, AuthorizationException {
        try {
            String actualChecksum = checksumObserver.getActualChecksum();
            File checksumFile = new File(destination + checksumFileExtension);
            checksumFile.deleteOnExit();
            wagon.get(remotePath + checksumFileExtension, checksumFile);
            String expectedChecksum = FileUtils.fileRead(checksumFile);
            expectedChecksum = expectedChecksum.trim();
            if (expectedChecksum.startsWith("MD5")) {
                int lastSpacePos = expectedChecksum.lastIndexOf(32);
                expectedChecksum = expectedChecksum.substring(lastSpacePos + 1);
            } else {
                int spacePos = expectedChecksum.indexOf(32);
                if (spacePos != -1) {
                    expectedChecksum = expectedChecksum.substring(0, spacePos);
                }
            }
            if (!expectedChecksum.equals(actualChecksum)) {
                throw new ChecksumFailedException("Checksum failed on download: local = '" + actualChecksum + "'; remote = '" + expectedChecksum + "'");
            }
        }
        catch (IOException e) {
            throw new ChecksumFailedException("Invalid checksum file", e);
        }
    }

    private void disconnectWagon(Wagon wagon) {
        try {
            wagon.disconnect();
        }
        catch (ConnectionException e) {
            this.getLogger().error("Problem disconnecting from wagon - ignoring: " + e.getMessage());
        }
    }

    private void releaseWagon(Wagon wagon) {
        try {
            this.container.release(wagon);
        }
        catch (ComponentLifecycleException e) {
            this.getLogger().error("Problem releasing wagon - ignoring: " + e.getMessage());
        }
    }

    public ProxyInfo getProxy(String protocol) {
        return (ProxyInfo)this.proxies.get(protocol);
    }

    public AuthenticationInfo getAuthenticationInfo(String id) {
        return (AuthenticationInfo)this.authenticationInfoMap.get(id);
    }

    public ArtifactRepository getMirror(String mirrorOf) {
        return (ArtifactRepository)this.mirrors.get(mirrorOf);
    }

    public void addProxy(String protocol, String host, int port, String username, String password, String nonProxyHosts) {
        ProxyInfo proxyInfo = new ProxyInfo();
        proxyInfo.setHost(host);
        proxyInfo.setType(protocol);
        proxyInfo.setPort(port);
        proxyInfo.setNonProxyHosts(nonProxyHosts);
        proxyInfo.setUserName(username);
        proxyInfo.setPassword(password);
        this.proxies.put(protocol, proxyInfo);
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }

    public void setDownloadMonitor(TransferListener downloadMonitor) {
        this.downloadMonitor = downloadMonitor;
    }

    public void addAuthenticationInfo(String repositoryId, String username, String password, String privateKey, String passphrase) {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName(username);
        authInfo.setPassword(password);
        authInfo.setPrivateKey(privateKey);
        authInfo.setPassphrase(passphrase);
        this.authenticationInfoMap.put(repositoryId, authInfo);
    }

    public void addPermissionInfo(String repositoryId, String filePermissions, String directoryPermissions) {
        RepositoryPermissions permissions = new RepositoryPermissions();
        boolean addPermissions = false;
        if (filePermissions != null) {
            permissions.setFileMode(filePermissions);
            addPermissions = true;
        }
        if (directoryPermissions != null) {
            permissions.setDirectoryMode(directoryPermissions);
            addPermissions = true;
        }
        if (addPermissions) {
            this.serverPermissionsMap.put(repositoryId, permissions);
        }
    }

    public void addMirror(String id, String mirrorOf, String url) {
        DefaultArtifactRepository mirror = new DefaultArtifactRepository(id, url, null);
        this.mirrors.put(mirrorOf, mirror);
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    private void configureWagon(Wagon wagon, ArtifactRepository repository) throws WagonConfigurationException {
        String repositoryId = repository.getId();
        if (this.serverConfigurationMap.containsKey(repositoryId)) {
            ComponentConfigurator componentConfigurator = null;
            try {
                componentConfigurator = (ComponentConfigurator)this.container.lookup(ComponentConfigurator.ROLE);
                componentConfigurator.configureComponent(wagon, (PlexusConfiguration)this.serverConfigurationMap.get(repositoryId), this.container.getContainerRealm());
                System.out.println("done");
            }
            catch (ComponentLookupException e) {
                throw new WagonConfigurationException(repositoryId, "Unable to lookup wagon configurator. Wagon configuration cannot be applied.", e);
            }
            catch (ComponentConfigurationException e) {
                throw new WagonConfigurationException(repositoryId, "Unable to apply wagon configuration.", e);
            }
            finally {
                if (componentConfigurator != null) {
                    try {
                        this.container.release(componentConfigurator);
                    }
                    catch (ComponentLifecycleException e) {
                        this.getLogger().error("Problem releasing configurator - ignoring: " + e.getMessage());
                    }
                }
            }
        }
    }

    public void addConfiguration(String repositoryId, Xpp3Dom configuration) {
        if (repositoryId == null || configuration == null) {
            throw new IllegalArgumentException("arguments can't be null");
        }
        XmlPlexusConfiguration xmlConf = configuration == null ? new XmlPlexusConfiguration("configuration") : new XmlPlexusConfiguration(configuration);
        this.serverConfigurationMap.put(repositoryId, xmlConf);
    }
}

