/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.PathTranslator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;

public class PluginParameterExpressionEvaluator
implements ExpressionEvaluator {
    private static final Map BANNED_EXPRESSIONS;
    private static final Map DEPRECATED_EXPRESSIONS;
    private final PathTranslator pathTranslator;
    private final MavenSession context;
    private final Logger logger;
    private final MojoExecution mojoExecution;
    private final MavenProject project;
    private final String basedir;
    private final Properties properties;

    public PluginParameterExpressionEvaluator(MavenSession context, MojoExecution mojoExecution, PathTranslator pathTranslator, Logger logger, MavenProject project, Properties properties) {
        File projectFile;
        this.context = context;
        this.mojoExecution = mojoExecution;
        this.pathTranslator = pathTranslator;
        this.logger = logger;
        this.project = project;
        this.properties = properties;
        String basedir = null;
        if (project != null && (projectFile = project.getFile()) != null) {
            basedir = projectFile.getParentFile().getAbsolutePath();
        }
        if (basedir == null) {
            basedir = System.getProperty("user.dir");
        }
        this.basedir = basedir;
    }

    public Object evaluate(String expr) throws ExpressionEvaluationException {
        String val;
        int exprStartDelimiter;
        String pathExpression;
        int pathSeparator;
        Object value = null;
        if (expr == null) {
            return null;
        }
        String expression = this.stripTokens(expr);
        if (expression.equals(expr)) {
            int lastIndex;
            int index = expr.indexOf("${");
            if (index >= 0 && (lastIndex = expr.indexOf("}", index)) >= 0) {
                String retVal = expr.substring(0, index);
                retVal = retVal + this.evaluate(expr.substring(index, lastIndex + 1));
                retVal = retVal + this.evaluate(expr.substring(lastIndex + 1));
                return retVal;
            }
            return expression;
        }
        MojoDescriptor mojoDescriptor = this.mojoExecution.getMojoDescriptor();
        if (BANNED_EXPRESSIONS.containsKey(expression)) {
            throw new ExpressionEvaluationException("The parameter expression: '" + expression + "' used in mojo: '" + mojoDescriptor.getGoal() + "' is banned. Use '" + BANNED_EXPRESSIONS.get(expression) + "' instead.");
        }
        if (DEPRECATED_EXPRESSIONS.containsKey(expression)) {
            this.logger.warn("The parameter expression: '" + expression + "' used in mojo: '" + mojoDescriptor.getGoal() + "' has been deprecated. Use '" + DEPRECATED_EXPRESSIONS.get(expression) + "' instead.");
        }
        if ("localRepository".equals(expression)) {
            value = this.context.getLocalRepository();
        } else if ("session".equals(expression)) {
            value = this.context;
        } else if ("reactorProjects".equals(expression)) {
            value = this.context.getSortedProjects();
        } else if ("reports".equals(expression)) {
            value = this.mojoExecution.getReports();
        } else if ("project".equals(expression)) {
            value = this.project;
        } else if ("executedProject".equals(expression)) {
            value = this.project.getExecutionProject();
        } else if (expression.startsWith("project")) {
            try {
                pathSeparator = expression.indexOf("/");
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(0, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression, this.project);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), this.project);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if (expression.startsWith("plugin")) {
            try {
                pathSeparator = expression.indexOf("/");
                PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
                if (pathSeparator > 0) {
                    String pathExpression2 = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression2, pluginDescriptor);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), pluginDescriptor);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if ("settings".equals(expression)) {
            value = this.context.getSettings();
        } else if (expression.startsWith("settings")) {
            try {
                pathSeparator = expression.indexOf("/");
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression, this.context.getSettings());
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), this.context.getSettings());
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if ("basedir".equals(expression)) {
            value = this.basedir;
        } else if (expression.startsWith("basedir")) {
            pathSeparator = expression.indexOf("/");
            if (pathSeparator > 0) {
                value = this.basedir + expression.substring(pathSeparator);
            } else {
                this.logger.error("Got expression '" + expression + "' that was not recognised");
            }
        }
        if (value == null) {
            if (this.project != null && this.project.getProperties() != null) {
                value = this.project.getProperties().getProperty(expression);
            }
            if (value == null && this.properties != null) {
                value = this.properties.getProperty(expression);
            }
        }
        if (value instanceof String && (exprStartDelimiter = (val = (String)value).indexOf("${")) >= 0) {
            value = exprStartDelimiter > 0 ? val.substring(0, exprStartDelimiter) + this.evaluate(val.substring(exprStartDelimiter)) : this.evaluate(val.substring(exprStartDelimiter));
        }
        return value;
    }

    private String stripTokens(String expr) {
        if (expr.startsWith("${") && expr.indexOf("}") == expr.length() - 1) {
            expr = expr.substring(2, expr.length() - 1);
        }
        return expr;
    }

    public File alignToBaseDirectory(File file) {
        File basedir = this.project != null && this.project.getFile() != null ? this.project.getFile().getParentFile() : new File(".").getAbsoluteFile().getParentFile();
        return new File(this.pathTranslator.alignToBaseDirectory(file.getPath(), basedir));
    }

    static {
        HashMap banned;
        HashMap<String, String> deprecated = new HashMap<String, String>();
        deprecated.put("project.build.resources", "project.resources");
        deprecated.put("project.build.testResources", "project.testResources");
        DEPRECATED_EXPRESSIONS = deprecated;
        BANNED_EXPRESSIONS = banned = new HashMap();
    }
}

