/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.RuntimeInfo;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultMavenSettingsBuilder
extends AbstractLogEnabled
implements MavenSettingsBuilder,
Initializable {
    public static final String userHome = System.getProperty("user.home");
    private String userSettingsPath;
    private String globalSettingsPath;
    private File userSettingsFile;
    private File globalSettingsFile;
    private Settings loadedSettings;

    public void initialize() {
        this.userSettingsFile = this.getFile(this.userSettingsPath, "user.home", "org.apache.maven.user-settings");
        this.globalSettingsFile = this.getFile(this.globalSettingsPath, "maven.home", "org.apache.maven.global-settings");
        this.getLogger().debug("Building Maven global-level settings from: '" + this.globalSettingsFile.getAbsolutePath() + "'");
        this.getLogger().debug("Building Maven user-level settings from: '" + this.userSettingsFile.getAbsolutePath() + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Settings readSettings(File settingsFile) throws IOException, XmlPullParserException {
        Settings settings = null;
        if (settingsFile.exists() && settingsFile.isFile()) {
            FileReader reader = null;
            try {
                reader = new FileReader(settingsFile);
                SettingsXpp3Reader modelReader = new SettingsXpp3Reader();
                settings = modelReader.read(reader);
                RuntimeInfo rtInfo = new RuntimeInfo(settings);
                rtInfo.setFile(settingsFile);
                settings.setRuntimeInfo(rtInfo);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
            IOUtil.close(reader);
        }
        return settings;
    }

    public Settings buildSettings() throws IOException, XmlPullParserException {
        return this.buildSettings(this.userSettingsFile);
    }

    public Settings buildSettings(File userSettingsFile) throws IOException, XmlPullParserException {
        if (this.loadedSettings == null) {
            Settings globalSettings = this.readSettings(this.globalSettingsFile);
            Settings userSettings = this.readSettings(userSettingsFile);
            if (userSettings == null) {
                userSettings = new Settings();
                userSettings.setRuntimeInfo(new RuntimeInfo(userSettings));
            }
            SettingsUtils.merge(userSettings, globalSettings, "global-level");
            this.setLocalRepository(userSettings);
            this.loadedSettings = userSettings;
        }
        return this.loadedSettings;
    }

    private void setLocalRepository(Settings userSettings) {
        String localRepository = System.getProperty("maven.repo.local");
        if (localRepository == null || localRepository.length() < 1) {
            localRepository = userSettings.getLocalRepository();
        }
        if (localRepository == null || localRepository.length() < 1) {
            File mavenUserConfigurationDirectory = new File(userHome, ".m2");
            if (mavenUserConfigurationDirectory.exists() || !mavenUserConfigurationDirectory.mkdirs()) {
                // empty if block
            }
            localRepository = new File(mavenUserConfigurationDirectory, "repository").getAbsolutePath();
        }
        userSettings.setLocalRepository(localRepository);
    }

    private File getFile(String pathPattern, String basedirSysProp, String altLocationSysProp) {
        String path = System.getProperty(altLocationSysProp);
        if (StringUtils.isEmpty(path)) {
            String basedir = System.getProperty(basedirSysProp);
            if (basedir == null) {
                basedir = System.getProperty("user.dir");
            }
            basedir = basedir.replaceAll("\\\\", "/");
            basedir = basedir.replaceAll("\\$", "\\\\\\$");
            path = pathPattern.replaceAll("\\$\\{" + basedirSysProp + "\\}", basedir);
            path = path.replaceAll("\\\\", "/");
            path = path.replaceAll("//", "/");
            return new File(path).getAbsoluteFile();
        }
        return new File(path).getAbsoluteFile();
    }
}

