/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.PermissionModeUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.ssh.interactive.InteractiveUserInfo;
import org.apache.maven.wagon.providers.ssh.interactive.NullInteractiveUserInfo;
import org.apache.maven.wagon.providers.ssh.interactive.UserInfoUIKeyboardInteractiveProxy;
import org.apache.maven.wagon.providers.ssh.knownhost.KnownHostsProvider;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractSshWagon
extends AbstractWagon
implements CommandExecutor {
    public static final int DEFAULT_SSH_PORT = 22;
    public static final int SOCKS5_PROXY_PORT = 1080;
    protected Session session;
    public static final String EXEC_CHANNEL = "exec";
    private static final int LINE_BUFFER_SIZE = 256;
    private static final byte LF = 10;
    private KnownHostsProvider knownHostsProvider;
    private InteractiveUserInfo interactiveUserInfo;
    private UIKeyboardInteractive uIKeyboardInteractive;

    public void openConnection() throws AuthenticationException {
        File privateKey;
        if (this.authenticationInfo == null) {
            this.authenticationInfo = new AuthenticationInfo();
        }
        if (this.authenticationInfo.getUserName() == null) {
            this.authenticationInfo.setUserName(System.getProperty("user.name"));
        }
        JSch sch = new JSch();
        int port = this.getRepository().getPort();
        if (port == -1) {
            port = 22;
        }
        String host = this.getRepository().getHost();
        try {
            this.session = sch.getSession(this.authenticationInfo.getUserName(), host, port);
        }
        catch (JSchException e) {
            this.fireSessionError(e);
            throw new AuthenticationException("Cannot connect. Reason: " + e.getMessage(), e);
        }
        if (this.authenticationInfo.getPassword() == null && (privateKey = this.authenticationInfo.getPrivateKey() != null ? new File(this.authenticationInfo.getPrivateKey()) : this.findPrivateKey()).exists()) {
            if (this.authenticationInfo.getPassphrase() == null) {
                this.authenticationInfo.setPassphrase("");
            }
            this.fireSessionDebug("Using private key: " + privateKey);
            try {
                sch.addIdentity(privateKey.getAbsolutePath(), this.authenticationInfo.getPassphrase());
            }
            catch (JSchException e) {
                this.fireSessionError(e);
                throw new AuthenticationException("Cannot connect. Reason: " + e.getMessage(), e);
            }
        }
        if (this.proxyInfo != null && this.proxyInfo.getHost() != null) {
            Proxy proxy;
            int proxyPort = this.proxyInfo.getPort();
            if (proxyPort == 1080) {
                proxy = new ProxySOCKS5(this.proxyInfo.getHost());
                ((ProxySOCKS5)proxy).setUserPasswd(this.proxyInfo.getUserName(), this.proxyInfo.getPassword());
            } else {
                proxy = new ProxyHTTP(this.proxyInfo.getHost(), proxyPort);
                ((ProxyHTTP)proxy).setUserPasswd(this.proxyInfo.getUserName(), this.proxyInfo.getPassword());
            }
            try {
                proxy.connect(this.session, host, port);
            }
            catch (Exception e) {
                this.fireSessionError(e);
                throw new AuthenticationException("Cannot connect. Reason: " + e.getMessage(), e);
            }
        }
        Properties config = new Properties();
        config.setProperty("BatchMode", this.interactive ? "no" : "yes");
        if (!this.interactive) {
            this.interactiveUserInfo = new NullInteractiveUserInfo();
            this.uIKeyboardInteractive = null;
        }
        UserInfo ui = new WagonUserInfo(this.authenticationInfo, this.interactiveUserInfo);
        if (this.uIKeyboardInteractive != null) {
            ui = new UserInfoUIKeyboardInteractiveProxy(ui, this.uIKeyboardInteractive);
        }
        if (this.knownHostsProvider != null) {
            try {
                this.knownHostsProvider.addConfiguration(config);
                this.knownHostsProvider.addKnownHosts(sch, ui);
            }
            catch (JSchException e) {
                this.fireSessionError(e);
            }
        }
        this.session.setConfig(config);
        this.session.setUserInfo(ui);
        try {
            this.session.connect();
            if (this.knownHostsProvider != null) {
                this.knownHostsProvider.storeKnownHosts(sch);
            }
        }
        catch (JSchException e) {
            this.fireSessionError(e);
            throw new AuthenticationException("Cannot connect. Reason: " + e.getMessage(), e);
        }
    }

    private File findPrivateKey() {
        File privateKey;
        String privateKeyDirectory = System.getProperty("wagon.privateKeyDirectory");
        if (privateKeyDirectory == null) {
            privateKeyDirectory = System.getProperty("user.home");
        }
        if (!(privateKey = new File(privateKeyDirectory, ".ssh/id_dsa")).exists()) {
            privateKey = new File(privateKeyDirectory, ".ssh/id_rsa");
        }
        return privateKey;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeCommand(String command) throws CommandExecutionException {
        Channel channel = null;
        InputStream in = null;
        InputStream err = null;
        OutputStream out = null;
        try {
            this.fireTransferDebug("Executing command: " + command);
            channel = (ChannelExec)this.session.openChannel(EXEC_CHANNEL);
            ((ChannelExec)channel).setCommand(command + "\n");
            out = channel.getOutputStream();
            in = channel.getInputStream();
            err = ((ChannelExec)channel).getErrStream();
            channel.connect();
            AbstractSshWagon.sendEom(out);
            String line = this.readLine(err);
            if (line != null) {
                throw new CommandExecutionException(line);
            }
        }
        catch (JSchException e) {
            try {
                throw new CommandExecutionException("Cannot execute remote command: " + command, e);
                catch (IOException e2) {
                    throw new CommandExecutionException("Cannot execute remote command: " + command, e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                IOUtil.close(in);
                IOUtil.close(err);
                if (channel == null) throw throwable;
                channel.disconnect();
                throw throwable;
            }
        }
        IOUtil.close(out);
        IOUtil.close(in);
        IOUtil.close(err);
        if (channel == null) return;
        channel.disconnect();
    }

    protected String readLine(InputStream in) throws IOException {
        byte[] buf = new byte[256];
        String result = null;
        int i = 0;
        while (result == null) {
            if (in.read(buf, i, 1) != 1) {
                return null;
            }
            if (buf[i] == 10) {
                result = new String(buf, 0, i);
            }
            ++i;
        }
        return result;
    }

    protected static void sendEom(OutputStream out) throws IOException {
        out.write(0);
        out.flush();
    }

    public void closeConnection() {
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    protected void handleGetException(Resource resource, Exception e, File destination) throws TransferFailedException, ResourceDoesNotExistException {
        boolean deleted;
        this.fireTransferError(resource, e, 5);
        if (destination.exists() && !(deleted = destination.delete())) {
            destination.deleteOnExit();
        }
        String msg = "Error occured while downloading '" + resource + "' from the remote repository:" + this.getRepository();
        if ("No such file".equals(e.toString())) {
            throw new ResourceDoesNotExistException(msg, e);
        }
        throw new TransferFailedException(msg, e);
    }

    public final KnownHostsProvider getKnownHostsProvider() {
        return this.knownHostsProvider;
    }

    public final void setKnownHostsProvider(KnownHostsProvider knownHostsProvider) {
        if (knownHostsProvider == null) {
            throw new IllegalArgumentException("knownHostsProvider can't be null");
        }
        this.knownHostsProvider = knownHostsProvider;
    }

    public InteractiveUserInfo getInteractiveUserInfo() {
        return this.interactiveUserInfo;
    }

    public void setInteractiveUserInfo(InteractiveUserInfo interactiveUserInfo) {
        if (interactiveUserInfo == null) {
            throw new IllegalArgumentException("interactiveUserInfo can't be null");
        }
        this.interactiveUserInfo = interactiveUserInfo;
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File zipFile;
        String basedir = this.getRepository().getBasedir();
        destinationDirectory = StringUtils.replace(destinationDirectory, "\\", "/");
        String path = AbstractWagon.getPath(basedir, destinationDirectory);
        try {
            String dirPerms;
            if (this.getRepository().getPermissions() != null && (dirPerms = this.getRepository().getPermissions().getDirectoryMode()) != null) {
                String umaskCmd = "umask " + PermissionModeUtils.getUserMaskFor(dirPerms);
                this.executeCommand(umaskCmd);
            }
            String mkdirCmd = "mkdir -p " + path;
            this.executeCommand(mkdirCmd);
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error performing commands for file transfer", e);
        }
        try {
            zipFile = File.createTempFile("wagon", ".zip");
            zipFile.deleteOnExit();
            List<String> files = FileUtils.getFileNames(sourceDirectory, "**/**", "", false);
            this.createZip(files, zipFile, sourceDirectory);
        }
        catch (IOException e) {
            throw new TransferFailedException("Unable to create ZIP archive of directory", e);
        }
        this.put(zipFile, AbstractWagon.getPath(destinationDirectory, zipFile.getName()));
        try {
            this.executeCommand("cd " + path + "; unzip -o " + zipFile.getName() + "; rm -f " + zipFile.getName());
            zipFile.delete();
            RepositoryPermissions permissions = this.getRepository().getPermissions();
            if (permissions != null && permissions.getGroup() != null) {
                this.executeCommand("chgrp -Rf " + permissions.getGroup() + " " + path);
            }
            if (permissions != null && permissions.getFileMode() != null) {
                this.executeCommand("chmod -Rf " + permissions.getFileMode() + " " + path);
            }
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error performing commands for file transfer", e);
        }
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public abstract /* synthetic */ void put(File var1, String var2) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    public abstract /* synthetic */ boolean getIfNewer(String var1, File var2, long var3) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    public abstract /* synthetic */ void get(String var1, File var2) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    private static class WagonUserInfo
    implements UserInfo {
        private final InteractiveUserInfo userInfo;
        private String password;
        private String passphrase;

        WagonUserInfo(AuthenticationInfo authInfo, InteractiveUserInfo userInfo) {
            this.userInfo = userInfo;
            this.password = authInfo.getPassword();
            this.passphrase = authInfo.getPassphrase();
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean promptPassphrase(String arg0) {
            if (this.passphrase == null && this.userInfo != null) {
                this.passphrase = this.userInfo.promptPassphrase(arg0);
            }
            return this.passphrase != null;
        }

        public boolean promptPassword(String arg0) {
            if (this.password == null && this.userInfo != null) {
                this.password = this.userInfo.promptPassword(arg0);
            }
            return this.password != null;
        }

        public boolean promptYesNo(String arg0) {
            if (this.userInfo != null) {
                return this.userInfo.promptYesNo(arg0);
            }
            return false;
        }

        public void showMessage(String message) {
            if (this.userInfo != null) {
                this.userInfo.showMessage(message);
            }
        }
    }
}

