/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.PermissionModeUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.ssh.AbstractSshWagon;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class ScpWagon
extends AbstractSshWagon {
    private static final char PATH_SEPARATOR = '/';
    private static final char COPY_START_CHAR = 'C';
    private static final char ACK_SEPARATOR = ' ';

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String path;
        block11: {
            String basedir = this.getRepository().getBasedir();
            resourceName = StringUtils.replace(resourceName, "\\", "/");
            String dir = PathUtils.dirname(resourceName);
            dir = StringUtils.replace(dir, "\\", "/");
            Resource resource = new Resource(resourceName);
            this.firePutInitiated(resource, source);
            try {
                String dirPerms;
                if (this.getRepository().getPermissions() != null && (dirPerms = this.getRepository().getPermissions().getDirectoryMode()) != null) {
                    String umaskCmd = "umask " + PermissionModeUtils.getUserMaskFor(dirPerms);
                    this.executeCommand(umaskCmd);
                }
                String mkdirCmd = "mkdir -p " + AbstractWagon.getPath(basedir, dir);
                this.executeCommand(mkdirCmd);
            }
            catch (CommandExecutionException e) {
                throw new TransferFailedException("Error performing commands for file transfer", e);
            }
            Channel channel = null;
            OutputStream out = null;
            path = AbstractWagon.getPath(basedir, resourceName);
            try {
                String command = "scp -t " + path;
                this.fireTransferDebug("Executing command: " + command);
                channel = (ChannelExec)this.session.openChannel("exec");
                ((ChannelExec)channel).setCommand(command);
                out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                ScpWagon.checkAck(in);
                long filesize = source.length();
                command = "C0644 " + filesize + " ";
                command = resourceName.lastIndexOf(47) > 0 ? command + resourceName.substring(resourceName.lastIndexOf(47) + 1) : command + resourceName;
                command = command + "\n";
                out.write(command.getBytes());
                out.flush();
                ScpWagon.checkAck(in);
                this.putTransfer(resource, source, out, false);
                AbstractSshWagon.sendEom(out);
                ScpWagon.checkAck(in);
                if (channel == null) break block11;
            }
            catch (IOException e) {
                try {
                    String msg = "Error occured while deploying '" + resourceName + "' to remote repository: " + this.getRepository().getUrl();
                    throw new TransferFailedException(msg, e);
                    catch (JSchException e2) {
                        msg = "Error occured while deploying '" + resourceName + "' to remote repository: " + this.getRepository().getUrl();
                        throw new TransferFailedException(msg, e2);
                    }
                }
                catch (Throwable throwable) {
                    if (channel == null) throw throwable;
                    IOUtil.close(out);
                    channel.disconnect();
                    throw throwable;
                }
            }
            IOUtil.close(out);
            channel.disconnect();
        }
        try {
            RepositoryPermissions permissions = this.getRepository().getPermissions();
            if (permissions != null && permissions.getGroup() != null) {
                this.executeCommand("chgrp -f " + permissions.getGroup() + " " + path);
            }
            if (permissions == null) return;
            if (permissions.getFileMode() == null) return;
            this.executeCommand("chmod -f " + permissions.getFileMode() + " " + path);
            return;
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error performing commands for file transfer", e);
        }
    }

    private static void checkAck(InputStream in) throws IOException, TransferFailedException {
        int code = in.read();
        if (code == -1) {
            throw new TransferFailedException("Unexpected end of data");
        }
        if (code != 0) {
            throw new TransferFailedException("Did receive proper ACK: '" + code + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        block16: {
            Resource resource = new Resource(resourceName);
            this.fireGetInitiated(resource, destination);
            Channel channel = null;
            OutputStream out = null;
            String basedir = this.getRepository().getBasedir();
            try {
                String path = AbstractWagon.getPath(basedir, resourceName);
                String cmd = "scp -f " + path;
                this.fireTransferDebug("Executing command: " + cmd);
                channel = (ChannelExec)this.session.openChannel("exec");
                ((ChannelExec)channel).setCommand(cmd);
                out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                AbstractSshWagon.sendEom(out);
                int exitCode = in.read();
                String line = this.readLine(in);
                if (exitCode != 67) {
                    if (exitCode == 1 && line.endsWith("No such file or directory")) {
                        throw new ResourceDoesNotExistException(line);
                    }
                    throw new TransferFailedException("Exit code: " + exitCode + " - " + line);
                }
                if (line == null) {
                    throw new EOFException("Unexpected end of data");
                }
                String perms = line.substring(0, 4);
                this.fireTransferDebug("Remote file permissions: " + perms);
                if (line.charAt(4) != ' ') {
                    throw new TransferFailedException("Invalid transfer header: " + line);
                }
                int index = line.indexOf(32, 5);
                if (index < 0) {
                    throw new TransferFailedException("Invalid transfer header: " + line);
                }
                int filesize = Integer.valueOf(line.substring(5, index));
                this.fireTransferDebug("Remote file size: " + filesize);
                resource.setContentLength(filesize);
                String filename = line.substring(index + 1);
                this.fireTransferDebug("Remote filename: " + filename);
                AbstractSshWagon.sendEom(out);
                this.getTransfer(resource, destination, in, false, filesize);
                if (destination.length() != (long)filesize) {
                    throw new TransferFailedException("Expected file length: " + filesize + "; received = " + destination.length());
                }
                ScpWagon.checkAck(in);
                AbstractSshWagon.sendEom(out);
                if (in.read() != -1) {
                    throw new TransferFailedException("End of stream not encountered - server possibly attempted to send multiple files");
                }
                IOUtil.close(out);
                if (channel != null) {
                    channel.disconnect();
                }
            }
            catch (JSchException e) {
                this.handleGetException(resource, e, destination);
            }
            catch (IOException e2) {
                this.handleGetException(resource, e2, destination);
                break block16;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtil.close(out);
                if (channel != null) {
                    channel.disconnect();
                }
            }
        }
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        throw new UnsupportedOperationException("getIfNewer is scp wagon must be still implemented");
    }
}

