/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.Streams;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;

public abstract class Compressor
extends AbstractLogEnabled {
    private File destFile;
    private PlexusIoResource source;

    public void setDestFile(File compressFile) {
        this.destFile = compressFile;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setSource(PlexusIoResource source) {
        this.source = source;
    }

    public PlexusIoResource getSource() {
        return this.source;
    }

    private void compressFile(InputStream in, OutputStream zOut) throws IOException {
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            zOut.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compress(PlexusIoResource resource, OutputStream zOut) throws IOException {
        BufferedInputStream in = Streams.bufferedInputStream(resource.getContents());
        try {
            this.compressFile(in, zOut);
        }
        finally {
            IOUtil.close(in);
        }
    }

    public abstract void compress() throws ArchiverException;

    public abstract void close();
}

