/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.authenticationplugins.gaianimpersonation;

import com.ibm.gaiandb.GaianAuthenticator;
import com.ibm.gaiandb.Logger;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;

public class ProxyUserAuthenticator
implements UserAuthenticator {
    private static final Logger logger = new Logger("ProxyUserAuthenticator", 30);
    private static final String PROXY_UID_KEY = "proxy-user";
    private static final String PROXY_PWD_KEY = "proxy-pwd";
    private static final GaianAuthenticator basAuth = new GaianAuthenticator();

    public boolean authenticateUser(String userName, String passwordOrSid, String dbName, Properties info) throws SQLException {
        String password;
        String userId = info.getProperty(PROXY_UID_KEY);
        boolean isAuthenticated = this.performProxyAuthentication(userName, dbName, info, userId, password = info.getProperty(PROXY_PWD_KEY));
        if (!isAuthenticated) {
            isAuthenticated = this.performRegularAuthentication(userName, passwordOrSid, dbName, info);
        }
        if (isAuthenticated) {
            logger.logDetail("authentication was successful");
        } else {
            logger.logDetail("authentication failed");
        }
        return isAuthenticated;
    }

    private boolean performRegularAuthentication(String userName, String passwordOrSid, String dbName, Properties info) throws SQLException {
        logger.logDetail("Performing regular authentication for user:" + userName);
        return basAuth.authenticateUser(userName, passwordOrSid, dbName, info);
    }

    private boolean performProxyAuthentication(String userName, String dbName, Properties info, String userId, String password) throws SQLException {
        if (userId == null || password == null) {
            return false;
        }
        logger.logDetail("Performing proxy authentication with user:" + userId + " on behalf of:" + userName);
        info.setProperty("create", "true");
        return basAuth.authenticateUser(userId, password, dbName, info);
    }
}

