/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.sw.EncodingXmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public final class ISOLatin1XmlWriter
extends EncodingXmlWriter {
    public ISOLatin1XmlWriter(OutputStream out, WriterConfig cfg, boolean autoclose) throws IOException {
        super(out, cfg, "ISO-8859-1", autoclose);
    }

    public void writeRaw(char[] cbuf, int offset2, int len) throws IOException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        int ptr = this.mOutputPtr;
        while (len > 0) {
            int inEnd;
            int max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (max2 > len) {
                max2 = len;
            }
            if (this.mCheckContent) {
                inEnd = offset2 + max2;
                while (offset2 < inEnd) {
                    char c = cbuf[offset2];
                    if (c < ' ') {
                        if (c != '\n' && c != '\r' && c != '\t') {
                            this.mOutputPtr = ptr;
                            c = this.handleInvalidChar(c);
                        }
                    } else if (c > '~') {
                        if (c > '\u00ff') {
                            this.mOutputPtr = ptr;
                            this.handleInvalidLatinChar(c);
                        } else if (this.mXml11 && c < '\u009f' && c != '\u0085') {
                            this.mOutputPtr = ptr;
                            c = this.handleInvalidChar(c);
                        }
                    }
                    this.mOutputBuffer[ptr++] = (byte)c;
                    ++offset2;
                }
            } else {
                inEnd = offset2 + max2;
                while (offset2 < inEnd) {
                    this.mOutputBuffer[ptr++] = (byte)cbuf[offset2];
                    ++offset2;
                }
            }
            len -= max2;
        }
        this.mOutputPtr = ptr;
    }

    public void writeRaw(String str, int offset2, int len) throws IOException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        int ptr = this.mOutputPtr;
        while (len > 0) {
            int inEnd;
            int max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (max2 > len) {
                max2 = len;
            }
            if (this.mCheckContent) {
                inEnd = offset2 + max2;
                while (offset2 < inEnd) {
                    char c = str.charAt(offset2);
                    if (c < ' ') {
                        if (c != '\n' && c != '\r' && c != '\t') {
                            this.mOutputPtr = ptr;
                            c = this.handleInvalidChar(c);
                        }
                    } else if (c > '~') {
                        if (c > '\u00ff') {
                            this.mOutputPtr = ptr;
                            this.handleInvalidLatinChar(c);
                        } else if (this.mXml11 && c < '\u009f' && c != '\u0085') {
                            this.mOutputPtr = ptr;
                            c = this.handleInvalidChar(c);
                        }
                    }
                    this.mOutputBuffer[ptr++] = (byte)c;
                    ++offset2;
                }
            } else {
                inEnd = offset2 + max2;
                while (offset2 < inEnd) {
                    this.mOutputBuffer[ptr++] = (byte)str.charAt(offset2);
                    ++offset2;
                }
            }
            len -= max2;
        }
        this.mOutputPtr = ptr;
    }

    protected void writeAttrValue(String data) throws IOException {
        int offset2 = 0;
        int len = data.length();
        int ptr = this.mOutputPtr;
        block0: while (len > 0) {
            int max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (this.mSurrogate != 0) {
                int sec = data.charAt(offset2++);
                sec = this.calcSurrogate(sec);
                this.mOutputPtr = ptr;
                ptr = this.writeAsEntity(sec);
                --len;
                continue;
            }
            if (max2 > len) {
                max2 = len;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                int c;
                if ((c = data.charAt(offset2++)) < 32) {
                    if (c == 13) {
                        if (!this.mEscapeCR) {
                            this.mOutputBuffer[ptr++] = (byte)c;
                            continue;
                        }
                    } else if (c != 10 && c != 9 && this.mCheckContent && (!this.mXml11 || c == 0)) {
                        c = this.handleInvalidChar(c);
                        this.mOutputBuffer[ptr++] = (byte)c;
                        continue;
                    }
                } else if (c < 127) {
                    if (c != 60 && c != 38 && c != 34) {
                        this.mOutputBuffer[ptr++] = (byte)c;
                        continue;
                    }
                } else {
                    if (c > 159 && c <= 255) {
                        this.mOutputBuffer[ptr++] = (byte)c;
                        continue;
                    }
                    if (c >= 55296 && c <= 57343) {
                        this.mSurrogate = c;
                        if (offset2 == inEnd) break;
                        c = this.calcSurrogate(data.charAt(offset2++));
                    }
                }
                this.mOutputPtr = ptr;
                ptr = this.writeAsEntity(c);
                len = data.length() - offset2;
                continue block0;
            }
            len -= max2;
        }
        this.mOutputPtr = ptr;
    }

    protected void writeAttrValue(char[] data, int offset2, int len) throws IOException {
        int ptr = this.mOutputPtr;
        while (len > 0) {
            int max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (this.mSurrogate != 0) {
                int sec = data[offset2++];
                sec = this.calcSurrogate(sec);
                this.mOutputPtr = ptr;
                ptr = this.writeAsEntity(sec);
                --len;
                continue;
            }
            if (max2 > len) {
                max2 = len;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                int c;
                if ((c = data[offset2++]) < 32) {
                    if (c == 13) {
                        if (!this.mEscapeCR) {
                            this.mOutputBuffer[ptr++] = (byte)c;
                            continue;
                        }
                    } else if (c != 10 && c != 9 && this.mCheckContent && (!this.mXml11 || c == 0)) {
                        c = this.handleInvalidChar(c);
                        this.mOutputBuffer[ptr++] = (byte)c;
                        continue;
                    }
                } else if (c < 127) {
                    if (c != 60 && c != 38 && c != 34) {
                        this.mOutputBuffer[ptr++] = (byte)c;
                        continue;
                    }
                } else {
                    if (c > 159 && c <= 255) {
                        this.mOutputBuffer[ptr++] = (byte)c;
                        continue;
                    }
                    if (c >= 55296 && c <= 57343) {
                        this.mSurrogate = c;
                        if (offset2 == inEnd) break;
                        c = this.calcSurrogate(data[offset2++]);
                    }
                }
                this.mOutputPtr = ptr;
                ptr = this.writeAsEntity(c);
                max2 -= inEnd - offset2;
                break;
            }
            len -= max2;
        }
        this.mOutputPtr = ptr;
    }

    protected int writeCDataContent(String data) throws IOException {
        int offset2 = 0;
        int len = data.length();
        if (!this.mCheckContent) {
            this.writeRaw(data, offset2, len);
            return -1;
        }
        int ptr = this.mOutputPtr;
        block0: while (len > 0) {
            int max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (max2 > len) {
                max2 = len;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                char c;
                block9: {
                    block10: {
                        block11: {
                            block8: {
                                if ((c = data.charAt(offset2++)) >= ' ') break block8;
                                if (c != '\n' && c != '\r' && c != '\t') {
                                    this.mOutputPtr = ptr;
                                    c = this.handleInvalidChar(c);
                                }
                                break block9;
                            }
                            if (c <= '~') break block10;
                            if (c <= '\u00ff') break block11;
                            this.mOutputPtr = ptr;
                            this.handleInvalidLatinChar(c);
                            break block9;
                        }
                        if (!this.mXml11 || c >= '\u009f' || c == '\u0085') break block9;
                        this.mOutputPtr = ptr;
                        c = this.handleInvalidChar(c);
                        break block9;
                    }
                    if (c == '>' && offset2 > 2 && data.charAt(offset2 - 2) == ']' && data.charAt(offset2 - 3) == ']') {
                        if (!this.mFixContent) {
                            return offset2 - 3;
                        }
                        this.mOutputPtr = ptr;
                        this.writeCDataEnd();
                        this.writeCDataStart();
                        this.writeAscii((byte)62);
                        ptr = this.mOutputPtr;
                        len = data.length() - offset2;
                        continue block0;
                    }
                }
                this.mOutputBuffer[ptr++] = (byte)c;
            }
            len -= max2;
        }
        this.mOutputPtr = ptr;
        return -1;
    }

    protected int writeCDataContent(char[] cbuf, int start, int len) throws IOException {
        if (!this.mCheckContent) {
            this.writeRaw(cbuf, start, len);
            return -1;
        }
        int ptr = this.mOutputPtr;
        int offset2 = start;
        while (len > 0) {
            int max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (max2 > len) {
                max2 = len;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                char c;
                block9: {
                    block10: {
                        block11: {
                            block8: {
                                if ((c = cbuf[offset2++]) >= ' ') break block8;
                                if (c != '\n' && c != '\r' && c != '\t') {
                                    this.mOutputPtr = ptr;
                                    c = this.handleInvalidChar(c);
                                }
                                break block9;
                            }
                            if (c <= '~') break block10;
                            if (c <= '\u00ff') break block11;
                            this.mOutputPtr = ptr;
                            this.handleInvalidLatinChar(c);
                            break block9;
                        }
                        if (!this.mXml11 || c >= '\u009f' || c == '\u0085') break block9;
                        this.mOutputPtr = ptr;
                        c = this.handleInvalidChar(c);
                        break block9;
                    }
                    if (c == '>' && offset2 >= start + 3 && cbuf[offset2 - 2] == ']' && cbuf[offset2 - 3] == ']') {
                        if (!this.mFixContent) {
                            return offset2 - 3;
                        }
                        this.mOutputPtr = ptr;
                        this.writeCDataEnd();
                        this.writeCDataStart();
                        this.writeAscii((byte)62);
                        ptr = this.mOutputPtr;
                        max2 -= inEnd - offset2;
                        break;
                    }
                }
                this.mOutputBuffer[ptr++] = (byte)c;
            }
            len -= max2;
        }
        this.mOutputPtr = ptr;
        return -1;
    }

    protected int writeCommentContent(String data) throws IOException {
        int max2;
        int len;
        int offset2 = 0;
        if (!this.mCheckContent) {
            this.writeRaw(data, offset2, len);
            return -1;
        }
        int ptr = this.mOutputPtr;
        block0: for (len = data.length(); len > 0; len -= max2) {
            max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (max2 > len) {
                max2 = len;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                char c;
                block10: {
                    block11: {
                        block12: {
                            block9: {
                                if ((c = data.charAt(offset2++)) >= ' ') break block9;
                                if (c != '\n' && c != '\r' && c != '\t') {
                                    this.mOutputPtr = ptr;
                                    c = this.handleInvalidChar(c);
                                }
                                break block10;
                            }
                            if (c <= '~') break block11;
                            if (c <= '\u00ff') break block12;
                            this.mOutputPtr = ptr;
                            this.handleInvalidLatinChar(c);
                            break block10;
                        }
                        if (!this.mXml11 || c >= '\u009f' || c == '\u0085') break block10;
                        this.mOutputPtr = ptr;
                        c = this.handleInvalidChar(c);
                        break block10;
                    }
                    if (c == '-' && offset2 > 1 && data.charAt(offset2 - 2) == '-') {
                        if (!this.mFixContent) {
                            return offset2 - 2;
                        }
                        this.mOutputBuffer[ptr++] = 32;
                        if (ptr >= this.mOutputBuffer.length) {
                            this.mOutputPtr = ptr;
                            this.flushBuffer();
                            ptr = 0;
                        }
                        this.mOutputBuffer[ptr++] = 45;
                        max2 -= inEnd - offset2;
                        continue block0;
                    }
                }
                this.mOutputBuffer[ptr++] = (byte)c;
            }
        }
        this.mOutputPtr = ptr;
        return -1;
    }

    protected int writePIData(String data) throws IOException, XMLStreamException {
        int max2;
        int len;
        int offset2 = 0;
        if (!this.mCheckContent) {
            this.writeRaw(data, offset2, len);
            return -1;
        }
        int ptr = this.mOutputPtr;
        for (len = data.length(); len > 0; len -= max2) {
            max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (max2 > len) {
                max2 = len;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                char c = data.charAt(offset2);
                if (c < ' ') {
                    if (c != '\n' && c != '\r' && c != '\t') {
                        this.mOutputPtr = ptr;
                        c = this.handleInvalidChar(c);
                    }
                } else if (c > '~') {
                    if (c > '\u00ff') {
                        this.mOutputPtr = ptr;
                        this.handleInvalidLatinChar(c);
                    } else if (this.mXml11 && c < '\u009f' && c != '\u0085') {
                        this.mOutputPtr = ptr;
                        c = this.handleInvalidChar(c);
                    }
                } else if (c == '>' && offset2 > 0 && data.charAt(offset2 - 1) == '?') {
                    return offset2 - 2;
                }
                this.mOutputBuffer[ptr++] = (byte)c;
                ++offset2;
            }
        }
        this.mOutputPtr = ptr;
        return -1;
    }

    protected void writeTextContent(String data) throws IOException {
        int offset2 = 0;
        int len = data.length();
        block0: while (len > 0) {
            int max2 = this.mOutputBuffer.length - this.mOutputPtr;
            if (max2 < 1) {
                this.flushBuffer();
                max2 = this.mOutputBuffer.length;
            }
            if (this.mSurrogate != 0) {
                int sec = data.charAt(offset2++);
                sec = this.calcSurrogate(sec);
                this.writeAsEntity(sec);
                --len;
                continue;
            }
            if (max2 > len) {
                max2 = len;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                int c;
                if ((c = data.charAt(offset2++)) < 32) {
                    if (c == 10 || c == 9) {
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)c;
                        continue;
                    }
                    if (c == 13) {
                        if (!this.mEscapeCR) {
                            this.mOutputBuffer[this.mOutputPtr++] = (byte)c;
                            continue;
                        }
                    } else if ((!this.mXml11 || c == 0) && this.mCheckContent) {
                        c = this.handleInvalidChar(c);
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)c;
                        continue;
                    }
                } else if (c < 127) {
                    if (c != 60 && c != 38 && (c != 62 || offset2 > 1 && data.charAt(offset2 - 2) != ']')) {
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)c;
                        continue;
                    }
                } else {
                    if (c > 159 && c <= 255) {
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)c;
                        continue;
                    }
                    if (c >= 55296 && c <= 57343) {
                        this.mSurrogate = c;
                        if (offset2 == inEnd) break;
                        c = this.calcSurrogate(data.charAt(offset2++));
                    }
                }
                this.writeAsEntity(c);
                len = data.length() - offset2;
                continue block0;
            }
            len -= max2;
        }
    }

    protected void writeTextContent(char[] cbuf, int offset2, int len) throws IOException {
        while (len > 0) {
            int max2 = this.mOutputBuffer.length - this.mOutputPtr;
            if (max2 < 1) {
                this.flushBuffer();
                max2 = this.mOutputBuffer.length;
            }
            if (this.mSurrogate != 0) {
                int sec = cbuf[offset2++];
                sec = this.calcSurrogate(sec);
                this.writeAsEntity(sec);
                --len;
                continue;
            }
            if (max2 > len) {
                max2 = len;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                int c;
                if ((c = cbuf[offset2++]) < 32) {
                    if (c == 10 || c == 9) {
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)c;
                        continue;
                    }
                    if (c == 13) {
                        if (!this.mEscapeCR) {
                            this.mOutputBuffer[this.mOutputPtr++] = (byte)c;
                            continue;
                        }
                    } else if ((!this.mXml11 || c == 0) && this.mCheckContent) {
                        c = this.handleInvalidChar(c);
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)c;
                        continue;
                    }
                } else if (c < 127) {
                    if (c != 60 && c != 38 && (c != 62 || offset2 > 1 && cbuf[offset2 - 2] != ']')) {
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)c;
                        continue;
                    }
                } else {
                    if (c > 159 && c <= 255) {
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)c;
                        continue;
                    }
                    if (c >= 55296 && c <= 57343) {
                        this.mSurrogate = c;
                        if (offset2 == inEnd) break;
                        c = this.calcSurrogate(cbuf[offset2++]);
                    }
                }
                this.writeAsEntity(c);
                max2 -= inEnd - offset2;
                break;
            }
            len -= max2;
        }
    }

    protected void handleInvalidLatinChar(int c) throws IOException {
        this.flush();
        throw new IOException("Invalid XML character (0x" + Integer.toHexString(c) + "); can only be output using character entity when using ISO-8859-1 encoding");
    }
}

