/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.el.ELContext;

class ELUtil {
    private static ThreadLocal instance = new ThreadLocal(){

        protected Object initialValue() {
            return null;
        }
    };

    private ELUtil() {
    }

    private static Map getCurrentInstance() {
        HashMap result2 = (HashMap)instance.get();
        if (null == result2) {
            result2 = new HashMap();
            ELUtil.setCurrentInstance(result2);
        }
        return result2;
    }

    private static void setCurrentInstance(Map context) {
        instance.set(context);
    }

    public static String getExceptionMessageString(ELContext context, String messageId) {
        return ELUtil.getExceptionMessageString(context, messageId, null);
    }

    public static String getExceptionMessageString(ELContext context, String messageId, Object[] params) {
        String result2 = "";
        Locale locale = null;
        if (null == context || null == messageId) {
            return result2;
        }
        locale = context.getLocale();
        if (null == locale) {
            locale = Locale.getDefault();
        }
        if (null != locale) {
            Map threadMap = ELUtil.getCurrentInstance();
            ResourceBundle rb = null;
            rb = (ResourceBundle)threadMap.get(locale.toString());
            if (null == rb) {
                rb = ResourceBundle.getBundle("javax.el.PrivateMessages", locale);
                threadMap.put(locale.toString(), rb);
            }
            if (null != rb) {
                try {
                    result2 = rb.getString(messageId);
                    if (null != params) {
                        result2 = MessageFormat.format(result2, params);
                    }
                }
                catch (IllegalArgumentException iae) {
                    result2 = "Can't get localized message: parameters to message appear to be incorrect.  Message to format: " + messageId;
                }
                catch (MissingResourceException mre) {
                    result2 = "Missing Resource in EL implementation: ???" + messageId + "???";
                }
                catch (Exception e) {
                    result2 = "Exception resolving message in EL implementation: ???" + messageId + "???";
                }
            }
        }
        return result2;
    }
}

