/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import joptsimple.OptionSpec;
import kafka.admin.AdminUtilities;
import kafka.admin.AdminUtils$;
import kafka.admin.ConfigCommand;
import kafka.common.Config;
import kafka.common.Config$class;
import kafka.common.InvalidConfigException;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.ScramFormatter;
import org.apache.kafka.common.security.scram.ScramMechanism;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConfigCommand$
implements Config {
    public static final ConfigCommand$ MODULE$;
    private final int DefaultScramIterations;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ConfigCommand$();
    }

    @Override
    public void validateChars(String prop, String value2) {
        Config$class.validateChars(this, prop, value2);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ConfigCommand$ configCommand$ = this;
        synchronized (configCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int DefaultScramIterations() {
        return this.DefaultScramIterations;
    }

    public void main(String[] args) {
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Add/Remove entity config for a topic, client, user or broker");
        }
        opts.checkArgs();
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(opts.options().valueOf(opts.zkConnectOpt()), 30000, 30000, JaasUtils.isZkSecurityEnabled());
        try {
            try {
                if (opts.options().has(opts.alterOpt())) {
                    this.alterConfig(zkUtils, opts, this.alterConfig$default$3());
                } else if (opts.options().has(opts.describeOpt())) {
                    this.describeConfig(zkUtils, opts);
                }
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println(new StringBuilder().append((Object)"Error while executing config command ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println(Utils.stackTrace(throwable));
            }
        }
        finally {
            zkUtils.close();
        }
    }

    public void alterConfig(ZkUtils zkUtils, ConfigCommand.ConfigCommandOptions opts, AdminUtilities utils) {
        Properties configs;
        Seq invalidConfigs;
        Properties configsToBeAdded = this.parseConfigsToBeAdded(opts);
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        ConfigCommand.ConfigEntity entity = this.parseEntity(opts);
        String entityType = entity.root().entityType();
        String entityName = entity.fullSanitizedName();
        String string2 = entityType;
        String string3 = ConfigType$.MODULE$.User();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.preProcessScramCredentials(configsToBeAdded);
        }
        if ((invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1<String, Object>)((Object)new Serializable(configs = utils.fetchEntityConfig(zkUtils, entityType, entityName)){
            public static final long serialVersionUID = 0L;
            private final Properties configs$1;

            public final boolean apply(String x$1) {
                return this.configs$1.containsKey(x$1);
            }
            {
                this.configs$1 = configs$1;
            }
        }))).nonEmpty()) {
            throw new InvalidConfigException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config(s): ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{invalidConfigs.mkString(",")})));
        }
        Implicits$.MODULE$.PropertiesOps(configs).$plus$plus$eq(configsToBeAdded);
        configsToBeDeleted.foreach(new Serializable(configs){
            public static final long serialVersionUID = 0L;
            private final Properties configs$1;

            public final Object apply(String x$2) {
                return this.configs$1.remove(x$2);
            }
            {
                this.configs$1 = configs$1;
            }
        });
        utils.changeConfigs(zkUtils, entityType, entityName, configs);
        Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed Updating config for entity: ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{entity})));
    }

    public AdminUtilities alterConfig$default$3() {
        return AdminUtils$.MODULE$;
    }

    private void preProcessScramCredentials(Properties configsToBeAdded) {
        Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values()).foreach(new Serializable(configsToBeAdded){
            public static final long serialVersionUID = 0L;
            private final Properties configsToBeAdded$1;

            public final Object apply(ScramMechanism mechanism) {
                String string2 = this.configsToBeAdded$1.getProperty(mechanism.mechanismName());
                Object object = string2 == null ? BoxedUnit.UNIT : this.configsToBeAdded$1.setProperty(mechanism.mechanismName(), ConfigCommand$.MODULE$.kafka$admin$ConfigCommand$$scramCredential$1(mechanism, string2));
                return object;
            }
            {
                this.configsToBeAdded$1 = configsToBeAdded$1;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private void describeConfig(ZkUtils zkUtils, ConfigCommand.ConfigCommandOptions opts) {
        configEntity = this.parseEntity(opts);
        v0 = configEntity.root().entityType();
        var5_4 = ConfigType$.MODULE$.User();
        if (v0 != null ? v0.equals(var5_4) == false : var5_4 != null) ** GOTO lbl-1000
        if (!configEntity.root().sanitizedName().isDefined() && !configEntity.child().isDefined()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        describeAllUsers = v1;
        entities = configEntity.getAllEntities(zkUtils);
        entities.foreach(new Serializable(zkUtils, describeAllUsers){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;
            private final boolean describeAllUsers$1;

            public final void apply(ConfigCommand.ConfigEntity entity) {
                Properties configs = AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils$1, entity.root().entityType(), entity.fullSanitizedName());
                if (!configs.isEmpty() || !this.describeAllUsers$1) {
                    Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Configs for %s are %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{entity, ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configs).asScala()).map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<String, String> kv) {
                            return new StringBuilder().append((Object)kv._1()).append((Object)"=").append((Object)kv._2()).toString();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).mkString(",")})));
                }
            }
            {
                this.zkUtils$1 = zkUtils$1;
                this.describeAllUsers$1 = describeAllUsers$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        void var2_2;
        Properties props = new Properties();
        if (opts.options().has(opts.addConfig())) {
            String pattern = "(?=[^\\]]*(?:\\[|$))";
            String[][] configsToBeAdded = (String[][])Predef$.MODULE$.refArrayOps((Object[])opts.options().valueOf(opts.addConfig()).split(new StringBuilder().append((Object)",").append((Object)pattern).toString())).map(new Serializable(pattern){
                public static final long serialVersionUID = 0L;
                private final String pattern$1;

                public final String[] apply(String x$4) {
                    return x$4.split(new StringBuilder().append((Object)"\\s*=\\s*").append((Object)this.pattern$1).toString());
                }
                {
                    this.pattern$1 = pattern$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
            Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded).forall(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String[] config) {
                    return config.length == 2;
                }
            }), (Function0<Object>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Invalid entity config: all configs to be added must be in the format \"key=val\".";
                }
            }));
            Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded).foreach(new Serializable(props){
                public static final long serialVersionUID = 0L;
                private final Properties props$1;

                public final Object apply(String[] pair) {
                    return this.props$1.setProperty(pair[0].trim(), pair[1].replaceAll("\\[?\\]?", "").trim());
                }
                {
                    this.props$1 = props$1;
                }
            });
            if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
                Predef$.MODULE$.println(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WARNING: The configuration ", "=", " is specified. "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{LogConfig$.MODULE$.MessageFormatVersionProp(), props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker."})).s(Nil$.MODULE$)).toString());
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        Seq seq;
        if (opts.options().has(opts.deleteConfig())) {
            void var2_2;
            Buffer<String> configsToBeDeleted = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.deleteConfig())).asScala()).map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$5) {
                    return x$5.trim();
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach(new Serializable(propsToBeDeleted){
                public static final long serialVersionUID = 0L;
                private final Properties propsToBeDeleted$1;

                public final Object apply(String x$6) {
                    return this.propsToBeDeleted$1.setProperty(x$6, "");
                }
                {
                    this.propsToBeDeleted$1 = propsToBeDeleted$1;
                }
            });
            seq = var2_2;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ConfigCommand.ConfigEntity parseEntity(ConfigCommand.ConfigCommandOptions opts) {
        ConfigCommand.ConfigEntity configEntity;
        Buffer<String> entityTypes;
        block3: {
            block2: {
                entityTypes = JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.entityType())).asScala();
                Object a = entityTypes.head();
                String string2 = ConfigType$.MODULE$.User();
                if (!(a == null ? string2 != null : !a.equals(string2))) break block2;
                Object a2 = entityTypes.head();
                String string3 = ConfigType$.MODULE$.Client();
                if (a2 != null ? !a2.equals(string3) : string3 != null) break block3;
            }
            configEntity = this.parseQuotaEntity(opts);
            return configEntity;
        }
        Option option = opts.options().has(opts.entityName()) ? new Some<String>(opts.options().valueOf(opts.entityName())) : None$.MODULE$;
        configEntity = new ConfigCommand.ConfigEntity(new ConfigCommand.Entity((String)entityTypes.head(), option), None$.MODULE$);
        return configEntity;
    }

    /*
     * Unable to fully structure code
     */
    private ConfigCommand.ConfigEntity parseQuotaEntity(ConfigCommand.ConfigCommandOptions opts) {
        types = JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.entityType())).asScala();
        namesIterator = opts.options().valuesOf(opts.entityName()).iterator();
        names = ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().specs()).asScala()).filter(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(OptionSpec<?> spec) {
                return spec.options().contains("entity-name") || spec.options().contains("entity-default");
            }
        })).map(new Serializable(namesIterator){
            public static final long serialVersionUID = 0L;
            private final java.util.Iterator namesIterator$1;

            public final String apply(OptionSpec<?> spec) {
                return spec.options().contains("entity-name") ? (String)this.namesIterator$1.next() : "";
            }
            {
                this.namesIterator$1 = namesIterator$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        if (opts.options().has(opts.alterOpt()) && names.size() != types.size()) {
            throw new IllegalArgumentException("--entity-name or --entity-default must be specified with each --entity-type for --alter");
        }
        if (types.size() != 2) ** GOTO lbl-1000
        v0 = types.apply(false);
        var6_5 = ConfigType$.MODULE$.Client();
        if (!(v0 != null ? v0.equals(var6_5) == false : var6_5 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        reverse = v1;
        entityTypes = reverse != false ? (Buffer)types.reverse() : types;
        sortedNames = ((IterableLike)(reverse != false && names.length() == 2 ? names.reverse() : names)).iterator();
        entities = entityTypes.map(new Serializable(sortedNames){
            public static final long serialVersionUID = 0L;
            private final Iterator sortedNames$1;

            public final ConfigCommand.Entity apply(String t) {
                return new ConfigCommand.Entity(t, this.sortedNames$1.hasNext() ? new Some<String>(ConfigCommand$.MODULE$.kafka$admin$ConfigCommand$$sanitizeName$1(t, (String)this.sortedNames$1.next())) : None$.MODULE$);
            }
            {
                this.sortedNames$1 = sortedNames$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return new ConfigCommand.ConfigEntity((ConfigCommand.Entity)entities.head(), entities.size() > 1 ? new Some<R>(entities.apply(true)) : None$.MODULE$);
    }

    public final String kafka$admin$ConfigCommand$$scramCredential$1(ScramMechanism mechanism, String credentialStr) {
        String string2;
        Regex pattern = new StringOps(Predef$.MODULE$.augmentString("(?:iterations=([0-9]*),)?password=(.*)")).r();
        Option<List<String>> option = pattern.unapplySeq(string2 = credentialStr);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String password;
            String iterations = (String)((LinearSeqOptimized)option.get()).apply(0);
            Tuple2<Integer, String> tuple2 = new Tuple2<Integer, String>(iterations == null ? BoxesRunTime.boxToInteger(this.DefaultScramIterations()) : BoxesRunTime.boxToInteger(new StringOps(Predef$.MODULE$.augmentString(iterations)).toInt()), password = (String)((LinearSeqOptimized)option.get()).apply(1));
            Tuple2<Integer, String> tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2<Integer, String> tuple23;
                int iterations2 = tuple22._1$mcI$sp();
                String password2 = tuple22._2();
                Tuple2<Integer, String> tuple24 = tuple23 = new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(iterations2), password2);
                int iterations3 = tuple24._1$mcI$sp();
                String password3 = tuple24._2();
                if (iterations3 < mechanism.minIterations()) {
                    throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Iterations ", " is less than the minimum ", " required for ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(iterations3), BoxesRunTime.boxToInteger(mechanism.minIterations()), mechanism})));
                }
                ScramCredential credential = new ScramFormatter(mechanism).generateCredential(password3, iterations3);
                return ScramCredentialUtils.credentialToString((ScramCredential)credential);
            }
            throw new MatchError(tuple22);
        }
        throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid credential property ", "=", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{mechanism, credentialStr})));
    }

    public final String kafka$admin$ConfigCommand$$sanitizeName$1(String entityType, String name) {
        block7: {
            String string2;
            block6: {
                String string3;
                boolean bl;
                block5: {
                    if (!name.isEmpty()) break block5;
                    string2 = ConfigEntityName$.MODULE$.Default();
                    break block6;
                }
                String string4 = entityType;
                String string5 = ConfigType$.MODULE$.User();
                String string6 = string4;
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    bl = true;
                } else {
                    String string7 = ConfigType$.MODULE$.Client();
                    String string8 = string4;
                    bl = !(string7 != null ? !string7.equals(string8) : string8 != null);
                }
                if (!bl) break block7;
                string2 = string3 = Sanitizer.sanitize(name);
            }
            return string2;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid entity type ").append((Object)entityType).toString());
    }

    private ConfigCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        Config$class.$init$(this);
        this.DefaultScramIterations = 4096;
    }
}

