/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEventManager;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager$;
import kafka.server.ConfigType$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005+A\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\u0007fm\u0016tG/T1oC\u001e,'\u000f\u0005\u0002\u00179%\u0011QD\u0001\u0002\u0017\u0007>tGO]8mY\u0016\u0014XI^3oi6\u000bg.Y4fe\")q\u0004\u0001C\u0001A\u00051A(\u001b8jiz\"2!\t\u0012$!\t1\u0002\u0001C\u0003\u0004=\u0001\u0007Q\u0003C\u0003\u001b=\u0001\u00071\u0004C\u0004&\u0001\t\u0007I\u0011\u0001\u0014\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001(!\t1\u0002&\u0003\u0002*\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\r-\u0002\u0001\u0015!\u0003(\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000f5\u0002!\u0019!C\u0001]\u0005)\u0002/\u0019:uSRLwN\\*uCR,W*Y2iS:,W#A\u0018\u0011\u0005Y\u0001\u0014BA\u0019\u0003\u0005U\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016Daa\r\u0001!\u0002\u0013y\u0013A\u00069beRLG/[8o'R\fG/Z'bG\"Lg.\u001a\u0011\t\u000fU\u0002!\u0019!C\u0001m\u0005\u0019\"/\u001a9mS\u000e\f7\u000b^1uK6\u000b7\r[5oKV\tq\u0007\u0005\u0002\u0017q%\u0011\u0011H\u0001\u0002\u0014%\u0016\u0004H.[2b'R\fG/Z'bG\"Lg.\u001a\u0005\u0007w\u0001\u0001\u000b\u0011B\u001c\u0002)I,\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3!\u0011\u001di\u0004A1A\u0005\u0002y\nA#[:EK2,G/\u001a+pa&\u001cWI\\1cY\u0016$W#A \u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015\u0001\u00027b]\u001eT\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G\u0003\n9!i\\8mK\u0006t\u0007B\u0002%\u0001A\u0003%q(A\u000bjg\u0012+G.\u001a;f)>\u0004\u0018nY#oC\ndW\r\u001a\u0011\t\u000f)\u0003!\u0019!C\u0001\u0017\u0006\tBo\u001c9jGN$vNQ3EK2,G/\u001a3\u0016\u00031\u00032!\u0014*U\u001b\u0005q%BA(Q\u0003\u001diW\u000f^1cY\u0016T!!\u0015\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002T\u001d\n\u00191+\u001a;\u0011\u0005UCfBA\u0005W\u0013\t9&\"\u0001\u0004Qe\u0016$WMZ\u0005\u00033j\u0013aa\u0015;sS:<'BA,\u000b\u0011\u0019a\u0006\u0001)A\u0005\u0019\u0006\u0011Bo\u001c9jGN$vNQ3EK2,G/\u001a3!\u0011\u001dq\u0006A1A\u0005\u0002}\u000bQ\u0003]1si&$\u0018n\u001c8t)>\u0014U\rR3mKR,G-F\u0001a!\ri%+\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I\u0012\taaY8n[>t\u0017B\u00014d\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\u0007Q\u0002\u0001\u000b\u0011\u00021\u0002-A\f'\u000f^5uS>t7\u000fV8CK\u0012+G.\u001a;fI\u0002BqA\u001b\u0001C\u0002\u0013\u00051*A\u000eu_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u0005\u0007Y\u0002\u0001\u000b\u0011\u0002'\u00029Q|\u0007/[2t\u0013:,G.[4jE2,gi\u001c:EK2,G/[8oA!)a\u000e\u0001C\u0001_\u0006!\u0011N\\5u)\r\u00018\u000f\u001f\t\u0003\u0013EL!A\u001d\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006i6\u0004\r!^\u0001\u0019S:LG/[1m)>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$\u0007c\u0001<x)6\t\u0001+\u0003\u0002T!\")\u00110\u001ca\u0001k\u0006\u0011\u0013N\\5uS\u0006dGk\u001c9jGNLe.\u001a7jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:DQa\u001f\u0001\u0005\u0002q\f\u0001\u0003\u001e:z)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8\u0015\u0003ADQA \u0001\u0005\u0002q\fQA]3tKRDq!!\u0001\u0001\t\u0003\t\u0019!\u0001\rf]F,X-^3U_BL7m\u001d$pe\u0012+G.\u001a;j_:$2\u0001]A\u0003\u0011\u0019\t9a a\u0001k\u00061Ao\u001c9jGNDq!a\u0003\u0001\t\u0003\ti!A\fsKN,X.\u001a#fY\u0016$\u0018n\u001c8G_J$v\u000e]5dgR\u0019\u0001/a\u0004\t\u0013\u0005\u001d\u0011\u0011\u0002I\u0001\u0002\u0004)\bbBA\n\u0001\u0011\u0005\u0011QC\u0001\u0014M\u0006LGNU3qY&\u001c\u0017\rR3mKRLwN\u001c\u000b\u0004a\u0006]\u0001\u0002CA\r\u0003#\u0001\r!a\u0007\u0002\u0011I,\u0007\u000f\\5dCN\u0004BA^<\u0002\u001eA\u0019a#a\b\n\u0007\u0005\u0005\"AA\nQCJ$\u0018\u000e^5p]\u0006sGMU3qY&\u001c\u0017\rC\u0004\u0002&\u0001!\t!a\n\u0002=5\f'o\u001b+pa&\u001c\u0017J\\3mS\u001eL'\r\\3G_J$U\r\\3uS>tGc\u00019\u0002*!9\u0011qAA\u0012\u0001\u0004)\bbBA\u0017\u0001\u0011%\u0011qF\u0001\u001dSN$v\u000e]5d\u0013:,G.[4jE2,gi\u001c:EK2,G/[8o)\u0011\t\t$!\u000e\u0011\u0007%\t\u0019$\u0003\u0002G\u0015!9\u0011qGA\u0016\u0001\u0004!\u0016!\u0002;pa&\u001c\u0007bBA\u001e\u0001\u0011%\u0011QH\u0001\u001aSN$v\u000e]5d\t\u0016dW\r^5p]&s\u0007K]8he\u0016\u001c8\u000f\u0006\u0003\u00022\u0005}\u0002bBA\u001c\u0003s\u0001\r\u0001\u0016\u0005\b\u0003\u0007\u0002A\u0011AA#\u0003YI7\u000fU1si&$\u0018n\u001c8U_\n+G)\u001a7fi\u0016$G\u0003BA\u0019\u0003\u000fBq!!\u0013\u0002B\u0001\u0007\u0011-A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:Dq!!\u0014\u0001\t\u0003\ty%\u0001\u000ejgR{\u0007/[2Rk\u0016,X\rZ+q\r>\u0014H)\u001a7fi&|g\u000e\u0006\u0003\u00022\u0005E\u0003bBA\u001c\u0003\u0017\u0002\r\u0001\u0016\u0005\b\u0003+\u0002A\u0011AA,\u0003]\u0019w.\u001c9mKR,'+\u001a9mS\u000e\fG)\u001a7fi&|g\u000eF\u0002q\u00033B\u0001\"!\u0007\u0002T\u0001\u0007\u00111\u0004\u0005\b\u0003;\u0002A\u0011BA0\u0003iI7\u000fV8qS\u000e,E.[4jE2,gi\u001c:EK2,G/[8o)\u0011\t\t$!\u0019\t\u000f\u0005]\u00121\fa\u0001)\"9\u0011Q\r\u0001\u0005\n\u0005\u001d\u0014!G7be.$v\u000e]5d\r>\u0014H)\u001a7fi&|gNU3uef$2\u0001]A5\u0011\u001d\t9$a\u0019A\u0002QCq!!\u001c\u0001\t\u0013\ty'A\nd_6\u0004H.\u001a;f\t\u0016dW\r^3U_BL7\rF\u0002q\u0003cBq!a\u000e\u0002l\u0001\u0007A\u000bC\u0004\u0002v\u0001!I!a\u001e\u0002\u001f=tGk\u001c9jG\u0012+G.\u001a;j_:$2\u0001]A=\u0011\u001d\t9!a\u001dA\u0002UDq!! \u0001\t\u0013\ty(\u0001\u000bti\u0006\u0014HOU3qY&\u001c\u0017\rR3mKRLwN\u001c\u000b\u0004a\u0006\u0005\u0005\u0002CAB\u0003w\u0002\r!a\u0007\u00029I,\u0007\u000f\\5dCN4uN\u001d+pa&\u001c7\u000fV8CK\u0012+G.\u001a;fI\"9\u0011q\u0011\u0001\u0005\n\u0005%\u0015aE8o!\u0006\u0014H/\u001b;j_:$U\r\\3uS>tGc\u00019\u0002\f\"9a,!\"A\u0002\u00055\u0005c\u0001<xC\"1\u0011\u0011\u0013\u0001\u0005\nq\fqB]3tk6,G)\u001a7fi&|gn\u001d\u0005\n\u0003+\u0003\u0011\u0013!C\u0001\u0003/\u000b\u0011E]3tk6,G)\u001a7fi&|gNR8s)>\u0004\u0018nY:%I\u00164\u0017-\u001e7uIE*\"!!'+\u0007U\fYj\u000b\u0002\u0002\u001eB!\u0011qTAU\u001b\t\t\tK\u0003\u0003\u0002$\u0006\u0015\u0016!C;oG\",7m[3e\u0015\r\t9KC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAV\u0003C\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class TopicDeletionManager
implements Logging {
    public final KafkaController kafka$controller$TopicDeletionManager$$controller;
    public final ControllerEventManager kafka$controller$TopicDeletionManager$$eventManager;
    private final ControllerContext controllerContext;
    private final PartitionStateMachine partitionStateMachine;
    private final ReplicaStateMachine replicaStateMachine;
    private final Boolean isDeleteTopicEnabled;
    private final scala.collection.mutable.Set<String> topicsToBeDeleted;
    private final scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted;
    private final scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    public ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    public Boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted() {
        return this.partitionsToBeDeleted;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.topicsToBeDeleted().$plus$plus$eq(initialTopicsToBeDeleted);
            this.partitionsToBeDeleted().$plus$plus$eq(this.topicsToBeDeleted().flatMap(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;

                public final Set<TopicAndPartition> apply(String topic) {
                    return this.$outer.controllerContext().partitionsForTopic(topic);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, scala.collection.mutable.Set$.MODULE$.canBuildFrom()));
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.topicsToBeDeleted()));
        } else {
            ZkUtils zkUtils = this.controllerContext().zkUtils();
            initialTopicsToBeDeleted.foreach(new Serializable(this, zkUtils){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;
                private final ZkUtils zkUtils$1;

                public final boolean apply(String topic) {
                    String deleteTopicPath = ZkUtils$.MODULE$.getDeleteTopicPath(topic);
                    this.$outer.info((Function0<String>)((Object)new Serializable(this, deleteTopicPath){
                        public static final long serialVersionUID = 0L;
                        private final String deleteTopicPath$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Removing ").append((Object)this.deleteTopicPath$1).append((Object)" since delete topic is disabled").toString();
                        }
                        {
                            this.deleteTopicPath$1 = deleteTopicPath$1;
                        }
                    }));
                    return this.zkUtils$1.deletePath(deleteTopicPath);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.zkUtils$1 = zkUtils$1;
                }
            });
        }
    }

    public void tryTopicDeletion() {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.resumeDeletions();
        }
    }

    public void reset() {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.topicsToBeDeleted().clear();
            this.partitionsToBeDeleted().clear();
            this.topicsIneligibleForDeletion().clear();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.topicsToBeDeleted().$plus$plus$eq(topics);
            this.partitionsToBeDeleted().$plus$plus$eq(topics.flatMap(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;

                public final Set<TopicAndPartition> apply(String topic) {
                    return this.$outer.controllerContext().partitionsForTopic(topic);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom()));
            this.resumeDeletions();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        Set topicsToResumeDeletion;
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) && (topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted())).nonEmpty()) {
            this.topicsIneligibleForDeletion().$minus$minus$eq(topicsToResumeDeletion);
            this.resumeDeletions();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set replicasThatFailedToDelete;
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) && (replicasThatFailedToDelete = (Set)replicas.filter((Function1<PartitionAndReplica, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }))).nonEmpty()) {
            Set<String> topics = replicasThatFailedToDelete.map(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(PartitionAndReplica x$1) {
                    return x$1.topic();
                }
            }, Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)((Object)new Serializable(this, replicasThatFailedToDelete, topics){
                public static final long serialVersionUID = 0L;
                private final Set replicasThatFailedToDelete$1;
                private final Set topics$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Deletion failed for replicas %s. Halting deletion for topics %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.replicasThatFailedToDelete$1.mkString(","), this.topics$1}));
                }
                {
                    this.replicasThatFailedToDelete$1 = replicasThatFailedToDelete$1;
                    this.topics$1 = topics$1;
                }
            }));
            this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(replicasThatFailedToDelete, ReplicaDeletionIneligible$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion(topics);
            this.resumeDeletions();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
            this.topicsIneligibleForDeletion().$plus$plus$eq(newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)((Object)new Serializable(this, newTopicsToHaltDeletion){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.mutable.Set newTopicsToHaltDeletion$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Halted deletion of topics %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.newTopicsToHaltDeletion$1.mkString(",")}));
                    }
                    {
                        this.newTopicsToHaltDeletion$1 = newTopicsToHaltDeletion$1;
                    }
                }));
            }
        }
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicIneligibleForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsIneligibleForDeletion().contains(topic) : true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic) : false;
    }

    public boolean isPartitionToBeDeleted(TopicAndPartition topicAndPartition) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.partitionsToBeDeleted().contains(topicAndPartition) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsToBeDeleted().contains(topic) : false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1<PartitionAndReplica, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.debug((Function0<String>)((Object)new Serializable(this, successfullyDeletedReplicas){
            public static final long serialVersionUID = 0L;
            private final Set successfullyDeletedReplicas$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Deletion successfully completed for replicas %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.successfullyDeletedReplicas$1.mkString(",")}));
            }
            {
                this.successfullyDeletedReplicas$1 = successfullyDeletedReplicas$1;
            }
        }));
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(successfullyDeletedReplicas, ReplicaDeletionSuccessful$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeDeletions();
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains(topic) && !this.isTopicDeletionInProgress(topic) && !this.kafka$controller$TopicDeletionManager$$isTopicIneligibleForDeletion(topic);
    }

    public void kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(String topic) {
        Set<PartitionAndReplica> failedReplicas = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)((Object)new Serializable(this, topic, failedReplicas){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final Set failedReplicas$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Retrying delete topic for topic %s since replicas %s were not successfully deleted")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, this.failedReplicas$1.mkString(",")}));
            }
            {
                this.topic$1 = topic$1;
                this.failedReplicas$1 = failedReplicas$1;
            }
        }));
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(failedReplicas, OfflineReplica$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
    }

    public void kafka$controller$TopicDeletionManager$$completeDeleteTopic(String topic) {
        this.kafka$controller$TopicDeletionManager$$controller.deregisterPartitionModificationsListener(topic);
        Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine().handleStateChanges(replicasForDeletedTopic, NonExistentReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicAndPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic);
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, OfflinePartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, NonExistentPartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.topicsToBeDeleted().$minus$eq(topic);
        this.partitionsToBeDeleted().retain((Function1<TopicAndPartition, Object>)((Object)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final boolean apply(TopicAndPartition x$2) {
                String string2 = x$2.topic();
                String string3 = this.topic$2;
                return string2 != null ? !string2.equals(string3) : string3 != null;
            }
            {
                this.topic$2 = topic$2;
            }
        }));
        ZkUtils zkUtils = this.controllerContext().zkUtils();
        zkUtils.deletePathRecursive(ZkUtils$.MODULE$.getTopicPath(topic));
        zkUtils.deletePathRecursive(ZkUtils$.MODULE$.getEntityConfigPath(ConfigType$.MODULE$.Topic(), topic));
        zkUtils.deletePath(ZkUtils$.MODULE$.getDeleteTopicPath(topic));
        this.controllerContext().removeTopic(topic);
    }

    public void kafka$controller$TopicDeletionManager$$onTopicDeletion(Set<String> topics) {
        this.info((Function0<String>)((Object)new Serializable(this, topics){
            public static final long serialVersionUID = 0L;
            private final Set topics$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Topic deletion callback for %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topics$2.mkString(",")}));
            }
            {
                this.topics$2 = topics$2;
            }
        }));
        Set<TopicAndPartition> partitions = topics.flatMap(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final Set<TopicAndPartition> apply(String topic) {
                return this.$outer.controllerContext().partitionsForTopic(topic);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        this.kafka$controller$TopicDeletionManager$$controller.sendUpdateMetadataRequest(this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), partitions);
        Map partitionReplicaAssignmentByTopic = this.controllerContext().partitionReplicaAssignment().groupBy(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                return p._1().topic();
            }
        });
        topics.foreach(new Serializable(this, partitionReplicaAssignmentByTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Map partitionReplicaAssignmentByTopic$1;

            public final void apply(String topic) {
                this.$outer.kafka$controller$TopicDeletionManager$$onPartitionDeletion(((MapLike)this.partitionReplicaAssignmentByTopic$1.apply(topic)).keySet());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionReplicaAssignmentByTopic$1 = partitionReplicaAssignmentByTopic$1;
            }
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(PartitionAndReplica x$3) {
                return x$3.topic();
            }
        }).keys().foreach(new Serializable(this, replicasForTopicsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Set replicasForTopicsToBeDeleted$1;

            public final void apply(String topic) {
                Set aliveReplicasForTopic = (Set)this.$outer.controllerContext().allLiveReplicas().filter((Function1<PartitionAndReplica, Object>)((Object)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$3;

                    public final boolean apply(PartitionAndReplica p) {
                        String string2 = p.topic();
                        String string3 = this.topic$3;
                        return !(string2 != null ? !string2.equals(string3) : string3 != null);
                    }
                    {
                        this.topic$3 = topic$3;
                    }
                }));
                Set deadReplicasForTopic = (Set)this.replicasForTopicsToBeDeleted$1.$minus$minus(aliveReplicasForTopic);
                Set<PartitionAndReplica> successfullyDeletedReplicas = this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
                Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
                this.$outer.replicaStateMachine().handleStateChanges(deadReplicasForTopic, ReplicaDeletionIneligible$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                this.$outer.replicaStateMachine().handleStateChanges(replicasForDeletionRetry, OfflineReplica$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                this.$outer.debug((Function0<String>)((Object)new Serializable(this, replicasForDeletionRetry){
                    public static final long serialVersionUID = 0L;
                    private final Set replicasForDeletionRetry$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Deletion started for replicas %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.replicasForDeletionRetry$1.mkString(",")}));
                    }
                    {
                        this.replicasForDeletionRetry$1 = replicasForDeletionRetry$1;
                    }
                }));
                this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(replicasForDeletionRetry, ReplicaDeletionStarted$.MODULE$, new Callbacks.CallbackBuilder().stopReplicaCallback((Function2<AbstractResponse, Object, BoxedUnit>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$startReplicaDeletion$2 $outer;

                    public final void apply(AbstractResponse stopReplicaResponseObj, int replicaId) {
                        this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$eventManager.put(new KafkaController.TopicDeletionStopReplicaResponseReceived(this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$controller, stopReplicaResponseObj, replicaId));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).build());
                if (deadReplicasForTopic.nonEmpty()) {
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this, deadReplicasForTopic, topic){
                        public static final long serialVersionUID = 0L;
                        private final Set deadReplicasForTopic$1;
                        private final String topic$3;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Dead Replicas (%s) found for topic %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.deadReplicasForTopic$1.mkString(","), this.topic$3}));
                        }
                        {
                            this.deadReplicasForTopic$1 = deadReplicasForTopic$1;
                            this.topic$3 = topic$3;
                        }
                    }));
                    this.$outer.markTopicIneligibleForDeletion((Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
                }
            }

            public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicasForTopicsToBeDeleted$1 = replicasForTopicsToBeDeleted$1;
            }
        });
    }

    public void kafka$controller$TopicDeletionManager$$onPartitionDeletion(Set<TopicAndPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)((Object)new Serializable(this, partitionsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final Set partitionsToBeDeleted$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Partition deletion callback for %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.partitionsToBeDeleted$1.mkString(",")}));
            }
            {
                this.partitionsToBeDeleted$1 = partitionsToBeDeleted$1;
            }
        }));
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    private void resumeDeletions() {
        Object topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.topicsToBeDeleted());
        if (topicsQueuedForDeletion.nonEmpty()) {
            this.info((Function0<String>)((Object)new Serializable(this, (Set)topicsQueuedForDeletion){
                public static final long serialVersionUID = 0L;
                private final Set topicsQueuedForDeletion$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Handling deletion for topics ").append((Object)this.topicsQueuedForDeletion$1.mkString(",")).toString();
                }
                {
                    this.topicsQueuedForDeletion$1 = topicsQueuedForDeletion$1;
                }
            }));
        }
        topicsQueuedForDeletion.foreach((Function1<String, BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final void apply(String topic) {
                if (this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic)) {
                    this.$outer.kafka$controller$TopicDeletionManager$$completeDeleteTopic(topic);
                    this.$outer.info((Function0<String>)((Object)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s successfully completed")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$4}));
                        }
                        {
                            this.topic$4 = topic$4;
                        }
                    }));
                } else if (this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic)) {
                    Set<PartitionAndReplica> replicasInDeletionStartedState = this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionStarted$.MODULE$);
                    Set<A> replicaIds = replicasInDeletionStartedState.map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(PartitionAndReplica x$4) {
                            return x$4.replica();
                        }
                    }, Set$.MODULE$.canBuildFrom());
                    Set<A> partitions = replicasInDeletionStartedState.map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final TopicAndPartition apply(PartitionAndReplica r) {
                            return new TopicAndPartition(r.topic(), r.partition());
                        }
                    }, Set$.MODULE$.canBuildFrom());
                    this.$outer.info((Function0<String>)((Object)new Serializable(this, replicaIds, partitions, topic){
                        public static final long serialVersionUID = 0L;
                        private final Set replicaIds$1;
                        private final Set partitions$1;
                        private final String topic$4;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Deletion for replicas %s for partition %s of topic %s in progress")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.replicaIds$1.mkString(","), this.partitions$1.mkString(","), this.topic$4}));
                        }
                        {
                            this.replicaIds$1 = replicaIds$1;
                            this.partitions$1 = partitions$1;
                            this.topic$4 = topic$4;
                        }
                    }));
                } else if (this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$)) {
                    this.$outer.kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(topic);
                }
                if (this.$outer.kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(topic)) {
                    this.$outer.info((Function0<String>)((Object)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s (re)started")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$4}));
                        }
                        {
                            this.topic$4 = topic$4;
                        }
                    }));
                    this.$outer.kafka$controller$TopicDeletionManager$$onTopicDeletion((Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
                } else if (this.$outer.kafka$controller$TopicDeletionManager$$isTopicIneligibleForDeletion(topic)) {
                    this.$outer.info((Function0<String>)((Object)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Not retrying deletion of topic %s at this time since it is marked ineligible for deletion")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$4}));
                        }
                        {
                            this.topic$4 = topic$4;
                        }
                    }));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public TopicDeletionManager(KafkaController controller, ControllerEventManager eventManager) {
        this.kafka$controller$TopicDeletionManager$$controller = controller;
        this.kafka$controller$TopicDeletionManager$$eventManager = eventManager;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Topic Deletion Manager ").append(BoxesRunTime.boxToInteger(controller.config().brokerId())).append((Object)"], ").toString());
        this.controllerContext = controller.controllerContext();
        this.partitionStateMachine = controller.partitionStateMachine();
        this.replicaStateMachine = controller.replicaStateMachine();
        this.isDeleteTopicEnabled = controller.config().deleteTopicEnable();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.partitionsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
    }
}

