/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.controller.AsyncRequest;
import kafka.controller.AsyncResponse;
import kafka.controller.CreateRequest;
import kafka.controller.CreateResponse;
import kafka.controller.DeleteRequest;
import kafka.controller.DeleteResponse;
import kafka.controller.ExistsRequest;
import kafka.controller.ExistsResponse;
import kafka.controller.GetACLRequest;
import kafka.controller.GetACLResponse;
import kafka.controller.GetChildrenRequest;
import kafka.controller.GetChildrenResponse;
import kafka.controller.GetDataRequest;
import kafka.controller.GetDataResponse;
import kafka.controller.SetACLRequest;
import kafka.controller.SetACLResponse;
import kafka.controller.SetDataRequest;
import kafka.controller.SetDataResponse;
import kafka.controller.StateChangeHandler;
import kafka.controller.ZNodeChangeHandler;
import kafka.controller.ZNodeChildChangeHandler;
import kafka.controller.ZookeeperClient$;
import kafka.controller.ZookeeperClient$$anonfun$handle$1$;
import kafka.controller.ZookeeperClient$ZookeeperClientWatcher$;
import kafka.controller.ZookeeperClientAuthFailedException;
import kafka.controller.ZookeeperClientExpiredException;
import kafka.controller.ZookeeperClientTimeoutException;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u0001\u0003\u0001\u001d\u0011qBW8pW\u0016,\u0007/\u001a:DY&,g\u000e\u001e\u0006\u0003\u0007\u0011\t!bY8oiJ|G\u000e\\3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h\u0011!)\u0002A!A!\u0002\u00131\u0012!D2p]:,7\r^*ue&tw\r\u0005\u0002\u001859\u0011\u0011\u0002G\u0005\u00033)\ta\u0001\u0015:fI\u00164\u0017BA\u000e\u001d\u0005\u0019\u0019FO]5oO*\u0011\u0011D\u0003\u0005\t=\u0001\u0011\t\u0011)A\u0005?\u0005\u00012/Z:tS>tG+[7f_V$Xj\u001d\t\u0003\u0013\u0001J!!\t\u0006\u0003\u0007%sG\u000f\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003 \u0003M\u0019wN\u001c8fGRLwN\u001c+j[\u0016|W\u000f^'t\u0011!)\u0003A!A!\u0002\u00131\u0013AE:uCR,7\t[1oO\u0016D\u0015M\u001c3mKJ\u0004\"a\n\u0015\u000e\u0003\tI!!\u000b\u0002\u0003%M#\u0018\r^3DQ\u0006tw-\u001a%b]\u0012dWM\u001d\u0005\u0006W\u0001!\t\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b5rs\u0006M\u0019\u0011\u0005\u001d\u0002\u0001\"B\u000b+\u0001\u00041\u0002\"\u0002\u0010+\u0001\u0004y\u0002\"B\u0012+\u0001\u0004y\u0002\"B\u0013+\u0001\u00041\u0003bB\u001a\u0001\u0005\u0004%I\u0001N\u0001\u0013S:LG/[1mSj\fG/[8o\u0019>\u001c7.F\u00016!\t1t(D\u00018\u0015\tA\u0014(A\u0003m_\u000e\\7O\u0003\u0002;w\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005qj\u0014\u0001B;uS2T\u0011AP\u0001\u0005U\u00064\u0018-\u0003\u0002Ao\t1\"+Z3oiJ\fg\u000e\u001e*fC\u0012<&/\u001b;f\u0019>\u001c7\u000e\u0003\u0004C\u0001\u0001\u0006I!N\u0001\u0014S:LG/[1mSj\fG/[8o\u0019>\u001c7\u000e\t\u0005\b\t\u0002\u0011\r\u0011\"\u0003F\u0003aI7oQ8o]\u0016\u001cG/\u001a3Pe\u0016C\b/\u001b:fI2{7m[\u000b\u0002\rB\u0011agR\u0005\u0003\u0011^\u0012QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0007B\u0002&\u0001A\u0003%a)A\rjg\u000e{gN\\3di\u0016$wJ]#ya&\u0014X\r\u001a'pG.\u0004\u0003b\u0002'\u0001\u0005\u0004%I!T\u0001\u001eSN\u001cuN\u001c8fGR,Gm\u0014:FqBL'/\u001a3D_:$\u0017\u000e^5p]V\ta\n\u0005\u00027\u001f&\u0011\u0001k\u000e\u0002\n\u0007>tG-\u001b;j_:DaA\u0015\u0001!\u0002\u0013q\u0015AH5t\u0007>tg.Z2uK\u0012|%/\u0012=qSJ,GmQ8oI&$\u0018n\u001c8!\u0011\u001d!\u0006A1A\u0005\nU\u000b1C\u001f(pI\u0016\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7feN,\u0012A\u0016\t\u0005/b3\",D\u0001:\u0013\tI\u0016HA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"aJ.\n\u0005q\u0013!A\u0005.O_\u0012,7\t[1oO\u0016D\u0015M\u001c3mKJDaA\u0018\u0001!\u0002\u00131\u0016\u0001\u0006>O_\u0012,7\t[1oO\u0016D\u0015M\u001c3mKJ\u001c\b\u0005C\u0004a\u0001\t\u0007I\u0011B1\u00021itu\u000eZ3DQ&dGm\u00115b]\u001e,\u0007*\u00198eY\u0016\u00148/F\u0001c!\u00119\u0006LF2\u0011\u0005\u001d\"\u0017BA3\u0003\u0005]Qfj\u001c3f\u0007\"LG\u000eZ\"iC:<W\rS1oI2,'\u000f\u0003\u0004h\u0001\u0001\u0006IAY\u0001\u001au:{G-Z\"iS2$7\t[1oO\u0016D\u0015M\u001c3mKJ\u001c\b\u0005C\u0004j\u0001\u0001\u0007I\u0011\u00026\u0002\u0013i|wnS3fa\u0016\u0014X#A6\u0011\u00051\u001cX\"A7\u000b\u00059|\u0017!\u0003>p_.,W\r]3s\u0015\t\u0001\u0018/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0006\u0019qN]4\n\u0005Ql'!\u0003.p_.+W\r]3s\u0011\u001d1\b\u00011A\u0005\n]\fQB_8p\u0017\u0016,\u0007/\u001a:`I\u0015\fHC\u0001=|!\tI\u00110\u0003\u0002{\u0015\t!QK\\5u\u0011\u001daX/!AA\u0002-\f1\u0001\u001f\u00132\u0011\u0019q\b\u0001)Q\u0005W\u0006Q!p\\8LK\u0016\u0004XM\u001d\u0011)\u0007u\f\t\u0001E\u0002\n\u0003\u0007I1!!\u0002\u000b\u0005!1x\u000e\\1uS2,\u0007bBA\u0005\u0001\u0011\u0005\u00111B\u0001\u0007Q\u0006tG\r\\3\u0015\t\u00055\u00111\u0003\t\u0004O\u0005=\u0011bAA\t\u0005\ti\u0011i]=oGJ+7\u000f]8og\u0016D\u0001\"!\u0006\u0002\b\u0001\u0007\u0011qC\u0001\be\u0016\fX/Z:u!\r9\u0013\u0011D\u0005\u0004\u00037\u0011!\u0001D!ts:\u001c'+Z9vKN$\bbBA\u0005\u0001\u0011\u0005\u0011q\u0004\u000b\u0005\u0003C\tI\u0004\u0005\u0004\u0002$\u0005M\u0012Q\u0002\b\u0005\u0003K\tyC\u0004\u0003\u0002(\u00055RBAA\u0015\u0015\r\tYCB\u0001\u0007yI|w\u000e\u001e \n\u0003-I1!!\r\u000b\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u000e\u00028\t\u00191+Z9\u000b\u0007\u0005E\"\u0002\u0003\u0005\u0002<\u0005u\u0001\u0019AA\u001f\u0003!\u0011X-];fgR\u001c\bCBA\u0012\u0003g\t9\u0002C\u0004\u0002B\u0001!\t!a\u0011\u0002%]\f\u0017\u000e^+oi&d7i\u001c8oK\u000e$X\r\u001a\u000b\u0002q\"9\u0011\u0011\t\u0001\u0005\n\u0005\u001dC#\u0002=\u0002J\u0005M\u0003\u0002CA&\u0003\u000b\u0002\r!!\u0014\u0002\u000fQLW.Z8viB\u0019\u0011\"a\u0014\n\u0007\u0005E#B\u0001\u0003M_:<\u0007\u0002CA+\u0003\u000b\u0002\r!a\u0016\u0002\u0011QLW.Z+oSR\u00042aVA-\u0013\r\tY&\u000f\u0002\t)&lW-\u00168ji\"9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0014A\u0007:fO&\u001cH/\u001a:[\u001d>$Wm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014H\u0003BA2\u0003S\u00022aJA3\u0013\r\t9G\u0001\u0002\u000f\u000bbL7\u000f^:SKN\u0004xN\\:f\u0011\u001d\tY'!\u0018A\u0002i\u000b!C\u001f(pI\u0016\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7fe\"9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0014a\u0007:fO&\u001cH/\u001a:[\u001d>$Wm\u00115b]\u001e,\u0007*\u00198eY\u0016\u00148\u000f\u0006\u0003\u0002t\u0005U\u0004CBA\u0012\u0003g\t\u0019\u0007\u0003\u0005\u0002x\u00055\u0004\u0019AA=\u0003!A\u0017M\u001c3mKJ\u001c\b#BA\u0012\u0003gQ\u0006bBA?\u0001\u0011\u0005\u0011qP\u0001\u001dk:\u0014XmZ5ti\u0016\u0014(LT8eK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s)\rA\u0018\u0011\u0011\u0005\b\u0003\u0007\u000bY\b1\u0001\u0017\u0003\u0011\u0001\u0018\r\u001e5\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\u0006y\"/Z4jgR,'O\u0017(pI\u0016\u001c\u0005.\u001b7e\u0007\"\fgnZ3IC:$G.\u001a:\u0015\t\u0005-\u0015\u0011\u0013\t\u0004O\u00055\u0015bAAH\u0005\t\u0019r)\u001a;DQ&dGM]3o%\u0016\u001c\bo\u001c8tK\"9\u00111SAC\u0001\u0004\u0019\u0017a\u0006>O_\u0012,7\t[5mI\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s\u0011\u001d\t9\n\u0001C\u0001\u00033\u000b\u0001E]3hSN$XM\u001d.O_\u0012,7\t[5mI\u000eC\u0017M\\4f\u0011\u0006tG\r\\3sgR!\u00111TAO!\u0019\t\u0019#a\r\u0002\f\"A\u0011qOAK\u0001\u0004\ty\nE\u0003\u0002$\u0005M2\rC\u0004\u0002$\u0002!\t!!*\u0002CUt'/Z4jgR,'O\u0017(pI\u0016\u001c\u0005.\u001b7e\u0007\"\fgnZ3IC:$G.\u001a:\u0015\u0007a\f9\u000bC\u0004\u0002\u0004\u0006\u0005\u0006\u0019\u0001\f\t\u000f\u0005-\u0006\u0001\"\u0001\u0002D\u0005)1\r\\8tK\"9\u0011q\u0016\u0001\u0005\n\u0005\r\u0013AC5oSRL\u0017\r\\5{K\u001e9\u00111\u0017\u0001\t\n\u0005U\u0016A\u0006.p_.,W\r]3s\u00072LWM\u001c;XCR\u001c\u0007.\u001a:\u0011\t\u0005]\u0016\u0011X\u0007\u0002\u0001\u00199\u00111\u0018\u0001\t\n\u0005u&A\u0006.p_.,W\r]3s\u00072LWM\u001c;XCR\u001c\u0007.\u001a:\u0014\r\u0005e\u0016qXAf!\u0011\t\t-a2\u000e\u0005\u0005\r'bAAc{\u0005!A.\u00198h\u0013\u0011\tI-a1\u0003\r=\u0013'.Z2u!\ra\u0017QZ\u0005\u0004\u0003\u001fl'aB,bi\u000eDWM\u001d\u0005\bW\u0005eF\u0011AAj)\t\t)\f\u0003\u0005\u0002X\u0006eF\u0011IAm\u0003\u001d\u0001(o\\2fgN$2\u0001_An\u0011!\ti.!6A\u0002\u0005}\u0017!B3wK:$\bc\u00017\u0002b&\u0019\u00111]7\u0003\u0019]\u000bGo\u00195fI\u00163XM\u001c;")
public class ZookeeperClient
implements Logging {
    public final String kafka$controller$ZookeeperClient$$connectString;
    private final int sessionTimeoutMs;
    private final int connectionTimeoutMs;
    public final StateChangeHandler kafka$controller$ZookeeperClient$$stateChangeHandler;
    private final ReentrantReadWriteLock kafka$controller$ZookeeperClient$$initializationLock;
    private final ReentrantLock kafka$controller$ZookeeperClient$$isConnectedOrExpiredLock;
    private final Condition kafka$controller$ZookeeperClient$$isConnectedOrExpiredCondition;
    private final ConcurrentHashMap<String, ZNodeChangeHandler> kafka$controller$ZookeeperClient$$zNodeChangeHandlers;
    private final ConcurrentHashMap<String, ZNodeChildChangeHandler> kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers;
    private volatile ZooKeeper kafka$controller$ZookeeperClient$$zooKeeper;
    private volatile ZookeeperClient$ZookeeperClientWatcher$ ZookeeperClientWatcher$module;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ZookeeperClient$ZookeeperClientWatcher$ ZookeeperClientWatcher$lzycompute() {
        ZookeeperClient zookeeperClient = this;
        synchronized (zookeeperClient) {
            if (this.ZookeeperClientWatcher$module != null) return this.ZookeeperClientWatcher$module;
            this.ZookeeperClientWatcher$module = new ZookeeperClient$ZookeeperClientWatcher$(this);
            return this.ZookeeperClientWatcher$module;
        }
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ZookeeperClient zookeeperClient = this;
        synchronized (zookeeperClient) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ReentrantReadWriteLock kafka$controller$ZookeeperClient$$initializationLock() {
        return this.kafka$controller$ZookeeperClient$$initializationLock;
    }

    public ReentrantLock kafka$controller$ZookeeperClient$$isConnectedOrExpiredLock() {
        return this.kafka$controller$ZookeeperClient$$isConnectedOrExpiredLock;
    }

    public Condition kafka$controller$ZookeeperClient$$isConnectedOrExpiredCondition() {
        return this.kafka$controller$ZookeeperClient$$isConnectedOrExpiredCondition;
    }

    public ConcurrentHashMap<String, ZNodeChangeHandler> kafka$controller$ZookeeperClient$$zNodeChangeHandlers() {
        return this.kafka$controller$ZookeeperClient$$zNodeChangeHandlers;
    }

    public ConcurrentHashMap<String, ZNodeChildChangeHandler> kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers() {
        return this.kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers;
    }

    public ZooKeeper kafka$controller$ZookeeperClient$$zooKeeper() {
        return this.kafka$controller$ZookeeperClient$$zooKeeper;
    }

    private void kafka$controller$ZookeeperClient$$zooKeeper_$eq(ZooKeeper x$1) {
        this.kafka$controller$ZookeeperClient$$zooKeeper = x$1;
    }

    public AsyncResponse handle(AsyncRequest request) {
        return (AsyncResponse)this.handle((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new AsyncRequest[]{request}))).head();
    }

    public Seq<AsyncResponse> handle(Seq<AsyncRequest> requests) {
        return CoreUtils$.MODULE$.inReadLock(this.kafka$controller$ZookeeperClient$$initializationLock(), new Serializable(this, requests){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperClient $outer;
            private final Seq requests$1;

            public final Seq<AsyncResponse> apply() {
                CountDownLatch countDownLatch = new CountDownLatch(this.requests$1.size());
                ArrayBlockingQueue<E> responseQueue = new ArrayBlockingQueue<E>(this.requests$1.size());
                this.requests$1.foreach(new Serializable(this, countDownLatch, responseQueue){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$handle$1 $outer;
                    public final CountDownLatch countDownLatch$1;
                    public final ArrayBlockingQueue responseQueue$1;

                    public final void apply(AsyncRequest x0$1) {
                        AsyncRequest asyncRequest;
                        block10: {
                            block3: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            asyncRequest = x0$1;
                                                            if (!(asyncRequest instanceof CreateRequest)) break block2;
                                                            CreateRequest createRequest = (CreateRequest)asyncRequest;
                                                            String path = createRequest.path();
                                                            byte[] data = createRequest.data();
                                                            Seq<ACL> acl = createRequest.acl();
                                                            CreateMode createMode = createRequest.createMode();
                                                            Object ctx = createRequest.ctx();
                                                            this.$outer.kafka$controller$ZookeeperClient$$anonfun$$$outer().kafka$controller$ZookeeperClient$$zooKeeper().create(path, data, JavaConverters$.MODULE$.seqAsJavaListConverter(acl).asJava(), createMode, new AsyncCallback.StringCallback(this){
                                                                private final /* synthetic */ $anonfun$handle$1$$anonfun$apply$1 $outer;

                                                                public void processResult(int rc, String path, Object ctx, String name) {
                                                                    this.$outer.responseQueue$1.add(new CreateResponse(rc, path, ctx, name));
                                                                    this.$outer.countDownLatch$1.countDown();
                                                                }
                                                                {
                                                                    if ($outer == null) {
                                                                        throw null;
                                                                    }
                                                                    this.$outer = $outer;
                                                                }
                                                            }, ctx);
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            break block3;
                                                        }
                                                        if (!(asyncRequest instanceof DeleteRequest)) break block4;
                                                        DeleteRequest deleteRequest = (DeleteRequest)asyncRequest;
                                                        String path = deleteRequest.path();
                                                        int version = deleteRequest.version();
                                                        Object ctx = deleteRequest.ctx();
                                                        this.$outer.kafka$controller$ZookeeperClient$$anonfun$$$outer().kafka$controller$ZookeeperClient$$zooKeeper().delete(path, version, new AsyncCallback.VoidCallback(this){
                                                            private final /* synthetic */ $anonfun$handle$1$$anonfun$apply$1 $outer;

                                                            public void processResult(int rc, String path, Object ctx) {
                                                                this.$outer.responseQueue$1.add(new DeleteResponse(rc, path, ctx));
                                                                this.$outer.countDownLatch$1.countDown();
                                                            }
                                                            {
                                                                if ($outer == null) {
                                                                    throw null;
                                                                }
                                                                this.$outer = $outer;
                                                            }
                                                        }, ctx);
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block3;
                                                    }
                                                    if (!(asyncRequest instanceof ExistsRequest)) break block5;
                                                    ExistsRequest existsRequest = (ExistsRequest)asyncRequest;
                                                    String path = existsRequest.path();
                                                    Object ctx = existsRequest.ctx();
                                                    this.$outer.kafka$controller$ZookeeperClient$$anonfun$$$outer().kafka$controller$ZookeeperClient$$zooKeeper().exists(path, this.$outer.kafka$controller$ZookeeperClient$$anonfun$$$outer().kafka$controller$ZookeeperClient$$zNodeChangeHandlers().containsKey(path), new AsyncCallback.StatCallback(this){
                                                        private final /* synthetic */ $anonfun$handle$1$$anonfun$apply$1 $outer;

                                                        public void processResult(int rc, String path, Object ctx, Stat stat) {
                                                            this.$outer.responseQueue$1.add(new ExistsResponse(rc, path, ctx, stat));
                                                            this.$outer.countDownLatch$1.countDown();
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                        }
                                                    }, ctx);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block3;
                                                }
                                                if (!(asyncRequest instanceof GetDataRequest)) break block6;
                                                GetDataRequest getDataRequest = (GetDataRequest)asyncRequest;
                                                String path = getDataRequest.path();
                                                Object ctx = getDataRequest.ctx();
                                                this.$outer.kafka$controller$ZookeeperClient$$anonfun$$$outer().kafka$controller$ZookeeperClient$$zooKeeper().getData(path, this.$outer.kafka$controller$ZookeeperClient$$anonfun$$$outer().kafka$controller$ZookeeperClient$$zNodeChangeHandlers().containsKey(path), new AsyncCallback.DataCallback(this){
                                                    private final /* synthetic */ $anonfun$handle$1$$anonfun$apply$1 $outer;

                                                    public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                                                        this.$outer.responseQueue$1.add(new GetDataResponse(rc, path, ctx, data, stat));
                                                        this.$outer.countDownLatch$1.countDown();
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                    }
                                                }, ctx);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block3;
                                            }
                                            if (!(asyncRequest instanceof SetDataRequest)) break block7;
                                            SetDataRequest setDataRequest = (SetDataRequest)asyncRequest;
                                            String path = setDataRequest.path();
                                            byte[] data = setDataRequest.data();
                                            int version = setDataRequest.version();
                                            Object ctx = setDataRequest.ctx();
                                            this.$outer.kafka$controller$ZookeeperClient$$anonfun$$$outer().kafka$controller$ZookeeperClient$$zooKeeper().setData(path, data, version, new AsyncCallback.StatCallback(this){
                                                private final /* synthetic */ $anonfun$handle$1$$anonfun$apply$1 $outer;

                                                public void processResult(int rc, String path, Object ctx, Stat stat) {
                                                    this.$outer.responseQueue$1.add(new SetDataResponse(rc, path, ctx, stat));
                                                    this.$outer.countDownLatch$1.countDown();
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            }, ctx);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (!(asyncRequest instanceof GetACLRequest)) break block8;
                                        GetACLRequest getACLRequest = (GetACLRequest)asyncRequest;
                                        String path = getACLRequest.path();
                                        Object ctx = getACLRequest.ctx();
                                        this.$outer.kafka$controller$ZookeeperClient$$anonfun$$$outer().kafka$controller$ZookeeperClient$$zooKeeper().getACL(path, null, new AsyncCallback.ACLCallback(this){
                                            private final /* synthetic */ $anonfun$handle$1$$anonfun$apply$1 $outer;

                                            public void processResult(int rc, String path, Object ctx, List<ACL> acl, Stat stat) {
                                                this.$outer.responseQueue$1.add(new GetACLResponse(rc, path, ctx, (Seq)Option$.MODULE$.apply(acl).map(new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final Buffer<ACL> apply(List<ACL> x$1) {
                                                        return JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala();
                                                    }
                                                }).orNull(Predef$.MODULE$.$conforms()), stat));
                                                this.$outer.countDownLatch$1.countDown();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        }, ctx);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!(asyncRequest instanceof SetACLRequest)) break block9;
                                    SetACLRequest setACLRequest = (SetACLRequest)asyncRequest;
                                    String path = setACLRequest.path();
                                    Seq<ACL> acl = setACLRequest.acl();
                                    int version = setACLRequest.version();
                                    Object ctx = setACLRequest.ctx();
                                    this.$outer.kafka$controller$ZookeeperClient$$anonfun$$$outer().kafka$controller$ZookeeperClient$$zooKeeper().setACL(path, JavaConverters$.MODULE$.seqAsJavaListConverter(acl).asJava(), version, new AsyncCallback.StatCallback(this){
                                        private final /* synthetic */ $anonfun$handle$1$$anonfun$apply$1 $outer;

                                        public void processResult(int rc, String path, Object ctx, Stat stat) {
                                            this.$outer.responseQueue$1.add(new SetACLResponse(rc, path, ctx, stat));
                                            this.$outer.countDownLatch$1.countDown();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    }, ctx);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(asyncRequest instanceof GetChildrenRequest)) break block10;
                                GetChildrenRequest getChildrenRequest = (GetChildrenRequest)asyncRequest;
                                String path = getChildrenRequest.path();
                                Object ctx = getChildrenRequest.ctx();
                                this.$outer.kafka$controller$ZookeeperClient$$anonfun$$$outer().kafka$controller$ZookeeperClient$$zooKeeper().getChildren(path, this.$outer.kafka$controller$ZookeeperClient$$anonfun$$$outer().kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers().containsKey(path), new AsyncCallback.Children2Callback(this){
                                    private final /* synthetic */ $anonfun$handle$1$$anonfun$apply$1 $outer;

                                    public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                                        this.$outer.responseQueue$1.add(new GetChildrenResponse(rc, path, ctx, (Seq)Option$.MODULE$.apply(children).map(new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Buffer<String> apply(List<String> x$2) {
                                                return JavaConverters$.MODULE$.asScalaBufferConverter(x$2).asScala();
                                            }
                                        }).orNull(Predef$.MODULE$.$conforms()), stat));
                                        this.$outer.countDownLatch$1.countDown();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                }, ctx);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError(asyncRequest);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.countDownLatch$1 = countDownLatch$1;
                        this.responseQueue$1 = responseQueue$1;
                    }
                });
                countDownLatch.await();
                return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(responseQueue).asScala()).toSeq();
            }

            public /* synthetic */ ZookeeperClient kafka$controller$ZookeeperClient$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.requests$1 = requests$1;
            }
        });
    }

    public void waitUntilConnected() {
        CoreUtils$.MODULE$.inLock(this.kafka$controller$ZookeeperClient$$isConnectedOrExpiredLock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperClient $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$controller$ZookeeperClient$$waitUntilConnected(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void kafka$controller$ZookeeperClient$$waitUntilConnected(long timeout, TimeUnit timeUnit) {
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Waiting until connected.";
            }
        }));
        LongRef nanos = LongRef.create(timeUnit.toNanos(timeout));
        CoreUtils$.MODULE$.inLock(this.kafka$controller$ZookeeperClient$$isConnectedOrExpiredLock(), new Serializable(this, nanos){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperClient $outer;
            private final LongRef nanos$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ZooKeeper.States state = this.$outer.kafka$controller$ZookeeperClient$$zooKeeper().getState();
                while (!state.isConnected() && state.isAlive()) {
                    if (this.nanos$1.elem <= 0L) {
                        throw new ZookeeperClientTimeoutException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timed out waiting for connection while in state: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{state})));
                    }
                    this.nanos$1.elem = this.$outer.kafka$controller$ZookeeperClient$$isConnectedOrExpiredCondition().awaitNanos(this.nanos$1.elem);
                    state = this.$outer.kafka$controller$ZookeeperClient$$zooKeeper().getState();
                }
                ZooKeeper.States states2 = state;
                ZooKeeper.States states3 = ZooKeeper.States.AUTH_FAILED;
                if (!(states2 != null ? !((Object)((Object)states2)).equals((Object)((Object)states3)) : states3 != null)) {
                    throw new ZookeeperClientAuthFailedException("Auth failed either before or while waiting for connection");
                }
                ZooKeeper.States states4 = state;
                ZooKeeper.States states5 = ZooKeeper.States.CLOSED;
                if (!(states4 != null ? !((Object)((Object)states4)).equals((Object)((Object)states5)) : states5 != null)) {
                    throw new ZookeeperClientExpiredException("Session expired either before or while waiting for connection");
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.nanos$1 = nanos$1;
            }
        });
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Connected.";
            }
        }));
    }

    public ExistsResponse registerZNodeChangeHandler(ZNodeChangeHandler zNodeChangeHandler) {
        return (ExistsResponse)this.registerZNodeChangeHandlers((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ZNodeChangeHandler[]{zNodeChangeHandler}))).head();
    }

    public Seq<ExistsResponse> registerZNodeChangeHandlers(Seq<ZNodeChangeHandler> handlers) {
        handlers.foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperClient $outer;

            public final ZNodeChangeHandler apply(ZNodeChangeHandler handler) {
                return this.$outer.kafka$controller$ZookeeperClient$$zNodeChangeHandlers().put(handler.path(), handler);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Seq<AsyncRequest> asyncRequests = handlers.map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ExistsRequest apply(ZNodeChangeHandler handler) {
                return new ExistsRequest(handler.path(), null);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return this.handle(asyncRequests);
    }

    public void unregisterZNodeChangeHandler(String path) {
        this.kafka$controller$ZookeeperClient$$zNodeChangeHandlers().remove(path);
    }

    public GetChildrenResponse registerZNodeChildChangeHandler(ZNodeChildChangeHandler zNodeChildChangeHandler) {
        return (GetChildrenResponse)this.registerZNodeChildChangeHandlers((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ZNodeChildChangeHandler[]{zNodeChildChangeHandler}))).head();
    }

    public Seq<GetChildrenResponse> registerZNodeChildChangeHandlers(Seq<ZNodeChildChangeHandler> handlers) {
        handlers.foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperClient $outer;

            public final ZNodeChildChangeHandler apply(ZNodeChildChangeHandler handler) {
                return this.$outer.kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers().put(handler.path(), handler);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Seq<AsyncRequest> asyncRequests = handlers.map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final GetChildrenRequest apply(ZNodeChildChangeHandler handler) {
                return new GetChildrenRequest(handler.path(), null);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return this.handle(asyncRequests);
    }

    public void unregisterZNodeChildChangeHandler(String path) {
        this.kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers().remove(path);
    }

    public void close() {
        CoreUtils$.MODULE$.inWriteLock(this.kafka$controller$ZookeeperClient$$initializationLock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperClient $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.info((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Closing.";
                    }
                }));
                this.$outer.kafka$controller$ZookeeperClient$$zNodeChangeHandlers().clear();
                this.$outer.kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers().clear();
                this.$outer.kafka$controller$ZookeeperClient$$zooKeeper().close();
                this.$outer.info((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Closed.";
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void kafka$controller$ZookeeperClient$$initialize() {
        if (this.kafka$controller$ZookeeperClient$$zooKeeper().getState().isAlive() != false) return;
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperClient $outer;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing a new session to ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$controller$ZookeeperClient$$connectString}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        now = System.currentTimeMillis();
        threshold = now + (long)this.connectionTimeoutMs;
        if (now < threshold) ** GOTO lbl-1000
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperClient $outer;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timed out waiting for connection during session initialization while in state: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$controller$ZookeeperClient$$zooKeeper().getState()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$controller$ZookeeperClient$$stateChangeHandler.onConnectionTimeout();
        return;
lbl-1000:
        // 1 sources

        {
            this.kafka$controller$ZookeeperClient$$zooKeeper().close();
            this.kafka$controller$ZookeeperClient$$zooKeeper_$eq(new ZooKeeper(this.kafka$controller$ZookeeperClient$$connectString, this.sessionTimeoutMs, this.ZookeeperClientWatcher()));
            this.kafka$controller$ZookeeperClient$$waitUntilConnected(threshold - now, TimeUnit.MILLISECONDS);
            return;
        }
    }

    private ZookeeperClient$ZookeeperClientWatcher$ ZookeeperClientWatcher() {
        return this.ZookeeperClientWatcher$module == null ? this.ZookeeperClientWatcher$lzycompute() : this.ZookeeperClientWatcher$module;
    }

    public ZookeeperClient(String connectString, int sessionTimeoutMs, int connectionTimeoutMs, StateChangeHandler stateChangeHandler) {
        this.kafka$controller$ZookeeperClient$$connectString = connectString;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.kafka$controller$ZookeeperClient$$stateChangeHandler = stateChangeHandler;
        Logging$class.$init$(this);
        this.logIdent_$eq("[ZookeeperClient]: ");
        this.kafka$controller$ZookeeperClient$$initializationLock = new ReentrantReadWriteLock();
        this.kafka$controller$ZookeeperClient$$isConnectedOrExpiredLock = new ReentrantLock();
        this.kafka$controller$ZookeeperClient$$isConnectedOrExpiredCondition = this.kafka$controller$ZookeeperClient$$isConnectedOrExpiredLock().newCondition();
        this.kafka$controller$ZookeeperClient$$zNodeChangeHandlers = new ConcurrentHashMap();
        this.kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers = new ConcurrentHashMap();
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperClient $outer;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing a new session to ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$controller$ZookeeperClient$$connectString}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.kafka$controller$ZookeeperClient$$zooKeeper = new ZooKeeper(connectString, sessionTimeoutMs, this.ZookeeperClientWatcher());
        this.kafka$controller$ZookeeperClient$$waitUntilConnected(connectionTimeoutMs, TimeUnit.MILLISECONDS);
    }
}

